/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.ai.config.task;

import com.bedrockk.molang.Expression;
import com.cobblemon.mod.common.CobblemonMemories;
import com.cobblemon.mod.common.api.ai.BehaviourConfigurationContext;
import com.cobblemon.mod.common.api.ai.ExpressionOrEntityVariableKt;
import com.cobblemon.mod.common.api.ai.config.task.SingleTaskConfig;
import com.cobblemon.mod.common.api.molang.MoLangFunctions;
import com.cobblemon.mod.common.api.npc.configuration.MoLangConfigVariable;
import com.cobblemon.mod.common.entity.OmniPathingEntity;
import com.cobblemon.mod.common.util.EntityExtensionsKt;
import com.cobblemon.mod.common.util.MoLangExtensionsKt;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.behavior.declarative.MemoryAccessor;
import net.minecraft.world.entity.ai.behavior.declarative.Trigger;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ)\u0010\r\u001a\f\u0012\u0006\b\u0000\u0012\u00020\u0004\u0018\u00010\f2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ%\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0016\u0010\u0017J%\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0018\u0010\u0017R'\u0010\u001c\u001a\u0012\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\t0\u0019j\u0002`\u001b8\u0006\u00a2\u0006\f\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006 "}, d2={"Lcom/cobblemon/mod/common/api/ai/config/task/GoToLandTaskConfig;", "Lcom/cobblemon/mod/common/api/ai/config/task/SingleTaskConfig;", "<init>", "()V", "Lnet/minecraft/world/entity/LivingEntity;", "entity", "Lcom/cobblemon/mod/common/api/ai/BehaviourConfigurationContext;", "behaviourConfigurationContext", "", "Lcom/cobblemon/mod/common/api/npc/configuration/MoLangConfigVariable;", "getVariables", "(Lnet/minecraft/world/entity/LivingEntity;Lcom/cobblemon/mod/common/api/ai/BehaviourConfigurationContext;)Ljava/util/List;", "Lnet/minecraft/world/entity/ai/behavior/BehaviorControl;", "createTask", "(Lnet/minecraft/world/entity/LivingEntity;Lcom/cobblemon/mod/common/api/ai/BehaviourConfigurationContext;)Lnet/minecraft/world/entity/ai/behavior/BehaviorControl;", "Lnet/minecraft/server/level/ServerLevel;", "world", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/world/entity/PathfinderMob;", "mob", "", "isSafeLandPos", "(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/entity/PathfinderMob;)Z", "isSafeLandPosAround", "Lcom/mojang/datafixers/util/Either;", "Lcom/bedrockk/molang/Expression;", "Lcom/cobblemon/mod/common/api/ai/ExpressionOrEntityVariable;", "walkSpeed", "Lcom/mojang/datafixers/util/Either;", "getWalkSpeed", "()Lcom/mojang/datafixers/util/Either;", "common"})
public final class GoToLandTaskConfig
implements SingleTaskConfig {
    @NotNull
    private final Either<Expression, MoLangConfigVariable> walkSpeed = this.numberVariable("movement", "walk_speed", 0.35).asExpressible();

    @NotNull
    public final Either<Expression, MoLangConfigVariable> getWalkSpeed() {
        return this.walkSpeed;
    }

    @Override
    @NotNull
    public List<MoLangConfigVariable> getVariables(@NotNull LivingEntity entity, @NotNull BehaviourConfigurationContext behaviourConfigurationContext) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)behaviourConfigurationContext, (String)"behaviourConfigurationContext");
        return ExpressionOrEntityVariableKt.asVariables(CollectionsKt.listOf(this.walkSpeed));
    }

    @Override
    @Nullable
    public BehaviorControl<? super LivingEntity> createTask(@NotNull LivingEntity entity, @NotNull BehaviourConfigurationContext behaviourConfigurationContext) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)behaviourConfigurationContext, (String)"behaviourConfigurationContext");
        if (!(entity instanceof PathfinderMob)) {
            return null;
        }
        MemoryModuleType[] memoryModuleTypeArray = new MemoryModuleType[2];
        Intrinsics.checkNotNullExpressionValue((Object)MemoryModuleType.WALK_TARGET, (String)"WALK_TARGET");
        memoryModuleTypeArray[1] = CobblemonMemories.PATH_COOLDOWN;
        behaviourConfigurationContext.addMemories(memoryModuleTypeArray);
        return (BehaviorControl)BehaviorBuilder.create(arg_0 -> GoToLandTaskConfig.createTask$lambda$0(this, arg_0));
    }

    public final boolean isSafeLandPos(@NotNull ServerLevel world, @NotNull BlockPos pos, @NotNull PathfinderMob mob) {
        int maxY;
        boolean solidBelow;
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)mob, (String)"mob");
        BlockState blockState = world.getBlockState(pos);
        boolean isFluid = !world.getFluidState(pos.above()).isEmpty();
        boolean bl = solidBelow = blockState.isSolid() || mob instanceof OmniPathingEntity && ((OmniPathingEntity)mob).canFly();
        if (isFluid || !solidBelow) {
            return false;
        }
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        int minY = pos.getY() + 1;
        int y = minY;
        if (y <= (maxY = minY + (int)Math.ceil(mob.getBbHeight()))) {
            while (true) {
                BlockState aboveState;
                boolean canPathfindThroughAbove;
                if (!(canPathfindThroughAbove = (aboveState = world.getBlockState((BlockPos)mutable.set(pos.getX(), y, pos.getZ()))).isPathfindable(PathComputationType.LAND))) {
                    return false;
                }
                if (y == maxY) break;
                ++y;
            }
        }
        return true;
    }

    public final boolean isSafeLandPosAround(@NotNull ServerLevel world, @NotNull BlockPos pos, @NotNull PathfinderMob mob) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)mob, (String)"mob");
        int minX = pos.getX();
        int maxX = minX + (int)Math.floor(mob.getBbWidth());
        int minZ = pos.getZ();
        int maxZ = minZ + (int)Math.floor(mob.getBbWidth());
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        int x = minX;
        if (x <= maxX) {
            while (true) {
                int z;
                if ((z = minZ) <= maxZ) {
                    while (true) {
                        BlockPos.MutableBlockPos mutableBlockPos = mutable.set(x, pos.getY(), z);
                        Intrinsics.checkNotNullExpressionValue((Object)mutableBlockPos, (String)"set(...)");
                        if (!this.isSafeLandPos(world, (BlockPos)mutableBlockPos, mob)) {
                            return false;
                        }
                        if (z == maxZ) break;
                        ++z;
                    }
                }
                if (x == maxX) break;
                ++x;
            }
        }
        return true;
    }

    private static final App createTask$lambda$0(GoToLandTaskConfig this$0, BehaviorBuilder.Instance it) {
        return it.group((App)it.absent(MemoryModuleType.WALK_TARGET), (App)it.absent(CobblemonMemories.PATH_COOLDOWN)).apply((Applicative)it, (arg_0, arg_1) -> GoToLandTaskConfig.createTask$lambda$0$0(this$0, arg_0, arg_1));
    }

    private static final Trigger createTask$lambda$0$0(GoToLandTaskConfig this$0, MemoryAccessor walkTarget, MemoryAccessor pathCooldown) {
        return (arg_0, arg_1, arg_2) -> GoToLandTaskConfig.createTask$lambda$0$0$0(this$0, pathCooldown, walkTarget, arg_0, arg_1, arg_2);
    }

    private static final boolean createTask$lambda$0$0$0(GoToLandTaskConfig this$0, MemoryAccessor $pathCooldown, MemoryAccessor $walkTarget, ServerLevel world, LivingEntity entity, long time) {
        if (!entity.isInWater()) {
            return false;
        }
        Intrinsics.checkNotNull((Object)entity, (String)"null cannot be cast to non-null type net.minecraft.world.entity.PathfinderMob");
        PathfinderMob cfr_ignored_0 = (PathfinderMob)entity;
        MoLangExtensionsKt.withQueryValue(MoLangExtensionsKt.getMainThreadRuntime(), "entity", MoLangFunctions.INSTANCE.asMostSpecificMoLangValue((Entity)entity));
        float walkSpeedValue = this$0.resolveFloat(this$0.walkSpeed, MoLangExtensionsKt.getMainThreadRuntime());
        Iterable iterable = BlockPos.betweenClosed((int)Mth.floor((double)(((PathfinderMob)entity).getX() - 8.0)), (int)((PathfinderMob)entity).getBlockY(), (int)Mth.floor((double)(((PathfinderMob)entity).getZ() - 8.0)), (int)Mth.floor((double)(((PathfinderMob)entity).getX() + 8.0)), (int)Mth.floor((double)(((PathfinderMob)entity).getY() + 2.0)), (int)Mth.floor((double)(((PathfinderMob)entity).getZ() + 8.0)));
        $pathCooldown.setWithExpiry((Object)true, 40L);
        Entity entity2 = (Entity)entity;
        Intrinsics.checkNotNull((Object)iterable);
        BlockPos blockPos = EntityExtensionsKt.closestPosition(entity2, iterable, (Function1<? super BlockPos, Boolean>)((Function1)arg_0 -> GoToLandTaskConfig.createTask$lambda$0$0$0$0(this$0, entity, arg_0)));
        if (blockPos == null) {
            return false;
        }
        BlockPos blockPos2 = blockPos;
        $walkTarget.set((Object)new WalkTarget(blockPos2.above(), walkSpeedValue, 0));
        return true;
    }

    private static final boolean createTask$lambda$0$0$0$0(GoToLandTaskConfig this$0, LivingEntity $entity, BlockPos it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Level level = ((PathfinderMob)$entity).level();
        Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
        return this$0.isSafeLandPosAround((ServerLevel)level, it, (PathfinderMob)$entity);
    }
}

