/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.ai.config.task;

import com.bedrockk.molang.Expression;
import com.cobblemon.mod.common.CobblemonMemories;
import com.cobblemon.mod.common.api.ai.BehaviourConfigurationContext;
import com.cobblemon.mod.common.api.ai.CobblemonWanderControl;
import com.cobblemon.mod.common.api.ai.ExpressionOrEntityVariableKt;
import com.cobblemon.mod.common.api.ai.config.task.SingleTaskConfig;
import com.cobblemon.mod.common.api.molang.MoLangFunctions;
import com.cobblemon.mod.common.api.npc.configuration.MoLangConfigVariable;
import com.cobblemon.mod.common.entity.ai.CobblemonWalkTarget;
import com.cobblemon.mod.common.util.MoLangExtensionsKt;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.behavior.declarative.MemoryAccessor;
import net.minecraft.world.entity.ai.behavior.declarative.Trigger;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ)\u0010\r\u001a\f\u0012\u0006\b\u0000\u0012\u00020\u0004\u0018\u00010\f2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\r\u0010\u000eR'\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\t0\u000fj\u0002`\u00118\u0006\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015R'\u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\t0\u000fj\u0002`\u00118\u0006\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0013\u001a\u0004\b\u0017\u0010\u0015R'\u0010\u0018\u001a\u0012\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\t0\u000fj\u0002`\u00118\u0006\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0013\u001a\u0004\b\u0019\u0010\u0015R'\u0010\u001a\u001a\u0012\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\t0\u000fj\u0002`\u00118\u0006\u00a2\u0006\f\n\u0004\b\u001a\u0010\u0013\u001a\u0004\b\u001b\u0010\u0015R'\u0010\u001c\u001a\u0012\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\t0\u000fj\u0002`\u00118\u0006\u00a2\u0006\f\n\u0004\b\u001c\u0010\u0013\u001a\u0004\b\u001d\u0010\u0015\u00a8\u0006\u001e"}, d2={"Lcom/cobblemon/mod/common/api/ai/config/task/WaterWanderTaskConfig;", "Lcom/cobblemon/mod/common/api/ai/config/task/SingleTaskConfig;", "<init>", "()V", "Lnet/minecraft/world/entity/LivingEntity;", "entity", "Lcom/cobblemon/mod/common/api/ai/BehaviourConfigurationContext;", "behaviourConfigurationContext", "", "Lcom/cobblemon/mod/common/api/npc/configuration/MoLangConfigVariable;", "getVariables", "(Lnet/minecraft/world/entity/LivingEntity;Lcom/cobblemon/mod/common/api/ai/BehaviourConfigurationContext;)Ljava/util/List;", "Lnet/minecraft/world/entity/ai/behavior/BehaviorControl;", "createTask", "(Lnet/minecraft/world/entity/LivingEntity;Lcom/cobblemon/mod/common/api/ai/BehaviourConfigurationContext;)Lnet/minecraft/world/entity/ai/behavior/BehaviorControl;", "Lcom/mojang/datafixers/util/Either;", "Lcom/bedrockk/molang/Expression;", "Lcom/cobblemon/mod/common/api/ai/ExpressionOrEntityVariable;", "condition", "Lcom/mojang/datafixers/util/Either;", "getCondition", "()Lcom/mojang/datafixers/util/Either;", "wanderChance", "getWanderChance", "speedMultiplier", "getSpeedMultiplier", "horizontalRange", "getHorizontalRange", "verticalRange", "getVerticalRange", "common"})
@SourceDebugExtension(value={"SMAP\nWaterWanderTaskConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WaterWanderTaskConfig.kt\ncom/cobblemon/mod/common/api/ai/config/task/WaterWanderTaskConfig\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,146:1\n1#2:147\n*E\n"})
public final class WaterWanderTaskConfig
implements SingleTaskConfig {
    @NotNull
    private final Either<Expression, MoLangConfigVariable> condition = this.booleanVariable("wander", "water_wanders", true).asExpressible();
    @NotNull
    private final Either<Expression, MoLangConfigVariable> wanderChance = this.numberVariable("wander", "water_wander_chance", Float.valueOf(0.016666668f)).asExpressible();
    @NotNull
    private final Either<Expression, MoLangConfigVariable> speedMultiplier = this.numberVariable("movement", "walk_speed", 0.35).asExpressible();
    @NotNull
    private final Either<Expression, MoLangConfigVariable> horizontalRange;
    @NotNull
    private final Either<Expression, MoLangConfigVariable> verticalRange;

    public WaterWanderTaskConfig() {
        Either either = Either.left((Object)MoLangExtensionsKt.asExpression("10.0"));
        Intrinsics.checkNotNullExpressionValue((Object)either, (String)"left(...)");
        this.horizontalRange = either;
        Either either2 = Either.left((Object)MoLangExtensionsKt.asExpression("7.0"));
        Intrinsics.checkNotNullExpressionValue((Object)either2, (String)"left(...)");
        this.verticalRange = either2;
    }

    @NotNull
    public final Either<Expression, MoLangConfigVariable> getCondition() {
        return this.condition;
    }

    @NotNull
    public final Either<Expression, MoLangConfigVariable> getWanderChance() {
        return this.wanderChance;
    }

    @NotNull
    public final Either<Expression, MoLangConfigVariable> getSpeedMultiplier() {
        return this.speedMultiplier;
    }

    @NotNull
    public final Either<Expression, MoLangConfigVariable> getHorizontalRange() {
        return this.horizontalRange;
    }

    @NotNull
    public final Either<Expression, MoLangConfigVariable> getVerticalRange() {
        return this.verticalRange;
    }

    @Override
    @NotNull
    public List<MoLangConfigVariable> getVariables(@NotNull LivingEntity entity, @NotNull BehaviourConfigurationContext behaviourConfigurationContext) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)behaviourConfigurationContext, (String)"behaviourConfigurationContext");
        Object[] objectArray = new Either[]{this.condition, this.wanderChance, this.speedMultiplier};
        return ExpressionOrEntityVariableKt.asVariables(CollectionsKt.listOf((Object[])objectArray));
    }

    @Override
    @Nullable
    public BehaviorControl<? super LivingEntity> createTask(@NotNull LivingEntity entity, @NotNull BehaviourConfigurationContext behaviourConfigurationContext) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)behaviourConfigurationContext, (String)"behaviourConfigurationContext");
        if (!this.resolveBoolean(this.condition, behaviourConfigurationContext.getRuntime())) {
            return null;
        }
        Expression wanderChanceExpression = this.asSimplifiedExpression(this.wanderChance, entity);
        MemoryModuleType[] memoryModuleTypeArray = new MemoryModuleType[4];
        Intrinsics.checkNotNullExpressionValue((Object)MemoryModuleType.WALK_TARGET, (String)"WALK_TARGET");
        Intrinsics.checkNotNullExpressionValue((Object)MemoryModuleType.LOOK_TARGET, (String)"LOOK_TARGET");
        memoryModuleTypeArray[2] = CobblemonMemories.PATH_COOLDOWN;
        memoryModuleTypeArray[3] = CobblemonMemories.WANDER_CONTROL;
        behaviourConfigurationContext.addMemories(memoryModuleTypeArray);
        return (BehaviorControl)BehaviorBuilder.create(arg_0 -> WaterWanderTaskConfig.createTask$lambda$0(wanderChanceExpression, this, arg_0));
    }

    private static final App createTask$lambda$0(Expression $wanderChanceExpression, WaterWanderTaskConfig this$0, BehaviorBuilder.Instance it) {
        return it.group((App)it.absent(MemoryModuleType.WALK_TARGET), (App)it.registered(MemoryModuleType.LOOK_TARGET), (App)it.registered(CobblemonMemories.PATH_COOLDOWN), (App)it.registered(CobblemonMemories.WANDER_CONTROL)).apply((Applicative)it, (arg_0, arg_1, arg_2, arg_3) -> WaterWanderTaskConfig.createTask$lambda$0$0(it, $wanderChanceExpression, this$0, arg_0, arg_1, arg_2, arg_3));
    }

    private static final Trigger createTask$lambda$0$0(BehaviorBuilder.Instance $it, Expression $wanderChanceExpression, WaterWanderTaskConfig this$0, MemoryAccessor walkTarget, MemoryAccessor lookTarget, MemoryAccessor pathCooldown, MemoryAccessor wanderControlData) {
        return (arg_0, arg_1, arg_2) -> WaterWanderTaskConfig.createTask$lambda$0$0$0($it, wanderControlData, $wanderChanceExpression, pathCooldown, this$0, walkTarget, lookTarget, arg_0, arg_1, arg_2);
    }

    private static final boolean createTask$lambda$0$0$0(BehaviorBuilder.Instance $it, MemoryAccessor $wanderControlData, Expression $wanderChanceExpression, MemoryAccessor $pathCooldown, WaterWanderTaskConfig this$0, MemoryAccessor $walkTarget, MemoryAccessor $lookTarget, ServerLevel world, LivingEntity entity, long time) {
        CobblemonWanderControl wanderControl;
        if (!(entity instanceof PathfinderMob) || !((PathfinderMob)entity).isInWater()) {
            return false;
        }
        CobblemonWanderControl cobblemonWanderControl = $it.tryGet($wanderControlData).orElse(null);
        if (cobblemonWanderControl == null) {
            cobblemonWanderControl = new CobblemonWanderControl(null, 0, false, false, false, 0, 0.0f, 127, null);
        }
        if (!(wanderControl = cobblemonWanderControl).getAllowWater()) {
            return false;
        }
        MoLangExtensionsKt.withQueryValue(MoLangExtensionsKt.getMainThreadRuntime(), "entity", MoLangFunctions.INSTANCE.asMostSpecificMoLangValue((Entity)entity));
        float wanderChance = MoLangExtensionsKt.resolveFloat$default(MoLangExtensionsKt.getMainThreadRuntime(), $wanderChanceExpression, null, 2, null);
        if (wanderChance <= 0.0f || world.random.nextFloat() > wanderChance) {
            return false;
        }
        $pathCooldown.setWithExpiry((Object)true, (long)wanderControl.getPathCooldownTicks());
        BlockPos pos = null;
        Vec3 target = null;
        for (int attempts = 0; attempts < wanderControl.getMaxAttempts() && pos == null; ++attempts) {
            BlockPos blockPos;
            if (BehaviorUtils.getRandomSwimmablePos((PathfinderMob)((PathfinderMob)entity), (int)this$0.resolveInt(this$0.horizontalRange, MoLangExtensionsKt.getMainThreadRuntime()), (int)this$0.resolveInt(this$0.verticalRange, MoLangExtensionsKt.getMainThreadRuntime())) == null) continue;
            BlockPos p0 = blockPos = BlockPos.containing((Position)((Position)target));
            boolean bl = false;
            pos = wanderControl.isSuitable(p0) ? blockPos : null;
        }
        if (pos == null || target == null) {
            return false;
        }
        double requiredDepth = Math.ceil(0.5 + (double)((PathfinderMob)entity).getEyeHeight());
        int depth = 1;
        BlockPos testPos = pos.above();
        BlockState blockState = ((PathfinderMob)entity).level().getBlockState(testPos);
        while (Intrinsics.areEqual((Object)blockState.getFluidState().getType(), (Object)Fluids.WATER)) {
            ++depth;
            BlockPos blockPos = testPos;
            Intrinsics.checkNotNull((Object)blockPos);
            testPos = blockPos.above();
            blockState = ((PathfinderMob)entity).level().getBlockState(testPos);
        }
        if ((double)depth < requiredDepth) {
            pos = pos.below();
            blockState = ((PathfinderMob)entity).level().getBlockState(pos);
            while (Intrinsics.areEqual((Object)blockState.getFluidState().getType(), (Object)Fluids.WATER) && (double)depth < requiredDepth) {
                ++depth;
                BlockPos blockPos = pos;
                Intrinsics.checkNotNull((Object)blockPos);
                pos = blockPos.below();
                blockState = ((PathfinderMob)entity).level().getBlockState(pos);
            }
        }
        if ((double)depth < requiredDepth) {
            return false;
        }
        BlockPos blockPos = pos;
        Intrinsics.checkNotNull((Object)blockPos);
        BlockPos blockPos2 = blockPos;
        float f = this$0.resolveFloat(this$0.speedMultiplier, MoLangExtensionsKt.getMainThreadRuntime());
        $walkTarget.set((Object)new CobblemonWalkTarget(blockPos2, f, 0, WaterWanderTaskConfig::createTask$lambda$0$0$0$0, null, 16, null));
        $lookTarget.set((Object)new BlockPosTracker(target));
        return true;
    }

    private static final boolean createTask$lambda$0$0$0$0(PathType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it == PathType.WATER || it == PathType.WATER_BORDER;
    }
}

