/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.berry;

import com.cobblemon.mod.common.CobblemonBlocks;
import com.cobblemon.mod.common.CobblemonItems;
import com.cobblemon.mod.common.api.berry.Berries;
import com.cobblemon.mod.common.api.berry.GrowthFactor;
import com.cobblemon.mod.common.api.berry.GrowthPoint;
import com.cobblemon.mod.common.api.berry.spawncondition.BerrySpawnCondition;
import com.cobblemon.mod.common.api.cooking.Flavour;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.events.berry.BerryYieldCalculationEvent;
import com.cobblemon.mod.common.api.mulch.MulchVariant;
import com.cobblemon.mod.common.api.reactive.EventObservable;
import com.cobblemon.mod.common.block.BerryBlock;
import com.cobblemon.mod.common.block.entity.BerryBlockEntity;
import com.cobblemon.mod.common.item.berry.BerryItem;
import com.cobblemon.mod.common.pokemon.Nature;
import com.cobblemon.mod.common.util.BufferUtilsKt;
import com.cobblemon.mod.common.util.NetExtensionsKt;
import com.google.gson.annotations.SerializedName;
import io.netty.buffer.ByteBuf;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00da\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b3\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 \u009d\u00012\u00020\u0001:\u0002\u009d\u0001B\u00a3\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0012\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0006\u0012\u0006\u0010\n\u001a\u00020\u0004\u0012\u0006\u0010\u000b\u001a\u00020\u0004\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\f\u0012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u0012\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u0006\u0012\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014\u0012\b\b\u0002\u0010\u0018\u001a\u00020\u0017\u0012\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0019\u0012\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\u000f\u0012\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001b0\u000f\u0012\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001f0\u0019\u0012\u0006\u0010\"\u001a\u00020!\u0012\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020#0\u0019\u0012\u0006\u0010%\u001a\u00020\u0002\u0012\u0006\u0010&\u001a\u00020\u0002\u0012\u0006\u0010'\u001a\u00020\u0002\u0012\u0006\u0010(\u001a\u00020\u0002\u0012\u0006\u0010)\u001a\u00020\u0015\u0012\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014\u0012\u0006\u0010,\u001a\u00020+\u0012\u0006\u0010-\u001a\u00020+\u00a2\u0006\u0004\b.\u0010/J\u000f\u00101\u001a\u0004\u0018\u000100\u00a2\u0006\u0004\b1\u00102J\u000f\u00104\u001a\u0004\u0018\u000103\u00a2\u0006\u0004\b4\u00105J\u0015\u00107\u001a\u00020\u001f2\u0006\u00106\u001a\u00020\u001e\u00a2\u0006\u0004\b7\u00108J\u0015\u0010;\u001a\u00020\u00172\u0006\u0010:\u001a\u000209\u00a2\u0006\u0004\b;\u0010<J1\u0010E\u001a\u00020\u001f2\u0006\u0010>\u001a\u00020=2\u0006\u0010@\u001a\u00020?2\u0006\u0010B\u001a\u00020A2\n\b\u0002\u0010D\u001a\u0004\u0018\u00010C\u00a2\u0006\u0004\bE\u0010FJ\r\u0010G\u001a\u00020\u001f\u00a2\u0006\u0004\bG\u0010HJ\r\u0010I\u001a\u00020\u001f\u00a2\u0006\u0004\bI\u0010HJ\u0015\u0010K\u001a\u00020\u00172\u0006\u0010J\u001a\u00020\u0000\u00a2\u0006\u0004\bK\u0010LJ\u0017\u0010M\u001a\u0004\u0018\u00010\u00002\u0006\u0010J\u001a\u00020\u0000\u00a2\u0006\u0004\bM\u0010NJ\u0017\u0010P\u001a\u0004\u0018\u00010\u00002\u0006\u0010O\u001a\u00020\u0000\u00a2\u0006\u0004\bP\u0010NJ\u000f\u0010T\u001a\u00020QH\u0000\u00a2\u0006\u0004\bR\u0010SJ\u0017\u0010Y\u001a\u00020Q2\u0006\u0010V\u001a\u00020UH\u0000\u00a2\u0006\u0004\bW\u0010XJ9\u0010[\u001a\u0014\u0012\u0004\u0012\u00020\u001f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0Z2\u0006\u0010>\u001a\u00020=2\u0006\u0010@\u001a\u00020?2\u0006\u0010B\u001a\u00020AH\u0002\u00a2\u0006\u0004\b[\u0010\\J\u001d\u0010_\u001a\u00020^2\f\u0010]\u001a\b\u0012\u0004\u0012\u00020\u001b0\u000fH\u0002\u00a2\u0006\u0004\b_\u0010`R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010a\u001a\u0004\bb\u0010cR#\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00068\u0006\u00a2\u0006\f\n\u0004\b\t\u0010d\u001a\u0004\be\u0010fR\u0017\u0010\n\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\n\u0010a\u001a\u0004\bg\u0010cR\u0017\u0010\u000b\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u000b\u0010a\u001a\u0004\bh\u0010cR\u001d\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\f8\u0006\u00a2\u0006\f\n\u0004\b\u000e\u0010i\u001a\u0004\bj\u0010kR\u001d\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8\u0006\u00a2\u0006\f\n\u0004\b\u0011\u0010l\u001a\u0004\bm\u0010nR\u001d\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0013\u0010d\u001a\u0004\bo\u0010fR(\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u00148\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0016\u0010p\u001a\u0004\bq\u0010r\"\u0004\bs\u0010tR\u0017\u0010\u0018\u001a\u00020\u00178\u0006\u00a2\u0006\f\n\u0004\b\u0018\u0010u\u001a\u0004\bv\u0010wR#\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u00198\u0006\u00a2\u0006\f\n\u0004\b\u001a\u0010x\u001a\u0004\by\u0010zR\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\u000f8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u001c\u0010lR\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001b0\u000f8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u001d\u0010lR&\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001f0\u00198\u0006X\u0087\u0004\u00a2\u0006\f\n\u0004\b \u0010x\u001a\u0004\b{\u0010zR\u001a\u0010\"\u001a\u00020!8\u0006X\u0087\u0004\u00a2\u0006\f\n\u0004\b\"\u0010|\u001a\u0004\b}\u0010~R#\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020#0\u00198\u0006\u00a2\u0006\f\n\u0004\b$\u0010x\u001a\u0004\b\u007f\u0010zR\u001d\u0010%\u001a\u00020\u00028\u0006X\u0087\u0004\u00a2\u0006\u000f\n\u0005\b%\u0010\u0080\u0001\u001a\u0006\b\u0081\u0001\u0010\u0082\u0001R\u001a\u0010&\u001a\u00020\u00028\u0006\u00a2\u0006\u000f\n\u0005\b&\u0010\u0080\u0001\u001a\u0006\b\u0083\u0001\u0010\u0082\u0001R\u001d\u0010'\u001a\u00020\u00028\u0006X\u0087\u0004\u00a2\u0006\u000f\n\u0005\b'\u0010\u0080\u0001\u001a\u0006\b\u0084\u0001\u0010\u0082\u0001R\u001a\u0010(\u001a\u00020\u00028\u0006\u00a2\u0006\u000f\n\u0005\b(\u0010\u0080\u0001\u001a\u0006\b\u0085\u0001\u0010\u0082\u0001R\u001a\u0010)\u001a\u00020\u00158\u0006\u00a2\u0006\u000f\n\u0005\b)\u0010\u0086\u0001\u001a\u0006\b\u0087\u0001\u0010\u0088\u0001R\u001e\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00150\u00148\u0006\u00a2\u0006\r\n\u0004\b*\u0010p\u001a\u0005\b\u0089\u0001\u0010rR\u001a\u0010,\u001a\u00020+8\u0006\u00a2\u0006\u000f\n\u0005\b,\u0010\u008a\u0001\u001a\u0006\b\u008b\u0001\u0010\u008c\u0001R\u001a\u0010-\u001a\u00020+8\u0006\u00a2\u0006\u000f\n\u0005\b-\u0010\u008a\u0001\u001a\u0006\b\u008d\u0001\u0010\u008c\u0001R0\u0010\u0003\u001a\u00020\u00022\u0007\u0010\u008e\u0001\u001a\u00020\u00028\u0006@@X\u0086\u000e\u00a2\u0006\u0017\n\u0005\b\u0003\u0010\u0080\u0001\u001a\u0006\b\u008f\u0001\u0010\u0082\u0001\"\u0006\b\u0090\u0001\u0010\u0091\u0001R7\u0010\u0094\u0001\u001a \u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020^0\u0092\u0001j\u000f\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020^`\u0093\u00018\u0002@\u0002X\u0082.\u00a2\u0006\b\n\u0006\b\u0094\u0001\u0010\u0095\u0001R7\u0010\u0096\u0001\u001a \u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020^0\u0092\u0001j\u000f\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020^`\u0093\u00018\u0002@\u0002X\u0082.\u00a2\u0006\b\n\u0006\b\u0096\u0001\u0010\u0095\u0001R*\u0010\u0097\u0001\u001a\u00020^2\u0007\u0010\u008e\u0001\u001a\u00020^8\u0006@BX\u0086.\u00a2\u0006\u0010\n\u0006\b\u0097\u0001\u0010\u0098\u0001\u001a\u0006\b\u0099\u0001\u0010\u009a\u0001R*\u0010\u009b\u0001\u001a\u00020^2\u0007\u0010\u008e\u0001\u001a\u00020^8\u0006@BX\u0086.\u00a2\u0006\u0010\n\u0006\b\u009b\u0001\u0010\u0098\u0001\u001a\u0006\b\u009c\u0001\u0010\u009a\u0001\u00a8\u0006\u009e\u0001"}, d2={"Lcom/cobblemon/mod/common/api/berry/Berry;", "", "Lnet/minecraft/resources/ResourceLocation;", "identifier", "Lkotlin/ranges/IntRange;", "baseYield", "", "Lnet/minecraft/tags/TagKey;", "Lnet/minecraft/world/level/biome/Biome;", "preferredBiomeTags", "growthTime", "refreshRate", "Ljava/util/EnumSet;", "Lcom/cobblemon/mod/common/api/mulch/MulchVariant;", "favoriteMulches", "", "Lcom/cobblemon/mod/common/api/berry/GrowthFactor;", "growthFactors", "Lcom/cobblemon/mod/common/api/berry/spawncondition/BerrySpawnCondition;", "spawnConditions", "", "Lcom/cobblemon/mod/common/api/berry/GrowthPoint;", "growthPoints", "", "randomizedGrowthPoints", "", "mutations", "Lnet/minecraft/world/phys/AABB;", "sproutShapeBoxes", "matureShapeBoxes", "Lcom/cobblemon/mod/common/api/cooking/Flavour;", "", "flavours", "Lnet/minecraft/world/item/DyeColor;", "colour", "Ljava/awt/Color;", "tintIndexes", "flowerModelIdentifier", "flowerTexture", "fruitModelIdentifier", "fruitTexture", "stageOnePositioning", "pokeSnackPositionings", "", "weight", "boneMealChance", "<init>", "(Lnet/minecraft/resources/ResourceLocation;Lkotlin/ranges/IntRange;Ljava/util/List;Lkotlin/ranges/IntRange;Lkotlin/ranges/IntRange;Ljava/util/EnumSet;Ljava/util/Collection;Ljava/util/List;[Lcom/cobblemon/mod/common/api/berry/GrowthPoint;ZLjava/util/Map;Ljava/util/Collection;Ljava/util/Collection;Ljava/util/Map;Lnet/minecraft/world/item/DyeColor;Ljava/util/Map;Lnet/minecraft/resources/ResourceLocation;Lnet/minecraft/resources/ResourceLocation;Lnet/minecraft/resources/ResourceLocation;Lnet/minecraft/resources/ResourceLocation;Lcom/cobblemon/mod/common/api/berry/GrowthPoint;[Lcom/cobblemon/mod/common/api/berry/GrowthPoint;FF)V", "Lcom/cobblemon/mod/common/item/berry/BerryItem;", "item", "()Lcom/cobblemon/mod/common/item/berry/BerryItem;", "Lcom/cobblemon/mod/common/block/BerryBlock;", "block", "()Lcom/cobblemon/mod/common/block/BerryBlock;", "flavour", "flavor", "(Lcom/cobblemon/mod/common/api/cooking/Flavour;)I", "Lcom/cobblemon/mod/common/pokemon/Nature;", "nature", "dislikedBy", "(Lcom/cobblemon/mod/common/pokemon/Nature;)Z", "Lnet/minecraft/world/level/Level;", "world", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/world/entity/LivingEntity;", "placer", "calculateYield", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/entity/LivingEntity;)I", "minYield", "()I", "maxYield", "partner", "canMutateWith", "(Lcom/cobblemon/mod/common/api/berry/Berry;)Z", "mutationWith", "(Lcom/cobblemon/mod/common/api/berry/Berry;)Lcom/cobblemon/mod/common/api/berry/Berry;", "resulting", "partnerForMutation", "", "validate$common", "()V", "validate", "Lnet/minecraft/network/RegistryFriendlyByteBuf;", "buffer", "encode$common", "(Lnet/minecraft/network/RegistryFriendlyByteBuf;)V", "encode", "Lkotlin/Pair;", "bonusYield", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/core/BlockPos;)Lkotlin/Pair;", "boxes", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "createAndUniteShapes", "(Ljava/util/Collection;)Lnet/minecraft/world/phys/shapes/VoxelShape;", "Lkotlin/ranges/IntRange;", "getBaseYield", "()Lkotlin/ranges/IntRange;", "Ljava/util/List;", "getPreferredBiomeTags", "()Ljava/util/List;", "getGrowthTime", "getRefreshRate", "Ljava/util/EnumSet;", "getFavoriteMulches", "()Ljava/util/EnumSet;", "Ljava/util/Collection;", "getGrowthFactors", "()Ljava/util/Collection;", "getSpawnConditions", "[Lcom/cobblemon/mod/common/api/berry/GrowthPoint;", "getGrowthPoints", "()[Lcom/cobblemon/mod/common/api/berry/GrowthPoint;", "setGrowthPoints", "([Lcom/cobblemon/mod/common/api/berry/GrowthPoint;)V", "Z", "getRandomizedGrowthPoints", "()Z", "Ljava/util/Map;", "getMutations", "()Ljava/util/Map;", "getFlavours", "Lnet/minecraft/world/item/DyeColor;", "getColour", "()Lnet/minecraft/world/item/DyeColor;", "getTintIndexes", "Lnet/minecraft/resources/ResourceLocation;", "getFlowerModelIdentifier", "()Lnet/minecraft/resources/ResourceLocation;", "getFlowerTexture", "getFruitModelIdentifier", "getFruitTexture", "Lcom/cobblemon/mod/common/api/berry/GrowthPoint;", "getStageOnePositioning", "()Lcom/cobblemon/mod/common/api/berry/GrowthPoint;", "getPokeSnackPositionings", "F", "getWeight", "()F", "getBoneMealChance", "value", "getIdentifier", "setIdentifier$common", "(Lnet/minecraft/resources/ResourceLocation;)V", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "shapedFlower", "Ljava/util/HashMap;", "shapedFruit", "sproutShape", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "getSproutShape", "()Lnet/minecraft/world/phys/shapes/VoxelShape;", "matureShape", "getMatureShape", "Companion", "common"})
@SourceDebugExtension(value={"SMAP\nBerry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Berry.kt\ncom/cobblemon/mod/common/api/berry/Berry\n+ 2 EventObservables.kt\ncom/cobblemon/mod/common/api/reactive/EventObservable\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,382:1\n17#2,2:383\n19#2:387\n13805#3,2:385\n1#4:388\n1869#5,2:389\n1869#5,2:391\n1869#5,2:393\n*S KotlinDebug\n*F\n+ 1 Berry.kt\ncom/cobblemon/mod/common/api/berry/Berry\n*L\n180#1:383,2\n180#1:387\n180#1:385,2\n250#1:389,2\n322#1:391,2\n335#1:393,2\n*E\n"})
public final class Berry {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IntRange baseYield;
    @NotNull
    private final List<TagKey<Biome>> preferredBiomeTags;
    @NotNull
    private final IntRange growthTime;
    @NotNull
    private final IntRange refreshRate;
    @NotNull
    private final EnumSet<MulchVariant> favoriteMulches;
    @NotNull
    private final Collection<GrowthFactor> growthFactors;
    @NotNull
    private final List<BerrySpawnCondition> spawnConditions;
    @NotNull
    private GrowthPoint[] growthPoints;
    private final boolean randomizedGrowthPoints;
    @NotNull
    private final Map<ResourceLocation, ResourceLocation> mutations;
    @SerializedName(value="sproutShape")
    @NotNull
    private final Collection<AABB> sproutShapeBoxes;
    @SerializedName(value="matureShape")
    @NotNull
    private final Collection<AABB> matureShapeBoxes;
    @SerializedName(value="flavours", alternate={"flavor"})
    @NotNull
    private final Map<Flavour, Integer> flavours;
    @SerializedName(value="colour", alternate={"color"})
    @NotNull
    private final DyeColor colour;
    @NotNull
    private final Map<Integer, Color> tintIndexes;
    @SerializedName(value="flowerModel")
    @NotNull
    private final ResourceLocation flowerModelIdentifier;
    @NotNull
    private final ResourceLocation flowerTexture;
    @SerializedName(value="fruitModel")
    @NotNull
    private final ResourceLocation fruitModelIdentifier;
    @NotNull
    private final ResourceLocation fruitTexture;
    @NotNull
    private final GrowthPoint stageOnePositioning;
    @NotNull
    private final GrowthPoint[] pokeSnackPositionings;
    private final float weight;
    private final float boneMealChance;
    @NotNull
    private transient ResourceLocation identifier;
    private transient HashMap<Integer, VoxelShape> shapedFlower;
    private transient HashMap<Integer, VoxelShape> shapedFruit;
    private transient VoxelShape sproutShape;
    private transient VoxelShape matureShape;
    public static final int RICH_MULCH_MIN = 1;
    public static final int RICH_MULCH_MAX = 2;

    public Berry(@NotNull ResourceLocation identifier2, @NotNull IntRange baseYield, @NotNull List<TagKey<Biome>> preferredBiomeTags, @NotNull IntRange growthTime, @NotNull IntRange refreshRate, @NotNull EnumSet<MulchVariant> favoriteMulches, @NotNull Collection<? extends GrowthFactor> growthFactors, @NotNull List<? extends BerrySpawnCondition> spawnConditions, @NotNull GrowthPoint[] growthPoints, boolean randomizedGrowthPoints, @NotNull Map<ResourceLocation, ResourceLocation> mutations, @NotNull Collection<? extends AABB> sproutShapeBoxes, @NotNull Collection<? extends AABB> matureShapeBoxes, @NotNull Map<Flavour, Integer> flavours, @NotNull DyeColor colour, @NotNull Map<Integer, ? extends Color> tintIndexes, @NotNull ResourceLocation flowerModelIdentifier, @NotNull ResourceLocation flowerTexture, @NotNull ResourceLocation fruitModelIdentifier, @NotNull ResourceLocation fruitTexture, @NotNull GrowthPoint stageOnePositioning, @NotNull GrowthPoint[] pokeSnackPositionings, float weight, float boneMealChance) {
        Intrinsics.checkNotNullParameter((Object)identifier2, (String)"identifier");
        Intrinsics.checkNotNullParameter((Object)baseYield, (String)"baseYield");
        Intrinsics.checkNotNullParameter(preferredBiomeTags, (String)"preferredBiomeTags");
        Intrinsics.checkNotNullParameter((Object)growthTime, (String)"growthTime");
        Intrinsics.checkNotNullParameter((Object)refreshRate, (String)"refreshRate");
        Intrinsics.checkNotNullParameter(favoriteMulches, (String)"favoriteMulches");
        Intrinsics.checkNotNullParameter(growthFactors, (String)"growthFactors");
        Intrinsics.checkNotNullParameter(spawnConditions, (String)"spawnConditions");
        Intrinsics.checkNotNullParameter((Object)growthPoints, (String)"growthPoints");
        Intrinsics.checkNotNullParameter(mutations, (String)"mutations");
        Intrinsics.checkNotNullParameter(sproutShapeBoxes, (String)"sproutShapeBoxes");
        Intrinsics.checkNotNullParameter(matureShapeBoxes, (String)"matureShapeBoxes");
        Intrinsics.checkNotNullParameter(flavours, (String)"flavours");
        Intrinsics.checkNotNullParameter((Object)colour, (String)"colour");
        Intrinsics.checkNotNullParameter(tintIndexes, (String)"tintIndexes");
        Intrinsics.checkNotNullParameter((Object)flowerModelIdentifier, (String)"flowerModelIdentifier");
        Intrinsics.checkNotNullParameter((Object)flowerTexture, (String)"flowerTexture");
        Intrinsics.checkNotNullParameter((Object)fruitModelIdentifier, (String)"fruitModelIdentifier");
        Intrinsics.checkNotNullParameter((Object)fruitTexture, (String)"fruitTexture");
        Intrinsics.checkNotNullParameter((Object)stageOnePositioning, (String)"stageOnePositioning");
        Intrinsics.checkNotNullParameter((Object)pokeSnackPositionings, (String)"pokeSnackPositionings");
        this.baseYield = baseYield;
        this.preferredBiomeTags = preferredBiomeTags;
        this.growthTime = growthTime;
        this.refreshRate = refreshRate;
        this.favoriteMulches = favoriteMulches;
        this.growthFactors = growthFactors;
        this.spawnConditions = spawnConditions;
        this.growthPoints = growthPoints;
        this.randomizedGrowthPoints = randomizedGrowthPoints;
        this.mutations = mutations;
        this.sproutShapeBoxes = sproutShapeBoxes;
        this.matureShapeBoxes = matureShapeBoxes;
        this.flavours = flavours;
        this.colour = colour;
        this.tintIndexes = tintIndexes;
        this.flowerModelIdentifier = flowerModelIdentifier;
        this.flowerTexture = flowerTexture;
        this.fruitModelIdentifier = fruitModelIdentifier;
        this.fruitTexture = fruitTexture;
        this.stageOnePositioning = stageOnePositioning;
        this.pokeSnackPositionings = pokeSnackPositionings;
        this.weight = weight;
        this.boneMealChance = boneMealChance;
        this.identifier = identifier2;
        this.validate$common();
    }

    public /* synthetic */ Berry(ResourceLocation resourceLocation, IntRange intRange, List list, IntRange intRange2, IntRange intRange3, EnumSet enumSet, Collection collection, List list2, GrowthPoint[] growthPointArray, boolean bl, Map map, Collection collection2, Collection collection3, Map map2, DyeColor dyeColor, Map map3, ResourceLocation resourceLocation2, ResourceLocation resourceLocation3, ResourceLocation resourceLocation4, ResourceLocation resourceLocation5, GrowthPoint growthPoint, GrowthPoint[] growthPointArray2, float f, float f2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x200) != 0) {
            bl = true;
        }
        this(resourceLocation, intRange, list, intRange2, intRange3, enumSet, collection, list2, growthPointArray, bl, map, collection2, collection3, map2, dyeColor, map3, resourceLocation2, resourceLocation3, resourceLocation4, resourceLocation5, growthPoint, growthPointArray2, f, f2);
    }

    @NotNull
    public final IntRange getBaseYield() {
        return this.baseYield;
    }

    @NotNull
    public final List<TagKey<Biome>> getPreferredBiomeTags() {
        return this.preferredBiomeTags;
    }

    @NotNull
    public final IntRange getGrowthTime() {
        return this.growthTime;
    }

    @NotNull
    public final IntRange getRefreshRate() {
        return this.refreshRate;
    }

    @NotNull
    public final EnumSet<MulchVariant> getFavoriteMulches() {
        return this.favoriteMulches;
    }

    @NotNull
    public final Collection<GrowthFactor> getGrowthFactors() {
        return this.growthFactors;
    }

    @NotNull
    public final List<BerrySpawnCondition> getSpawnConditions() {
        return this.spawnConditions;
    }

    @NotNull
    public final GrowthPoint[] getGrowthPoints() {
        return this.growthPoints;
    }

    public final void setGrowthPoints(@NotNull GrowthPoint[] growthPointArray) {
        Intrinsics.checkNotNullParameter((Object)growthPointArray, (String)"<set-?>");
        this.growthPoints = growthPointArray;
    }

    public final boolean getRandomizedGrowthPoints() {
        return this.randomizedGrowthPoints;
    }

    @NotNull
    public final Map<ResourceLocation, ResourceLocation> getMutations() {
        return this.mutations;
    }

    @NotNull
    public final Map<Flavour, Integer> getFlavours() {
        return this.flavours;
    }

    @NotNull
    public final DyeColor getColour() {
        return this.colour;
    }

    @NotNull
    public final Map<Integer, Color> getTintIndexes() {
        return this.tintIndexes;
    }

    @NotNull
    public final ResourceLocation getFlowerModelIdentifier() {
        return this.flowerModelIdentifier;
    }

    @NotNull
    public final ResourceLocation getFlowerTexture() {
        return this.flowerTexture;
    }

    @NotNull
    public final ResourceLocation getFruitModelIdentifier() {
        return this.fruitModelIdentifier;
    }

    @NotNull
    public final ResourceLocation getFruitTexture() {
        return this.fruitTexture;
    }

    @NotNull
    public final GrowthPoint getStageOnePositioning() {
        return this.stageOnePositioning;
    }

    @NotNull
    public final GrowthPoint[] getPokeSnackPositionings() {
        return this.pokeSnackPositionings;
    }

    public final float getWeight() {
        return this.weight;
    }

    public final float getBoneMealChance() {
        return this.boneMealChance;
    }

    @NotNull
    public final ResourceLocation getIdentifier() {
        return this.identifier;
    }

    public final void setIdentifier$common(@NotNull ResourceLocation resourceLocation) {
        Intrinsics.checkNotNullParameter((Object)resourceLocation, (String)"<set-?>");
        this.identifier = resourceLocation;
    }

    @NotNull
    public final VoxelShape getSproutShape() {
        VoxelShape voxelShape = this.sproutShape;
        if (voxelShape != null) {
            return voxelShape;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"sproutShape");
        return null;
    }

    @NotNull
    public final VoxelShape getMatureShape() {
        VoxelShape voxelShape = this.matureShape;
        if (voxelShape != null) {
            return voxelShape;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"matureShape");
        return null;
    }

    @Nullable
    public final BerryItem item() {
        return CobblemonItems.INSTANCE.berries().get(this.identifier);
    }

    @Nullable
    public final BerryBlock block() {
        return CobblemonBlocks.INSTANCE.berries().get(this.identifier);
    }

    public final int flavor(@NotNull Flavour flavour) {
        Intrinsics.checkNotNullParameter((Object)((Object)flavour), (String)"flavour");
        Integer n = this.flavours.get((Object)flavour);
        return n != null ? n : 0;
    }

    public final boolean dislikedBy(@NotNull Nature nature) {
        Intrinsics.checkNotNullParameter((Object)nature, (String)"nature");
        Flavour flavour = nature.getDislikedFlavour();
        if (flavour == null) {
            return false;
        }
        Flavour dislikedFlavor = flavour;
        return this.flavor(dislikedFlavor) > 0;
    }

    /*
     * WARNING - void declaration
     */
    public final int calculateYield(@NotNull Level world, @NotNull BlockState state, @NotNull BlockPos pos, @Nullable LivingEntity placer) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        int base = RangesKt.random((IntRange)this.baseYield, (Random)((Random)Random.Default));
        Pair<Integer, Collection<GrowthFactor>> bonus = this.bonusYield(world, state, pos);
        int yield = 0;
        yield = base + ((Number)bonus.getFirst()).intValue();
        BlockEntity blockEntity = world.getBlockEntity(pos);
        Intrinsics.checkNotNull((Object)blockEntity, (String)"null cannot be cast to non-null type com.cobblemon.mod.common.block.entity.BerryBlockEntity");
        BerryBlockEntity treeEntity = (BerryBlockEntity)blockEntity;
        if (BerryBlock.Companion.getMulch(treeEntity) == MulchVariant.RICH) {
            yield += world.random.nextIntBetweenInclusive(1, 2);
            treeEntity.decrementMulchDuration(world, pos, state);
        }
        yield = RangesKt.coerceAtMost((int)yield, (int)this.growthPoints.length);
        BerryYieldCalculationEvent event = new BerryYieldCalculationEvent(this, world, state, pos, placer, yield, (Collection)bonus.getSecond());
        EventObservable<BerryYieldCalculationEvent> eventObservable = CobblemonEvents.BERRY_YIELD;
        BerryYieldCalculationEvent[] berryYieldCalculationEventArray = new BerryYieldCalculationEvent[]{event};
        BerryYieldCalculationEvent[] events$iv = berryYieldCalculationEventArray;
        boolean $i$f$post = false;
        this_$iv.emit(Arrays.copyOf(events$iv, events$iv.length));
        BerryYieldCalculationEvent[] $this$forEach$iv$iv = events$iv;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv$iv.length;
        for (int i = 0; i < n; ++i) {
            BerryYieldCalculationEvent element$iv$iv;
            BerryYieldCalculationEvent it = element$iv$iv = $this$forEach$iv$iv[i];
            boolean bl = false;
            yield = it.getYield();
        }
        return yield;
    }

    public static /* synthetic */ int calculateYield$default(Berry berry, Level level, BlockState blockState, BlockPos blockPos, LivingEntity livingEntity, int n, Object object) {
        if ((n & 8) != 0) {
            livingEntity = null;
        }
        return berry.calculateYield(level, blockState, blockPos, livingEntity);
    }

    /*
     * WARNING - void declaration
     */
    public final int minYield() {
        int n;
        Iterable iterable = this.growthFactors;
        int n2 = this.baseYield.getFirst();
        int n3 = 0;
        for (Object t : iterable) {
            void it;
            GrowthFactor growthFactor = (GrowthFactor)t;
            n = n3;
            boolean bl = false;
            int n4 = it.minYield();
            n3 = n + n4;
        }
        n = n3;
        return n2 + n;
    }

    /*
     * WARNING - void declaration
     */
    public final int maxYield() {
        int n;
        Iterable iterable = this.growthFactors;
        int n2 = this.baseYield.getLast();
        int n3 = 0;
        for (Object t : iterable) {
            void it;
            GrowthFactor growthFactor = (GrowthFactor)t;
            n = n3;
            boolean bl = false;
            int n4 = it.maxYield();
            n3 = n + n4;
        }
        n = n3;
        return n2 + n + 2;
    }

    public final boolean canMutateWith(@NotNull Berry partner) {
        Intrinsics.checkNotNullParameter((Object)partner, (String)"partner");
        return this.mutationWith(partner) != null;
    }

    @Nullable
    public final Berry mutationWith(@NotNull Berry partner) {
        Intrinsics.checkNotNullParameter((Object)partner, (String)"partner");
        ResourceLocation resourceLocation = this.mutations.get(partner.identifier);
        if (resourceLocation == null) {
            return null;
        }
        ResourceLocation berryIdentifier = resourceLocation;
        return Berries.getByIdentifier(berryIdentifier);
    }

    @Nullable
    public final Berry partnerForMutation(@NotNull Berry resulting) {
        Berry berry;
        block1: {
            Intrinsics.checkNotNullParameter((Object)resulting, (String)"resulting");
            for (Map.Entry<ResourceLocation, ResourceLocation> entry : this.mutations.entrySet()) {
                boolean bl = false;
                ResourceLocation partner = entry.getKey();
                ResourceLocation result = entry.getValue();
                Berry object2 = Intrinsics.areEqual((Object)result, (Object)resulting.identifier) ? Berries.getByIdentifier(partner) : null;
                if (object2 == null) continue;
                berry = object2;
                break block1;
            }
            berry = null;
        }
        return berry;
    }

    public final void validate$common() {
        if (this.baseYield.getFirst() < 0 || this.baseYield.getLast() < 0) {
            throw new IllegalArgumentException("A berry base yield must be a positive range");
        }
        if (this.growthTime.getFirst() < 0 || this.growthTime.getLast() < 0) {
            throw new IllegalArgumentException("The growth time must be a positive range");
        }
        if (this.refreshRate.getFirst() < 0 || this.refreshRate.getLast() < 0) {
            throw new IllegalArgumentException("The refresh rate must be a positive range");
        }
        Iterable $this$forEach$iv = this.growthFactors;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GrowthFactor it = (GrowthFactor)element$iv;
            boolean bl = false;
            it.validateArguments();
        }
        this.shapedFlower = new HashMap();
        this.shapedFruit = new HashMap();
        this.sproutShape = this.createAndUniteShapes(this.sproutShapeBoxes);
        this.matureShape = this.createAndUniteShapes(this.matureShapeBoxes);
    }

    public final void encode$common(@NotNull RegistryFriendlyByteBuf buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        BufferUtilsKt.writeIdentifier((ByteBuf)buffer, this.identifier);
        buffer.writeInt(this.baseYield.getFirst());
        buffer.writeInt(this.baseYield.getLast());
        buffer.writeEnumSet(this.favoriteMulches, MulchVariant.class);
        buffer.writeInt(this.growthTime.getFirst());
        buffer.writeInt(this.growthTime.getLast());
        buffer.writeInt(this.refreshRate.getFirst());
        buffer.writeInt(this.refreshRate.getLast());
        buffer.writeCollection((Collection)ArraysKt.toList((Object[])this.growthPoints), (arg_0, arg_1) -> Berry.encode$lambda$1(Berry::encode$lambda$0, arg_0, arg_1));
        buffer.writeBoolean(this.randomizedGrowthPoints);
        buffer.writeMap(this.mutations, (arg_0, arg_1) -> Berry.encode$lambda$3(Berry::encode$lambda$2, arg_0, arg_1), (arg_0, arg_1) -> Berry.encode$lambda$5(Berry::encode$lambda$4, arg_0, arg_1));
        buffer.writeCollection(this.sproutShapeBoxes, (arg_0, arg_1) -> Berry.encode$lambda$7(Berry::encode$lambda$6, arg_0, arg_1));
        buffer.writeCollection(this.matureShapeBoxes, (arg_0, arg_1) -> Berry.encode$lambda$9(Berry::encode$lambda$8, arg_0, arg_1));
        buffer.writeMap(this.flavours, (arg_0, arg_1) -> Berry.encode$lambda$11(Berry::encode$lambda$10, arg_0, arg_1), (arg_0, arg_1) -> Berry.encode$lambda$13(Berry::encode$lambda$12, arg_0, arg_1));
        BufferUtilsKt.writeEnumConstant((ByteBuf)buffer, (Enum)this.colour);
        buffer.writeMap(this.tintIndexes, (arg_0, arg_1) -> Berry.encode$lambda$15(Berry::encode$lambda$14, arg_0, arg_1), (arg_0, arg_1) -> Berry.encode$lambda$17(Berry::encode$lambda$16, arg_0, arg_1));
        BufferUtilsKt.writeIdentifier((ByteBuf)buffer, this.flowerModelIdentifier);
        BufferUtilsKt.writeIdentifier((ByteBuf)buffer, this.flowerTexture);
        BufferUtilsKt.writeIdentifier((ByteBuf)buffer, this.fruitModelIdentifier);
        BufferUtilsKt.writeIdentifier((ByteBuf)buffer, this.fruitTexture);
        buffer.writeDouble(this.stageOnePositioning.getPosition().x);
        buffer.writeDouble(this.stageOnePositioning.getPosition().y);
        buffer.writeDouble(this.stageOnePositioning.getPosition().z);
        buffer.writeDouble(this.stageOnePositioning.getRotation().x);
        buffer.writeDouble(this.stageOnePositioning.getRotation().y);
        buffer.writeDouble(this.stageOnePositioning.getRotation().z);
        buffer.writeCollection((Collection)ArraysKt.toList((Object[])this.pokeSnackPositionings), (arg_0, arg_1) -> Berry.encode$lambda$19(Berry::encode$lambda$18, arg_0, arg_1));
        buffer.writeFloat(this.boneMealChance);
    }

    private final Pair<Integer, Collection<GrowthFactor>> bonusYield(Level world, BlockState state, BlockPos pos) {
        int bonus = 0;
        ArrayList passed = new ArrayList();
        BlockEntity blockEntity = world.getBlockEntity(pos);
        BerryBlockEntity berryBlockEntity = blockEntity instanceof BerryBlockEntity ? (BerryBlockEntity)blockEntity : null;
        if (berryBlockEntity == null) {
            return TuplesKt.to((Object)0, passed);
        }
        BerryBlockEntity treeEntity = berryBlockEntity;
        MulchVariant mulchVariant = BerryBlock.Companion.getMulch(treeEntity);
        boolean hasBiomeMulch = this.favoriteMulches.contains((Object)mulchVariant);
        Iterable $this$forEach$iv = this.growthFactors;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GrowthFactor factor = (GrowthFactor)element$iv;
            boolean bl = false;
            if (factor.isValid((LevelReader)world, state, pos)) {
                bonus += factor.yield();
                ((Collection)passed).add(factor);
                continue;
            }
            if (!hasBiomeMulch) continue;
            bonus += factor.yield();
        }
        return TuplesKt.to((Object)bonus, passed);
    }

    private final VoxelShape createAndUniteShapes(Collection<? extends AABB> boxes) {
        VoxelShape shape = null;
        Iterable $this$forEach$iv = boxes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AABB box = (AABB)element$iv;
            boolean bl = false;
            VoxelShape outerShape = shape;
            shape = outerShape == null ? Block.box((double)box.minX, (double)box.minY, (double)box.minZ, (double)box.maxX, (double)box.maxY, (double)box.maxZ) : Shapes.or((VoxelShape)outerShape, (VoxelShape)Block.box((double)box.minX, (double)box.minY, (double)box.minZ, (double)box.maxX, (double)box.maxY, (double)box.maxZ));
        }
        VoxelShape voxelShape = shape;
        if (voxelShape == null) {
            VoxelShape voxelShape2 = Shapes.block();
            voxelShape = voxelShape2;
            Intrinsics.checkNotNullExpressionValue((Object)voxelShape2, (String)"block(...)");
        }
        return voxelShape;
    }

    private static final Unit encode$lambda$0(FriendlyByteBuf writer, GrowthPoint value) {
        writer.writeDouble(value.getPosition().x);
        writer.writeDouble(value.getPosition().y);
        writer.writeDouble(value.getPosition().z);
        writer.writeDouble(value.getRotation().x);
        writer.writeDouble(value.getRotation().y);
        writer.writeDouble(value.getRotation().z);
        return Unit.INSTANCE;
    }

    private static final void encode$lambda$1(Function2 $tmp0, Object object, GrowthPoint object2) {
        $tmp0.invoke(object, (Object)object2);
    }

    private static final Unit encode$lambda$2(FriendlyByteBuf writer, ResourceLocation key) {
        Intrinsics.checkNotNull((Object)writer);
        ByteBuf byteBuf = (ByteBuf)writer;
        Intrinsics.checkNotNull((Object)key);
        BufferUtilsKt.writeIdentifier(byteBuf, key);
        return Unit.INSTANCE;
    }

    private static final void encode$lambda$3(Function2 $tmp0, Object object, ResourceLocation object2) {
        $tmp0.invoke(object, (Object)object2);
    }

    private static final Unit encode$lambda$4(FriendlyByteBuf writer, ResourceLocation value) {
        Intrinsics.checkNotNull((Object)writer);
        ByteBuf byteBuf = (ByteBuf)writer;
        Intrinsics.checkNotNull((Object)value);
        BufferUtilsKt.writeIdentifier(byteBuf, value);
        return Unit.INSTANCE;
    }

    private static final void encode$lambda$5(Function2 $tmp0, Object object, ResourceLocation object2) {
        $tmp0.invoke(object, (Object)object2);
    }

    private static final Unit encode$lambda$6(FriendlyByteBuf writer, AABB value) {
        Intrinsics.checkNotNull((Object)writer);
        ByteBuf byteBuf = (ByteBuf)writer;
        Intrinsics.checkNotNull((Object)value);
        NetExtensionsKt.writeBox(byteBuf, value);
        return Unit.INSTANCE;
    }

    private static final void encode$lambda$7(Function2 $tmp0, Object object, AABB object2) {
        $tmp0.invoke(object, (Object)object2);
    }

    private static final Unit encode$lambda$8(FriendlyByteBuf writer, AABB value) {
        Intrinsics.checkNotNull((Object)writer);
        ByteBuf byteBuf = (ByteBuf)writer;
        Intrinsics.checkNotNull((Object)value);
        NetExtensionsKt.writeBox(byteBuf, value);
        return Unit.INSTANCE;
    }

    private static final void encode$lambda$9(Function2 $tmp0, Object object, AABB object2) {
        $tmp0.invoke(object, (Object)object2);
    }

    private static final Unit encode$lambda$10(FriendlyByteBuf writer, Flavour key) {
        Intrinsics.checkNotNull((Object)writer);
        ByteBuf byteBuf = (ByteBuf)writer;
        Intrinsics.checkNotNull((Object)((Object)key));
        BufferUtilsKt.writeEnumConstant(byteBuf, key);
        return Unit.INSTANCE;
    }

    private static final void encode$lambda$11(Function2 $tmp0, Object object, Flavour object2) {
        $tmp0.invoke(object, (Object)object2);
    }

    private static final Unit encode$lambda$12(FriendlyByteBuf writer, Integer value) {
        Intrinsics.checkNotNull((Object)value);
        writer.writeInt(value.intValue());
        return Unit.INSTANCE;
    }

    private static final void encode$lambda$13(Function2 $tmp0, Object object, Integer object2) {
        $tmp0.invoke(object, (Object)object2);
    }

    private static final Unit encode$lambda$14(FriendlyByteBuf writer, Integer key) {
        Intrinsics.checkNotNull((Object)key);
        writer.writeInt(key.intValue());
        return Unit.INSTANCE;
    }

    private static final void encode$lambda$15(Function2 $tmp0, Object object, Integer object2) {
        $tmp0.invoke(object, (Object)object2);
    }

    private static final Unit encode$lambda$16(FriendlyByteBuf writer, Color value) {
        writer.writeInt(value.getRGB());
        return Unit.INSTANCE;
    }

    private static final void encode$lambda$17(Function2 $tmp0, Object object, Color object2) {
        $tmp0.invoke(object, (Object)object2);
    }

    private static final Unit encode$lambda$18(FriendlyByteBuf writer, GrowthPoint value) {
        writer.writeDouble(value.getPosition().x);
        writer.writeDouble(value.getPosition().y);
        writer.writeDouble(value.getPosition().z);
        writer.writeDouble(value.getRotation().x);
        writer.writeDouble(value.getRotation().y);
        writer.writeDouble(value.getRotation().z);
        return Unit.INSTANCE;
    }

    private static final void encode$lambda$19(Function2 $tmp0, Object object, GrowthPoint object2) {
        $tmp0.invoke(object, (Object)object2);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\t\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0000\u00a2\u0006\u0004\b\u0007\u0010\bR\u0014\u0010\u000b\u001a\u00020\n8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\n8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\r\u0010\f\u00a8\u0006\u000e"}, d2={"Lcom/cobblemon/mod/common/api/berry/Berry$Companion;", "", "<init>", "()V", "Lnet/minecraft/network/RegistryFriendlyByteBuf;", "buffer", "Lcom/cobblemon/mod/common/api/berry/Berry;", "decode$common", "(Lnet/minecraft/network/RegistryFriendlyByteBuf;)Lcom/cobblemon/mod/common/api/berry/Berry;", "decode", "", "RICH_MULCH_MIN", "I", "RICH_MULCH_MAX", "common"})
    @SourceDebugExtension(value={"SMAP\nBerry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Berry.kt\ncom/cobblemon/mod/common/api/berry/Berry$Companion\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,382:1\n37#2,2:383\n37#2,2:385\n*S KotlinDebug\n*F\n+ 1 Berry.kt\ncom/cobblemon/mod/common/api/berry/Berry$Companion\n*L\n360#1:383,2\n375#1:385,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Berry decode$common(@NotNull RegistryFriendlyByteBuf buffer) {
            void $this$toTypedArray$iv;
            void $this$toTypedArray$iv2;
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            ResourceLocation identifier2 = BufferUtilsKt.readIdentifier((ByteBuf)buffer);
            IntRange baseYield = new IntRange(buffer.readInt(), buffer.readInt());
            EnumSet favMulchs = buffer.readEnumSet(MulchVariant.class);
            IntRange growthTime = new IntRange(buffer.readInt(), buffer.readInt());
            IntRange refreshRate = new IntRange(buffer.readInt(), buffer.readInt());
            List list = buffer.readList(arg_0 -> Companion.decode$lambda$1(Companion::decode$lambda$0, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"readList(...)");
            Collection collection = list;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv2;
            GrowthPoint[] growthPoints = thisCollection$iv.toArray(new GrowthPoint[0]);
            boolean randomizedGrowthPoints = buffer.readBoolean();
            Map mutations = buffer.readMap(arg_0 -> Companion.decode$lambda$3(Companion::decode$lambda$2, arg_0), arg_0 -> Companion.decode$lambda$5(Companion::decode$lambda$4, arg_0));
            List sproutShapeBoxes = buffer.readList(arg_0 -> Companion.decode$lambda$7(Companion::decode$lambda$6, arg_0));
            List matureShapeBoxes = buffer.readList(arg_0 -> Companion.decode$lambda$9(Companion::decode$lambda$8, arg_0));
            Map flavors = buffer.readMap(arg_0 -> Companion.decode$lambda$11(Companion::decode$lambda$10, arg_0), arg_0 -> Companion.decode$lambda$13(Companion::decode$lambda$12, arg_0));
            DyeColor colour = BufferUtilsKt.readEnumConstant((ByteBuf)buffer, DyeColor.class);
            Map tintIndexes = buffer.readMap(arg_0 -> Companion.decode$lambda$15(Companion::decode$lambda$14, arg_0), arg_0 -> Companion.decode$lambda$17(Companion::decode$lambda$16, arg_0));
            ResourceLocation flowerModelIdentifier = BufferUtilsKt.readIdentifier((ByteBuf)buffer);
            ResourceLocation flowerTexture = BufferUtilsKt.readIdentifier((ByteBuf)buffer);
            ResourceLocation fruitModelIdentifier = BufferUtilsKt.readIdentifier((ByteBuf)buffer);
            ResourceLocation fruitTexture = BufferUtilsKt.readIdentifier((ByteBuf)buffer);
            GrowthPoint stageOnePos = new GrowthPoint(new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble()), new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble()));
            List list2 = buffer.readList(arg_0 -> Companion.decode$lambda$19(Companion::decode$lambda$18, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"readList(...)");
            Collection collection2 = list2;
            boolean $i$f$toTypedArray2 = false;
            void thisCollection$iv2 = $this$toTypedArray$iv;
            GrowthPoint[] pokeSnackPos = thisCollection$iv2.toArray(new GrowthPoint[0]);
            float boneMealChance = buffer.readFloat();
            List list3 = CollectionsKt.emptyList();
            Intrinsics.checkNotNull((Object)favMulchs);
            Collection collection3 = SetsKt.emptySet();
            List list4 = CollectionsKt.emptyList();
            Intrinsics.checkNotNull((Object)mutations);
            Intrinsics.checkNotNull((Object)sproutShapeBoxes);
            Collection collection4 = sproutShapeBoxes;
            Intrinsics.checkNotNull((Object)matureShapeBoxes);
            Collection collection5 = matureShapeBoxes;
            Intrinsics.checkNotNull((Object)flavors);
            Intrinsics.checkNotNull((Object)tintIndexes);
            return new Berry(identifier2, baseYield, list3, growthTime, refreshRate, favMulchs, collection3, list4, growthPoints, randomizedGrowthPoints, mutations, collection4, collection5, flavors, colour, tintIndexes, flowerModelIdentifier, flowerTexture, fruitModelIdentifier, fruitTexture, stageOnePos, pokeSnackPos, 0.0f, boneMealChance);
        }

        private static final GrowthPoint decode$lambda$0(FriendlyByteBuf reader) {
            return new GrowthPoint(new Vec3(reader.readDouble(), reader.readDouble(), reader.readDouble()), new Vec3(reader.readDouble(), reader.readDouble(), reader.readDouble()));
        }

        private static final GrowthPoint decode$lambda$1(Function1 $tmp0, Object object) {
            return (GrowthPoint)$tmp0.invoke(object);
        }

        private static final ResourceLocation decode$lambda$2(FriendlyByteBuf reader) {
            Intrinsics.checkNotNull((Object)reader);
            return BufferUtilsKt.readIdentifier((ByteBuf)reader);
        }

        private static final ResourceLocation decode$lambda$3(Function1 $tmp0, Object object) {
            return (ResourceLocation)$tmp0.invoke(object);
        }

        private static final ResourceLocation decode$lambda$4(FriendlyByteBuf reader) {
            Intrinsics.checkNotNull((Object)reader);
            return BufferUtilsKt.readIdentifier((ByteBuf)reader);
        }

        private static final ResourceLocation decode$lambda$5(Function1 $tmp0, Object object) {
            return (ResourceLocation)$tmp0.invoke(object);
        }

        private static final AABB decode$lambda$6(FriendlyByteBuf it) {
            Intrinsics.checkNotNull((Object)it);
            return NetExtensionsKt.readBox((ByteBuf)it);
        }

        private static final AABB decode$lambda$7(Function1 $tmp0, Object object) {
            return (AABB)$tmp0.invoke(object);
        }

        private static final AABB decode$lambda$8(FriendlyByteBuf it) {
            Intrinsics.checkNotNull((Object)it);
            return NetExtensionsKt.readBox((ByteBuf)it);
        }

        private static final AABB decode$lambda$9(Function1 $tmp0, Object object) {
            return (AABB)$tmp0.invoke(object);
        }

        private static final Flavour decode$lambda$10(FriendlyByteBuf reader) {
            Intrinsics.checkNotNull((Object)reader);
            return BufferUtilsKt.readEnumConstant((ByteBuf)reader, Flavour.class);
        }

        private static final Flavour decode$lambda$11(Function1 $tmp0, Object object) {
            return (Flavour)((Object)$tmp0.invoke(object));
        }

        private static final Integer decode$lambda$12(FriendlyByteBuf reader) {
            return reader.readInt();
        }

        private static final Integer decode$lambda$13(Function1 $tmp0, Object object) {
            return (Integer)$tmp0.invoke(object);
        }

        private static final Integer decode$lambda$14(FriendlyByteBuf reader) {
            return reader.readInt();
        }

        private static final Integer decode$lambda$15(Function1 $tmp0, Object object) {
            return (Integer)$tmp0.invoke(object);
        }

        private static final Color decode$lambda$16(FriendlyByteBuf reader) {
            return new Color(reader.readInt());
        }

        private static final Color decode$lambda$17(Function1 $tmp0, Object object) {
            return (Color)$tmp0.invoke(object);
        }

        private static final GrowthPoint decode$lambda$18(FriendlyByteBuf reader) {
            return new GrowthPoint(new Vec3(reader.readDouble(), reader.readDouble(), reader.readDouble()), new Vec3(reader.readDouble(), reader.readDouble(), reader.readDouble()));
        }

        private static final GrowthPoint decode$lambda$19(Function1 $tmp0, Object object) {
            return (GrowthPoint)$tmp0.invoke(object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

