/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.cooking;

import com.cobblemon.mod.common.CobblemonItemComponents;
import com.cobblemon.mod.common.api.cooking.Flavour;
import com.cobblemon.mod.common.api.cooking.Seasoning;
import com.cobblemon.mod.common.api.cooking.Seasonings;
import com.cobblemon.mod.common.item.components.FlavourComponent;
import com.cobblemon.mod.common.item.components.IngredientComponent;
import com.cobblemon.mod.common.pokemon.Nature;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ!\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0015\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0015\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0015\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0018\u0010\u0017\u00a8\u0006\u0019"}, d2={"Lcom/cobblemon/mod/common/api/cooking/PokePuffUtils;", "", "<init>", "()V", "Lnet/minecraft/world/item/ItemStack;", "stack", "Lcom/cobblemon/mod/common/pokemon/Nature;", "nature", "", "calculateFriendshipChange", "(Lnet/minecraft/world/item/ItemStack;Lcom/cobblemon/mod/common/pokemon/Nature;)I", "Lkotlin/Pair;", "", "calculateBaseFriendship", "(Lnet/minecraft/world/item/ItemStack;)Lkotlin/Pair;", "Lcom/cobblemon/mod/common/api/cooking/Flavour;", "getDominantFlavour", "(Lnet/minecraft/world/item/ItemStack;)Lcom/cobblemon/mod/common/api/cooking/Flavour;", "flavour", "", "getFlavorNatureLabel", "(Lcom/cobblemon/mod/common/api/cooking/Flavour;)Ljava/lang/String;", "getFriendshipChangeLiked", "(Lnet/minecraft/world/item/ItemStack;)I", "getFriendshipChangeDisliked", "common"})
@SourceDebugExtension(value={"SMAP\nPokePuffUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PokePuffUtils.kt\ncom/cobblemon/mod/common/api/cooking/PokePuffUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,94:1\n1563#2:95\n1634#2,3:96\n1761#2,3:99\n504#3,7:102\n*S KotlinDebug\n*F\n+ 1 PokePuffUtils.kt\ncom/cobblemon/mod/common/api/cooking/PokePuffUtils\n*L\n46#1:95\n46#1:96,3\n48#1:99,3\n65#1:102,7\n*E\n"})
public final class PokePuffUtils {
    @NotNull
    public static final PokePuffUtils INSTANCE = new PokePuffUtils();

    private PokePuffUtils() {
    }

    public final int calculateFriendshipChange(@NotNull ItemStack stack, @NotNull Nature nature) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)nature, (String)"nature");
        Flavour flavour = this.getDominantFlavour(stack);
        if (flavour == null) {
            return 0;
        }
        Flavour dominantFlavour = flavour;
        boolean isNeutralNature = nature.getFavouriteFlavour() == nature.getDislikedFlavour();
        double baseFriendship = ((Number)this.calculateBaseFriendship(stack).component1()).doubleValue();
        int multiplier = dominantFlavour == nature.getFavouriteFlavour() || dominantFlavour == Flavour.MILD && isNeutralNature ? 10 : -7;
        return (int)(baseFriendship / (double)multiplier);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Pair<Double, Double> calculateBaseFriendship(@NotNull ItemStack stack) {
        boolean bl;
        boolean hasSugar;
        double baseFriendship;
        block6: {
            void $this$mapTo$iv$iv;
            Iterable itemStack;
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            Object object = (IngredientComponent)stack.get(CobblemonItemComponents.INGREDIENT);
            if (object == null || (object = ((IngredientComponent)object).getIngredientIds()) == null) {
                object = CollectionsKt.emptyList();
            }
            Object ingredientIds = object;
            baseFriendship = 0.0;
            Iterator iterator = ingredientIds.iterator();
            while (iterator.hasNext()) {
                Seasoning seasoning;
                ResourceLocation id = (ResourceLocation)iterator.next();
                Object object2 = BuiltInRegistries.ITEM.get(id);
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
                Item item = (Item)object2;
                itemStack = new ItemStack((ItemLike)item);
                if (Seasonings.INSTANCE.getFromItemStack((ItemStack)itemStack) == null) continue;
                Map<Flavour, Integer> map = seasoning.getFlavours();
                int dominantValue = map != null && (map = map.values()) != null && (map = (Integer)CollectionsKt.maxOrNull((Iterable)((Iterable)((Object)map)))) != null ? (Integer)((Object)map) : 0;
                baseFriendship += (double)dominantValue;
            }
            Iterable $this$map$iv = (Iterable)ingredientIds;
            boolean $i$f$map = false;
            itemStack = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ResourceLocation resourceLocation = (ResourceLocation)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(it.toString());
            }
            List ingredientStrings = (List)destination$iv$iv;
            hasSugar = ingredientStrings.contains("minecraft:sugar");
            Iterable $this$any$iv = ingredientStrings;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl3 = false;
                    Intrinsics.checkNotNull((Object)it);
                    if (!(StringsKt.startsWith$default((String)it, (String)"cobblemon:", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)it, (String)"_sweet", (boolean)false, (int)2, null))) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        boolean hasSweet = bl;
        double multiplier = hasSugar && hasSweet ? 5.0 : (hasSweet ? 2.25 : (hasSugar ? 1.75 : 1.0));
        double finalBaseFriendship = baseFriendship * multiplier;
        return TuplesKt.to((Object)finalBaseFriendship, (Object)multiplier);
    }

    @Nullable
    public final Flavour getDominantFlavour(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Object object = (FlavourComponent)stack.get(CobblemonItemComponents.FLAVOUR);
        if (object == null || (object = ((FlavourComponent)object).getFlavours()) == null) {
            return null;
        }
        Object flavours = object;
        Integer n = (Integer)CollectionsKt.maxOrNull((Iterable)flavours.values());
        if (n == null) {
            return null;
        }
        int max = n;
        Object $this$filterValues$iv = flavours;
        boolean $i$f$filterValues = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
            int it = ((Number)entry$iv.getValue()).intValue();
            boolean bl = false;
            if (!(it == max)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        Set dominant = ((Map)result$iv).keySet();
        return dominant.isEmpty() ? null : (dominant.size() > 1 ? Flavour.MILD : (Flavour)((Object)CollectionsKt.first((Iterable)dominant)));
    }

    @NotNull
    public final String getFlavorNatureLabel(@NotNull Flavour flavour) {
        Intrinsics.checkNotNullParameter((Object)((Object)flavour), (String)"flavour");
        return switch (WhenMappings.$EnumSwitchMapping$0[flavour.ordinal()]) {
            case 1 -> "attack";
            case 2 -> "special_attack";
            case 3 -> "speed";
            case 4 -> "special_defence";
            case 5 -> "defence";
            case 6 -> "neutral";
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public final int getFriendshipChangeLiked(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        double baseFriendship = ((Number)this.calculateBaseFriendship(stack).component1()).doubleValue();
        return (int)(baseFriendship / (double)10);
    }

    public final int getFriendshipChangeDisliked(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        double baseFriendship = ((Number)this.calculateBaseFriendship(stack).component1()).doubleValue();
        return (int)(baseFriendship / (double)7);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Flavour.values().length];
            try {
                nArray[Flavour.SPICY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Flavour.DRY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Flavour.SWEET.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Flavour.BITTER.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Flavour.SOUR.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Flavour.MILD.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

