/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.item;

import com.cobblemon.mod.common.api.data.DataRegistry;
import com.cobblemon.mod.common.api.reactive.SimpleObservable;
import com.cobblemon.mod.common.battles.runner.ShowdownService;
import com.cobblemon.mod.common.pokemon.helditem.CobblemonHeldItemManager;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\u000b\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fR\u001a\u0010\u000e\u001a\u00020\r8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0013\u001a\u00020\u00128\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016R \u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00000\u00178\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u001a\u0010\u001bR&\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001d0\u001c8\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b \u0010!R'\u0010$\u001a\u0012\u0012\u0004\u0012\u00020\u001d0\"j\b\u0012\u0004\u0012\u00020\u001d`#8\u0006\u00a2\u0006\f\n\u0004\b$\u0010%\u001a\u0004\b&\u0010'\u00a8\u0006("}, d2={"Lcom/cobblemon/mod/common/api/item/HeldItems;", "Lcom/cobblemon/mod/common/api/data/DataRegistry;", "<init>", "()V", "Lnet/minecraft/server/level/ServerPlayer;", "player", "", "sync", "(Lnet/minecraft/server/level/ServerPlayer;)V", "Lnet/minecraft/server/packs/resources/ResourceManager;", "manager", "reload", "(Lnet/minecraft/server/packs/resources/ResourceManager;)V", "Lnet/minecraft/resources/ResourceLocation;", "id", "Lnet/minecraft/resources/ResourceLocation;", "getId", "()Lnet/minecraft/resources/ResourceLocation;", "Lnet/minecraft/server/packs/PackType;", "type", "Lnet/minecraft/server/packs/PackType;", "getType", "()Lnet/minecraft/server/packs/PackType;", "Lcom/cobblemon/mod/common/api/reactive/SimpleObservable;", "observable", "Lcom/cobblemon/mod/common/api/reactive/SimpleObservable;", "getObservable", "()Lcom/cobblemon/mod/common/api/reactive/SimpleObservable;", "", "", "heldItemsScripts", "Ljava/util/Map;", "getHeldItemsScripts$common", "()Ljava/util/Map;", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "showdownItems", "Ljava/util/HashSet;", "getShowdownItems", "()Ljava/util/HashSet;", "common"})
@SourceDebugExtension(value={"SMAP\nHeldItems.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HeldItems.kt\ncom/cobblemon/mod/common/api/item/HeldItems\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,57:1\n216#2,2:58\n*S KotlinDebug\n*F\n+ 1 HeldItems.kt\ncom/cobblemon/mod/common/api/item/HeldItems\n*L\n36#1:58,2\n*E\n"})
public final class HeldItems
implements DataRegistry {
    @NotNull
    public static final HeldItems INSTANCE = new HeldItems();
    @NotNull
    private static final ResourceLocation id = MiscUtilsKt.cobblemonResource("held_items");
    @NotNull
    private static final PackType type = PackType.SERVER_DATA;
    @NotNull
    private static final SimpleObservable<HeldItems> observable = new SimpleObservable();
    @NotNull
    private static final Map<String, String> heldItemsScripts = new LinkedHashMap();
    @NotNull
    private static final HashSet<String> showdownItems = new HashSet();

    private HeldItems() {
    }

    @Override
    @NotNull
    public ResourceLocation getId() {
        return id;
    }

    @Override
    @NotNull
    public PackType getType() {
        return type;
    }

    @NotNull
    public SimpleObservable<HeldItems> getObservable() {
        return observable;
    }

    @Override
    public void sync(@NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
    }

    @NotNull
    public final Map<String, String> getHeldItemsScripts$common() {
        return heldItemsScripts;
    }

    @NotNull
    public final HashSet<String> getShowdownItems() {
        return showdownItems;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reload(@NotNull ResourceManager manager) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        heldItemsScripts.clear();
        ShowdownService.Companion.getService().resetRegistryData("heldItem");
        Map map = manager.listResources("held_items", HeldItems::reload$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"listResources(...)");
        Map $this$forEach$iv = map;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            ResourceLocation identifier2 = (ResourceLocation)entry.getKey();
            Resource resource = (Resource)entry.getValue();
            Closeable closeable = resource.open();
            Throwable throwable = null;
            try {
                InputStream stream = (InputStream)closeable;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)stream);
                Closeable closeable2 = stream;
                Object object = Charsets.UTF_8;
                Reader reader = new InputStreamReader((InputStream)closeable2, (Charset)object);
                int n = 8192;
                closeable2 = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n);
                object = null;
                try {
                    BufferedReader reader2 = (BufferedReader)closeable2;
                    boolean bl3 = false;
                    ResourceLocation resolvedIdentifier = ResourceLocation.fromNamespaceAndPath((String)identifier2.getNamespace(), (String)FilesKt.getNameWithoutExtension((File)new File(identifier2.getPath())));
                    String js = TextStreamsKt.readText((Reader)reader2);
                    heldItemsScripts.put(resolvedIdentifier.getPath(), js);
                    reader = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    object = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)object);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        ShowdownService.Companion.getService().sendRegistryData(heldItemsScripts, "heldItem");
        JsonArray itemsJson = ShowdownService.Companion.getService().getRegistryData("heldItem");
        int n = itemsJson.size();
        for (int i = 0; i < n; ++i) {
            JsonObject jsItem = itemsJson.get(i).getAsJsonObject();
            ((Collection)showdownItems).add(jsItem.get("id").getAsString());
        }
        CobblemonHeldItemManager.INSTANCE.load$common();
        HeldItems[] heldItemsArray = new HeldItems[]{this};
        this.getObservable().emit((HeldItems[])heldItemsArray);
    }

    private static final boolean reload$lambda$0(ResourceLocation it) {
        String string = it.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return StringsKt.endsWith$default((String)string, (String)".js", (boolean)false, (int)2, null);
    }
}

