/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.moves;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.data.DataRegistry;
import com.cobblemon.mod.common.api.moves.MoveTemplate;
import com.cobblemon.mod.common.api.moves.categories.DamageCategories;
import com.cobblemon.mod.common.api.moves.categories.DamageCategory;
import com.cobblemon.mod.common.api.reactive.SimpleObservable;
import com.cobblemon.mod.common.api.types.ElementalType;
import com.cobblemon.mod.common.api.types.ElementalTypes;
import com.cobblemon.mod.common.battles.MoveTarget;
import com.cobblemon.mod.common.battles.runner.ShowdownService;
import com.cobblemon.mod.common.net.messages.client.data.MovesRegistrySyncPacket;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\u000b\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0019\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u000e\u001a\u00020\rH\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0019\u0010\u0014\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0013\u001a\u00020\u0012H\u0007\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\rH\u0007\u00a2\u0006\u0004\b\u0016\u0010\u0011J\u000f\u0010\u0017\u001a\u00020\u000fH\u0007\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u000f\u0010\u0019\u001a\u00020\u0012H\u0007\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0015\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\r0\u001bH\u0007\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0015\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001eH\u0007\u00a2\u0006\u0004\b\u001f\u0010 J\u001d\u0010$\u001a\u00020\u00062\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001bH\u0000\u00a2\u0006\u0004\b\"\u0010#J\u0017\u0010&\u001a\u00020\u00062\u0006\u0010%\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b&\u0010'R\u001a\u0010\u0013\u001a\u00020(8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0013\u0010)\u001a\u0004\b*\u0010+R\u001a\u0010-\u001a\u00020,8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b-\u0010.\u001a\u0004\b/\u00100R \u00102\u001a\b\u0012\u0004\u0012\u00020\u0000018\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b2\u00103\u001a\u0004\b4\u00105R \u00107\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000f068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b7\u00108R \u00109\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u000f068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b9\u00108R&\u0010:\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r068\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b:\u00108\u001a\u0004\b;\u0010<\u00a8\u0006="}, d2={"Lcom/cobblemon/mod/common/api/moves/Moves;", "Lcom/cobblemon/mod/common/api/data/DataRegistry;", "<init>", "()V", "Lnet/minecraft/server/packs/resources/ResourceManager;", "manager", "", "reload", "(Lnet/minecraft/server/packs/resources/ResourceManager;)V", "Lnet/minecraft/server/level/ServerPlayer;", "player", "sync", "(Lnet/minecraft/server/level/ServerPlayer;)V", "", "name", "Lcom/cobblemon/mod/common/api/moves/MoveTemplate;", "getByName", "(Ljava/lang/String;)Lcom/cobblemon/mod/common/api/moves/MoveTemplate;", "", "id", "getByNumericalId", "(I)Lcom/cobblemon/mod/common/api/moves/MoveTemplate;", "getByNameOrDummy", "getExceptional", "()Lcom/cobblemon/mod/common/api/moves/MoveTemplate;", "count", "()I", "", "names", "()Ljava/util/Collection;", "", "all", "()Ljava/util/List;", "moves", "receiveSyncPacket$common", "(Ljava/util/Collection;)V", "receiveSyncPacket", "move", "register", "(Lcom/cobblemon/mod/common/api/moves/MoveTemplate;)V", "Lnet/minecraft/resources/ResourceLocation;", "Lnet/minecraft/resources/ResourceLocation;", "getId", "()Lnet/minecraft/resources/ResourceLocation;", "Lnet/minecraft/server/packs/PackType;", "type", "Lnet/minecraft/server/packs/PackType;", "getType", "()Lnet/minecraft/server/packs/PackType;", "Lcom/cobblemon/mod/common/api/reactive/SimpleObservable;", "observable", "Lcom/cobblemon/mod/common/api/reactive/SimpleObservable;", "getObservable", "()Lcom/cobblemon/mod/common/api/reactive/SimpleObservable;", "", "allMoves", "Ljava/util/Map;", "idMapping", "moveScripts", "getMoveScripts$common", "()Ljava/util/Map;", "common"})
@SourceDebugExtension(value={"SMAP\nMoves.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Moves.kt\ncom/cobblemon/mod/common/api/moves/Moves\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,133:1\n216#2,2:134\n37#3,2:136\n1869#4,2:138\n*S KotlinDebug\n*F\n+ 1 Moves.kt\ncom/cobblemon/mod/common/api/moves/Moves\n*L\n50#1:134,2\n95#1:136,2\n125#1:138,2\n*E\n"})
public final class Moves
implements DataRegistry {
    @NotNull
    public static final Moves INSTANCE = new Moves();
    @NotNull
    private static final ResourceLocation id = MiscUtilsKt.cobblemonResource("moves");
    @NotNull
    private static final PackType type = PackType.SERVER_DATA;
    @NotNull
    private static final SimpleObservable<Moves> observable = new SimpleObservable();
    @NotNull
    private static final Map<String, MoveTemplate> allMoves = new LinkedHashMap();
    @NotNull
    private static final Map<Integer, MoveTemplate> idMapping = new LinkedHashMap();
    @NotNull
    private static final Map<String, String> moveScripts = new LinkedHashMap();

    private Moves() {
    }

    @Override
    @NotNull
    public ResourceLocation getId() {
        return id;
    }

    @Override
    @NotNull
    public PackType getType() {
        return type;
    }

    @NotNull
    public SimpleObservable<Moves> getObservable() {
        return observable;
    }

    @NotNull
    public final Map<String, String> getMoveScripts$common() {
        return moveScripts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reload(@NotNull ResourceManager manager) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        allMoves.clear();
        idMapping.clear();
        moveScripts.clear();
        ShowdownService.Companion.getService().resetRegistryData("move");
        Map map = manager.listResources("moves", Moves::reload$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"listResources(...)");
        Map $this$forEach$iv = map;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            ResourceLocation identifier2 = (ResourceLocation)entry.getKey();
            Resource resource = (Resource)entry.getValue();
            Closeable closeable = resource.open();
            Throwable throwable = null;
            try {
                InputStream stream = (InputStream)closeable;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)stream);
                Closeable closeable2 = stream;
                Object object = Charsets.UTF_8;
                Reader reader = new InputStreamReader((InputStream)closeable2, (Charset)object);
                int n = 8192;
                closeable2 = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n);
                object = null;
                try {
                    BufferedReader reader2 = (BufferedReader)closeable2;
                    boolean bl3 = false;
                    ResourceLocation resolvedIdentifier = ResourceLocation.fromNamespaceAndPath((String)identifier2.getNamespace(), (String)FilesKt.getNameWithoutExtension((File)new File(identifier2.getPath())));
                    String js = TextStreamsKt.readText((Reader)reader2);
                    moveScripts.put(resolvedIdentifier.getPath(), js);
                    reader2 = Unit.INSTANCE;
                }
                catch (Throwable bl3) {
                    object = bl3;
                    throw bl3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)object);
                }
                stream = Unit.INSTANCE;
            }
            catch (Throwable bl2) {
                throwable = bl2;
                throw bl2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        ShowdownService.Companion.getService().sendRegistryData(moveScripts, "move");
        JsonArray movesJson = ShowdownService.Companion.getService().getRegistryData("move");
        int n = movesJson.size();
        for (int i = 0; i < n; ++i) {
            JsonObject jsMove = movesJson.get(i).getAsJsonObject();
            String id = jsMove.get("id").getAsString();
            try {
                int num = jsMove.get("num").getAsInt();
                String string = jsMove.get("type").getAsString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAsString(...)");
                ElementalType elementalType = ElementalTypes.getOrException(string);
                String string2 = jsMove.get("category").getAsString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAsString(...)");
                DamageCategory damageCategory = DamageCategories.INSTANCE.getOrException(string2);
                double power = jsMove.get("basePower").getAsDouble();
                String string3 = jsMove.get("target").getAsString();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getAsString(...)");
                MoveTarget target = MoveTarget.Companion.fromShowdownId(string3);
                JsonPrimitive accuracyJson = jsMove.get("accuracy").getAsJsonPrimitive();
                double accuracy = accuracyJson.isNumber() ? accuracyJson.getAsDouble() : -1.0;
                int pp = jsMove.get("pp").getAsInt();
                int priority = jsMove.get("priority").getAsInt();
                JsonElement jsonElement = jsMove.get("critRatio");
                double critRatio = jsonElement != null ? jsonElement.getAsDouble() : 1.0;
                ArrayList effectChances = new ArrayList();
                JsonElement secondariesMember = jsMove.get("secondaries");
                JsonElement secondaryMember = jsMove.get("secondary");
                if (secondariesMember != null && secondariesMember instanceof JsonArray) {
                    int n2 = ((JsonArray)secondariesMember).size();
                    for (int j = 0; j < n2; ++j) {
                        JsonObject element = ((JsonArray)secondariesMember).get(j).getAsJsonObject();
                        if (!element.has("chance")) continue;
                        ((Collection)effectChances).add(element.get("chance").getAsDouble());
                    }
                } else if (secondaryMember != null && secondaryMember instanceof JsonObject && ((JsonObject)secondaryMember).has("chance")) {
                    ((Collection)effectChances).add(((JsonObject)secondaryMember).get("chance").getAsDouble());
                }
                Intrinsics.checkNotNull((Object)id);
                Collection $this$toTypedArray$iv = effectChances;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                MoveTemplate move = new MoveTemplate(id, num, elementalType, damageCategory, power, target, accuracy, pp, priority, critRatio, thisCollection$iv.toArray(new Double[0]));
                this.register(move);
                continue;
            }
            catch (Exception e) {
                Cobblemon.LOGGER.error("Caught exception trying to resolve the move '{}'", (Object)id, (Object)e);
            }
        }
        Cobblemon.LOGGER.info("Loaded {} moves", (Object)allMoves.size());
        Moves[] movesArray = new Moves[]{this};
        this.getObservable().emit((Moves[])movesArray);
    }

    @Override
    public void sync(@NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        new MovesRegistrySyncPacket(Moves.all()).sendToPlayer(player);
    }

    @JvmStatic
    @Nullable
    public static final MoveTemplate getByName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String string = name.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return allMoves.get(string);
    }

    @JvmStatic
    @Nullable
    public static final MoveTemplate getByNumericalId(int id) {
        return idMapping.get(id);
    }

    @JvmStatic
    @NotNull
    public static final MoveTemplate getByNameOrDummy(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String string = name.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        MoveTemplate moveTemplate = allMoves.get(string);
        if (moveTemplate == null) {
            String string2 = name.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            moveTemplate = MoveTemplate.Companion.dummy(string2);
        }
        return moveTemplate;
    }

    @JvmStatic
    @NotNull
    public static final MoveTemplate getExceptional() {
        MoveTemplate moveTemplate = Moves.getByName("tackle");
        if (moveTemplate == null) {
            moveTemplate = (MoveTemplate)CollectionsKt.random(allMoves.values(), (Random)((Random)Random.Default));
        }
        return moveTemplate;
    }

    @JvmStatic
    public static final int count() {
        return allMoves.size();
    }

    @JvmStatic
    @NotNull
    public static final Collection<String> names() {
        return CollectionsKt.toSet((Iterable)allMoves.keySet());
    }

    @JvmStatic
    @NotNull
    public static final List<MoveTemplate> all() {
        return CollectionsKt.toList((Iterable)allMoves.values());
    }

    public final void receiveSyncPacket$common(@NotNull Collection<? extends MoveTemplate> moves) {
        Intrinsics.checkNotNullParameter(moves, (String)"moves");
        Iterable $this$forEach$iv = moves;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MoveTemplate p0 = (MoveTemplate)element$iv;
            boolean bl = false;
            this.register(p0);
        }
    }

    private final void register(MoveTemplate move) {
        allMoves.put(move.getName(), move);
        idMapping.put(move.getNum(), move);
    }

    private static final boolean reload$lambda$0(ResourceLocation it) {
        String string = it.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return StringsKt.endsWith$default((String)string, (String)".js", (boolean)false, (int)2, null);
    }
}

