/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.riding.behaviour.types.composite;

import com.cobblemon.mod.common.api.riding.behaviour.RidingBehaviourSettings;
import com.cobblemon.mod.common.api.riding.behaviour.types.composite.CompositeBehaviour;
import com.cobblemon.mod.common.api.riding.stats.RidingStat;
import com.cobblemon.mod.common.util.BufferUtilsKt;
import com.cobblemon.mod.common.util.adapters.RidingBehaviourSettingsAdapter;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.Constructor;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\t\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\t\u0010\bR$\u0010\f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n8\u0006@BX\u0086.\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000fR$\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u00018\u0006@BX\u0086.\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013R$\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u00018\u0006@BX\u0086.\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0011\u001a\u0004\b\u0015\u0010\u0013R\u001a\u0010\u0016\u001a\u00020\n8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0016\u0010\r\u001a\u0004\b\u0017\u0010\u000fR&\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u00188\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006\u001f"}, d2={"Lcom/cobblemon/mod/common/api/riding/behaviour/types/composite/CompositeSettings;", "Lcom/cobblemon/mod/common/api/riding/behaviour/RidingBehaviourSettings;", "<init>", "()V", "Lnet/minecraft/network/RegistryFriendlyByteBuf;", "buffer", "", "encode", "(Lnet/minecraft/network/RegistryFriendlyByteBuf;)V", "decode", "Lnet/minecraft/resources/ResourceLocation;", "value", "transitionStrategy", "Lnet/minecraft/resources/ResourceLocation;", "getTransitionStrategy", "()Lnet/minecraft/resources/ResourceLocation;", "defaultBehaviour", "Lcom/cobblemon/mod/common/api/riding/behaviour/RidingBehaviourSettings;", "getDefaultBehaviour", "()Lcom/cobblemon/mod/common/api/riding/behaviour/RidingBehaviourSettings;", "alternateBehaviour", "getAlternateBehaviour", "key", "getKey", "", "Lcom/cobblemon/mod/common/api/riding/stats/RidingStat;", "Lkotlin/ranges/IntRange;", "stats", "Ljava/util/Map;", "getStats", "()Ljava/util/Map;", "common"})
public class CompositeSettings
implements RidingBehaviourSettings {
    private ResourceLocation transitionStrategy;
    private RidingBehaviourSettings defaultBehaviour;
    private RidingBehaviourSettings alternateBehaviour;
    @NotNull
    private final ResourceLocation key = CompositeBehaviour.Companion.getKEY();
    @NotNull
    private final Map<RidingStat, IntRange> stats = new LinkedHashMap();

    @NotNull
    public final ResourceLocation getTransitionStrategy() {
        ResourceLocation resourceLocation = this.transitionStrategy;
        if (resourceLocation != null) {
            return resourceLocation;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"transitionStrategy");
        return null;
    }

    @NotNull
    public final RidingBehaviourSettings getDefaultBehaviour() {
        RidingBehaviourSettings ridingBehaviourSettings = this.defaultBehaviour;
        if (ridingBehaviourSettings != null) {
            return ridingBehaviourSettings;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"defaultBehaviour");
        return null;
    }

    @NotNull
    public final RidingBehaviourSettings getAlternateBehaviour() {
        RidingBehaviourSettings ridingBehaviourSettings = this.alternateBehaviour;
        if (ridingBehaviourSettings != null) {
            return ridingBehaviourSettings;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"alternateBehaviour");
        return null;
    }

    @Override
    @NotNull
    public ResourceLocation getKey() {
        return this.key;
    }

    @Override
    @NotNull
    public Map<RidingStat, IntRange> getStats() {
        return this.stats;
    }

    @Override
    public void encode(@NotNull RegistryFriendlyByteBuf buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        BufferUtilsKt.writeRidingStats((ByteBuf)buffer, this.getStats());
        buffer.writeResourceLocation(this.getTransitionStrategy());
        buffer.writeResourceLocation(this.getDefaultBehaviour().getKey());
        this.getDefaultBehaviour().encode(buffer);
        buffer.writeResourceLocation(this.getAlternateBehaviour().getKey());
        this.getAlternateBehaviour().encode(buffer);
    }

    @Override
    public void decode(@NotNull RegistryFriendlyByteBuf buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.getStats().putAll(BufferUtilsKt.readRidingStats((ByteBuf)buffer));
        ResourceLocation resourceLocation = buffer.readResourceLocation();
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"readResourceLocation(...)");
        this.transitionStrategy = resourceLocation;
        ResourceLocation defaultBehaviourKey = buffer.readResourceLocation();
        Class<? extends RidingBehaviourSettings> clazz = RidingBehaviourSettingsAdapter.INSTANCE.getTypes().get(defaultBehaviourKey);
        if (clazz == null || (clazz = clazz.getConstructor(new Class[0])) == null || (clazz = (RidingBehaviourSettings)((Constructor)((Object)clazz)).newInstance(new Object[0])) == null) {
            throw new IllegalStateException(("Unknown controller key: " + this.getKey()).toString());
        }
        this.defaultBehaviour = clazz;
        this.getDefaultBehaviour().decode(buffer);
        ResourceLocation alternativeBehaviourKey = buffer.readResourceLocation();
        Class<? extends RidingBehaviourSettings> clazz2 = RidingBehaviourSettingsAdapter.INSTANCE.getTypes().get(alternativeBehaviourKey);
        if (clazz2 == null || (clazz2 = clazz2.getConstructor(new Class[0])) == null || (clazz2 = (RidingBehaviourSettings)((Constructor)((Object)clazz2)).newInstance(new Object[0])) == null) {
            throw new IllegalStateException(("Unknown controller key: " + this.getKey()).toString());
        }
        this.alternateBehaviour = clazz2;
        this.getAlternateBehaviour().decode(buffer);
    }
}

