/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.riding.behaviour.types.land;

import com.cobblemon.mod.common.api.riding.behaviour.RidingBehaviourState;
import com.cobblemon.mod.common.api.riding.behaviour.RidingBehaviourStateKt;
import com.cobblemon.mod.common.api.riding.behaviour.Side;
import com.cobblemon.mod.common.api.riding.behaviour.SidedRidingState;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0007\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u0017\u0010\b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\n\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\n\u0010\tJ\u000f\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000e\u001a\u00020\u0000H\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0001H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013R(\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u00148\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR0\u0010\u001e\u001a\u0010\u0012\f\u0012\n \u001d*\u0004\u0018\u00010\u001c0\u001c0\u00148\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001e\u0010\u0017\u001a\u0004\b\u001f\u0010\u0019\"\u0004\b \u0010\u001bR(\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00110\u00148\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b!\u0010\u0017\u001a\u0004\b\"\u0010\u0019\"\u0004\b#\u0010\u001bR(\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00110\u00148\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b$\u0010\u0017\u001a\u0004\b%\u0010\u0019\"\u0004\b&\u0010\u001bR\u001d\u0010(\u001a\b\u0012\u0004\u0012\u00020'0\u00148\u0006\u00a2\u0006\f\n\u0004\b(\u0010\u0017\u001a\u0004\b)\u0010\u0019R\u001d\u0010*\u001a\b\u0012\u0004\u0012\u00020'0\u00148\u0006\u00a2\u0006\f\n\u0004\b*\u0010\u0017\u001a\u0004\b+\u0010\u0019R(\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00110\u00148\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b,\u0010\u0017\u001a\u0004\b-\u0010\u0019\"\u0004\b.\u0010\u001b\u00a8\u0006/"}, d2={"Lcom/cobblemon/mod/common/api/riding/behaviour/types/land/MinekartState;", "Lcom/cobblemon/mod/common/api/riding/behaviour/RidingBehaviourState;", "<init>", "()V", "", "reset", "Lnet/minecraft/network/FriendlyByteBuf;", "buffer", "encode", "(Lnet/minecraft/network/FriendlyByteBuf;)V", "decode", "", "toString", "()Ljava/lang/String;", "copy", "()Lcom/cobblemon/mod/common/api/riding/behaviour/types/land/MinekartState;", "previous", "", "shouldSync", "(Lcom/cobblemon/mod/common/api/riding/behaviour/RidingBehaviourState;)Z", "Lcom/cobblemon/mod/common/api/riding/behaviour/SidedRidingState;", "", "currSpeed", "Lcom/cobblemon/mod/common/api/riding/behaviour/SidedRidingState;", "getCurrSpeed", "()Lcom/cobblemon/mod/common/api/riding/behaviour/SidedRidingState;", "setCurrSpeed", "(Lcom/cobblemon/mod/common/api/riding/behaviour/SidedRidingState;)V", "Lnet/minecraft/world/phys/Vec2;", "kotlin.jvm.PlatformType", "deltaRotation", "getDeltaRotation", "setDeltaRotation", "drifting", "getDrifting", "setDrifting", "clockwiseDrift", "getClockwiseDrift", "setClockwiseDrift", "", "boost", "getBoost", "turnMomentum", "getTurnMomentum", "inAir", "getInAir", "setInAir", "common"})
public final class MinekartState
extends RidingBehaviourState {
    @NotNull
    private SidedRidingState<Double> currSpeed = RidingBehaviourStateKt.ridingState(0.0, Side.BOTH);
    @NotNull
    private SidedRidingState<Vec2> deltaRotation = RidingBehaviourStateKt.ridingState(Vec2.ZERO, Side.BOTH);
    @NotNull
    private SidedRidingState<Boolean> drifting = RidingBehaviourStateKt.ridingState(false, Side.CLIENT);
    @NotNull
    private SidedRidingState<Boolean> clockwiseDrift = RidingBehaviourStateKt.ridingState(false, Side.CLIENT);
    @NotNull
    private final SidedRidingState<Float> boost = RidingBehaviourStateKt.ridingState(Float.valueOf(0.0f), Side.CLIENT);
    @NotNull
    private final SidedRidingState<Float> turnMomentum = RidingBehaviourStateKt.ridingState(Float.valueOf(0.0f), Side.CLIENT);
    @NotNull
    private SidedRidingState<Boolean> inAir = RidingBehaviourStateKt.ridingState(false, Side.CLIENT);

    @NotNull
    public final SidedRidingState<Double> getCurrSpeed() {
        return this.currSpeed;
    }

    public final void setCurrSpeed(@NotNull SidedRidingState<Double> sidedRidingState) {
        Intrinsics.checkNotNullParameter(sidedRidingState, (String)"<set-?>");
        this.currSpeed = sidedRidingState;
    }

    @NotNull
    public final SidedRidingState<Vec2> getDeltaRotation() {
        return this.deltaRotation;
    }

    public final void setDeltaRotation(@NotNull SidedRidingState<Vec2> sidedRidingState) {
        Intrinsics.checkNotNullParameter(sidedRidingState, (String)"<set-?>");
        this.deltaRotation = sidedRidingState;
    }

    @NotNull
    public final SidedRidingState<Boolean> getDrifting() {
        return this.drifting;
    }

    public final void setDrifting(@NotNull SidedRidingState<Boolean> sidedRidingState) {
        Intrinsics.checkNotNullParameter(sidedRidingState, (String)"<set-?>");
        this.drifting = sidedRidingState;
    }

    @NotNull
    public final SidedRidingState<Boolean> getClockwiseDrift() {
        return this.clockwiseDrift;
    }

    public final void setClockwiseDrift(@NotNull SidedRidingState<Boolean> sidedRidingState) {
        Intrinsics.checkNotNullParameter(sidedRidingState, (String)"<set-?>");
        this.clockwiseDrift = sidedRidingState;
    }

    @NotNull
    public final SidedRidingState<Float> getBoost() {
        return this.boost;
    }

    @NotNull
    public final SidedRidingState<Float> getTurnMomentum() {
        return this.turnMomentum;
    }

    @NotNull
    public final SidedRidingState<Boolean> getInAir() {
        return this.inAir;
    }

    public final void setInAir(@NotNull SidedRidingState<Boolean> sidedRidingState) {
        Intrinsics.checkNotNullParameter(sidedRidingState, (String)"<set-?>");
        this.inAir = sidedRidingState;
    }

    @Override
    public void reset() {
        super.reset();
        this.currSpeed.set(0.0, true);
        this.deltaRotation.set(Vec2.ZERO, true);
        this.drifting.set(false, true);
        this.clockwiseDrift.set(false, true);
        this.boost.set(Float.valueOf(0.0f), true);
        this.turnMomentum.set(Float.valueOf(0.0f), true);
        this.inAir.set(false, true);
    }

    @Override
    public void encode(@NotNull FriendlyByteBuf buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        super.encode(buffer);
        buffer.writeBoolean(this.drifting.get().booleanValue());
        buffer.writeBoolean(this.clockwiseDrift.get().booleanValue());
        buffer.writeFloat(((Number)this.boost.get()).floatValue());
        buffer.writeFloat(((Number)this.turnMomentum.get()).floatValue());
        buffer.writeBoolean(this.inAir.get().booleanValue());
    }

    @Override
    public void decode(@NotNull FriendlyByteBuf buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        super.decode(buffer);
        this.drifting.set(buffer.readBoolean(), true);
        this.clockwiseDrift.set(buffer.readBoolean(), true);
        this.boost.set(Float.valueOf(buffer.readFloat()), true);
        this.turnMomentum.set(Float.valueOf(buffer.readFloat()), true);
        this.inAir.set(buffer.readBoolean(), true);
    }

    @NotNull
    public String toString() {
        return "MinekartState(currSpeed=" + this.currSpeed.get() + ", deltaRotation=" + this.deltaRotation.get() + ")";
    }

    @Override
    @NotNull
    public MinekartState copy() {
        MinekartState minekartState;
        MinekartState it = minekartState = new MinekartState();
        boolean bl = false;
        it.getRideVelocity().set(this.getRideVelocity().get(), true);
        it.getStamina().set(this.getStamina().get(), true);
        it.currSpeed.set(this.currSpeed.get(), true);
        it.deltaRotation.set(this.deltaRotation.get(), true);
        it.drifting.set(this.drifting.get(), true);
        it.clockwiseDrift.set(this.clockwiseDrift.get(), true);
        it.boost.set(this.boost.get(), true);
        it.turnMomentum.set(this.turnMomentum.get(), true);
        it.inAir.set(this.inAir.get(), true);
        return minekartState;
    }

    @Override
    public boolean shouldSync(@NotNull RidingBehaviourState previous) {
        Intrinsics.checkNotNullParameter((Object)previous, (String)"previous");
        if (!(previous instanceof MinekartState)) {
            return false;
        }
        if (((MinekartState)previous).drifting.get().booleanValue() != this.drifting.get().booleanValue()) {
            return true;
        }
        if (((MinekartState)previous).clockwiseDrift.get().booleanValue() != this.clockwiseDrift.get().booleanValue()) {
            return true;
        }
        if (!(((Number)((MinekartState)previous).boost.get()).floatValue() == ((Number)this.boost.get()).floatValue())) {
            return true;
        }
        if (!(((Number)((MinekartState)previous).turnMomentum.get()).floatValue() == ((Number)this.turnMomentum.get()).floatValue())) {
            return true;
        }
        if (((MinekartState)previous).inAir.get().booleanValue() != this.inAir.get().booleanValue()) {
            return true;
        }
        return super.shouldSync(previous);
    }
}

