/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.riding.util;

import com.cobblemon.mod.common.OrientationControllable;
import com.cobblemon.mod.common.api.orientation.OrientationController;
import com.cobblemon.mod.common.api.riding.behaviour.RidingBehaviour;
import com.cobblemon.mod.common.api.riding.behaviour.RidingBehaviourSettings;
import com.cobblemon.mod.common.api.riding.behaviour.RidingBehaviourState;
import com.cobblemon.mod.common.api.riding.util.Vec3Spring;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.util.math.geometry.AngleExtensionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\r\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\r\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\bR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\n\u001a\u0004\b\u000b\u0010\fR\"\u0010\u000e\u001a\u00020\r8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\"\u0010\u0015\u001a\u00020\u00148\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\"\u0010\u001c\u001a\u00020\u001b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\"\u0010\"\u001a\u00020\u001b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\"\u0010\u001d\u001a\u0004\b#\u0010\u001f\"\u0004\b$\u0010!R\"\u0010%\u001a\u00020\u001b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b%\u0010\u001d\u001a\u0004\b&\u0010\u001f\"\u0004\b'\u0010!R\"\u0010(\u001a\u00020\u001b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b(\u0010\u001d\u001a\u0004\b)\u0010\u001f\"\u0004\b*\u0010!R\"\u0010+\u001a\u00020\u001b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b+\u0010\u001d\u001a\u0004\b,\u0010\u001f\"\u0004\b-\u0010!R\"\u0010.\u001a\u00020\u001b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b.\u0010\u001d\u001a\u0004\b/\u0010\u001f\"\u0004\b0\u0010!\u00a8\u00061"}, d2={"Lcom/cobblemon/mod/common/api/riding/util/RidingAnimationData;", "", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "ride", "<init>", "(Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)V", "", "clear", "()V", "update", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "getRide", "()Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "Lorg/joml/Matrix3f;", "prevOrientation", "Lorg/joml/Matrix3f;", "getPrevOrientation", "()Lorg/joml/Matrix3f;", "setPrevOrientation", "(Lorg/joml/Matrix3f;)V", "Lnet/minecraft/world/phys/Vec3;", "prevRot", "Lnet/minecraft/world/phys/Vec3;", "getPrevRot", "()Lnet/minecraft/world/phys/Vec3;", "setPrevRot", "(Lnet/minecraft/world/phys/Vec3;)V", "Lcom/cobblemon/mod/common/api/riding/util/Vec3Spring;", "velocitySpring", "Lcom/cobblemon/mod/common/api/riding/util/Vec3Spring;", "getVelocitySpring", "()Lcom/cobblemon/mod/common/api/riding/util/Vec3Spring;", "setVelocitySpring", "(Lcom/cobblemon/mod/common/api/riding/util/Vec3Spring;)V", "rotSpring", "getRotSpring", "setRotSpring", "rotDeltaSpring", "getRotDeltaSpring", "setRotDeltaSpring", "localVelocitySpring", "getLocalVelocitySpring", "setLocalVelocitySpring", "driverInputSpring", "getDriverInputSpring", "setDriverInputSpring", "diveSpring", "getDiveSpring", "setDiveSpring", "common"})
public final class RidingAnimationData {
    @NotNull
    private final PokemonEntity ride;
    @NotNull
    private Matrix3f prevOrientation;
    @NotNull
    private Vec3 prevRot;
    @NotNull
    private Vec3Spring velocitySpring;
    @NotNull
    private Vec3Spring rotSpring;
    @NotNull
    private Vec3Spring rotDeltaSpring;
    @NotNull
    private Vec3Spring localVelocitySpring;
    @NotNull
    private Vec3Spring driverInputSpring;
    @NotNull
    private Vec3Spring diveSpring;

    public RidingAnimationData(@NotNull PokemonEntity ride) {
        Intrinsics.checkNotNullParameter((Object)ride, (String)"ride");
        this.ride = ride;
        this.prevOrientation = new Matrix3f();
        Vec3 vec3 = Vec3.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"ZERO");
        this.prevRot = vec3;
        this.velocitySpring = new Vec3Spring(null, null, 3, null);
        this.rotSpring = new Vec3Spring(null, null, 3, null);
        this.rotDeltaSpring = new Vec3Spring(null, null, 3, null);
        this.localVelocitySpring = new Vec3Spring(null, null, 3, null);
        this.driverInputSpring = new Vec3Spring(null, null, 3, null);
        this.diveSpring = new Vec3Spring(null, null, 3, null);
    }

    @NotNull
    public final PokemonEntity getRide() {
        return this.ride;
    }

    @NotNull
    public final Matrix3f getPrevOrientation() {
        return this.prevOrientation;
    }

    public final void setPrevOrientation(@NotNull Matrix3f matrix3f) {
        Intrinsics.checkNotNullParameter((Object)matrix3f, (String)"<set-?>");
        this.prevOrientation = matrix3f;
    }

    @NotNull
    public final Vec3 getPrevRot() {
        return this.prevRot;
    }

    public final void setPrevRot(@NotNull Vec3 vec3) {
        Intrinsics.checkNotNullParameter((Object)vec3, (String)"<set-?>");
        this.prevRot = vec3;
    }

    @NotNull
    public final Vec3Spring getVelocitySpring() {
        return this.velocitySpring;
    }

    public final void setVelocitySpring(@NotNull Vec3Spring vec3Spring) {
        Intrinsics.checkNotNullParameter((Object)vec3Spring, (String)"<set-?>");
        this.velocitySpring = vec3Spring;
    }

    @NotNull
    public final Vec3Spring getRotSpring() {
        return this.rotSpring;
    }

    public final void setRotSpring(@NotNull Vec3Spring vec3Spring) {
        Intrinsics.checkNotNullParameter((Object)vec3Spring, (String)"<set-?>");
        this.rotSpring = vec3Spring;
    }

    @NotNull
    public final Vec3Spring getRotDeltaSpring() {
        return this.rotDeltaSpring;
    }

    public final void setRotDeltaSpring(@NotNull Vec3Spring vec3Spring) {
        Intrinsics.checkNotNullParameter((Object)vec3Spring, (String)"<set-?>");
        this.rotDeltaSpring = vec3Spring;
    }

    @NotNull
    public final Vec3Spring getLocalVelocitySpring() {
        return this.localVelocitySpring;
    }

    public final void setLocalVelocitySpring(@NotNull Vec3Spring vec3Spring) {
        Intrinsics.checkNotNullParameter((Object)vec3Spring, (String)"<set-?>");
        this.localVelocitySpring = vec3Spring;
    }

    @NotNull
    public final Vec3Spring getDriverInputSpring() {
        return this.driverInputSpring;
    }

    public final void setDriverInputSpring(@NotNull Vec3Spring vec3Spring) {
        Intrinsics.checkNotNullParameter((Object)vec3Spring, (String)"<set-?>");
        this.driverInputSpring = vec3Spring;
    }

    @NotNull
    public final Vec3Spring getDiveSpring() {
        return this.diveSpring;
    }

    public final void setDiveSpring(@NotNull Vec3Spring vec3Spring) {
        Intrinsics.checkNotNullParameter((Object)vec3Spring, (String)"<set-?>");
        this.diveSpring = vec3Spring;
    }

    public final void clear() {
        this.prevOrientation = new Matrix3f();
        Vec3 vec3 = Vec3.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"ZERO");
        this.prevRot = vec3;
        this.velocitySpring = new Vec3Spring(null, null, 3, null);
        this.rotSpring = new Vec3Spring(null, null, 3, null);
        this.rotDeltaSpring = new Vec3Spring(null, null, 3, null);
        this.localVelocitySpring = new Vec3Spring(null, null, 3, null);
        this.driverInputSpring = new Vec3Spring(null, null, 3, null);
        this.diveSpring = new Vec3Spring(null, null, 3, null);
    }

    public final void update() {
        boolean activeRide = this.ride.hasControllingPassenger();
        if (!activeRide) {
            return;
        }
        Vec3 currRot = Vec3.ZERO;
        Vec3 angDelta = Vec3.ZERO;
        double stiffness = 90.0;
        double damping = 18.0;
        Vec3 currentVelocity = new Vec3(this.ride.getX() - this.ride.xOld, this.ride.getY() - this.ride.yOld, this.ride.getZ() - this.ride.zOld);
        boolean r = this.ride.ifRidingAvailableSupply(false, (arg_0, arg_1, arg_2) -> RidingAnimationData.update$lambda$0(this, arg_0, arg_1, arg_2));
        if (r) {
            PokemonEntity pokemonEntity = this.ride;
            Object object = pokemonEntity instanceof OrientationControllable ? (OrientationControllable)((Object)pokemonEntity) : null;
            if (object == null || (object = object.getOrientationController()) == null) {
                return;
            }
            Object controller = object;
            Matrix3f matrix3f = ((OrientationController)controller).getOrientation();
            if (matrix3f == null) {
                matrix3f = new Matrix3f();
            }
            Matrix3f orientation = matrix3f;
            float currPitch = ((OrientationController)controller).getPitch();
            float currYaw = ((OrientationController)controller).getYaw();
            float currRoll = ((OrientationController)controller).getRoll();
            currRot = new Vec3((double)currPitch, (double)currYaw, (double)currRoll);
            Matrix3f currOrientation = orientation;
            Quaternionf currQuat = new Quaternionf().setFromUnnormalized((Matrix3fc)currOrientation);
            Quaternionf prevQuat = new Quaternionf().setFromUnnormalized((Matrix3fc)this.prevOrientation);
            Quaternionf deltaQuat = new Quaternionf((Quaternionfc)currQuat).mul((Quaternionfc)new Quaternionf((Quaternionfc)prevQuat).invert());
            Quaternionf localDeltaQuat = new Quaternionf((Quaternionfc)currQuat).invert().mul((Quaternionfc)deltaQuat).mul((Quaternionfc)currQuat);
            Vector3f euler = new Vector3f();
            localDeltaQuat.getEulerAnglesXYZ(euler);
            double pitchDegrees = Math.toDegrees(euler.x);
            double yawDegrees = Math.toDegrees(euler.y);
            double rollDegrees = Math.toDegrees(euler.z);
            angDelta = new Vec3(pitchDegrees, yawDegrees, rollDegrees).scale(20.0);
            Vector3f velocityWorldF = new Vector3f((float)currentVelocity.x, (float)currentVelocity.y, (float)currentVelocity.z);
            Vector3f localVelocityF = new Matrix3f((Matrix3fc)orientation).transpose().transform(velocityWorldF);
            Vec3 localVelocity = new Vec3((double)localVelocityF.x, (double)localVelocityF.y, (double)localVelocityF.z);
            this.localVelocitySpring.update(localVelocity, stiffness, damping);
            this.prevOrientation.set((Matrix3fc)currOrientation);
        } else {
            float currPitch = this.ride.getXRot();
            float currYaw = this.ride.getYRot();
            float currRoll = 0.0f;
            currRot = new Vec3((double)currPitch, (double)currYaw, (double)currRoll);
            angDelta = new Vec3(currRot.x - this.prevRot.x, (double)Mth.degreesDifference((float)((float)currRot.y), (float)((float)this.prevRot.y)), (double)Mth.degreesDifference((float)((float)currRot.z), (float)((float)this.prevRot.z))).scale(20.0);
            double yaw360 = -1.0 * (double)(this.ride.getYRot() + 360.0f) % (double)360.0f;
            Matrix3f orientationNonRollable = new Matrix3f().rotateY(AngleExtensionsKt.toRadians(yaw360));
            Vector3f velocityWorldF = new Vector3f((float)currentVelocity.x, (float)currentVelocity.y, (float)currentVelocity.z);
            Vector3f localVelocityF = new Matrix3f((Matrix3fc)orientationNonRollable).transpose().transform(velocityWorldF);
            Vec3 localVelocity = new Vec3((double)localVelocityF.x, (double)localVelocityF.y, (double)localVelocityF.z);
            this.localVelocitySpring.update(localVelocity, stiffness, damping);
        }
        LivingEntity driver = this.ride.getControllingPassenger();
        double vertInput = driver != null && driver.jumping ? 1.0 : (driver != null && driver.isShiftKeyDown() ? -1.0 : 0.0);
        Vec3 input = driver != null ? new Vec3((double)driver.xxa * (double)-1, vertInput, (double)driver.zza) : Vec3.ZERO;
        Intrinsics.checkNotNull((Object)input);
        this.driverInputSpring.update(input, stiffness * (double)2, damping);
        Vec3 currRoll = angDelta;
        Intrinsics.checkNotNull((Object)currRoll);
        this.rotDeltaSpring.update(currRoll, stiffness, damping);
        this.velocitySpring.update(currentVelocity, stiffness, damping);
        this.rotSpring.update(currRot, stiffness, damping);
        float diving = Math.abs(Math.max((float)Math.sin(AngleExtensionsKt.toRadians(currRot.x)), 0.0f));
        this.diveSpring.update(new Vec3(0.0, (double)diving, 0.0), stiffness, damping);
        this.prevRot = currRot;
    }

    private static final boolean update$lambda$0(RidingAnimationData this$0, RidingBehaviour behaviour, RidingBehaviourSettings settings, RidingBehaviourState state) {
        Intrinsics.checkNotNullParameter((Object)behaviour, (String)"behaviour");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return behaviour.shouldRoll(settings, state, this$0.ride);
    }
}

