/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.storage.adapter.flatfile;

import com.cobblemon.mod.common.api.storage.PokemonStore;
import com.cobblemon.mod.common.api.storage.StorePosition;
import com.cobblemon.mod.common.api.storage.adapter.flatfile.OneToOneFileStoreAdapter;
import java.io.File;
import java.lang.reflect.Constructor;
import java.nio.file.Path;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\tJ9\u0010\u0011\u001a\u00020\u0002\"\b\b\u0000\u0010\u000b*\u00020\n\"\u000e\b\u0001\u0010\r*\b\u0012\u0004\u0012\u00028\u00000\f2\u0006\u0010\u000e\u001a\u00028\u00012\u0006\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001f\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018JO\u0010\u001d\u001a\u0004\u0018\u00018\u0001\"\u0004\b\u0000\u0010\u000b\"\u000e\b\u0001\u0010\r*\b\u0012\u0004\u0012\u00028\u00000\f2\u0006\u0010\u0014\u001a\u00020\u00132\u000e\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00010\u00192\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001e\u00a8\u0006\u001f"}, d2={"Lcom/cobblemon/mod/common/api/storage/adapter/flatfile/NBTStoreAdapter;", "Lcom/cobblemon/mod/common/api/storage/adapter/flatfile/OneToOneFileStoreAdapter;", "Lnet/minecraft/nbt/CompoundTag;", "", "rootFolder", "", "useNestedFolders", "folderPerClass", "<init>", "(Ljava/lang/String;ZZ)V", "Lcom/cobblemon/mod/common/api/storage/StorePosition;", "E", "Lcom/cobblemon/mod/common/api/storage/PokemonStore;", "T", "store", "Lnet/minecraft/core/RegistryAccess;", "registryAccess", "serialize", "(Lcom/cobblemon/mod/common/api/storage/PokemonStore;Lnet/minecraft/core/RegistryAccess;)Lnet/minecraft/nbt/CompoundTag;", "Ljava/io/File;", "file", "serialized", "", "save", "(Ljava/io/File;Lnet/minecraft/nbt/CompoundTag;)V", "Ljava/lang/Class;", "storeClass", "Ljava/util/UUID;", "uuid", "load", "(Ljava/io/File;Ljava/lang/Class;Ljava/util/UUID;Lnet/minecraft/core/RegistryAccess;)Lcom/cobblemon/mod/common/api/storage/PokemonStore;", "common"})
public class NBTStoreAdapter
extends OneToOneFileStoreAdapter<CompoundTag> {
    public NBTStoreAdapter(@NotNull String rootFolder, boolean useNestedFolders, boolean folderPerClass) {
        Intrinsics.checkNotNullParameter((Object)rootFolder, (String)"rootFolder");
        super(rootFolder, useNestedFolders, folderPerClass, "dat");
    }

    @Override
    @NotNull
    public <E extends StorePosition, T extends PokemonStore<E>> CompoundTag serialize(@NotNull T store, @NotNull RegistryAccess registryAccess) {
        Intrinsics.checkNotNullParameter(store, (String)"store");
        Intrinsics.checkNotNullParameter((Object)registryAccess, (String)"registryAccess");
        return store.saveToNBT(new CompoundTag(), registryAccess);
    }

    @Override
    public void save(@NotNull File file, @NotNull CompoundTag serialized) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)serialized, (String)"serialized");
        NbtIo.writeCompressed((CompoundTag)serialized, (Path)file.toPath());
    }

    @Override
    @Nullable
    public <E, T extends PokemonStore<E>> T load(@NotNull File file, @NotNull Class<? extends T> storeClass, @NotNull UUID uuid, @NotNull RegistryAccess registryAccess) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(storeClass, (String)"storeClass");
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Intrinsics.checkNotNullParameter((Object)registryAccess, (String)"registryAccess");
        try {
            object = new Class[]{UUID.class, UUID.class};
            Constructor<T> constructor = storeClass.getConstructor((Class<?>[])object);
            object = new Object[]{uuid, uuid};
            object = (PokemonStore)constructor.newInstance(object);
        }
        catch (NoSuchMethodException exception) {
            Object[] objectArray = new Class[]{UUID.class};
            Constructor<T> constructor = storeClass.getConstructor((Class<?>[])objectArray);
            objectArray = new Object[]{uuid};
            object = (PokemonStore)constructor.newInstance(objectArray);
        }
        Object[] store = object;
        try {
            CompoundTag nbt = NbtIo.readCompressed((Path)file.toPath(), (NbtAccounter)NbtAccounter.unlimitedHeap());
            Intrinsics.checkNotNull((Object)nbt);
            store.loadFromNBT(nbt, registryAccess);
            object = store;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return (T)object;
    }
}

