/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.battles.interpreter.instructions;

import com.cobblemon.mod.common.api.battles.interpreter.BattleMessage;
import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.battles.ActiveBattlePokemon;
import com.cobblemon.mod.common.battles.Targetable;
import com.cobblemon.mod.common.battles.dispatch.CauserInstruction;
import com.cobblemon.mod.common.battles.dispatch.InstructionSet;
import com.cobblemon.mod.common.battles.dispatch.InterpreterInstruction;
import com.cobblemon.mod.common.battles.interpreter.instructions.MoveInstruction;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.net.messages.client.battle.BattleSwapPokemonPacket;
import com.cobblemon.mod.common.util.CollectionUtilsKt;
import com.cobblemon.mod.common.util.EntityExtensionsKt;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\bH\u0096\u0002\u00a2\u0006\u0004\b\u000b\u0010\fR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\r\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lcom/cobblemon/mod/common/battles/interpreter/instructions/SwapInstruction;", "Lcom/cobblemon/mod/common/battles/dispatch/InterpreterInstruction;", "Lcom/cobblemon/mod/common/api/battles/interpreter/BattleMessage;", "message", "Lcom/cobblemon/mod/common/battles/dispatch/InstructionSet;", "instructionSet", "<init>", "(Lcom/cobblemon/mod/common/api/battles/interpreter/BattleMessage;Lcom/cobblemon/mod/common/battles/dispatch/InstructionSet;)V", "Lcom/cobblemon/mod/common/api/battles/model/PokemonBattle;", "battle", "", "invoke", "(Lcom/cobblemon/mod/common/api/battles/model/PokemonBattle;)V", "Lcom/cobblemon/mod/common/api/battles/interpreter/BattleMessage;", "getMessage", "()Lcom/cobblemon/mod/common/api/battles/interpreter/BattleMessage;", "Lcom/cobblemon/mod/common/battles/dispatch/InstructionSet;", "getInstructionSet", "()Lcom/cobblemon/mod/common/battles/dispatch/InstructionSet;", "common"})
public final class SwapInstruction
implements InterpreterInstruction {
    @NotNull
    private final BattleMessage message;
    @NotNull
    private final InstructionSet instructionSet;

    public SwapInstruction(@NotNull BattleMessage message, @NotNull InstructionSet instructionSet) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)instructionSet, (String)"instructionSet");
        this.message = message;
        this.instructionSet = instructionSet;
    }

    @NotNull
    public final BattleMessage getMessage() {
        return this.message;
    }

    @NotNull
    public final InstructionSet getInstructionSet() {
        return this.instructionSet;
    }

    @Override
    public void invoke(@NotNull PokemonBattle battle) {
        Intrinsics.checkNotNullParameter((Object)battle, (String)"battle");
        PokemonBattle.dispatchWaiting$default(battle, 0.0f, () -> SwapInstruction.invoke$lambda$0(this, battle), 1, null);
    }

    private static final Unit invoke$lambda$0(SwapInstruction this$0, PokemonBattle $battle) {
        String pnxA;
        String string;
        BattlePokemon battlePokemon = this$0.message.battlePokemon(0, $battle);
        if (battlePokemon == null) {
            return Unit.INSTANCE;
        }
        BattlePokemon battlePokemonA = battlePokemon;
        String string2 = this$0.message.argumentAt(0);
        if (string2 != null) {
            String string3 = string2.substring(0, 3);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        } else {
            string = null;
        }
        String string4 = pnxA = string;
        Intrinsics.checkNotNull((Object)string4);
        Pair<BattleActor, ActiveBattlePokemon> pair = $battle.getActorAndActiveSlotFromPNX(string4);
        BattleActor actor = (BattleActor)pair.component1();
        ActiveBattlePokemon activePokemonA = (ActiveBattlePokemon)pair.component2();
        Targetable activeBattlePokemonB = (Targetable)CollectionsKt.firstOrNull(activePokemonA.getAdjacentAllies());
        if (activeBattlePokemonB != null) {
            Object object;
            Vec3 posA;
            String pnxB = activeBattlePokemonB.getPNX();
            Pair<BattleActor, ActiveBattlePokemon> pair2 = $battle.getActorAndActiveSlotFromPNX(pnxB);
            BattleActor actorB = (BattleActor)pair2.component1();
            ActiveBattlePokemon activePokemonB = (ActiveBattlePokemon)pair2.component2();
            CollectionUtilsKt.swap(actor.getPokemonList(), actor.getActivePokemon().indexOf(activePokemonA), CollectionsKt.indexOf(actor.getActivePokemon(), (Object)activeBattlePokemonB));
            CollectionUtilsKt.swap(actor.getActivePokemon(), pnxA.charAt(2) - 97, pnxB.charAt(2) - 97);
            Object object2 = activePokemonA.getSendOutPosition();
            if (object2 == null) {
                Pair<ServerLevel, Vec3> pair3 = activePokemonA.getPosition();
                object2 = pair3 != null ? (Vec3)pair3.getSecond() : null;
            }
            if ((posA = object2) != null && battlePokemonA.getEntity() != null) {
                PokemonEntity pokemonEntity = battlePokemonA.getEntity();
                if (pokemonEntity != null) {
                    Entity entity = (Entity)pokemonEntity;
                    PokemonEntity pokemonEntity2 = battlePokemonA.getEntity();
                    Intrinsics.checkNotNull((Object)pokemonEntity2);
                    EntityExtensionsKt.setPositionSafely(entity, pokemonEntity2.getAdjustedSendoutPosition(posA));
                }
            }
            if ((object = activePokemonB.getSendOutPosition()) == null) {
                Pair<ServerLevel, Vec3> pair4 = activePokemonB.getPosition();
                object = pair4 != null ? (Vec3)pair4.getSecond() : null;
            }
            Vec3 posB = object;
            BattlePokemon battlePokemonB = activePokemonB.getBattlePokemon();
            if (posB != null) {
                Object object3;
                BattlePokemon battlePokemon2 = battlePokemonB;
                if ((battlePokemon2 != null ? battlePokemon2.getEntity() : null) != null && (object3 = activePokemonB.getBattlePokemon()) != null && (object3 = ((BattlePokemon)object3).getEntity()) != null) {
                    Entity entity = (Entity)object3;
                    PokemonEntity pokemonEntity = battlePokemonB.getEntity();
                    Intrinsics.checkNotNull((Object)pokemonEntity);
                    EntityExtensionsKt.setPositionSafely(entity, pokemonEntity.getAdjustedSendoutPosition(posB));
                }
            }
            $battle.sendUpdate(new BattleSwapPokemonPacket(pnxA));
            if (!this$0.message.hasOptionalArgument("silent")) {
                MutableComponent mutableComponent;
                CauserInstruction lastCauser = this$0.instructionSet.getMostRecentCauser(this$0);
                if (lastCauser instanceof MoveInstruction && Intrinsics.areEqual((Object)((MoveInstruction)lastCauser).getMove().getName(), (Object)"allyswitch")) {
                    var17_16 = new Object[2];
                    var17_16[0] = battlePokemonA.getName();
                    Object object4 = activePokemonB.getBattlePokemon();
                    if (object4 == null || (object4 = ((BattlePokemon)object4).getName()) == null) {
                        object4 = "";
                    }
                    var17_16[1] = object4;
                    mutableComponent = LocalizationUtilsKt.battleLang("activate.allyswitch", var17_16);
                } else {
                    var17_16 = new Object[]{battlePokemonA.getName()};
                    mutableComponent = LocalizationUtilsKt.battleLang("shift", var17_16);
                }
                MutableComponent lang = mutableComponent;
                Intrinsics.checkNotNull((Object)lang);
                $battle.broadcastChatMessage((Component)lang);
            }
        }
        return Unit.INSTANCE;
    }
}

