/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.block;

import com.cobblemon.mod.common.api.apricorn.Apricorn;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.events.farming.ApricornHarvestEvent;
import com.cobblemon.mod.common.api.reactive.EventObservable;
import com.cobblemon.mod.common.api.tags.CobblemonBlockTags;
import com.cobblemon.mod.common.api.tags.CobblemonItemTags;
import com.cobblemon.mod.common.block.ApricornBlock;
import com.cobblemon.mod.common.block.ShearableBlock;
import com.cobblemon.mod.common.util.BlockPosExtensionsKt;
import com.cobblemon.mod.common.util.WorldExtensionsKt;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty1;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00c0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 X2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001XB\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\nH\u0014\u00a2\u0006\u0004\b\r\u0010\u000eJ/\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0013H\u0015\u00a2\u0006\u0004\b\u0016\u0010\u0017J'\u0010\u0019\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u0011H\u0015\u00a2\u0006\u0004\b\u0019\u0010\u001aJ/\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u001b2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u001cH\u0014\u00a2\u0006\u0004\b\u001f\u0010 J/\u0010!\u001a\u00020\u001e2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u001b2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u001cH\u0015\u00a2\u0006\u0004\b!\u0010 J\u0019\u0010$\u001a\u0004\u0018\u00010\n2\u0006\u0010#\u001a\u00020\"H\u0016\u00a2\u0006\u0004\b$\u0010%J?\u0010+\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010'\u001a\u00020&2\u0006\u0010(\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020)2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010*\u001a\u00020\u0011H\u0014\u00a2\u0006\u0004\b+\u0010,J'\u0010-\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b-\u0010.J/\u00100\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020/2\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b0\u00101J/\u00102\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b2\u00103J#\u00107\u001a\u00020\u00152\u0012\u00106\u001a\u000e\u0012\u0004\u0012\u000205\u0012\u0004\u0012\u00020\n04H\u0014\u00a2\u0006\u0004\b7\u00108J\u001f\u0010;\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010:\u001a\u000209H\u0014\u00a2\u0006\u0004\b;\u0010<J7\u0010C\u001a\u00020B2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010=\u001a\u00020/2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010?\u001a\u00020>2\u0006\u0010A\u001a\u00020@H\u0014\u00a2\u0006\u0004\bC\u0010DJ/\u0010E\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020/2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010?\u001a\u00020>H\u0014\u00a2\u0006\u0004\bE\u0010FJ'\u0010H\u001a\u00020G2\u0006\u0010\u0010\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\bH\u0010IJ/\u0010J\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020/2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010?\u001a\u00020>H\u0002\u00a2\u0006\u0004\bJ\u0010KJ%\u0010L\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020/2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\bL\u0010MJ5\u0010P\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020/2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00112\f\u0010O\u001a\b\u0012\u0004\u0012\u00020\u00150NH\u0016\u00a2\u0006\u0004\bP\u0010QJ\u0017\u0010S\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010RH\u0014\u00a2\u0006\u0004\bS\u0010TR\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010U\u001a\u0004\bV\u0010W\u00a8\u0006Y"}, d2={"Lcom/cobblemon/mod/common/block/ApricornBlock;", "Lnet/minecraft/world/level/block/HorizontalDirectionalBlock;", "Lnet/minecraft/world/level/block/BonemealableBlock;", "Lcom/cobblemon/mod/common/block/ShearableBlock;", "Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;", "settings", "Lcom/cobblemon/mod/common/api/apricorn/Apricorn;", "apricorn", "<init>", "(Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;Lcom/cobblemon/mod/common/api/apricorn/Apricorn;)V", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "", "isRandomlyTicking", "(Lnet/minecraft/world/level/block/state/BlockState;)Z", "Lnet/minecraft/server/level/ServerLevel;", "world", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/util/RandomSource;", "random", "", "randomTick", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;Lnet/minecraft/util/RandomSource;)V", "Lnet/minecraft/world/level/LevelReader;", "canSurvive", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/LevelReader;Lnet/minecraft/core/BlockPos;)Z", "Lnet/minecraft/world/level/BlockGetter;", "Lnet/minecraft/world/phys/shapes/CollisionContext;", "context", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "getShape", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/phys/shapes/CollisionContext;)Lnet/minecraft/world/phys/shapes/VoxelShape;", "getCollisionShape", "Lnet/minecraft/world/item/context/BlockPlaceContext;", "ctx", "getStateForPlacement", "(Lnet/minecraft/world/item/context/BlockPlaceContext;)Lnet/minecraft/world/level/block/state/BlockState;", "Lnet/minecraft/core/Direction;", "direction", "neighborState", "Lnet/minecraft/world/level/LevelAccessor;", "neighborPos", "updateShape", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/core/Direction;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/LevelAccessor;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/block/state/BlockState;", "isValidBonemealTarget", "(Lnet/minecraft/world/level/LevelReader;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)Z", "Lnet/minecraft/world/level/Level;", "isBonemealSuccess", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/util/RandomSource;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)Z", "performBonemeal", "(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/util/RandomSource;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "Lnet/minecraft/world/level/block/state/StateDefinition$Builder;", "Lnet/minecraft/world/level/block/Block;", "builder", "createBlockStateDefinition", "(Lnet/minecraft/world/level/block/state/StateDefinition$Builder;)V", "Lnet/minecraft/world/level/pathfinder/PathComputationType;", "type", "isPathfindable", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/pathfinder/PathComputationType;)Z", "level", "Lnet/minecraft/world/entity/player/Player;", "player", "Lnet/minecraft/world/phys/BlockHitResult;", "blockHitResult", "Lnet/minecraft/world/InteractionResult;", "useWithoutItem", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/phys/BlockHitResult;)Lnet/minecraft/world/InteractionResult;", "attack", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/entity/player/Player;)V", "Lnet/minecraft/world/item/ItemStack;", "getCloneItemStack", "(Lnet/minecraft/world/level/LevelReader;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)Lnet/minecraft/world/item/ItemStack;", "doHarvest", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/entity/player/Player;)V", "harvest", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/block/state/BlockState;", "Lkotlin/Function0;", "successCallback", "attemptShear", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/core/BlockPos;Lkotlin/jvm/functions/Function0;)Z", "Lcom/mojang/serialization/MapCodec;", "codec", "()Lcom/mojang/serialization/MapCodec;", "Lcom/cobblemon/mod/common/api/apricorn/Apricorn;", "getApricorn", "()Lcom/cobblemon/mod/common/api/apricorn/Apricorn;", "Companion", "common"})
@SourceDebugExtension(value={"SMAP\nApricornBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApricornBlock.kt\ncom/cobblemon/mod/common/block/ApricornBlock\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 EventObservables.kt\ncom/cobblemon/mod/common/api/reactive/EventObservable\n+ 4 EventObservables.kt\ncom/cobblemon/mod/common/api/reactive/EventObservable$post$1\n*L\n1#1,327:1\n13805#2,2:328\n13805#2:335\n13806#2:337\n14#3,5:330\n19#3:338\n14#4:336\n*S KotlinDebug\n*F\n+ 1 ApricornBlock.kt\ncom/cobblemon/mod/common/block/ApricornBlock\n*L\n108#1:328,2\n179#1:335\n179#1:337\n179#1:330,5\n179#1:338\n179#1:336\n*E\n"})
public final class ApricornBlock
extends HorizontalDirectionalBlock
implements BonemealableBlock,
ShearableBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Apricorn apricorn;
    @NotNull
    private static final MapCodec<ApricornBlock> CODEC;
    private static final IntegerProperty AGE;
    public static final int MAX_AGE = 3;
    public static final int MIN_AGE = 0;
    private static final VoxelShape NORTH_STAGE_0;
    private static final VoxelShape NORTH_CAP_STAGE_0;
    private static final VoxelShape NORTH_STAGE_1;
    private static final VoxelShape NORTH_CAP_STAGE_1;
    private static final VoxelShape NORTH_STAGE_2;
    private static final VoxelShape NORTH_CAP_STAGE_2;
    private static final VoxelShape NORTH_STAGE_3;
    private static final VoxelShape NORTH_CAP_STAGE_3;
    @NotNull
    private static final VoxelShape[] NORTH_AABB;
    private static final VoxelShape SOUTH_STAGE_0;
    private static final VoxelShape SOUTH_CAP_STAGE_0;
    private static final VoxelShape SOUTH_STAGE_1;
    private static final VoxelShape SOUTH_CAP_STAGE_1;
    private static final VoxelShape SOUTH_STAGE_2;
    private static final VoxelShape SOUTH_CAP_STAGE_2;
    private static final VoxelShape SOUTH_STAGE_3;
    private static final VoxelShape SOUTH_CAP_STAGE_3;
    @NotNull
    private static final VoxelShape[] SOUTH_AABB;
    private static final VoxelShape EAST_STAGE_0;
    private static final VoxelShape EAST_CAP_STAGE_0;
    private static final VoxelShape EAST_STAGE_1;
    private static final VoxelShape EAST_CAP_STAGE_1;
    private static final VoxelShape EAST_STAGE_2;
    private static final VoxelShape EAST_CAP_STAGE_2;
    private static final VoxelShape EAST_STAGE_3;
    private static final VoxelShape EAST_CAP_STAGE_3;
    @NotNull
    private static final VoxelShape[] EAST_AABB;
    private static final VoxelShape WEST_STAGE_0;
    private static final VoxelShape WEST_CAP_STAGE_0;
    private static final VoxelShape WEST_STAGE_1;
    private static final VoxelShape WEST_CAP_STAGE_1;
    private static final VoxelShape WEST_STAGE_2;
    private static final VoxelShape WEST_CAP_STAGE_2;
    private static final VoxelShape WEST_STAGE_3;
    private static final VoxelShape WEST_CAP_STAGE_3;
    @NotNull
    private static final VoxelShape[] WEST_AABB;

    public ApricornBlock(@NotNull BlockBehaviour.Properties settings, @NotNull Apricorn apricorn) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)((Object)apricorn), (String)"apricorn");
        super(settings);
        this.apricorn = apricorn;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)Direction.NORTH)).setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    @NotNull
    public final Apricorn getApricorn() {
        return this.apricorn;
    }

    protected boolean isRandomlyTicking(@NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return ((Number)((Object)state.getValue((Property)AGE))).intValue() < 3;
    }

    @Deprecated(message="Deprecated in Java")
    protected void randomTick(@NotNull BlockState state, @NotNull ServerLevel world, @NotNull BlockPos pos, @NotNull RandomSource random) {
        Integer currentAge;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        if (world.random.nextInt(5) == 0 && (currentAge = (Integer)state.getValue((Property)AGE)) < 3) {
            world.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(currentAge + 1)), 2);
        }
    }

    @Deprecated(message="Deprecated in Java")
    protected boolean canSurvive(@NotNull BlockState state, @NotNull LevelReader world, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Comparable comparable = state.getValue((Property)HorizontalDirectionalBlock.FACING);
        Intrinsics.checkNotNull((Object)comparable, (String)"null cannot be cast to non-null type net.minecraft.core.Direction");
        BlockState blockState = world.getBlockState(pos.relative((Direction)comparable));
        return blockState.is(CobblemonBlockTags.APRICORN_LEAVES);
    }

    @NotNull
    protected VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        VoxelShape voxelShape;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Integer age = (Integer)state.getValue((Property)AGE);
        Direction direction = (Direction)state.getValue((Property)HorizontalDirectionalBlock.FACING);
        switch (direction == null ? -1 : WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
            case 1: {
                Intrinsics.checkNotNull((Object)age);
                VoxelShape voxelShape2 = NORTH_AABB[age];
                voxelShape = voxelShape2;
                Intrinsics.checkNotNullExpressionValue((Object)voxelShape2, (String)"get(...)");
                break;
            }
            case 2: {
                Intrinsics.checkNotNull((Object)age);
                VoxelShape voxelShape3 = EAST_AABB[age];
                voxelShape = voxelShape3;
                Intrinsics.checkNotNullExpressionValue((Object)voxelShape3, (String)"get(...)");
                break;
            }
            case 3: {
                Intrinsics.checkNotNull((Object)age);
                VoxelShape voxelShape4 = SOUTH_AABB[age];
                voxelShape = voxelShape4;
                Intrinsics.checkNotNullExpressionValue((Object)voxelShape4, (String)"get(...)");
                break;
            }
            case 4: {
                Intrinsics.checkNotNull((Object)age);
                VoxelShape voxelShape5 = WEST_AABB[age];
                voxelShape = voxelShape5;
                Intrinsics.checkNotNullExpressionValue((Object)voxelShape5, (String)"get(...)");
                break;
            }
            default: {
                Intrinsics.checkNotNull((Object)age);
                VoxelShape voxelShape6 = NORTH_AABB[age];
                voxelShape = voxelShape6;
                Intrinsics.checkNotNullExpressionValue((Object)voxelShape6, (String)"get(...)");
            }
        }
        return voxelShape;
    }

    @Deprecated(message="Deprecated in Java")
    @NotNull
    protected VoxelShape getCollisionShape(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context instanceof EntityCollisionContext) {
            Entity entity = ((EntityCollisionContext)context).getEntity();
            ItemEntity itemEntity = entity instanceof ItemEntity ? (ItemEntity)entity : null;
            boolean bl = itemEntity != null && (itemEntity = itemEntity.getItem()) != null ? itemEntity.is(CobblemonItemTags.APRICORNS) : false;
            if (bl) {
                VoxelShape voxelShape = Shapes.empty();
                Intrinsics.checkNotNullExpressionValue((Object)voxelShape, (String)"empty(...)");
                return voxelShape;
            }
        }
        VoxelShape voxelShape = super.getCollisionShape(state, world, pos, context);
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape, (String)"getCollisionShape(...)");
        return voxelShape;
    }

    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        BlockState blockState = null;
        blockState = this.defaultBlockState();
        Level worldView = ctx.getLevel();
        BlockPos blockPos = ctx.getClickedPos();
        Direction[] directionArray = ctx.getNearestLookingDirections();
        Intrinsics.checkNotNullExpressionValue((Object)directionArray, (String)"getNearestLookingDirections(...)");
        Object[] $this$forEach$iv = directionArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Direction direction = (Direction)element$iv;
            boolean bl = false;
            if (!direction.getAxis().isHorizontal()) continue;
            Object object = blockState.setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)direction);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type net.minecraft.world.level.block.state.BlockState");
            blockState = (BlockState)object;
            if (!blockState.canSurvive((LevelReader)worldView, blockPos)) continue;
            return blockState;
        }
        return null;
    }

    @NotNull
    protected BlockState updateShape(@NotNull BlockState state, @NotNull Direction direction, @NotNull BlockState neighborState, @NotNull LevelAccessor world, @NotNull BlockPos pos, @NotNull BlockPos neighborPos) {
        BlockState blockState;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        Intrinsics.checkNotNullParameter((Object)neighborState, (String)"neighborState");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)neighborPos, (String)"neighborPos");
        if (direction == state.getValue((Property)HorizontalDirectionalBlock.FACING) && !state.canSurvive((LevelReader)world, pos)) {
            BlockState blockState2 = Blocks.AIR.defaultBlockState();
            blockState = blockState2;
            Intrinsics.checkNotNullExpressionValue((Object)blockState2, (String)"defaultBlockState(...)");
        } else {
            BlockState blockState3 = super.updateShape(state, direction, neighborState, world, pos, neighborPos);
            blockState = blockState3;
            Intrinsics.checkNotNullExpressionValue((Object)blockState3, (String)"updateShape(...)");
        }
        return blockState;
    }

    public boolean isValidBonemealTarget(@NotNull LevelReader world, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return ((Number)((Object)state.getValue((Property)AGE))).intValue() < 3;
    }

    public boolean isBonemealSuccess(@NotNull Level world, @NotNull RandomSource random, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return true;
    }

    public void performBonemeal(@NotNull ServerLevel world, @NotNull RandomSource random, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        world.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(((Number)((Object)state.getValue((Property)AGE))).intValue() + 1)), 2);
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        Property[] propertyArray = new Property[]{HorizontalDirectionalBlock.FACING, AGE};
        builder.add(propertyArray);
    }

    protected boolean isPathfindable(@NotNull BlockState state, @NotNull PathComputationType type) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return false;
    }

    @NotNull
    protected InteractionResult useWithoutItem(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult blockHitResult) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)blockHitResult, (String)"blockHitResult");
        Integer n = (Integer)state.getValue((Property)AGE);
        int n2 = 3;
        if (n == null || n != n2) {
            InteractionResult interactionResult = super.useWithoutItem(state, level, pos, player, blockHitResult);
            Intrinsics.checkNotNullExpressionValue((Object)interactionResult, (String)"useWithoutItem(...)");
            return interactionResult;
        }
        this.doHarvest(level, state, pos, player);
        return InteractionResult.SUCCESS;
    }

    protected void attack(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Integer n = (Integer)state.getValue((Property)AGE);
        int n2 = 3;
        if (n == null || n != n2) {
            super.attack(state, world, pos, player);
            return;
        }
        this.doHarvest(world, state, pos, player);
    }

    @NotNull
    public ItemStack getCloneItemStack(@NotNull LevelReader world, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return new ItemStack((ItemLike)this.apricorn.item());
    }

    /*
     * WARNING - void declaration
     */
    private final void doHarvest(Level world, BlockState state, BlockPos pos, Player player) {
        BlockState resetState = this.harvest(world, state, pos);
        world.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)((Entity)player), (BlockState)resetState));
        if (!world.isClientSide) {
            Vec3 vec3 = BlockPosExtensionsKt.toVec3d(pos);
            SoundEvent soundEvent = SoundEvents.ITEM_PICKUP;
            Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"ITEM_PICKUP");
            WorldExtensionsKt.playSoundServer$default(world, vec3, soundEvent, null, 0.7f, 1.4f, 4, null);
            if (world instanceof ServerLevel && player instanceof ServerPlayer) {
                void $this$iv;
                EventObservable<ApricornHarvestEvent> eventObservable = CobblemonEvents.APRICORN_HARVESTED;
                ApricornHarvestEvent[] apricornHarvestEventArray = new ApricornHarvestEvent[]{new ApricornHarvestEvent((ServerPlayer)player, this.apricorn, (ServerLevel)world, pos)};
                ApricornHarvestEvent[] events$iv = apricornHarvestEventArray;
                boolean $i$f$post = false;
                $this$iv.emit(Arrays.copyOf(events$iv, events$iv.length));
                ApricornHarvestEvent[] $this$forEach$iv$iv = events$iv;
                boolean $i$f$forEach = false;
                int n = $this$forEach$iv$iv.length;
                for (int i = 0; i < n; ++i) {
                    ApricornHarvestEvent element$iv$iv;
                    ApricornHarvestEvent apricornHarvestEvent = element$iv$iv = $this$forEach$iv$iv[i];
                    boolean bl = false;
                    ApricornHarvestEvent it = apricornHarvestEvent;
                }
            }
        }
    }

    @NotNull
    public final BlockState harvest(@NotNull Level world, @NotNull BlockState state, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Block.dropResources((BlockState)state, (Level)world, (BlockPos)pos);
        BlockState resetState = (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(0));
        world.setBlock(pos, resetState, 2);
        Intrinsics.checkNotNull((Object)resetState);
        return resetState;
    }

    @Override
    public boolean attemptShear(@NotNull Level world, @NotNull BlockState state, @NotNull BlockPos pos, @NotNull Function0<Unit> successCallback) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter(successCallback, (String)"successCallback");
        Integer n = (Integer)state.getValue((Property)AGE);
        int n2 = 3;
        if (n == null || n != n2) {
            return false;
        }
        world.playSound(null, pos, SoundEvents.SHEEP_SHEAR, SoundSource.BLOCKS, 1.0f, 1.0f);
        this.harvest(world, state, pos);
        successCallback.invoke();
        world.gameEvent(null, (Holder)GameEvent.SHEAR, pos);
        return true;
    }

    @NotNull
    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    private static final App CODEC$lambda$0(RecordCodecBuilder.Instance it) {
        return it.group((App)HorizontalDirectionalBlock.propertiesCodec(), (App)Apricorn.Companion.getCODEC().fieldOf("apricorn").forGetter(arg_0 -> ApricornBlock.CODEC$lambda$0$0((KProperty1)Companion.CODEC.1.1.INSTANCE, arg_0))).apply((Applicative)it, ApricornBlock::new);
    }

    private static final Apricorn CODEC$lambda$0$0(KProperty1 $tmp0, ApricornBlock p0) {
        return (Apricorn)((Object)((Function1)$tmp0).invoke((Object)p0));
    }

    static {
        MapCodec mapCodec = RecordCodecBuilder.mapCodec(ApricornBlock::CODEC$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)mapCodec, (String)"mapCodec(...)");
        CODEC = mapCodec;
        AGE = BlockStateProperties.AGE_3;
        NORTH_STAGE_0 = Shapes.box((double)0.40625, (double)0.5, (double)0.0, (double)0.59375, (double)0.6875, (double)0.1875);
        NORTH_CAP_STAGE_0 = Shapes.box((double)0.4375, (double)0.65625, (double)0.03125, (double)0.5625, (double)0.71875, (double)0.15625);
        NORTH_STAGE_1 = Shapes.box((double)0.375, (double)0.40625, (double)0.0, (double)0.625, (double)0.65625, (double)0.25);
        NORTH_CAP_STAGE_1 = Shapes.box((double)0.40625, (double)0.625, (double)0.03125, (double)0.59375, (double)0.6875, (double)0.21875);
        NORTH_STAGE_2 = Shapes.box((double)0.34375, (double)0.296875, (double)0.0, (double)0.65625, (double)0.609375, (double)0.3125);
        NORTH_CAP_STAGE_2 = Shapes.box((double)0.375, (double)0.59375, (double)0.03125, (double)0.625, (double)0.65625, (double)0.28125);
        NORTH_STAGE_3 = Shapes.box((double)0.3125, (double)0.1875, (double)0.0, (double)0.6875, (double)0.5625, (double)0.375);
        NORTH_CAP_STAGE_3 = Shapes.box((double)0.375, (double)0.5625, (double)0.0625, (double)0.625, (double)0.625, (double)0.3125);
        VoxelShape[] voxelShapeArray = new VoxelShape[]{Shapes.or((VoxelShape)NORTH_STAGE_0, (VoxelShape)NORTH_CAP_STAGE_0), Shapes.or((VoxelShape)NORTH_STAGE_1, (VoxelShape)NORTH_CAP_STAGE_1), Shapes.or((VoxelShape)NORTH_STAGE_2, (VoxelShape)NORTH_CAP_STAGE_2), Shapes.or((VoxelShape)NORTH_STAGE_3, (VoxelShape)NORTH_CAP_STAGE_3)};
        NORTH_AABB = voxelShapeArray;
        SOUTH_STAGE_0 = Shapes.box((double)0.40625, (double)0.5, (double)0.8125, (double)0.59375, (double)0.6875, (double)1.0);
        SOUTH_CAP_STAGE_0 = Shapes.box((double)0.4375, (double)0.65625, (double)0.84375, (double)0.5625, (double)0.71875, (double)0.96875);
        SOUTH_STAGE_1 = Shapes.box((double)0.375, (double)0.40625, (double)0.75, (double)0.625, (double)0.65625, (double)1.0);
        SOUTH_CAP_STAGE_1 = Shapes.box((double)0.40625, (double)0.625, (double)0.78125, (double)0.59375, (double)0.6875, (double)0.96875);
        SOUTH_STAGE_2 = Shapes.box((double)0.34375, (double)0.296875, (double)0.6875, (double)0.65625, (double)0.609375, (double)1.0);
        SOUTH_CAP_STAGE_2 = Shapes.box((double)0.375, (double)0.59375, (double)0.71875, (double)0.625, (double)0.65625, (double)0.96875);
        SOUTH_STAGE_3 = Shapes.box((double)0.3125, (double)0.1875, (double)0.625, (double)0.6875, (double)0.5625, (double)1.0);
        SOUTH_CAP_STAGE_3 = Shapes.box((double)0.375, (double)0.5625, (double)0.6875, (double)0.625, (double)0.625, (double)0.9375);
        voxelShapeArray = new VoxelShape[]{Shapes.or((VoxelShape)SOUTH_STAGE_0, (VoxelShape)SOUTH_CAP_STAGE_0), Shapes.or((VoxelShape)SOUTH_STAGE_1, (VoxelShape)SOUTH_CAP_STAGE_1), Shapes.or((VoxelShape)SOUTH_STAGE_2, (VoxelShape)SOUTH_CAP_STAGE_2), Shapes.or((VoxelShape)SOUTH_STAGE_3, (VoxelShape)SOUTH_CAP_STAGE_3)};
        SOUTH_AABB = voxelShapeArray;
        EAST_STAGE_0 = Shapes.box((double)0.8125, (double)0.5, (double)0.40625, (double)1.0, (double)0.6875, (double)0.59375);
        EAST_CAP_STAGE_0 = Shapes.box((double)0.84375, (double)0.65625, (double)0.4375, (double)0.96875, (double)0.71875, (double)0.5625);
        EAST_STAGE_1 = Shapes.box((double)0.75, (double)0.40625, (double)0.375, (double)1.0, (double)0.65625, (double)0.625);
        EAST_CAP_STAGE_1 = Shapes.box((double)0.78125, (double)0.625, (double)0.40625, (double)0.96875, (double)0.6875, (double)0.59375);
        EAST_STAGE_2 = Shapes.box((double)0.6875, (double)0.296875, (double)0.34375, (double)1.0, (double)0.609375, (double)0.65625);
        EAST_CAP_STAGE_2 = Shapes.box((double)0.71875, (double)0.59375, (double)0.375, (double)0.96875, (double)0.65625, (double)0.625);
        EAST_STAGE_3 = Shapes.box((double)0.625, (double)0.1875, (double)0.3125, (double)1.0, (double)0.5625, (double)0.6875);
        EAST_CAP_STAGE_3 = Shapes.box((double)0.6875, (double)0.5625, (double)0.375, (double)0.9375, (double)0.625, (double)0.625);
        voxelShapeArray = new VoxelShape[]{Shapes.or((VoxelShape)EAST_STAGE_0, (VoxelShape)EAST_CAP_STAGE_0), Shapes.or((VoxelShape)EAST_STAGE_1, (VoxelShape)EAST_CAP_STAGE_1), Shapes.or((VoxelShape)EAST_STAGE_2, (VoxelShape)EAST_CAP_STAGE_2), Shapes.or((VoxelShape)EAST_STAGE_3, (VoxelShape)EAST_CAP_STAGE_3)};
        EAST_AABB = voxelShapeArray;
        WEST_STAGE_0 = Shapes.box((double)0.0, (double)0.5, (double)0.40625, (double)0.1875, (double)0.6875, (double)0.59375);
        WEST_CAP_STAGE_0 = Shapes.box((double)0.03125, (double)0.65625, (double)0.4375, (double)0.15625, (double)0.71875, (double)0.5625);
        WEST_STAGE_1 = Shapes.box((double)0.0, (double)0.40625, (double)0.375, (double)0.25, (double)0.65625, (double)0.625);
        WEST_CAP_STAGE_1 = Shapes.box((double)0.03125, (double)0.625, (double)0.40625, (double)0.21875, (double)0.6875, (double)0.59375);
        WEST_STAGE_2 = Shapes.box((double)0.0, (double)0.296875, (double)0.34375, (double)0.3125, (double)0.609375, (double)0.65625);
        WEST_CAP_STAGE_2 = Shapes.box((double)0.03125, (double)0.59375, (double)0.375, (double)0.28125, (double)0.65625, (double)0.625);
        WEST_STAGE_3 = Shapes.box((double)0.0, (double)0.1875, (double)0.3125, (double)0.375, (double)0.5625, (double)0.6875);
        WEST_CAP_STAGE_3 = Shapes.box((double)0.0625, (double)0.5625, (double)0.375, (double)0.3125, (double)0.625, (double)0.625);
        voxelShapeArray = new VoxelShape[]{Shapes.or((VoxelShape)WEST_STAGE_0, (VoxelShape)WEST_CAP_STAGE_0), Shapes.or((VoxelShape)WEST_STAGE_1, (VoxelShape)WEST_CAP_STAGE_1), Shapes.or((VoxelShape)WEST_STAGE_2, (VoxelShape)WEST_CAP_STAGE_2), Shapes.or((VoxelShape)WEST_STAGE_3, (VoxelShape)WEST_CAP_STAGE_3)};
        WEST_AABB = voxelShapeArray;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0011\n\u0002\b\u001e\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001d\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0007\u001a\u0004\b\b\u0010\tR\u001f\u0010\f\u001a\n \u000b*\u0004\u0018\u00010\n0\n8\u0006\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0011\u001a\u00020\u00108\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00108\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0012R\u001c\u0010\u0015\u001a\n \u000b*\u0004\u0018\u00010\u00140\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016R\u001c\u0010\u0017\u001a\n \u000b*\u0004\u0018\u00010\u00140\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0016R\u001c\u0010\u0018\u001a\n \u000b*\u0004\u0018\u00010\u00140\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0016R\u001c\u0010\u0019\u001a\n \u000b*\u0004\u0018\u00010\u00140\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u0016R\u001c\u0010\u001a\u001a\n \u000b*\u0004\u0018\u00010\u00140\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u0016R\u001c\u0010\u001b\u001a\n \u000b*\u0004\u0018\u00010\u00140\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u0016R\u001c\u0010\u001c\u001a\n \u000b*\u0004\u0018\u00010\u00140\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u0016R\u001c\u0010\u001d\u001a\n \u000b*\u0004\u0018\u00010\u00140\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u0016R\"\u0010\u001f\u001a\u0010\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00140\u00140\u001e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 R\u001c\u0010!\u001a\n \u000b*\u0004\u0018\u00010\u00140\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b!\u0010\u0016R\u001c\u0010\"\u001a\n \u000b*\u0004\u0018\u00010\u00140\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\"\u0010\u0016R\u001c\u0010#\u001a\n \u000b*\u0004\u0018\u00010\u00140\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b#\u0010\u0016R\u001c\u0010$\u001a\n \u000b*\u0004\u0018\u00010\u00140\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b$\u0010\u0016R\u001c\u0010%\u001a\n \u000b*\u0004\u0018\u00010\u00140\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b%\u0010\u0016R\u001c\u0010&\u001a\n \u000b*\u0004\u0018\u00010\u00140\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b&\u0010\u0016R\u001c\u0010'\u001a\n \u000b*\u0004\u0018\u00010\u00140\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b'\u0010\u0016R\u001c\u0010(\u001a\n \u000b*\u0004\u0018\u00010\u00140\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b(\u0010\u0016R\"\u0010)\u001a\u0010\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00140\u00140\u001e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b)\u0010 R\u001c\u0010*\u001a\n \u000b*\u0004\u0018\u00010\u00140\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b*\u0010\u0016R\u001c\u0010+\u001a\n \u000b*\u0004\u0018\u00010\u00140\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b+\u0010\u0016R\u001c\u0010,\u001a\n \u000b*\u0004\u0018\u00010\u00140\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b,\u0010\u0016R\u001c\u0010-\u001a\n \u000b*\u0004\u0018\u00010\u00140\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b-\u0010\u0016R\u001c\u0010.\u001a\n \u000b*\u0004\u0018\u00010\u00140\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b.\u0010\u0016R\u001c\u0010/\u001a\n \u000b*\u0004\u0018\u00010\u00140\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b/\u0010\u0016R\u001c\u00100\u001a\n \u000b*\u0004\u0018\u00010\u00140\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b0\u0010\u0016R\u001c\u00101\u001a\n \u000b*\u0004\u0018\u00010\u00140\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b1\u0010\u0016R\"\u00102\u001a\u0010\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00140\u00140\u001e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b2\u0010 R\u001c\u00103\u001a\n \u000b*\u0004\u0018\u00010\u00140\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b3\u0010\u0016R\u001c\u00104\u001a\n \u000b*\u0004\u0018\u00010\u00140\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b4\u0010\u0016R\u001c\u00105\u001a\n \u000b*\u0004\u0018\u00010\u00140\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b5\u0010\u0016R\u001c\u00106\u001a\n \u000b*\u0004\u0018\u00010\u00140\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b6\u0010\u0016R\u001c\u00107\u001a\n \u000b*\u0004\u0018\u00010\u00140\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b7\u0010\u0016R\u001c\u00108\u001a\n \u000b*\u0004\u0018\u00010\u00140\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b8\u0010\u0016R\u001c\u00109\u001a\n \u000b*\u0004\u0018\u00010\u00140\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b9\u0010\u0016R\u001c\u0010:\u001a\n \u000b*\u0004\u0018\u00010\u00140\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b:\u0010\u0016R\"\u0010;\u001a\u0010\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00140\u00140\u001e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b;\u0010 \u00a8\u0006<"}, d2={"Lcom/cobblemon/mod/common/block/ApricornBlock$Companion;", "", "<init>", "()V", "Lcom/mojang/serialization/MapCodec;", "Lcom/cobblemon/mod/common/block/ApricornBlock;", "CODEC", "Lcom/mojang/serialization/MapCodec;", "getCODEC", "()Lcom/mojang/serialization/MapCodec;", "Lnet/minecraft/world/level/block/state/properties/IntegerProperty;", "kotlin.jvm.PlatformType", "AGE", "Lnet/minecraft/world/level/block/state/properties/IntegerProperty;", "getAGE", "()Lnet/minecraft/world/level/block/state/properties/IntegerProperty;", "", "MAX_AGE", "I", "MIN_AGE", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "NORTH_STAGE_0", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "NORTH_CAP_STAGE_0", "NORTH_STAGE_1", "NORTH_CAP_STAGE_1", "NORTH_STAGE_2", "NORTH_CAP_STAGE_2", "NORTH_STAGE_3", "NORTH_CAP_STAGE_3", "", "NORTH_AABB", "[Lnet/minecraft/world/phys/shapes/VoxelShape;", "SOUTH_STAGE_0", "SOUTH_CAP_STAGE_0", "SOUTH_STAGE_1", "SOUTH_CAP_STAGE_1", "SOUTH_STAGE_2", "SOUTH_CAP_STAGE_2", "SOUTH_STAGE_3", "SOUTH_CAP_STAGE_3", "SOUTH_AABB", "EAST_STAGE_0", "EAST_CAP_STAGE_0", "EAST_STAGE_1", "EAST_CAP_STAGE_1", "EAST_STAGE_2", "EAST_CAP_STAGE_2", "EAST_STAGE_3", "EAST_CAP_STAGE_3", "EAST_AABB", "WEST_STAGE_0", "WEST_CAP_STAGE_0", "WEST_STAGE_1", "WEST_CAP_STAGE_1", "WEST_STAGE_2", "WEST_CAP_STAGE_2", "WEST_STAGE_3", "WEST_CAP_STAGE_3", "WEST_AABB", "common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MapCodec<ApricornBlock> getCODEC() {
            return CODEC;
        }

        public final IntegerProperty getAGE() {
            return AGE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Direction.values().length];
            try {
                nArray[Direction.NORTH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.EAST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.SOUTH.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.WEST.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

