/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.block.campfirepot;

import com.cobblemon.mod.common.CobblemonBlockEntities;
import com.cobblemon.mod.common.CobblemonSounds;
import com.cobblemon.mod.common.block.campfirepot.CampfireBlock;
import com.cobblemon.mod.common.block.entity.CampfireBlockEntity;
import com.cobblemon.mod.common.item.CampfirePotItem;
import com.cobblemon.mod.common.util.WorldExtensionsKt;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty1;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00d2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u0000 l2\u00020\u00012\u00020\u0002:\u0001lB\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0019\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ/\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0013H\u0014\u00a2\u0006\u0004\b\u0016\u0010\u0017J/\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u0013H\u0014\u00a2\u0006\u0004\b\u001c\u0010\u0017J7\u0010#\u001a\u00020\"2\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020 H\u0014\u00a2\u0006\u0004\b#\u0010$J/\u0010(\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020%2\u0006\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020&H\u0016\u00a2\u0006\u0004\b(\u0010)JE\u0010.\u001a\u00020-2\u0006\u0010+\u001a\u00020*2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001d2\u0006\u0010\u0012\u001a\u00020\u00112\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010\u001e2\b\b\u0002\u0010,\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b.\u0010/J%\u00100\u001a\u00020-2\u0006\u0010\u0019\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020\u001e\u00a2\u0006\u0004\b0\u00101J#\u00105\u001a\u00020-2\u0012\u00104\u001a\u000e\u0012\u0004\u0012\u000203\u0012\u0004\u0012\u00020\u000b02H\u0014\u00a2\u0006\u0004\b5\u00106J?\u0010<\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u00108\u001a\u0002072\u0006\u00109\u001a\u00020\u000b2\u0006\u0010:\u001a\u00020%2\u0006\u0010\u001a\u001a\u00020\u00112\u0006\u0010;\u001a\u00020\u0011H\u0014\u00a2\u0006\u0004\b<\u0010=J\u0017\u0010?\u001a\u00020>2\u0006\u0010\u0018\u001a\u00020\u000bH\u0014\u00a2\u0006\u0004\b?\u0010@J'\u0010B\u001a\u00020A2\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u0011H\u0014\u00a2\u0006\u0004\bB\u0010CJ\u0017\u0010D\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u000bH\u0014\u00a2\u0006\u0004\bD\u0010EJ\u0017\u0010G\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010FH\u0014\u00a2\u0006\u0004\bG\u0010HJ\u001f\u0010K\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010J\u001a\u00020IH\u0014\u00a2\u0006\u0004\bK\u0010LJE\u0010R\u001a\f\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0018\u00010Q\"\n\b\u0000\u0010N*\u0004\u0018\u00010M2\u0006\u0010\u0019\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u000b2\u000e\u0010P\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000OH\u0016\u00a2\u0006\u0004\bR\u0010SJG\u0010V\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010Q\"\b\b\u0000\u0010N*\u00020M2\u0006\u0010\u0019\u001a\u00020\u001d2\f\u0010T\u001a\b\u0012\u0004\u0012\u00028\u00000O2\u000e\u0010U\u001a\n\u0012\u0006\b\u0001\u0012\u00020*0OH\u0005\u00a2\u0006\u0004\bV\u0010WJ!\u0010X\u001a\u0004\u0018\u00010M2\u0006\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\bX\u0010YJ/\u0010\\\u001a\u00020-2\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u00112\u0006\u0010[\u001a\u00020ZH\u0016\u00a2\u0006\u0004\b\\\u0010]J'\u0010`\u001a\u00020_2\u0006\u0010\u0019\u001a\u00020^2\u0006\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b`\u0010aJ?\u0010d\u001a\u00020-2\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u00112\u0006\u0010b\u001a\u0002032\u0006\u0010;\u001a\u00020\u00112\u0006\u0010c\u001a\u00020\u0005H\u0014\u00a2\u0006\u0004\bd\u0010eJ\u0017\u0010f\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u000bH\u0014\u00a2\u0006\u0004\bf\u0010EJ7\u0010h\u001a\u00020-2\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u00112\u0006\u0010g\u001a\u00020\u000b2\u0006\u0010c\u001a\u00020\u0005H\u0014\u00a2\u0006\u0004\bh\u0010iR\u0017\u0010\u0006\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010j\u001a\u0004\b\u0006\u0010k\u00a8\u0006m"}, d2={"Lcom/cobblemon/mod/common/block/campfirepot/CampfireBlock;", "Lnet/minecraft/world/level/block/BaseEntityBlock;", "Lnet/minecraft/world/level/block/SimpleWaterloggedBlock;", "Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;", "settings", "", "isSoul", "<init>", "(Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;Z)V", "Lnet/minecraft/world/item/context/BlockPlaceContext;", "ctx", "Lnet/minecraft/world/level/block/state/BlockState;", "getStateForPlacement", "(Lnet/minecraft/world/item/context/BlockPlaceContext;)Lnet/minecraft/world/level/block/state/BlockState;", "blockState", "Lnet/minecraft/world/level/BlockGetter;", "blockGetter", "Lnet/minecraft/core/BlockPos;", "blockPos", "Lnet/minecraft/world/phys/shapes/CollisionContext;", "collisionContext", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "getShape", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/phys/shapes/CollisionContext;)Lnet/minecraft/world/phys/shapes/VoxelShape;", "state", "level", "pos", "context", "getCollisionShape", "Lnet/minecraft/world/level/Level;", "Lnet/minecraft/world/entity/player/Player;", "player", "Lnet/minecraft/world/phys/BlockHitResult;", "hitResult", "Lnet/minecraft/world/InteractionResult;", "useWithoutItem", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/phys/BlockHitResult;)Lnet/minecraft/world/InteractionResult;", "Lnet/minecraft/world/level/LevelAccessor;", "Lnet/minecraft/world/level/material/FluidState;", "fluidState", "placeLiquid", "(Lnet/minecraft/world/level/LevelAccessor;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/material/FluidState;)Z", "Lcom/cobblemon/mod/common/block/entity/CampfireBlockEntity;", "blockEntity", "byWater", "", "removePotItem", "(Lcom/cobblemon/mod/common/block/entity/CampfireBlockEntity;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/entity/player/Player;Z)V", "openContainer", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/entity/player/Player;)V", "Lnet/minecraft/world/level/block/state/StateDefinition$Builder;", "Lnet/minecraft/world/level/block/Block;", "builder", "createBlockStateDefinition", "(Lnet/minecraft/world/level/block/state/StateDefinition$Builder;)V", "Lnet/minecraft/core/Direction;", "direction", "neighborState", "world", "neighborPos", "updateShape", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/core/Direction;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/LevelAccessor;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/block/state/BlockState;", "Lnet/minecraft/world/level/block/RenderShape;", "getRenderShape", "(Lnet/minecraft/world/level/block/state/BlockState;)Lnet/minecraft/world/level/block/RenderShape;", "", "getAnalogOutputSignal", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)I", "hasAnalogOutputSignal", "(Lnet/minecraft/world/level/block/state/BlockState;)Z", "Lcom/mojang/serialization/MapCodec;", "codec", "()Lcom/mojang/serialization/MapCodec;", "Lnet/minecraft/world/level/pathfinder/PathComputationType;", "type", "isPathfindable", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/pathfinder/PathComputationType;)Z", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "T", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "blockEntityType", "Lnet/minecraft/world/level/block/entity/BlockEntityTicker;", "getTicker", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/block/entity/BlockEntityType;)Lnet/minecraft/world/level/block/entity/BlockEntityTicker;", "serverType", "clientType", "createCookingPotTicker", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/level/block/entity/BlockEntityType;Lnet/minecraft/world/level/block/entity/BlockEntityType;)Lnet/minecraft/world/level/block/entity/BlockEntityTicker;", "newBlockEntity", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)Lnet/minecraft/world/level/block/entity/BlockEntity;", "Lnet/minecraft/util/RandomSource;", "random", "animateTick", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/util/RandomSource;)V", "Lnet/minecraft/world/level/LevelReader;", "Lnet/minecraft/world/item/ItemStack;", "getCloneItemStack", "(Lnet/minecraft/world/level/LevelReader;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)Lnet/minecraft/world/item/ItemStack;", "neighborBlock", "movedByPiston", "neighborChanged", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/Block;Lnet/minecraft/core/BlockPos;Z)V", "isSignalSource", "newState", "onRemove", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Z)V", "Z", "()Z", "Companion", "common"})
@SourceDebugExtension(value={"SMAP\nCampfireBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CampfireBlock.kt\ncom/cobblemon/mod/common/block/campfirepot/CampfireBlock\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,335:1\n13805#2,2:336\n*S KotlinDebug\n*F\n+ 1 CampfireBlock.kt\ncom/cobblemon/mod/common/block/campfirepot/CampfireBlock\n*L\n95#1:336,2\n*E\n"})
public final class CampfireBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean isSoul;
    @NotNull
    private static final MapCodec<CampfireBlock> CODEC;
    private static final DirectionProperty ITEM_DIRECTION;
    private static final BooleanProperty POWERED;
    private static final BooleanProperty COOKING;
    private static final BooleanProperty LID;
    private static final VoxelShape campfireAABB;
    private static final VoxelShape AABB;

    public CampfireBlock(@NotNull BlockBehaviour.Properties settings, boolean isSoul) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super(settings);
        this.isSoul = isSoul;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)Direction.NORTH)).setValue((Property)ITEM_DIRECTION, (Comparable)Direction.NORTH)).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)COOKING, (Comparable)Boolean.valueOf(false))).setValue((Property)LID, (Comparable)Boolean.valueOf(false)));
    }

    public final boolean isSoul() {
        return this.isSoul;
    }

    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        BlockState blockState = null;
        blockState = this.defaultBlockState();
        Level worldView = ctx.getLevel();
        BlockPos blockPos = ctx.getClickedPos();
        Direction[] directionArray = ctx.getNearestLookingDirections();
        Intrinsics.checkNotNullExpressionValue((Object)directionArray, (String)"getNearestLookingDirections(...)");
        Object[] $this$forEach$iv = directionArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Direction direction = (Direction)element$iv;
            boolean bl = false;
            if (!direction.getAxis().isHorizontal()) continue;
            Object object = ((BlockState)blockState.setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)direction)).setValue((Property)ITEM_DIRECTION, (Comparable)direction);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type net.minecraft.world.level.block.state.BlockState");
            blockState = (BlockState)object;
            if (!blockState.canSurvive((LevelReader)worldView, blockPos)) continue;
            return blockState;
        }
        return null;
    }

    @NotNull
    protected VoxelShape getShape(@NotNull BlockState blockState, @NotNull BlockGetter blockGetter, @NotNull BlockPos blockPos, @NotNull CollisionContext collisionContext) {
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        Intrinsics.checkNotNullParameter((Object)blockGetter, (String)"blockGetter");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)collisionContext, (String)"collisionContext");
        VoxelShape voxelShape = AABB;
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape, (String)"AABB");
        return voxelShape;
    }

    @NotNull
    protected VoxelShape getCollisionShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        VoxelShape voxelShape = AABB;
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape, (String)"AABB");
        return voxelShape;
    }

    @NotNull
    protected InteractionResult useWithoutItem(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hitResult) {
        CampfirePotItem potItem;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hitResult, (String)"hitResult");
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof CampfireBlockEntity)) {
            return InteractionResult.PASS;
        }
        ItemStack itemStack = ((CampfireBlockEntity)blockEntity).getPotItem();
        Item item = itemStack != null ? itemStack.getItem() : null;
        CampfirePotItem campfirePotItem = potItem = item instanceof CampfirePotItem ? (CampfirePotItem)item : null;
        if (potItem != null) {
            if (!level.isClientSide) {
                if (player.isCrouching()) {
                    CampfireBlock.removePotItem$default(this, (CampfireBlockEntity)blockEntity, state, level, pos, player, false, 32, null);
                } else {
                    this.openContainer(level, pos, player);
                }
            }
            return InteractionResult.SUCCESS;
        }
        if (player.getItemInHand(InteractionHand.MAIN_HAND).getItem() instanceof CampfirePotItem) {
            ItemStack heldItem = player.getItemInHand(InteractionHand.MAIN_HAND);
            ((CampfireBlockEntity)blockEntity).setPotItem(heldItem.split(1));
            Vec3 vec3 = pos.getBottomCenter();
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getBottomCenter(...)");
            WorldExtensionsKt.playSoundServer$default(level, vec3, CobblemonSounds.CAMPFIRE_POT_PLACE, null, 0.0f, 0.0f, 28, null);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean placeLiquid(@NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull FluidState fluidState) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)fluidState, (String)"fluidState");
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (fluidState.getType() == Fluids.WATER && blockEntity instanceof CampfireBlockEntity) {
            if (!level.isClientSide()) {
                this.removePotItem((CampfireBlockEntity)blockEntity, state, (Level)level, pos, null, true);
                Level level2 = (Level)level;
                Vec3 vec3 = pos.getCenter();
                Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getCenter(...)");
                SoundEvent soundEvent = SoundEvents.GENERIC_EXTINGUISH_FIRE;
                Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"GENERIC_EXTINGUISH_FIRE");
                WorldExtensionsKt.playSoundServer(level2, vec3, soundEvent, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            if (level.isClientSide()) {
                for (int i = 0; i < 20; ++i) {
                    net.minecraft.world.level.block.CampfireBlock.makeParticles((Level)((Level)level), (BlockPos)pos, (boolean)false, (boolean)true);
                }
            }
            level.scheduleTick(pos, fluidState.getType(), fluidState.getType().getTickDelay((LevelReader)level));
            return true;
        }
        return false;
    }

    private final void removePotItem(CampfireBlockEntity blockEntity, BlockState blockState, Level level, BlockPos blockPos, Player player, boolean byWater) {
        if (!byWater && player != null && !player.getItemInHand(InteractionHand.MAIN_HAND).isEmpty()) {
            return;
        }
        ItemStack potItem = blockEntity.getPotItem();
        if (!byWater && player != null) {
            if (!player.isCreative() && potItem != null) {
                player.setItemInHand(InteractionHand.MAIN_HAND, potItem);
            }
        } else {
            Comparable comparable = blockState.getValue((Property)HorizontalDirectionalBlock.FACING);
            Intrinsics.checkNotNull((Object)comparable, (String)"null cannot be cast to non-null type net.minecraft.core.Direction");
            Direction direction = (Direction)comparable;
            float f = 0.25f * (float)direction.getStepX();
            float g = 0.25f * (float)direction.getStepZ();
            ItemEntity itemEntity = new ItemEntity(level, (double)blockPos.getX() + 0.5 + (double)f, (double)(blockPos.getY() + 1), (double)blockPos.getZ() + 0.5 + (double)g, potItem);
            itemEntity.setDefaultPickUpDelay();
            level.addFreshEntity((Entity)itemEntity);
        }
        blockEntity.setPotItem(ItemStack.EMPTY);
        Vec3 vec3 = blockPos.getBottomCenter();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getBottomCenter(...)");
        WorldExtensionsKt.playSoundServer$default(level, vec3, CobblemonSounds.CAMPFIRE_POT_RETRIEVE, null, 0.0f, 0.0f, 28, null);
        Containers.dropContents((Level)level, (BlockPos)blockPos, (Container)((Container)blockEntity));
        Direction facing = (Direction)blockState.getValue((Property)HorizontalDirectionalBlock.FACING);
        blockEntity.setRemoved();
        BlockState newBlockState = this.isSoul ? (BlockState)Blocks.SOUL_CAMPFIRE.defaultBlockState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)facing) : (BlockState)Blocks.CAMPFIRE.defaultBlockState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)facing);
        level.setBlockAndUpdate(blockPos, byWater ? (BlockState)((BlockState)newBlockState.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(true))).setValue((Property)net.minecraft.world.level.block.CampfireBlock.LIT, (Comparable)Boolean.valueOf(false)) : newBlockState);
    }

    static /* synthetic */ void removePotItem$default(CampfireBlock campfireBlock, CampfireBlockEntity campfireBlockEntity, BlockState blockState, Level level, BlockPos blockPos, Player player, boolean bl, int n, Object object) {
        if ((n & 0x10) != 0) {
            player = null;
        }
        if ((n & 0x20) != 0) {
            bl = false;
        }
        campfireBlock.removePotItem(campfireBlockEntity, blockState, level, blockPos, player, bl);
    }

    public final void openContainer(@NotNull Level level, @NotNull BlockPos pos, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CampfireBlockEntity) {
            player.openMenu((MenuProvider)blockEntity);
        }
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        Property[] propertyArray = new Property[]{HorizontalDirectionalBlock.FACING, ITEM_DIRECTION, POWERED, COOKING, LID};
        builder.add(propertyArray);
    }

    @NotNull
    protected BlockState updateShape(@NotNull BlockState state, @NotNull Direction direction, @NotNull BlockState neighborState, @NotNull LevelAccessor world, @NotNull BlockPos pos, @NotNull BlockPos neighborPos) {
        BlockState blockState;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        Intrinsics.checkNotNullParameter((Object)neighborState, (String)"neighborState");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)neighborPos, (String)"neighborPos");
        if (direction == state.getValue((Property)HorizontalDirectionalBlock.FACING) && !state.canSurvive((LevelReader)world, pos)) {
            BlockState blockState2 = Blocks.AIR.defaultBlockState();
            blockState = blockState2;
            Intrinsics.checkNotNullExpressionValue((Object)blockState2, (String)"defaultBlockState(...)");
        } else {
            BlockState blockState3 = super.updateShape(state, direction, neighborState, world, pos, neighborPos);
            blockState = blockState3;
            Intrinsics.checkNotNullExpressionValue((Object)blockState3, (String)"updateShape(...)");
        }
        return blockState;
    }

    @NotNull
    protected RenderShape getRenderShape(@NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return RenderShape.MODEL;
    }

    protected int getAnalogOutputSignal(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return AbstractContainerMenu.getRedstoneSignalFromBlockEntity((BlockEntity)level.getBlockEntity(pos));
    }

    protected boolean hasAnalogOutputSignal(@NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return true;
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected boolean isPathfindable(@NotNull BlockState state, @NotNull PathComputationType type) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return false;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> blockEntityType) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter(blockEntityType, (String)"blockEntityType");
        return this.createCookingPotTicker(level, blockEntityType, CobblemonBlockEntities.CAMPFIRE);
    }

    @Nullable
    protected final <T extends BlockEntity> BlockEntityTicker<T> createCookingPotTicker(@NotNull Level level, @NotNull BlockEntityType<T> serverType, @NotNull BlockEntityType<? extends CampfireBlockEntity> clientType) {
        BlockEntityTicker blockEntityTicker;
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter(serverType, (String)"serverType");
        Intrinsics.checkNotNullParameter(clientType, (String)"clientType");
        if (level.isClientSide) {
            CampfireBlockEntity.Companion companion = CampfireBlockEntity.Companion;
            blockEntityTicker = BaseEntityBlock.createTickerHelper(serverType, clientType, (BlockEntityTicker)new BlockEntityTicker(companion){
                final /* synthetic */ CampfireBlockEntity.Companion $tmp0;
                {
                    this.$tmp0 = $tmp0;
                }

                public final void tick(Level p0, BlockPos p1, BlockState p2, CampfireBlockEntity p3) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                    Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                    Intrinsics.checkNotNullParameter((Object)((Object)p3), (String)"p3");
                    this.$tmp0.clientTick(p0, p1, p2, p3);
                }
            });
        } else {
            CampfireBlockEntity.Companion companion = CampfireBlockEntity.Companion;
            blockEntityTicker = BaseEntityBlock.createTickerHelper(serverType, clientType, (BlockEntityTicker)new BlockEntityTicker(companion){
                final /* synthetic */ CampfireBlockEntity.Companion $tmp0;
                {
                    this.$tmp0 = $tmp0;
                }

                public final void tick(Level p0, BlockPos p1, BlockState p2, CampfireBlockEntity p3) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                    Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                    Intrinsics.checkNotNullParameter((Object)((Object)p3), (String)"p3");
                    this.$tmp0.serverTick(p0, p1, p2, p3);
                }
            });
        }
        return blockEntityTicker;
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return (BlockEntity)new CampfireBlockEntity(pos, state);
    }

    public void animateTick(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        if (random.nextInt(10) == 0) {
            level.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.CAMPFIRE_CRACKLE, SoundSource.BLOCKS, 0.5f + random.nextFloat(), random.nextFloat() * 0.7f + 0.6f, false);
        }
    }

    @NotNull
    public ItemStack getCloneItemStack(@NotNull LevelReader level, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return this.isSoul ? new ItemStack((ItemLike)Blocks.SOUL_CAMPFIRE) : new ItemStack((ItemLike)Blocks.CAMPFIRE);
    }

    protected void neighborChanged(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Block neighborBlock, @NotNull BlockPos neighborPos, boolean movedByPiston) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)neighborBlock, (String)"neighborBlock");
        Intrinsics.checkNotNullParameter((Object)neighborPos, (String)"neighborPos");
        super.neighborChanged(state, level, pos, neighborBlock, neighborPos, movedByPiston);
        boolean isPowered = level.hasNeighborSignal(pos);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        CampfireBlockEntity campfireBlockEntity = blockEntity instanceof CampfireBlockEntity ? (CampfireBlockEntity)blockEntity : null;
        if (campfireBlockEntity == null) {
            return;
        }
        CampfireBlockEntity blockEntity2 = campfireBlockEntity;
        if (!Intrinsics.areEqual((Object)isPowered, (Object)state.getValue((Property)POWERED))) {
            level.setBlock(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(isPowered)), 3);
            blockEntity2.toggleLid(!isPowered);
        }
    }

    protected boolean isSignalSource(@NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return true;
    }

    protected void onRemove(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState newState, boolean movedByPiston) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
        if (!state.is(newState.getBlock())) {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof CampfireBlockEntity) {
                if (level instanceof ServerLevel) {
                    ItemStack potItem;
                    Containers.dropContents((Level)level, (BlockPos)pos, (Container)((Container)blockEntity));
                    ItemStack itemStack = ((CampfireBlockEntity)blockEntity).getPotItem();
                    if (itemStack == null) {
                        itemStack = ItemStack.EMPTY;
                    }
                    if (!(potItem = itemStack).isEmpty()) {
                        Comparable comparable = state.getValue((Property)HorizontalDirectionalBlock.FACING);
                        Intrinsics.checkNotNull((Object)comparable, (String)"null cannot be cast to non-null type net.minecraft.core.Direction");
                        Direction direction = (Direction)comparable;
                        float f = 0.25f * (float)direction.getStepX();
                        float g = 0.25f * (float)direction.getStepZ();
                        ItemEntity itemEntity = new ItemEntity(level, (double)pos.getX() + 0.5 + (double)f, (double)(pos.getY() + 1), (double)pos.getZ() + 0.5 + (double)g, potItem);
                        itemEntity.setDefaultPickUpDelay();
                        ((ServerLevel)level).addFreshEntity((Entity)itemEntity);
                    }
                }
                super.onRemove(state, level, pos, newState, movedByPiston);
                level.updateNeighbourForOutputSignal(pos, (Block)this);
            } else {
                super.onRemove(state, level, pos, newState, movedByPiston);
            }
        }
    }

    private static final App CODEC$lambda$0(RecordCodecBuilder.Instance it) {
        return it.group((App)BaseEntityBlock.propertiesCodec(), (App)Codec.BOOL.fieldOf("isSoul").forGetter(arg_0 -> CampfireBlock.CODEC$lambda$0$0((KProperty1)Companion.CODEC.1.1.INSTANCE, arg_0))).apply((Applicative)it, CampfireBlock::new);
    }

    private static final Boolean CODEC$lambda$0$0(KProperty1 $tmp0, CampfireBlock p0) {
        return (Boolean)((Function1)$tmp0).invoke((Object)p0);
    }

    static {
        MapCodec mapCodec = RecordCodecBuilder.mapCodec(CampfireBlock::CODEC$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)mapCodec, (String)"mapCodec(...)");
        CODEC = mapCodec;
        ITEM_DIRECTION = DirectionProperty.create((String)"item_facing");
        POWERED = BlockStateProperties.POWERED;
        COOKING = BooleanProperty.create((String)"cooking");
        LID = BooleanProperty.create((String)"lid");
        campfireAABB = Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.4375, (double)1.0);
        VoxelShape[] voxelShapeArray = new VoxelShape[]{Shapes.box((double)0.1875, (double)0.5, (double)0.125, (double)0.875, (double)0.8125, (double)0.1875), Shapes.box((double)0.125, (double)0.4375, (double)0.125, (double)0.875, (double)0.5, (double)0.875), Shapes.box((double)0.8125, (double)0.5, (double)0.1875, (double)0.875, (double)0.8125, (double)0.875), Shapes.box((double)0.125, (double)0.5, (double)0.125, (double)0.1875, (double)0.8125, (double)0.8125), Shapes.box((double)0.125, (double)0.5, (double)0.8125, (double)0.8125, (double)0.8125, (double)0.875)};
        AABB = Shapes.or((VoxelShape)campfireAABB, (VoxelShape[])voxelShapeArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001d\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0007\u001a\u0004\b\b\u0010\tR\u001f\u0010\f\u001a\n \u000b*\u0004\u0018\u00010\n0\n8\u0006\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000fR\u001f\u0010\u0011\u001a\n \u000b*\u0004\u0018\u00010\u00100\u00108\u0006\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014R\u001f\u0010\u0015\u001a\n \u000b*\u0004\u0018\u00010\u00100\u00108\u0006\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0012\u001a\u0004\b\u0016\u0010\u0014R\u001f\u0010\u0017\u001a\n \u000b*\u0004\u0018\u00010\u00100\u00108\u0006\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0012\u001a\u0004\b\u0018\u0010\u0014R\u001c\u0010\u001a\u001a\n \u000b*\u0004\u0018\u00010\u00190\u00198\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001bR\u001c\u0010\u001c\u001a\n \u000b*\u0004\u0018\u00010\u00190\u00198\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001b\u00a8\u0006\u001d"}, d2={"Lcom/cobblemon/mod/common/block/campfirepot/CampfireBlock$Companion;", "", "<init>", "()V", "Lcom/mojang/serialization/MapCodec;", "Lcom/cobblemon/mod/common/block/campfirepot/CampfireBlock;", "CODEC", "Lcom/mojang/serialization/MapCodec;", "getCODEC", "()Lcom/mojang/serialization/MapCodec;", "Lnet/minecraft/world/level/block/state/properties/DirectionProperty;", "kotlin.jvm.PlatformType", "ITEM_DIRECTION", "Lnet/minecraft/world/level/block/state/properties/DirectionProperty;", "getITEM_DIRECTION", "()Lnet/minecraft/world/level/block/state/properties/DirectionProperty;", "Lnet/minecraft/world/level/block/state/properties/BooleanProperty;", "POWERED", "Lnet/minecraft/world/level/block/state/properties/BooleanProperty;", "getPOWERED", "()Lnet/minecraft/world/level/block/state/properties/BooleanProperty;", "COOKING", "getCOOKING", "LID", "getLID", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "campfireAABB", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "AABB", "common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MapCodec<CampfireBlock> getCODEC() {
            return CODEC;
        }

        public final DirectionProperty getITEM_DIRECTION() {
            return ITEM_DIRECTION;
        }

        public final BooleanProperty getPOWERED() {
            return POWERED;
        }

        public final BooleanProperty getCOOKING() {
            return COOKING;
        }

        public final BooleanProperty getLID() {
            return LID;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

