/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.block.campfirepot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 *2\u00020\u00012\u00020\u0002:\u0001*B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J/\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\rH\u0014\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0019\u0010\u0014\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0016H\u0014\u00a2\u0006\u0004\b\u0017\u0010\u0018J?\u0010\u001e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u001c2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u000bH\u0014\u00a2\u0006\u0004\b\u001e\u0010\u001fJ#\u0010$\u001a\u00020#2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\u00070 H\u0014\u00a2\u0006\u0004\b$\u0010%J\u0019\u0010(\u001a\u0004\u0018\u00010'2\u0006\u0010&\u001a\u00020\u0007H\u0014\u00a2\u0006\u0004\b(\u0010)\u00a8\u0006+"}, d2={"Lcom/cobblemon/mod/common/block/campfirepot/CampfirePotBlock;", "Lnet/minecraft/world/level/block/HorizontalDirectionalBlock;", "Lnet/minecraft/world/level/block/SimpleWaterloggedBlock;", "Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;", "settings", "<init>", "(Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;)V", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "Lnet/minecraft/world/level/BlockGetter;", "world", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/world/phys/shapes/CollisionContext;", "context", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "getShape", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/phys/shapes/CollisionContext;)Lnet/minecraft/world/phys/shapes/VoxelShape;", "Lnet/minecraft/world/item/context/BlockPlaceContext;", "ctx", "getStateForPlacement", "(Lnet/minecraft/world/item/context/BlockPlaceContext;)Lnet/minecraft/world/level/block/state/BlockState;", "Lcom/mojang/serialization/MapCodec;", "codec", "()Lcom/mojang/serialization/MapCodec;", "Lnet/minecraft/core/Direction;", "direction", "neighborState", "Lnet/minecraft/world/level/LevelAccessor;", "neighborPos", "updateShape", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/core/Direction;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/LevelAccessor;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/block/state/BlockState;", "Lnet/minecraft/world/level/block/state/StateDefinition$Builder;", "Lnet/minecraft/world/level/block/Block;", "builder", "", "createBlockStateDefinition", "(Lnet/minecraft/world/level/block/state/StateDefinition$Builder;)V", "blockState", "Lnet/minecraft/world/level/material/FluidState;", "getFluidState", "(Lnet/minecraft/world/level/block/state/BlockState;)Lnet/minecraft/world/level/material/FluidState;", "Companion", "common"})
@SourceDebugExtension(value={"SMAP\nCampfirePotBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CampfirePotBlock.kt\ncom/cobblemon/mod/common/block/campfirepot/CampfirePotBlock\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,127:1\n13805#2,2:128\n*S KotlinDebug\n*F\n+ 1 CampfirePotBlock.kt\ncom/cobblemon/mod/common/block/campfirepot/CampfirePotBlock\n*L\n97#1:128,2\n*E\n"})
public final class CampfirePotBlock
extends HorizontalDirectionalBlock
implements SimpleWaterloggedBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final MapCodec<CampfirePotBlock> CODEC;
    private static final BooleanProperty OPEN;
    private static final BooleanProperty OCCUPIED;
    private static final VoxelShape AABB_NS;
    private static final VoxelShape AABB_WE;
    private static final VoxelShape AABB_NS_OPEN;
    private static final VoxelShape AABB_WE_OPEN;

    public CampfirePotBlock(@NotNull BlockBehaviour.Properties settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)Direction.NORTH)).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false))).setValue((Property)OCCUPIED, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    protected VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        VoxelShape voxelShape;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Direction direction = (Direction)state.getValue((Property)HorizontalDirectionalBlock.FACING);
        Boolean open = (Boolean)state.getValue((Property)OPEN);
        if (open.booleanValue()) {
            VoxelShape voxelShape2 = direction == Direction.NORTH || direction == Direction.SOUTH ? AABB_NS_OPEN : AABB_WE_OPEN;
            Intrinsics.checkNotNull((Object)voxelShape2);
            voxelShape = voxelShape2;
        } else if (direction == Direction.NORTH || direction == Direction.SOUTH) {
            VoxelShape voxelShape3 = AABB_NS;
            voxelShape = voxelShape3;
            Intrinsics.checkNotNullExpressionValue((Object)voxelShape3, (String)"AABB_NS");
        } else {
            VoxelShape voxelShape4 = AABB_WE;
            voxelShape = voxelShape4;
            Intrinsics.checkNotNullExpressionValue((Object)voxelShape4, (String)"AABB_WE");
        }
        return voxelShape;
    }

    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Object blockState = null;
        blockState = this.defaultBlockState().setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(Intrinsics.areEqual((Object)ctx.getLevel().getFluidState(ctx.getClickedPos()).getType(), (Object)Fluids.WATER)));
        Level worldView = ctx.getLevel();
        BlockPos blockPos = ctx.getClickedPos();
        Direction[] directionArray = ctx.getNearestLookingDirections();
        Intrinsics.checkNotNullExpressionValue((Object)directionArray, (String)"getNearestLookingDirections(...)");
        Object[] $this$forEach$iv = directionArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Direction direction = (Direction)element$iv;
            boolean bl = false;
            if (!direction.getAxis().isHorizontal()) continue;
            Object object = ((BlockState)blockState).setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)direction.getOpposite());
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type net.minecraft.world.level.block.state.BlockState");
            blockState = (BlockState)object;
            if (!blockState.canSurvive((LevelReader)worldView, blockPos)) continue;
            return blockState;
        }
        return null;
    }

    @NotNull
    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    @NotNull
    protected BlockState updateShape(@NotNull BlockState state, @NotNull Direction direction, @NotNull BlockState neighborState, @NotNull LevelAccessor world, @NotNull BlockPos pos, @NotNull BlockPos neighborPos) {
        BlockState blockState;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        Intrinsics.checkNotNullParameter((Object)neighborState, (String)"neighborState");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)neighborPos, (String)"neighborPos");
        if (((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            world.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        if (direction == state.getValue((Property)HorizontalDirectionalBlock.FACING) && !state.canSurvive((LevelReader)world, pos)) {
            BlockState blockState2 = Blocks.AIR.defaultBlockState();
            blockState = blockState2;
            Intrinsics.checkNotNullExpressionValue((Object)blockState2, (String)"defaultBlockState(...)");
        } else {
            BlockState blockState3 = super.updateShape(state, direction, neighborState, world, pos, neighborPos);
            blockState = blockState3;
            Intrinsics.checkNotNullExpressionValue((Object)blockState3, (String)"updateShape(...)");
        }
        return blockState;
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        Property[] propertyArray = new Property[]{HorizontalDirectionalBlock.FACING, OPEN, OCCUPIED, BlockStateProperties.WATERLOGGED};
        builder.add(propertyArray);
    }

    @Nullable
    protected FluidState getFluidState(@NotNull BlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        return (Boolean)blockState.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(blockState);
    }

    private static final App CODEC$lambda$0(RecordCodecBuilder.Instance it) {
        return it.group((App)HorizontalDirectionalBlock.propertiesCodec()).apply((Applicative)it, CampfirePotBlock::new);
    }

    static {
        MapCodec mapCodec = RecordCodecBuilder.mapCodec(CampfirePotBlock::CODEC$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)mapCodec, (String)"mapCodec(...)");
        CODEC = mapCodec;
        OPEN = BlockStateProperties.OPEN;
        OCCUPIED = BlockStateProperties.OCCUPIED;
        VoxelShape[] voxelShapeArray = new VoxelShape[]{Shapes.box((double)0.0, (double)0.3125, (double)0.375, (double)0.125, (double)0.375, (double)0.625), Shapes.box((double)0.875, (double)0.3125, (double)0.375, (double)1.0, (double)0.375, (double)0.625), Shapes.box((double)0.4375, (double)0.375, (double)0.4375, (double)0.5625, (double)0.4375, (double)0.5625)};
        AABB_NS = Shapes.or((VoxelShape)Shapes.box((double)0.125, (double)0.0, (double)0.125, (double)0.875, (double)0.375, (double)0.875), (VoxelShape[])voxelShapeArray);
        voxelShapeArray = new VoxelShape[]{Shapes.box((double)0.375, (double)0.3125, (double)0.0, (double)0.625, (double)0.375, (double)0.125), Shapes.box((double)0.375, (double)0.3125, (double)0.875, (double)0.625, (double)0.375, (double)1.0), Shapes.box((double)0.4375, (double)0.375, (double)0.4375, (double)0.5625, (double)0.4375, (double)0.5625)};
        AABB_WE = Shapes.or((VoxelShape)Shapes.box((double)0.125, (double)0.0, (double)0.125, (double)0.875, (double)0.375, (double)0.875), (VoxelShape[])voxelShapeArray);
        voxelShapeArray = new VoxelShape[]{Shapes.box((double)0.125, (double)0.0, (double)0.125, (double)0.875, (double)0.0625, (double)0.875), Shapes.box((double)0.8125, (double)0.0625, (double)0.1875, (double)0.875, (double)0.375, (double)0.875), Shapes.box((double)0.125, (double)0.0625, (double)0.125, (double)0.1875, (double)0.375, (double)0.8125), Shapes.box((double)0.125, (double)0.0625, (double)0.8125, (double)0.8125, (double)0.375, (double)0.875), Shapes.box((double)0.0, (double)0.3125, (double)0.375, (double)0.125, (double)0.375, (double)0.625), Shapes.box((double)0.875, (double)0.3125, (double)0.375, (double)1.0, (double)0.375, (double)0.625)};
        AABB_NS_OPEN = Shapes.or((VoxelShape)Shapes.box((double)0.1875, (double)0.0625, (double)0.125, (double)0.875, (double)0.375, (double)0.1875), (VoxelShape[])voxelShapeArray);
        voxelShapeArray = new VoxelShape[]{Shapes.box((double)0.125, (double)0.0, (double)0.125, (double)0.875, (double)0.0625, (double)0.875), Shapes.box((double)0.8125, (double)0.0625, (double)0.1875, (double)0.875, (double)0.375, (double)0.875), Shapes.box((double)0.125, (double)0.0625, (double)0.125, (double)0.1875, (double)0.375, (double)0.8125), Shapes.box((double)0.125, (double)0.0625, (double)0.8125, (double)0.8125, (double)0.375, (double)0.875), Shapes.box((double)0.375, (double)0.3125, (double)0.0, (double)0.625, (double)0.375, (double)0.125), Shapes.box((double)0.375, (double)0.3125, (double)0.875, (double)0.625, (double)0.375, (double)1.0)};
        AABB_WE_OPEN = Shapes.or((VoxelShape)Shapes.box((double)0.1875, (double)0.0625, (double)0.125, (double)0.875, (double)0.375, (double)0.1875), (VoxelShape[])voxelShapeArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001d\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0007\u001a\u0004\b\b\u0010\tR\u001f\u0010\f\u001a\n \u000b*\u0004\u0018\u00010\n0\n8\u0006\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000fR\u001f\u0010\u0010\u001a\n \u000b*\u0004\u0018\u00010\n0\n8\u0006\u00a2\u0006\f\n\u0004\b\u0010\u0010\r\u001a\u0004\b\u0011\u0010\u000fR\u001c\u0010\u0013\u001a\n \u000b*\u0004\u0018\u00010\u00120\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\n \u000b*\u0004\u0018\u00010\u00120\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0014R\u001c\u0010\u0016\u001a\n \u000b*\u0004\u0018\u00010\u00120\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0014R\u001c\u0010\u0017\u001a\n \u000b*\u0004\u0018\u00010\u00120\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0014\u00a8\u0006\u0018"}, d2={"Lcom/cobblemon/mod/common/block/campfirepot/CampfirePotBlock$Companion;", "", "<init>", "()V", "Lcom/mojang/serialization/MapCodec;", "Lcom/cobblemon/mod/common/block/campfirepot/CampfirePotBlock;", "CODEC", "Lcom/mojang/serialization/MapCodec;", "getCODEC", "()Lcom/mojang/serialization/MapCodec;", "Lnet/minecraft/world/level/block/state/properties/BooleanProperty;", "kotlin.jvm.PlatformType", "OPEN", "Lnet/minecraft/world/level/block/state/properties/BooleanProperty;", "getOPEN", "()Lnet/minecraft/world/level/block/state/properties/BooleanProperty;", "OCCUPIED", "getOCCUPIED", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "AABB_NS", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "AABB_WE", "AABB_NS_OPEN", "AABB_WE_OPEN", "common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MapCodec<CampfirePotBlock> getCODEC() {
            return CODEC;
        }

        public final BooleanProperty getOPEN() {
            return OPEN;
        }

        public final BooleanProperty getOCCUPIED() {
            return OCCUPIED;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

