/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.block.chest;

import com.cobblemon.mod.common.CobblemonSounds;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.api.scheduling.SchedulingFunctionsKt;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.block.chest.GildedChestBlock;
import com.cobblemon.mod.common.block.entity.GildedChestBlockEntity;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.util.BlockPosExtensionsKt;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KProperty1;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00fe\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 j2\u00020\u00012\u00020\u0002:\u0002jkB\u0019\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001f\u0010\u000e\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ/\u0010\u0015\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0012H\u0014\u00a2\u0006\u0004\b\u0015\u0010\u0016J?\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u001a2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\tH\u0014\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0017\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\f\u001a\u00020\u000bH\u0014\u00a2\u0006\u0004\b\u001f\u0010 J#\u0010%\u001a\u00020$2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u000b0!H\u0014\u00a2\u0006\u0004\b%\u0010&J\u000f\u0010(\u001a\u00020'H\u0016\u00a2\u0006\u0004\b(\u0010)J\r\u0010+\u001a\u00020*\u00a2\u0006\u0004\b+\u0010,J/\u00100\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020-2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010/\u001a\u00020.H\u0016\u00a2\u0006\u0004\b0\u00101J/\u00104\u001a\u0002032\u0006\u0010\u0011\u001a\u00020-2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010/\u001a\u000202H\u0002\u00a2\u0006\u0004\b4\u00105J7\u00108\u001a\u0002032\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020-2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010/\u001a\u00020.2\u0006\u00107\u001a\u000206H\u0014\u00a2\u0006\u0004\b8\u00109J7\u0010<\u001a\u00020$2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020-2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010:\u001a\u00020\u000b2\u0006\u0010;\u001a\u00020*H\u0014\u00a2\u0006\u0004\b<\u0010=J\u0017\u0010?\u001a\u00020>2\u0006\u0010\f\u001a\u00020\u000bH\u0014\u00a2\u0006\u0004\b?\u0010@J\u0017\u0010C\u001a\u00020\u000b2\u0006\u0010B\u001a\u00020AH\u0016\u00a2\u0006\u0004\bC\u0010DJ\u001f\u0010G\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010F\u001a\u00020EH\u0015\u00a2\u0006\u0004\bG\u0010HJ\u0017\u0010I\u001a\u00020*2\u0006\u0010\f\u001a\u00020\u000bH\u0014\u00a2\u0006\u0004\bI\u0010JJ'\u0010L\u001a\u00020K2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020-2\u0006\u0010\n\u001a\u00020\tH\u0014\u00a2\u0006\u0004\bL\u0010MJ\u001f\u0010O\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010O\u001a\u00020NH\u0014\u00a2\u0006\u0004\bO\u0010PJ\u001f\u0010R\u001a\u00020*2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020QH\u0015\u00a2\u0006\u0004\bR\u0010SJ\u0017\u0010U\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010TH\u0014\u00a2\u0006\u0004\bU\u0010VJ9\u0010[\u001a\u00020$2\u0006\u0010\u0011\u001a\u00020-2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b2\b\u0010X\u001a\u0004\u0018\u00010W2\u0006\u0010Z\u001a\u00020YH\u0016\u00a2\u0006\u0004\b[\u0010\\J/\u0010`\u001a\u00020$2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020]2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010_\u001a\u00020^H\u0014\u00a2\u0006\u0004\b`\u0010aR\u0017\u0010\u0006\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010b\u001a\u0004\bc\u0010dR0\u0010h\u001a\u001e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020f0ej\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020f`g8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bh\u0010i\u00a8\u0006l"}, d2={"Lcom/cobblemon/mod/common/block/chest/GildedChestBlock;", "Lnet/minecraft/world/level/block/BaseEntityBlock;", "Lnet/minecraft/world/level/block/SimpleWaterloggedBlock;", "Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;", "settings", "Lcom/cobblemon/mod/common/block/chest/GildedChestBlock$Type;", "type", "<init>", "(Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;Lcom/cobblemon/mod/common/block/chest/GildedChestBlock$Type;)V", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "Lcom/cobblemon/mod/common/block/entity/GildedChestBlockEntity;", "newBlockEntity", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)Lcom/cobblemon/mod/common/block/entity/GildedChestBlockEntity;", "Lnet/minecraft/world/level/BlockGetter;", "world", "Lnet/minecraft/world/phys/shapes/CollisionContext;", "context", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "getShape", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/phys/shapes/CollisionContext;)Lnet/minecraft/world/phys/shapes/VoxelShape;", "Lnet/minecraft/core/Direction;", "direction", "neighborState", "Lnet/minecraft/world/level/LevelAccessor;", "neighborPos", "updateShape", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/core/Direction;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/LevelAccessor;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/block/state/BlockState;", "Lnet/minecraft/world/level/material/FluidState;", "getFluidState", "(Lnet/minecraft/world/level/block/state/BlockState;)Lnet/minecraft/world/level/material/FluidState;", "Lnet/minecraft/world/level/block/state/StateDefinition$Builder;", "Lnet/minecraft/world/level/block/Block;", "builder", "", "createBlockStateDefinition", "(Lnet/minecraft/world/level/block/state/StateDefinition$Builder;)V", "Lnet/minecraft/network/chat/MutableComponent;", "getName", "()Lnet/minecraft/network/chat/MutableComponent;", "", "isFake", "()Z", "Lnet/minecraft/world/level/Level;", "Lnet/minecraft/world/entity/player/Player;", "player", "playerWillDestroy", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/entity/player/Player;)Lnet/minecraft/world/level/block/state/BlockState;", "Lnet/minecraft/server/level/ServerPlayer;", "Lnet/minecraft/world/InteractionResult;", "spawnPokemon", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/server/level/ServerPlayer;)Lnet/minecraft/world/InteractionResult;", "Lnet/minecraft/world/phys/BlockHitResult;", "hit", "useWithoutItem", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/phys/BlockHitResult;)Lnet/minecraft/world/InteractionResult;", "newState", "moved", "onRemove", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Z)V", "Lnet/minecraft/world/level/block/RenderShape;", "getRenderShape", "(Lnet/minecraft/world/level/block/state/BlockState;)Lnet/minecraft/world/level/block/RenderShape;", "Lnet/minecraft/world/item/context/BlockPlaceContext;", "blockPlaceContext", "getStateForPlacement", "(Lnet/minecraft/world/item/context/BlockPlaceContext;)Lnet/minecraft/world/level/block/state/BlockState;", "Lnet/minecraft/world/level/block/Rotation;", "rotation", "rotate", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/block/Rotation;)Lnet/minecraft/world/level/block/state/BlockState;", "hasAnalogOutputSignal", "(Lnet/minecraft/world/level/block/state/BlockState;)Z", "", "getAnalogOutputSignal", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)I", "Lnet/minecraft/world/level/block/Mirror;", "mirror", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/block/Mirror;)Lnet/minecraft/world/level/block/state/BlockState;", "Lnet/minecraft/world/level/pathfinder/PathComputationType;", "isPathfindable", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/pathfinder/PathComputationType;)Z", "Lcom/mojang/serialization/MapCodec;", "codec", "()Lcom/mojang/serialization/MapCodec;", "Lnet/minecraft/world/entity/LivingEntity;", "placer", "Lnet/minecraft/world/item/ItemStack;", "itemStack", "setPlacedBy", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/item/ItemStack;)V", "Lnet/minecraft/server/level/ServerLevel;", "Lnet/minecraft/util/RandomSource;", "random", "tick", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;Lnet/minecraft/util/RandomSource;)V", "Lcom/cobblemon/mod/common/block/chest/GildedChestBlock$Type;", "getType", "()Lcom/cobblemon/mod/common/block/chest/GildedChestBlock$Type;", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "facingToYaw", "Ljava/util/HashMap;", "Companion", "Type", "common"})
public final class GildedChestBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Type type;
    @NotNull
    private final HashMap<Direction, Float> facingToYaw;
    @NotNull
    private static final MapCodec<GildedChestBlock> CODEC;
    @NotNull
    private static final String POKEMON_ARGS;
    @NotNull
    private static final IntRange LEVEL_RANGE;
    private static final VoxelShape SOUTH_OUTLINE;
    private static final VoxelShape NORTH_OUTLINE;
    private static final VoxelShape WEST_OUTLINE;
    private static final VoxelShape EAST_OUTLINE;

    public GildedChestBlock(@NotNull BlockBehaviour.Properties settings, @NotNull Type type) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        super(settings);
        this.type = type;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)Direction.NORTH, (Object)Float.valueOf(-179.0f)), TuplesKt.to((Object)Direction.WEST, (Object)Float.valueOf(90.0f)), TuplesKt.to((Object)Direction.SOUTH, (Object)Float.valueOf(0.0f)), TuplesKt.to((Object)Direction.EAST, (Object)Float.valueOf(-90.0f))};
        this.facingToYaw = MapsKt.hashMapOf((Pair[])pairArray);
    }

    public /* synthetic */ GildedChestBlock(BlockBehaviour.Properties properties, Type type, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            type = Type.RED;
        }
        this(properties, type);
    }

    @NotNull
    public final Type getType() {
        return this.type;
    }

    @NotNull
    public GildedChestBlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return new GildedChestBlockEntity(pos, state, this.type);
    }

    @NotNull
    protected VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        VoxelShape voxelShape;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Direction direction = (Direction)state.getValue((Property)HorizontalDirectionalBlock.FACING);
        switch (direction == null ? -1 : WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
            case 1: {
                VoxelShape voxelShape2 = NORTH_OUTLINE;
                voxelShape = voxelShape2;
                Intrinsics.checkNotNullExpressionValue((Object)voxelShape2, (String)"NORTH_OUTLINE");
                break;
            }
            case 2: {
                VoxelShape voxelShape3 = SOUTH_OUTLINE;
                voxelShape = voxelShape3;
                Intrinsics.checkNotNullExpressionValue((Object)voxelShape3, (String)"SOUTH_OUTLINE");
                break;
            }
            case 3: {
                VoxelShape voxelShape4 = WEST_OUTLINE;
                voxelShape = voxelShape4;
                Intrinsics.checkNotNullExpressionValue((Object)voxelShape4, (String)"WEST_OUTLINE");
                break;
            }
            default: {
                VoxelShape voxelShape5 = EAST_OUTLINE;
                voxelShape = voxelShape5;
                Intrinsics.checkNotNullExpressionValue((Object)voxelShape5, (String)"EAST_OUTLINE");
            }
        }
        return voxelShape;
    }

    @NotNull
    protected BlockState updateShape(@NotNull BlockState state, @NotNull Direction direction, @NotNull BlockState neighborState, @NotNull LevelAccessor world, @NotNull BlockPos pos, @NotNull BlockPos neighborPos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        Intrinsics.checkNotNullParameter((Object)neighborState, (String)"neighborState");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)neighborPos, (String)"neighborPos");
        if (((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            world.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        BlockState blockState = super.updateShape(state, direction, neighborState, world, pos, neighborPos);
        Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"updateShape(...)");
        return blockState;
    }

    @NotNull
    protected FluidState getFluidState(@NotNull BlockState state) {
        FluidState fluidState;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            FluidState fluidState2 = Fluids.WATER.getSource(false);
            Intrinsics.checkNotNull((Object)fluidState2);
            fluidState = fluidState2;
        } else {
            FluidState fluidState3 = super.getFluidState(state);
            fluidState = fluidState3;
            Intrinsics.checkNotNullExpressionValue((Object)fluidState3, (String)"getFluidState(...)");
        }
        return fluidState;
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        super.createBlockStateDefinition(builder);
        Property[] propertyArray = new Property[]{BlockStateProperties.HORIZONTAL_FACING};
        builder.add(propertyArray);
        propertyArray = new Property[]{BlockStateProperties.WATERLOGGED};
        builder.add(propertyArray);
    }

    @NotNull
    public MutableComponent getName() {
        MutableComponent mutableComponent;
        if (this.isFake()) {
            MutableComponent mutableComponent2 = Component.translatable((String)"block.cobblemon.gilded_chest");
            mutableComponent = mutableComponent2;
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent2, (String)"translatable(...)");
        } else {
            MutableComponent mutableComponent3 = super.getName();
            mutableComponent = mutableComponent3;
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent3, (String)"getName(...)");
        }
        return mutableComponent;
    }

    public final boolean isFake() {
        return this.type == Type.FAKE;
    }

    @NotNull
    public BlockState playerWillDestroy(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (!world.isClientSide && this.isFake() && player instanceof ServerPlayer) {
            this.spawnPokemon(world, pos, state, (ServerPlayer)player);
        }
        BlockState blockState = super.playerWillDestroy(world, pos, state, player);
        Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"playerWillDestroy(...)");
        return blockState;
    }

    private final InteractionResult spawnPokemon(Level world, BlockPos pos, BlockState state, ServerPlayer player) {
        String properties = POKEMON_ARGS + " lvl=" + RangesKt.random((IntRange)LEVEL_RANGE, (Random)((Random)Random.Default));
        PokemonProperties pokemon = PokemonProperties.Companion.parse$default(PokemonProperties.Companion, properties, null, null, 6, null);
        PokemonEntity entity = PokemonProperties.createEntity$default(pokemon, world, null, 2, null);
        Float f = this.facingToYaw.get(state.getValue((Property)HorizontalDirectionalBlock.FACING));
        float yaw = f != null ? f.floatValue() : 0.0f;
        entity.getEntityData().set(PokemonEntity.Companion.getSPAWN_DIRECTION(), (Object)Float.valueOf(yaw));
        Direction offsetDir = (Direction)state.getValue((Property)HorizontalDirectionalBlock.FACING);
        Vec3 vec = BlockPosExtensionsKt.toVec3d(pos).add((double)offsetDir.getStepX() * 0.1 + 0.5, 0.0, (double)offsetDir.getStepZ() * 0.1 + 0.5);
        entity.moveTo(vec.x, vec.y, vec.z, yaw, entity.getXRot());
        world.addFreshEntity((Entity)entity);
        world.removeBlock(pos, false);
        SchedulingFunctionsKt.afterOnServer(0.1f, (Function0<Unit>)((Function0)() -> GildedChestBlock.spawnPokemon$lambda$0(player, entity, world, pos)));
        return InteractionResult.SUCCESS;
    }

    @NotNull
    protected InteractionResult useWithoutItem(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hit) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hit, (String)"hit");
        if (this.isFake()) {
            if (player instanceof ServerPlayer) {
                return this.spawnPokemon(world, pos, state, (ServerPlayer)player);
            }
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = world.getBlockEntity(pos);
        GildedChestBlockEntity gildedChestBlockEntity = blockEntity instanceof GildedChestBlockEntity ? (GildedChestBlockEntity)blockEntity : null;
        if (gildedChestBlockEntity == null) {
            return InteractionResult.FAIL;
        }
        GildedChestBlockEntity entity = gildedChestBlockEntity;
        if (world.getBlockState(pos.above()).isSolidRender((BlockGetter)world, pos.above())) {
            return InteractionResult.FAIL;
        }
        player.openMenu((MenuProvider)entity);
        if (!player.level().isClientSide) {
            PiglinAi.angerNearbyPiglins((Player)player, (boolean)true);
        }
        return InteractionResult.SUCCESS;
    }

    protected void onRemove(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState newState, boolean moved) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
        if (!this.isFake()) {
            Containers.dropContentsOnDestroy((BlockState)state, (BlockState)newState, (Level)world, (BlockPos)pos);
        }
        super.onRemove(state, world, pos, newState, moved);
    }

    @NotNull
    protected RenderShape getRenderShape(@NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @NotNull
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext blockPlaceContext) {
        Intrinsics.checkNotNullParameter((Object)blockPlaceContext, (String)"blockPlaceContext");
        Object object = ((BlockState)this.defaultBlockState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)blockPlaceContext.getHorizontalDirection().getOpposite())).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(Intrinsics.areEqual((Object)blockPlaceContext.getLevel().getFluidState(blockPlaceContext.getClickedPos()).getType(), (Object)Fluids.WATER)));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"setValue(...)");
        return (BlockState)object;
    }

    @Deprecated(message="Deprecated in Java")
    @NotNull
    protected BlockState rotate(@NotNull BlockState state, @NotNull Rotation rotation) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)rotation, (String)"rotation");
        Property property = (Property)BlockStateProperties.HORIZONTAL_FACING;
        Comparable comparable = state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        Intrinsics.checkNotNull((Object)comparable, (String)"null cannot be cast to non-null type net.minecraft.core.Direction");
        Object object = state.setValue(property, (Comparable)rotation.rotate((Direction)comparable));
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type net.minecraft.world.level.block.state.BlockState");
        return (BlockState)object;
    }

    protected boolean hasAnalogOutputSignal(@NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return true;
    }

    protected int getAnalogOutputSignal(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return AbstractContainerMenu.getRedstoneSignalFromBlockEntity((BlockEntity)world.getBlockEntity(pos));
    }

    @NotNull
    protected BlockState mirror(@NotNull BlockState state, @NotNull Mirror mirror) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)mirror, (String)"mirror");
        Comparable comparable = state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        Intrinsics.checkNotNull((Object)comparable, (String)"null cannot be cast to non-null type net.minecraft.core.Direction");
        BlockState blockState = state.rotate(mirror.getRotation((Direction)comparable));
        Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"rotate(...)");
        return blockState;
    }

    @Deprecated(message="Deprecated in Java")
    protected boolean isPathfindable(@NotNull BlockState state, @NotNull PathComputationType type) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return false;
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public void setPlacedBy(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity placer, @NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
    }

    protected void tick(@NotNull BlockState state, @NotNull ServerLevel world, @NotNull BlockPos pos, @NotNull RandomSource random) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        BlockEntity blockEntity = world.getBlockEntity(pos);
        GildedChestBlockEntity gildedChestBlockEntity = blockEntity instanceof GildedChestBlockEntity ? (GildedChestBlockEntity)blockEntity : null;
        if (gildedChestBlockEntity == null) {
            return;
        }
        GildedChestBlockEntity blockEntity2 = gildedChestBlockEntity;
        blockEntity2.tick();
    }

    private static final Unit spawnPokemon$lambda$0(ServerPlayer $player, PokemonEntity $entity, Level $world, BlockPos $pos) {
        List list = $player.level().players();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"players(...)");
        if (!CollectionsKt.contains((Iterable)list, (Object)$player)) {
            return Unit.INSTANCE;
        }
        PlayerPartyStore party = PlayerExtensionsKt.party($player);
        if (!$player.isCreative()) {
            $entity.forceBattle($player);
        } else {
            $world.playSound(null, $pos, CobblemonSounds.GIMMIGHOUL_REVEAL, SoundSource.NEUTRAL);
        }
        return Unit.INSTANCE;
    }

    private static final App CODEC$lambda$0(RecordCodecBuilder.Instance it) {
        return it.group((App)BaseEntityBlock.propertiesCodec(), (App)Type.Companion.getCODEC().fieldOf("chestType").forGetter(arg_0 -> GildedChestBlock.CODEC$lambda$0$0((KProperty1)Companion.CODEC.1.1.INSTANCE, arg_0))).apply((Applicative)it, GildedChestBlock::new);
    }

    private static final Type CODEC$lambda$0$0(KProperty1 $tmp0, GildedChestBlock p0) {
        return (Type)((Object)((Function1)$tmp0).invoke((Object)p0));
    }

    static {
        MapCodec mapCodec = RecordCodecBuilder.mapCodec(GildedChestBlock::CODEC$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)mapCodec, (String)"mapCodec(...)");
        CODEC = mapCodec;
        POKEMON_ARGS = "gimmighoul";
        LEVEL_RANGE = new IntRange(5, 30);
        SOUTH_OUTLINE = Shapes.or((VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.25, (double)1.0, (double)1.0, (double)0.9375), (VoxelShape[])new VoxelShape[0]);
        NORTH_OUTLINE = Shapes.or((VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.0625, (double)1.0, (double)1.0, (double)0.75), (VoxelShape[])new VoxelShape[0]);
        WEST_OUTLINE = Shapes.or((VoxelShape)Shapes.box((double)0.0625, (double)0.0, (double)0.0, (double)0.75, (double)1.0, (double)1.0), (VoxelShape[])new VoxelShape[0]);
        EAST_OUTLINE = Shapes.or((VoxelShape)Shapes.box((double)0.25, (double)0.0, (double)0.0, (double)0.9375, (double)1.0, (double)1.0), (VoxelShape[])new VoxelShape[0]);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001d\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0007\u001a\u0004\b\b\u0010\tR\u001a\u0010\u000b\u001a\u00020\n8\u0006X\u0086D\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0010\u001a\u00020\u000f8\u0006\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013R\u001f\u0010\u0016\u001a\n \u0015*\u0004\u0018\u00010\u00140\u00148\u0006\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019R\u001f\u0010\u001a\u001a\n \u0015*\u0004\u0018\u00010\u00140\u00148\u0006\u00a2\u0006\f\n\u0004\b\u001a\u0010\u0017\u001a\u0004\b\u001b\u0010\u0019R\u001f\u0010\u001c\u001a\n \u0015*\u0004\u0018\u00010\u00140\u00148\u0006\u00a2\u0006\f\n\u0004\b\u001c\u0010\u0017\u001a\u0004\b\u001d\u0010\u0019R\u001f\u0010\u001e\u001a\n \u0015*\u0004\u0018\u00010\u00140\u00148\u0006\u00a2\u0006\f\n\u0004\b\u001e\u0010\u0017\u001a\u0004\b\u001f\u0010\u0019\u00a8\u0006 "}, d2={"Lcom/cobblemon/mod/common/block/chest/GildedChestBlock$Companion;", "", "<init>", "()V", "Lcom/mojang/serialization/MapCodec;", "Lcom/cobblemon/mod/common/block/chest/GildedChestBlock;", "CODEC", "Lcom/mojang/serialization/MapCodec;", "getCODEC", "()Lcom/mojang/serialization/MapCodec;", "", "POKEMON_ARGS", "Ljava/lang/String;", "getPOKEMON_ARGS", "()Ljava/lang/String;", "Lkotlin/ranges/IntRange;", "LEVEL_RANGE", "Lkotlin/ranges/IntRange;", "getLEVEL_RANGE", "()Lkotlin/ranges/IntRange;", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "kotlin.jvm.PlatformType", "SOUTH_OUTLINE", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "getSOUTH_OUTLINE", "()Lnet/minecraft/world/phys/shapes/VoxelShape;", "NORTH_OUTLINE", "getNORTH_OUTLINE", "WEST_OUTLINE", "getWEST_OUTLINE", "EAST_OUTLINE", "getEAST_OUTLINE", "common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MapCodec<GildedChestBlock> getCODEC() {
            return CODEC;
        }

        @NotNull
        public final String getPOKEMON_ARGS() {
            return POKEMON_ARGS;
        }

        @NotNull
        public final IntRange getLEVEL_RANGE() {
            return LEVEL_RANGE;
        }

        public final VoxelShape getSOUTH_OUTLINE() {
            return SOUTH_OUTLINE;
        }

        public final VoxelShape getNORTH_OUTLINE() {
            return NORTH_OUTLINE;
        }

        public final VoxelShape getWEST_OUTLINE() {
            return WEST_OUTLINE;
        }

        public final VoxelShape getEAST_OUTLINE() {
            return EAST_OUTLINE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000f\b\u0086\u0081\u0002\u0018\u0000 \r2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002:\u0001\rB\u0011\b\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\n\u001a\u0004\b\u000b\u0010\fj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015\u00a8\u0006\u0016"}, d2={"Lcom/cobblemon/mod/common/block/chest/GildedChestBlock$Type;", "Lnet/minecraft/util/StringRepresentable;", "", "Lnet/minecraft/resources/ResourceLocation;", "poserId", "<init>", "(Ljava/lang/String;ILnet/minecraft/resources/ResourceLocation;)V", "", "getSerializedName", "()Ljava/lang/String;", "Lnet/minecraft/resources/ResourceLocation;", "getPoserId", "()Lnet/minecraft/resources/ResourceLocation;", "Companion", "RED", "BLUE", "GREEN", "PINK", "WHITE", "BLACK", "YELLOW", "FAKE", "common"})
    public static final class Type
    extends Enum<Type>
    implements StringRepresentable {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final ResourceLocation poserId;
        private static final Codec<Type> CODEC;
        public static final /* enum */ Type RED;
        public static final /* enum */ Type BLUE;
        public static final /* enum */ Type GREEN;
        public static final /* enum */ Type PINK;
        public static final /* enum */ Type WHITE;
        public static final /* enum */ Type BLACK;
        public static final /* enum */ Type YELLOW;
        public static final /* enum */ Type FAKE;
        private static final /* synthetic */ Type[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Type(ResourceLocation poserId) {
            this.poserId = poserId;
        }

        @NotNull
        public final ResourceLocation getPoserId() {
            return this.poserId;
        }

        @NotNull
        public String getSerializedName() {
            String string = this.name().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            return string;
        }

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String value) {
            return Enum.valueOf(Type.class, value);
        }

        @NotNull
        public static EnumEntries<Type> getEntries() {
            return $ENTRIES;
        }

        static {
            RED = new Type(MiscUtilsKt.cobblemonResource("gilded_chest"));
            BLUE = new Type(MiscUtilsKt.cobblemonResource("blue_gilded_chest"));
            GREEN = new Type(MiscUtilsKt.cobblemonResource("green_gilded_chest"));
            PINK = new Type(MiscUtilsKt.cobblemonResource("pink_gilded_chest"));
            WHITE = new Type(MiscUtilsKt.cobblemonResource("white_gilded_chest"));
            BLACK = new Type(MiscUtilsKt.cobblemonResource("black_gilded_chest"));
            YELLOW = new Type(MiscUtilsKt.cobblemonResource("yellow_gilded_chest"));
            FAKE = new Type(MiscUtilsKt.cobblemonResource("gilded_chest"));
            $VALUES = typeArray = new Type[]{Type.RED, Type.BLUE, Type.GREEN, Type.PINK, Type.WHITE, Type.BLACK, Type.YELLOW, Type.FAKE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
            CODEC = StringRepresentable.fromValues(Type::values);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R;\u0010\u0007\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/cobblemon/mod/common/block/chest/GildedChestBlock$Type$Companion;", "", "<init>", "()V", "Lcom/mojang/serialization/Codec;", "Lcom/cobblemon/mod/common/block/chest/GildedChestBlock$Type;", "kotlin.jvm.PlatformType", "CODEC", "Lcom/mojang/serialization/Codec;", "getCODEC", "()Lcom/mojang/serialization/Codec;", "common"})
        public static final class Companion {
            private Companion() {
            }

            public final Codec<Type> getCODEC() {
                return CODEC;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Direction.values().length];
            try {
                nArray[Direction.NORTH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.SOUTH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.WEST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

