/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.block.entity;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.CobblemonBlockEntities;
import com.cobblemon.mod.common.CobblemonItemComponents;
import com.cobblemon.mod.common.api.cooking.FlavourColourHelperKt;
import com.cobblemon.mod.common.api.events.Cancelable;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.events.cooking.PokeSnackSpawnPokemonEvent;
import com.cobblemon.mod.common.api.fishing.SpawnBait;
import com.cobblemon.mod.common.api.fishing.SpawnBaitEffects;
import com.cobblemon.mod.common.api.net.NetworkPacket;
import com.cobblemon.mod.common.api.reactive.CancelableObservable;
import com.cobblemon.mod.common.api.reactive.EventObservable;
import com.cobblemon.mod.common.api.spawning.CobblemonSpawnPools;
import com.cobblemon.mod.common.api.spawning.SpawnCause;
import com.cobblemon.mod.common.api.spawning.detail.EntitySpawnResult;
import com.cobblemon.mod.common.api.spawning.detail.PokemonHerdSpawnDetail;
import com.cobblemon.mod.common.api.spawning.detail.SpawnAction;
import com.cobblemon.mod.common.api.spawning.detail.SpawnDetail;
import com.cobblemon.mod.common.api.spawning.detail.SpawnPool;
import com.cobblemon.mod.common.api.spawning.influence.BucketMultiplyingInfluence;
import com.cobblemon.mod.common.api.spawning.influence.BucketNormalizingInfluence;
import com.cobblemon.mod.common.api.spawning.influence.SpawnBaitInfluence;
import com.cobblemon.mod.common.api.spawning.influence.SpawningInfluence;
import com.cobblemon.mod.common.api.spawning.position.SpawnablePosition;
import com.cobblemon.mod.common.api.spawning.spawner.FixedAreaSpawner;
import com.cobblemon.mod.common.api.spawning.spawner.SpawningZoneInput;
import com.cobblemon.mod.common.block.PokeSnackBlock;
import com.cobblemon.mod.common.block.entity.TintBlockEntity;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.item.components.BaitEffectsComponent;
import com.cobblemon.mod.common.item.components.FoodColourComponent;
import com.cobblemon.mod.common.item.components.IngredientComponent;
import com.cobblemon.mod.common.net.messages.client.effect.PokeSnackBlockParticlesPacket;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.RangesKt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00b0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\r\b\u0016\u0018\u0000 i2\u00020\u00012\u00020\u0002:\u0001iB\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001f\u0010\u000e\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ#\u0010\u0015\u001a\u00020\u00142\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0015\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\r\u0010\u001b\u001a\u00020\r\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\r\u0010\u001d\u001a\u00020\u0014\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0015\u0010!\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\u001f\u00a2\u0006\u0004\b!\u0010\"J\r\u0010$\u001a\u00020#\u00a2\u0006\u0004\b$\u0010%J\r\u0010&\u001a\u00020#\u00a2\u0006\u0004\b&\u0010%J\r\u0010'\u001a\u00020\u0017\u00a2\u0006\u0004\b'\u0010(J\u0013\u0010+\u001a\b\u0012\u0004\u0012\u00020*0)\u00a2\u0006\u0004\b+\u0010,J\u001f\u00101\u001a\u00020\u00142\u0006\u0010.\u001a\u00020-2\u0006\u00100\u001a\u00020/H\u0014\u00a2\u0006\u0004\b1\u00102J\u001f\u00103\u001a\u00020\u00142\u0006\u0010.\u001a\u00020-2\u0006\u00100\u001a\u00020/H\u0014\u00a2\u0006\u0004\b3\u00102J\u0017\u00105\u001a\u00020-2\u0006\u00104\u001a\u00020/H\u0016\u00a2\u0006\u0004\b5\u00106J\u0019\u00109\u001a\f\u0012\u0006\u0012\u0004\u0018\u000108\u0018\u000107H\u0016\u00a2\u0006\u0004\b9\u0010:R\u001b\u0010@\u001a\u00020;8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b<\u0010=\u001a\u0004\b>\u0010?R$\u0010B\u001a\u0004\u0018\u00010A8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bB\u0010C\u001a\u0004\bD\u0010E\"\u0004\bF\u0010GR\"\u0010I\u001a\u00020H8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bI\u0010J\u001a\u0004\bK\u0010L\"\u0004\bM\u0010NR$\u0010P\u001a\u0004\u0018\u00010O8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bP\u0010Q\u001a\u0004\bR\u0010S\"\u0004\bT\u0010UR$\u0010W\u001a\u0004\u0018\u00010V8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bW\u0010X\u001a\u0004\bY\u0010Z\"\u0004\b[\u0010\\R$\u0010^\u001a\u0004\u0018\u00010]8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b^\u0010_\u001a\u0004\b`\u0010a\"\u0004\bb\u0010cR\"\u0010d\u001a\u00020#8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bd\u0010e\u001a\u0004\bf\u0010%\"\u0004\bg\u0010h\u00a8\u0006j"}, d2={"Lcom/cobblemon/mod/common/block/entity/PokeSnackBlockEntity;", "Lcom/cobblemon/mod/common/block/entity/TintBlockEntity;", "Lcom/cobblemon/mod/common/api/spawning/influence/SpawningInfluence;", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "Lcom/cobblemon/mod/common/api/spawning/detail/SpawnDetail;", "detail", "Lcom/cobblemon/mod/common/api/spawning/position/SpawnablePosition;", "spawnablePosition", "", "affectSpawnable", "(Lcom/cobblemon/mod/common/api/spawning/detail/SpawnDetail;Lcom/cobblemon/mod/common/api/spawning/position/SpawnablePosition;)Z", "Lcom/cobblemon/mod/common/api/spawning/detail/SpawnAction;", "action", "Lnet/minecraft/world/entity/Entity;", "entity", "", "affectSpawn", "(Lcom/cobblemon/mod/common/api/spawning/detail/SpawnAction;Lnet/minecraft/world/entity/Entity;)V", "Lnet/minecraft/world/item/ItemStack;", "itemStack", "initializeFromItemStack", "(Lnet/minecraft/world/item/ItemStack;)V", "isLure", "()Z", "randomTick", "()V", "Lnet/minecraft/world/entity/player/Player;", "player", "attemptSpawn", "(Lnet/minecraft/world/entity/player/Player;)V", "", "getRandomTicksBetweenSpawns", "()F", "getBiteTimeMultiplier", "toItemStack", "()Lnet/minecraft/world/item/ItemStack;", "", "Lcom/cobblemon/mod/common/api/fishing/SpawnBait$Effect;", "getBaitEffects", "()Ljava/util/List;", "Lnet/minecraft/nbt/CompoundTag;", "tag", "Lnet/minecraft/core/HolderLookup$Provider;", "registries", "saveAdditional", "(Lnet/minecraft/nbt/CompoundTag;Lnet/minecraft/core/HolderLookup$Provider;)V", "loadAdditional", "registryLookup", "getUpdateTag", "(Lnet/minecraft/core/HolderLookup$Provider;)Lnet/minecraft/nbt/CompoundTag;", "Lnet/minecraft/network/protocol/Packet;", "Lnet/minecraft/network/protocol/game/ClientGamePacketListener;", "getUpdatePacket", "()Lnet/minecraft/network/protocol/Packet;", "Lcom/cobblemon/mod/common/api/spawning/spawner/FixedAreaSpawner;", "spawner$delegate", "Lkotlin/Lazy;", "getSpawner", "()Lcom/cobblemon/mod/common/api/spawning/spawner/FixedAreaSpawner;", "spawner", "Ljava/util/UUID;", "placedBy", "Ljava/util/UUID;", "getPlacedBy", "()Ljava/util/UUID;", "setPlacedBy", "(Ljava/util/UUID;)V", "", "amountSpawned", "I", "getAmountSpawned", "()I", "setAmountSpawned", "(I)V", "Lcom/cobblemon/mod/common/item/components/FoodColourComponent;", "foodColourComponent", "Lcom/cobblemon/mod/common/item/components/FoodColourComponent;", "getFoodColourComponent", "()Lcom/cobblemon/mod/common/item/components/FoodColourComponent;", "setFoodColourComponent", "(Lcom/cobblemon/mod/common/item/components/FoodColourComponent;)V", "Lcom/cobblemon/mod/common/item/components/BaitEffectsComponent;", "baitEffectsComponent", "Lcom/cobblemon/mod/common/item/components/BaitEffectsComponent;", "getBaitEffectsComponent", "()Lcom/cobblemon/mod/common/item/components/BaitEffectsComponent;", "setBaitEffectsComponent", "(Lcom/cobblemon/mod/common/item/components/BaitEffectsComponent;)V", "Lcom/cobblemon/mod/common/item/components/IngredientComponent;", "ingredientComponent", "Lcom/cobblemon/mod/common/item/components/IngredientComponent;", "getIngredientComponent", "()Lcom/cobblemon/mod/common/item/components/IngredientComponent;", "setIngredientComponent", "(Lcom/cobblemon/mod/common/item/components/IngredientComponent;)V", "randomTicksUntilNextSpawn", "F", "getRandomTicksUntilNextSpawn", "setRandomTicksUntilNextSpawn", "(F)V", "Companion", "common"})
@SourceDebugExtension(value={"SMAP\nPokeSnackBlockEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PokeSnackBlockEntity.kt\ncom/cobblemon/mod/common/block/entity/PokeSnackBlockEntity\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 EventObservables.kt\ncom/cobblemon/mod/common/api/reactive/CancelableObservable\n+ 4 EventObservables.kt\ncom/cobblemon/mod/common/api/reactive/EventObservable\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 6 EventObservables.kt\ncom/cobblemon/mod/common/api/reactive/EventObservable$post$1\n+ 7 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,336:1\n1#2:337\n1#2:372\n40#3:338\n41#3,4:342\n46#3:355\n47#3:358\n17#4,2:339\n14#4,5:346\n19#4:354\n19#4:357\n13805#5:341\n13805#5:351\n13806#5:353\n13806#5:356\n14#6:352\n774#7:359\n865#7,2:360\n1617#7,9:362\n1869#7:371\n1870#7:373\n1626#7:374\n1374#7:375\n1460#7,5:376\n774#7:381\n865#7,2:382\n*S KotlinDebug\n*F\n+ 1 PokeSnackBlockEntity.kt\ncom/cobblemon/mod/common/block/entity/PokeSnackBlockEntity\n*L\n243#1:372\n183#1:338\n183#1:342,4\n183#1:355\n183#1:358\n183#1:339,2\n193#1:346,5\n193#1:354\n183#1:357\n183#1:341\n193#1:351\n193#1:353\n183#1:356\n193#1:352\n208#1:359\n208#1:360,2\n243#1:362,9\n243#1:371\n243#1:373\n243#1:374\n244#1:375\n244#1:376,5\n80#1:381\n80#1:382,2\n*E\n"})
public class PokeSnackBlockEntity
extends TintBlockEntity
implements SpawningInfluence {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy spawner$delegate;
    @Nullable
    private UUID placedBy;
    private int amountSpawned;
    @Nullable
    private FoodColourComponent foodColourComponent;
    @Nullable
    private BaitEffectsComponent baitEffectsComponent;
    @Nullable
    private IngredientComponent ingredientComponent;
    private float randomTicksUntilNextSpawn;
    public static final int SPAWNS_PER_BITE = 1;
    public static final int RADIUS = 8;
    public static final int RANDOM_TICKS_BETWEEN_SPAWNS = 2;
    @NotNull
    public static final String POKE_SNACK_CRUMBED_ASPECT = "poke_snack_crumbed";

    public PokeSnackBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(CobblemonBlockEntities.POKE_SNACK, pos, state);
        this.spawner$delegate = LazyKt.lazy(() -> PokeSnackBlockEntity.spawner_delegate$lambda$0(this));
        this.randomTicksUntilNextSpawn = this.getRandomTicksBetweenSpawns();
    }

    @NotNull
    public final FixedAreaSpawner getSpawner() {
        Lazy lazy = this.spawner$delegate;
        return (FixedAreaSpawner)lazy.getValue();
    }

    @Override
    public boolean affectSpawnable(@NotNull SpawnDetail detail, @NotNull SpawnablePosition spawnablePosition) {
        Intrinsics.checkNotNullParameter((Object)detail, (String)"detail");
        Intrinsics.checkNotNullParameter((Object)spawnablePosition, (String)"spawnablePosition");
        return SpawnDetail.Companion.getPokemonTypes().contains(detail.getType()) && !(detail instanceof PokemonHerdSpawnDetail);
    }

    @Override
    public void affectSpawn(@NotNull SpawnAction<?> action, @NotNull Entity entity) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (entity instanceof PokemonEntity) {
            Pokemon pokemon = ((PokemonEntity)entity).getPokemon();
            pokemon.setForcedAspects(SetsKt.plus(pokemon.getForcedAspects(), (Object)POKE_SNACK_CRUMBED_ASPECT));
            Block block = this.getBlockState().getBlock();
            PokeSnackBlock pokeSnackBlock = block instanceof PokeSnackBlock ? (PokeSnackBlock)block : null;
            if (pokeSnackBlock == null) {
                return;
            }
            PokeSnackBlock block2 = pokeSnackBlock;
            Level level = this.level;
            if (level == null) {
                return;
            }
            Level level2 = level;
            BlockPos entityPos = entity.blockPosition();
            BlockPos blockPos = this.getBlockPos();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
            NetworkPacket networkPacket = new PokeSnackBlockParticlesPacket(blockPos, entityPos);
            double d = this.getBlockPos().getX();
            double d2 = this.getBlockPos().getY();
            double d3 = this.getBlockPos().getZ();
            ResourceKey resourceKey = level2.dimension();
            Intrinsics.checkNotNullExpressionValue((Object)resourceKey, (String)"dimension(...)");
            NetworkPacket.sendToPlayersAround$default(networkPacket, d, d2, d3, 64.0, resourceKey, null, 32, null);
            BlockPos blockPos2 = this.getBlockPos();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos2, (String)"getBlockPos(...)");
            BlockState blockState = this.getBlockState();
            Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"getBlockState(...)");
            Entity entity2 = action.getSpawnablePosition().getCause().getEntity();
            block2.eat(level2, blockPos2, blockState, entity2 instanceof Player ? (Player)entity2 : null);
        }
    }

    @Nullable
    public final UUID getPlacedBy() {
        return this.placedBy;
    }

    public final void setPlacedBy(@Nullable UUID uUID) {
        this.placedBy = uUID;
    }

    public final int getAmountSpawned() {
        return this.amountSpawned;
    }

    public final void setAmountSpawned(int n) {
        this.amountSpawned = n;
    }

    @Nullable
    public final FoodColourComponent getFoodColourComponent() {
        return this.foodColourComponent;
    }

    public final void setFoodColourComponent(@Nullable FoodColourComponent foodColourComponent) {
        this.foodColourComponent = foodColourComponent;
    }

    @Nullable
    public final BaitEffectsComponent getBaitEffectsComponent() {
        return this.baitEffectsComponent;
    }

    public final void setBaitEffectsComponent(@Nullable BaitEffectsComponent baitEffectsComponent) {
        this.baitEffectsComponent = baitEffectsComponent;
    }

    @Nullable
    public final IngredientComponent getIngredientComponent() {
        return this.ingredientComponent;
    }

    public final void setIngredientComponent(@Nullable IngredientComponent ingredientComponent) {
        this.ingredientComponent = ingredientComponent;
    }

    public final float getRandomTicksUntilNextSpawn() {
        return this.randomTicksUntilNextSpawn;
    }

    public final void setRandomTicksUntilNextSpawn(float f) {
        this.randomTicksUntilNextSpawn = f;
    }

    public final void initializeFromItemStack(@NotNull ItemStack itemStack) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
            this.foodColourComponent = (FoodColourComponent)itemStack.get(CobblemonItemComponents.FOOD_COLOUR);
            this.ingredientComponent = (IngredientComponent)itemStack.get(CobblemonItemComponents.INGREDIENT);
            if (this.isLure()) {
                this.baitEffectsComponent = (BaitEffectsComponent)itemStack.get(CobblemonItemComponents.BAIT_EFFECTS);
            }
            FoodColourComponent foodColourComponent = this.foodColourComponent;
            if (foodColourComponent == null) break block2;
            FoodColourComponent it = foodColourComponent;
            boolean bl = false;
            Integer n = FlavourColourHelperKt.getColourMixFromColors(it.getColoursAsARGB());
            if (n != null) {
                int p0 = ((Number)n).intValue();
                boolean bl2 = false;
                this.setTint(p0);
            }
        }
    }

    public final boolean isLure() {
        Block block = this.getBlockState().getBlock();
        if (block instanceof PokeSnackBlock) {
            return ((PokeSnackBlock)block).isLure();
        }
        return false;
    }

    public final void randomTick() {
        Player nearestPlayer;
        float f = this.randomTicksUntilNextSpawn;
        this.randomTicksUntilNextSpawn = f + -1.0f;
        if (this.randomTicksUntilNextSpawn > 0.0f) {
            return;
        }
        Level level = this.level;
        Player player = nearestPlayer = level != null ? level.getNearestPlayer((double)this.getBlockPos().getX(), (double)this.getBlockPos().getY(), (double)this.getBlockPos().getZ(), (double)Cobblemon.INSTANCE.getConfig().getMaximumSpawningZoneDistanceFromPlayer(), false) : null;
        if (nearestPlayer != null) {
            this.attemptSpawn(nearestPlayer);
        }
        this.randomTicksUntilNextSpawn = this.getRandomTicksBetweenSpawns();
    }

    /*
     * WARNING - void declaration
     */
    public final void attemptSpawn(@NotNull Player player) {
        void this_$iv$iv;
        void event$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        SpawnCause cause = new SpawnCause(this.getSpawner(), (Entity)player);
        SpawningZoneInput zoneInput = this.getSpawner().getZoneInput(cause);
        SpawnAction spawnAction = (SpawnAction)CollectionsKt.firstOrNull(this.getSpawner().calculateSpawnActionsForArea(zoneInput, 1));
        if (spawnAction == null) {
            return;
        }
        CancelableObservable<PokeSnackSpawnPokemonEvent.Pre> cancelableObservable = CobblemonEvents.POKE_SNACK_SPAWN_POKEMON_PRE;
        Cancelable cancelable = new PokeSnackSpawnPokemonEvent.Pre(this, spawnAction);
        boolean $i$f$postThen = false;
        EventObservable eventObservable = (EventObservable)this_$iv;
        Cancelable[] cancelableArray = new Cancelable[]{event$iv};
        Cancelable[] events$iv$iv = cancelableArray;
        boolean $i$f$post = false;
        this_$iv$iv.emit(Arrays.copyOf(events$iv$iv, events$iv$iv.length));
        Cancelable[] $this$forEach$iv$iv$iv = events$iv$iv;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv$iv$iv.length;
        for (int i = 0; i < n; ++i) {
            void events$iv;
            void $this$iv;
            Cancelable element$iv$iv$iv;
            Cancelable it$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            if (it$iv.isCanceled()) {
                PokeSnackSpawnPokemonEvent.Pre it = (PokeSnackSpawnPokemonEvent.Pre)it$iv;
                boolean bl2 = false;
                continue;
            }
            PokeSnackSpawnPokemonEvent.Pre event = (PokeSnackSpawnPokemonEvent.Pre)it$iv;
            boolean bl3 = false;
            spawnAction.complete();
            CompletableFuture result = spawnAction.getFuture();
            Object resultingSpawn = result.get();
            if (!(resultingSpawn instanceof EntitySpawnResult)) continue;
            Object object = CollectionsKt.firstOrNull(((EntitySpawnResult)resultingSpawn).getEntities());
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.cobblemon.mod.common.entity.pokemon.PokemonEntity");
            PokemonEntity pokemonEntity = (PokemonEntity)object;
            EventObservable<PokeSnackSpawnPokemonEvent.Post> eventObservable2 = CobblemonEvents.POKE_SNACK_SPAWN_POKEMON_POST;
            PokeSnackSpawnPokemonEvent.Post[] postArray = new PokeSnackSpawnPokemonEvent.Post[]{new PokeSnackSpawnPokemonEvent.Post(this, spawnAction, pokemonEntity)};
            boolean $i$f$post2 = false;
            $this$iv.emit(Arrays.copyOf(events$iv, ((void)events$iv).length));
            void $this$forEach$iv$iv = events$iv;
            boolean $i$f$forEach2 = false;
            int n2 = ((void)$this$forEach$iv$iv).length;
            for (int j = 0; j < n2; ++j) {
                void element$iv$iv;
                void var31_31 = element$iv$iv = $this$forEach$iv$iv[j];
                boolean bl4 = false;
                void it = var31_31;
            }
        }
    }

    public final float getRandomTicksBetweenSpawns() {
        float biteTimeMultiplier = this.getBiteTimeMultiplier();
        return RangesKt.coerceAtLeast((float)((float)2 * biteTimeMultiplier), (float)1.0f);
    }

    /*
     * WARNING - void declaration
     */
    public final float getBiteTimeMultiplier() {
        void $this$filterTo$iv$iv;
        List<SpawnBait.Effect> baitEffects = this.getBaitEffects();
        Iterable $this$filter$iv = baitEffects;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            SpawnBait.Effect it = (SpawnBait.Effect)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getType(), (Object)SpawnBait.Effects.INSTANCE.getBITE_TIME())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List biteTimeEffects = (List)destination$iv$iv;
        if (biteTimeEffects.isEmpty()) {
            return 1.0f;
        }
        SpawnBait.Effect biteTimeEffect = (SpawnBait.Effect)CollectionsKt.random((Collection)biteTimeEffects, (Random)((Random)Random.Default));
        if (Math.random() > biteTimeEffect.getChance()) {
            return 1.0f;
        }
        return 1.0f - (float)biteTimeEffect.getValue();
    }

    @NotNull
    public final ItemStack toItemStack() {
        ItemStack stack = new ItemStack((ItemLike)this.getBlockState().getBlock());
        if (this.isLure() && this.baitEffectsComponent != null) {
            stack.set(CobblemonItemComponents.BAIT_EFFECTS, (Object)this.baitEffectsComponent);
        }
        if (this.foodColourComponent != null) {
            stack.set(CobblemonItemComponents.FOOD_COLOUR, (Object)this.foodColourComponent);
        }
        if (this.ingredientComponent != null) {
            stack.set(CobblemonItemComponents.INGREDIENT, (Object)this.ingredientComponent);
        }
        return stack;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<SpawnBait.Effect> getBaitEffects() {
        List list;
        List list2;
        List<ResourceLocation> list3;
        BaitEffectsComponent baitEffectsComponent = this.baitEffectsComponent;
        if (baitEffectsComponent != null && (list3 = baitEffectsComponent.getEffects()) != null) {
            void $this$flatMapTo$iv$iv;
            Iterable $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = list3;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                SpawnBait it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                ResourceLocation p0 = (ResourceLocation)element$iv$iv;
                boolean bl2 = false;
                if (SpawnBaitEffects.getFromIdentifier(p0) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Iterable $this$flatMap$iv = (List)destination$iv$iv;
            boolean $i$f$flatMap = false;
            $this$mapNotNullTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                SpawnBait it = (SpawnBait)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = it.getEffects();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = list = null;
        }
        if (list2 == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    protected void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        block3: {
            Object component;
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
            super.saveAdditional(tag, registries);
            tag.putInt("AmountSpawned", this.amountSpawned);
            FoodColourComponent foodColourComponent = this.foodColourComponent;
            if (foodColourComponent != null) {
                component = foodColourComponent;
                boolean bl = false;
                Codec codec = CobblemonItemComponents.FOOD_COLOUR.codec();
                Intrinsics.checkNotNull((Object)codec);
                codec.encodeStart((DynamicOps)NbtOps.INSTANCE, component).result().ifPresent(arg_0 -> PokeSnackBlockEntity.saveAdditional$lambda$0$1(arg_0 -> PokeSnackBlockEntity.saveAdditional$lambda$0$0(tag, arg_0), arg_0));
            }
            BaitEffectsComponent baitEffectsComponent = this.baitEffectsComponent;
            if (baitEffectsComponent != null) {
                component = baitEffectsComponent;
                boolean bl = false;
                Codec codec = CobblemonItemComponents.BAIT_EFFECTS.codec();
                Intrinsics.checkNotNull((Object)codec);
                codec.encodeStart((DynamicOps)NbtOps.INSTANCE, component).result().ifPresent(arg_0 -> PokeSnackBlockEntity.saveAdditional$lambda$1$1(arg_0 -> PokeSnackBlockEntity.saveAdditional$lambda$1$0(tag, arg_0), arg_0));
            }
            IngredientComponent ingredientComponent = this.ingredientComponent;
            if (ingredientComponent != null) {
                component = ingredientComponent;
                boolean bl = false;
                Codec codec = CobblemonItemComponents.INGREDIENT.codec();
                Intrinsics.checkNotNull((Object)codec);
                codec.encodeStart((DynamicOps)NbtOps.INSTANCE, component).result().ifPresent(arg_0 -> PokeSnackBlockEntity.saveAdditional$lambda$2$1(arg_0 -> PokeSnackBlockEntity.saveAdditional$lambda$2$0(tag, arg_0), arg_0));
            }
            tag.putFloat("TicksUntilNextSpawn", this.randomTicksUntilNextSpawn);
            UUID uUID = this.placedBy;
            if (uUID == null) break block3;
            UUID it = uUID;
            boolean bl = false;
            tag.putUUID("PlacedBy", it);
        }
    }

    @Override
    protected void loadAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        Optional optional;
        DataResult dataResult;
        Codec codec;
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        super.loadAdditional(tag, registries);
        this.amountSpawned = tag.getInt("AmountSpawned");
        if (tag.contains("FoodColour") && (codec = CobblemonItemComponents.FOOD_COLOUR.codec()) != null && (dataResult = codec.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get("FoodColour"))) != null && (optional = dataResult.result()) != null) {
            optional.ifPresent(arg_0 -> PokeSnackBlockEntity.loadAdditional$lambda$1(arg_0 -> PokeSnackBlockEntity.loadAdditional$lambda$0(this, arg_0), arg_0));
        }
        if (tag.contains("BaitEffects") && (codec = CobblemonItemComponents.BAIT_EFFECTS.codec()) != null && (dataResult = codec.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get("BaitEffects"))) != null && (optional = dataResult.result()) != null) {
            optional.ifPresent(arg_0 -> PokeSnackBlockEntity.loadAdditional$lambda$3(arg_0 -> PokeSnackBlockEntity.loadAdditional$lambda$2(this, arg_0), arg_0));
        }
        if (tag.contains("Ingredients") && (codec = CobblemonItemComponents.INGREDIENT.codec()) != null && (dataResult = codec.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get("Ingredients"))) != null && (optional = dataResult.result()) != null) {
            optional.ifPresent(arg_0 -> PokeSnackBlockEntity.loadAdditional$lambda$5(arg_0 -> PokeSnackBlockEntity.loadAdditional$lambda$4(this, arg_0), arg_0));
        }
        if (tag.contains("TicksUntilNextSpawn")) {
            this.randomTicksUntilNextSpawn = tag.getFloat("TicksUntilNextSpawn");
        }
        if (tag.contains("PlacedBy")) {
            this.placedBy = tag.getUUID("PlacedBy");
        }
    }

    @Override
    @NotNull
    public CompoundTag getUpdateTag(@NotNull HolderLookup.Provider registryLookup) {
        Intrinsics.checkNotNullParameter((Object)registryLookup, (String)"registryLookup");
        CompoundTag compoundTag = this.saveWithoutMetadata(registryLookup);
        Intrinsics.checkNotNullExpressionValue((Object)compoundTag, (String)"saveWithoutMetadata(...)");
        return compoundTag;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return (Packet)ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    /*
     * WARNING - void declaration
     */
    private static final FixedAreaSpawner spawner_delegate$lambda$0(PokeSnackBlockEntity this$0) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        FixedAreaSpawner fixedAreaSpawner;
        Level level = this$0.level;
        String string = "poke_snack_spawner_" + (level != null && (level = level.dimension()) != null ? level.location() : null) + "}_" + this$0.getBlockPos();
        SpawnPool spawnPool = CobblemonSpawnPools.INSTANCE.getWORLD_SPAWN_POOL();
        Level level2 = this$0.level;
        Intrinsics.checkNotNull((Object)level2, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
        ServerLevel serverLevel = (ServerLevel)level2;
        BlockPos blockPos = this$0.getBlockPos();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
        FixedAreaSpawner it = fixedAreaSpawner = new FixedAreaSpawner(string, spawnPool, serverLevel, blockPos, 8, 8, Cobblemon.INSTANCE.getConfig().getPokeSnackPokemonPerChunk());
        boolean bl = false;
        it.getInfluences().add(this$0);
        List<SpawnBait.Effect> baitEffects = this$0.getBaitEffects();
        Iterable iterable = baitEffects;
        boolean $i$f$filter = false;
        void var7_8 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            SpawnBait.Effect it2 = (SpawnBait.Effect)element$iv$iv;
            boolean bl2 = false;
            if (!Intrinsics.areEqual((Object)it2.getType(), (Object)SpawnBait.Effects.INSTANCE.getRARITY_BUCKET())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        iterable = (List)destination$iv$iv;
        double d = 0.0;
        for (Object t : iterable) {
            void it3;
            SpawnBait.Effect effect = (SpawnBait.Effect)t;
            double d2 = d;
            boolean bl3 = false;
            double d3 = it3.getValue();
            d = d2 + d3;
        }
        int stackedLureTier = (int)d;
        if (stackedLureTier > 0) {
            ((Collection)it.getInfluences()).add(new BucketNormalizingInfluence(stackedLureTier, 0.2f, 1.2f));
        }
        iterable = it.getInfluences();
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"uncommon", (Object)Float.valueOf(2.25f)), TuplesKt.to((Object)"rare", (Object)Float.valueOf(5.5f)), TuplesKt.to((Object)"ultra-rare", (Object)Float.valueOf(5.5f))};
        iterable.add(new BucketMultiplyingInfluence(MapsKt.mapOf((Pair[])pairArray)));
        ((Collection)it.getInfluences()).add(new SpawnBaitInfluence(baitEffects, null, 2, null));
        return fixedAreaSpawner;
    }

    private static final Unit saveAdditional$lambda$0$0(CompoundTag $tag, Tag encodedTag) {
        Intrinsics.checkNotNullParameter((Object)encodedTag, (String)"encodedTag");
        $tag.put("FoodColour", encodedTag);
        return Unit.INSTANCE;
    }

    private static final void saveAdditional$lambda$0$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit saveAdditional$lambda$1$0(CompoundTag $tag, Tag encodedTag) {
        Intrinsics.checkNotNullParameter((Object)encodedTag, (String)"encodedTag");
        $tag.put("BaitEffects", encodedTag);
        return Unit.INSTANCE;
    }

    private static final void saveAdditional$lambda$1$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit saveAdditional$lambda$2$0(CompoundTag $tag, Tag encodedTag) {
        Intrinsics.checkNotNullParameter((Object)encodedTag, (String)"encodedTag");
        $tag.put("Ingredients", encodedTag);
        return Unit.INSTANCE;
    }

    private static final void saveAdditional$lambda$2$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit loadAdditional$lambda$0(PokeSnackBlockEntity this$0, FoodColourComponent component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        this$0.foodColourComponent = component;
        return Unit.INSTANCE;
    }

    private static final void loadAdditional$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit loadAdditional$lambda$2(PokeSnackBlockEntity this$0, BaitEffectsComponent component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        this$0.baitEffectsComponent = component;
        return Unit.INSTANCE;
    }

    private static final void loadAdditional$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit loadAdditional$lambda$4(PokeSnackBlockEntity this$0, IngredientComponent component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        this$0.ingredientComponent = component;
        return Unit.INSTANCE;
    }

    private static final void loadAdditional$lambda$5(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0006R\u0014\u0010\b\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\b\u0010\u0006R\u0014\u0010\n\u001a\u00020\t8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/cobblemon/mod/common/block/entity/PokeSnackBlockEntity$Companion;", "", "<init>", "()V", "", "SPAWNS_PER_BITE", "I", "RADIUS", "RANDOM_TICKS_BETWEEN_SPAWNS", "", "POKE_SNACK_CRUMBED_ASPECT", "Ljava/lang/String;", "common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

