/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.block.multiblock;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.CobblemonBlocks;
import com.cobblemon.mod.common.CobblemonSounds;
import com.cobblemon.mod.common.advancement.CobblemonCriteria;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.events.pokemon.FossilRevivedEvent;
import com.cobblemon.mod.common.api.fossil.Fossil;
import com.cobblemon.mod.common.api.fossil.Fossils;
import com.cobblemon.mod.common.api.fossil.NaturalMaterials;
import com.cobblemon.mod.common.api.multiblock.MultiblockEntity;
import com.cobblemon.mod.common.api.multiblock.MultiblockStructure;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.api.reactive.EventObservable;
import com.cobblemon.mod.common.api.tags.CobblemonItemTags;
import com.cobblemon.mod.common.block.FossilAnalyzerBlock;
import com.cobblemon.mod.common.block.MonitorBlock;
import com.cobblemon.mod.common.block.RestorationTankBlock;
import com.cobblemon.mod.common.block.entity.FossilMultiblockEntity;
import com.cobblemon.mod.common.block.entity.RestorationTankBlockEntity;
import com.cobblemon.mod.common.client.render.models.blockbench.fossil.FossilState;
import com.cobblemon.mod.common.client.sound.BlockEntitySoundTracker;
import com.cobblemon.mod.common.client.sound.instances.CancellableSoundInstance;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.item.PokeBallItem;
import com.cobblemon.mod.common.pokeball.PokeBall;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.DistributionUtilsKt;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import com.mojang.authlib.GameProfile;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00c4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\u0012\u0018\u0000 \u0084\u00012\u00020\u0001:\u0002\u0084\u0001B3\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ7\u0010\u0016\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J-\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001b\u00a2\u0006\u0004\b\u001e\u0010\u001fJ%\u0010\"\u001a\u00020\u001d2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00022\u0006\u0010!\u001a\u00020 \u00a2\u0006\u0004\b\"\u0010#J/\u0010&\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00022\u0006\u0010!\u001a\u00020 2\u0006\u0010%\u001a\u00020$\u00a2\u0006\u0004\b&\u0010'J+\u0010)\u001a\u00020\u00062\u0006\u0010(\u001a\u00020\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0002H\u0017\u00a2\u0006\u0004\b)\u0010*J7\u0010/\u001a\u00020.2\b\u0010(\u001a\u0004\u0018\u00010\f2\b\u0010\u000f\u001a\u0004\u0018\u00010+2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00022\b\u0010-\u001a\u0004\u0018\u00010,H\u0016\u00a2\u0006\u0004\b/\u00100J1\u00101\u001a\u00020.2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00022\u0006\u0010(\u001a\u00020\f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0011H\u0016\u00a2\u0006\u0004\b1\u00102J\u0017\u00103\u001a\u00020.2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b3\u00104J\u0017\u00105\u001a\u00020.2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b5\u00104J\u0017\u00106\u001a\u00020.2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b6\u00104J\u0017\u00107\u001a\u00020.2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b7\u00104J\u0015\u00108\u001a\u00020.2\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b8\u00104J\u0015\u00109\u001a\u00020.2\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b9\u00104J\u0015\u0010:\u001a\u00020.2\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b:\u00104J\u0015\u0010;\u001a\u00020.2\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b;\u00104J\u0015\u0010>\u001a\u00020=2\u0006\u0010<\u001a\u00020\u0006\u00a2\u0006\u0004\b>\u0010?J\u0015\u0010@\u001a\u00020.2\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b@\u00104J\r\u0010A\u001a\u00020\u001d\u00a2\u0006\u0004\bA\u0010BJ\u001d\u0010E\u001a\u00020\u001d2\u0006\u0010D\u001a\u00020C2\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\bE\u0010FJ\u001d\u0010G\u001a\u00020\u001d2\u0006\u0010D\u001a\u00020C2\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\bG\u0010FJ\u0017\u0010K\u001a\u00020J2\u0006\u0010I\u001a\u00020HH\u0016\u00a2\u0006\u0004\bK\u0010LR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010M\u001a\u0004\bN\u0010OR\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010M\u001a\u0004\bP\u0010OR\u0017\u0010\u0005\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010M\u001a\u0004\bQ\u0010OR\u001a\u0010R\u001a\u00020\u00028\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\bR\u0010M\u001a\u0004\bS\u0010OR$\u0010U\u001a\u00020\u00062\u0006\u0010T\u001a\u00020\u00068\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\bU\u0010V\u001a\u0004\bW\u0010XR$\u0010Y\u001a\u00020\u001d2\u0006\u0010T\u001a\u00020\u001d8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\bY\u0010Z\u001a\u0004\b[\u0010BR$\u0010\\\u001a\u00020\u00062\u0006\u0010T\u001a\u00020\u00068\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b\\\u0010V\u001a\u0004\b]\u0010XR(\u0010_\u001a\u0004\u0018\u00010^2\b\u0010T\u001a\u0004\u0018\u00010^8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b_\u0010`\u001a\u0004\ba\u0010bR\u0016\u0010d\u001a\u00020c8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bd\u0010eR\u0016\u0010f\u001a\u00020c8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bf\u0010eR\u0016\u0010g\u001a\u00020\u00068\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bg\u0010VR\u0018\u0010i\u001a\u0004\u0018\u00010h8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bi\u0010jR\u0014\u0010l\u001a\u00020k8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bl\u0010mR\u0017\u0010o\u001a\u00020n8\u0006\u00a2\u0006\f\n\u0004\bo\u0010p\u001a\u0004\bq\u0010rR(\u0010t\u001a\b\u0012\u0004\u0012\u00020C0s8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bt\u0010u\u001a\u0004\bv\u0010w\"\u0004\bx\u0010yR$\u0010z\u001a\u0004\u0018\u00010\u00198\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bz\u0010{\u001a\u0004\b|\u0010}\"\u0004\b~\u0010\u007fR'\u0010\u0080\u0001\u001a\u00020\u00068\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0016\n\u0005\b\u0080\u0001\u0010V\u001a\u0005\b\u0081\u0001\u0010X\"\u0006\b\u0082\u0001\u0010\u0083\u0001\u00a8\u0006\u0085\u0001"}, d2={"Lcom/cobblemon/mod/common/block/multiblock/FossilMultiblockStructure;", "Lcom/cobblemon/mod/common/api/multiblock/MultiblockStructure;", "Lnet/minecraft/core/BlockPos;", "monitorPos", "analyzerPos", "tankBasePos", "", "animAge", "", "animPartialTicks", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/BlockPos;IF)V", "Lnet/minecraft/world/level/block/state/BlockState;", "blockState", "Lnet/minecraft/world/level/Level;", "world", "blockPos", "Lnet/minecraft/world/entity/player/Player;", "player", "Lnet/minecraft/world/phys/BlockHitResult;", "blockHitResult", "Lnet/minecraft/world/InteractionResult;", "useWithoutItem", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/phys/BlockHitResult;)Lnet/minecraft/world/InteractionResult;", "pos", "Lnet/minecraft/core/Direction;", "directionToBehind", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "pokemon", "", "spawn", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/Direction;Lcom/cobblemon/mod/common/pokemon/Pokemon;)Z", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "entity", "isSafeFloor", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)Z", "Lnet/minecraft/world/phys/AABB;", "box", "makeSuitableY", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;Lnet/minecraft/world/phys/AABB;)Lnet/minecraft/core/BlockPos;", "state", "getAnalogOutputSignal", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)I", "Lnet/minecraft/server/level/ServerLevel;", "Lnet/minecraft/util/RandomSource;", "random", "", "onTriggerEvent", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;Lnet/minecraft/util/RandomSource;)V", "playerWillDestroy", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/entity/player/Player;)V", "setRemoved", "(Lnet/minecraft/world/level/Level;)V", "tick", "syncToClient", "markDirty", "startMachine", "stopMachine", "updateOnStatus", "updateProgress", "progress", "Lcom/cobblemon/mod/common/block/MonitorBlock$MonitorScreen;", "getProgressScreen", "(I)Lcom/cobblemon/mod/common/block/MonitorBlock$MonitorScreen;", "updateFossilType", "isRunning", "()Z", "Lnet/minecraft/world/item/ItemStack;", "stack", "insertOrganicMaterial", "(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/level/Level;)Z", "insertFossil", "Lnet/minecraft/core/HolderLookup$Provider;", "registryLookup", "Lnet/minecraft/nbt/CompoundTag;", "writeToNbt", "(Lnet/minecraft/core/HolderLookup$Provider;)Lnet/minecraft/nbt/CompoundTag;", "Lnet/minecraft/core/BlockPos;", "getMonitorPos", "()Lnet/minecraft/core/BlockPos;", "getAnalyzerPos", "getTankBasePos", "controllerBlockPos", "getControllerBlockPos", "value", "organicMaterialInside", "I", "getOrganicMaterialInside", "()I", "hasCreatedPokemon", "Z", "getHasCreatedPokemon", "timeRemaining", "getTimeRemaining", "Lcom/cobblemon/mod/common/api/fossil/Fossil;", "resultingFossil", "Lcom/cobblemon/mod/common/api/fossil/Fossil;", "getResultingFossil", "()Lcom/cobblemon/mod/common/api/fossil/Fossil;", "", "lastInteraction", "J", "machineStartTime", "protectionTime", "Ljava/util/UUID;", "fossilOwnerUUID", "Ljava/util/UUID;", "Lnet/minecraft/sounds/SoundEvent;", "runningSound", "Lnet/minecraft/sounds/SoundEvent;", "Lcom/cobblemon/mod/common/client/render/models/blockbench/fossil/FossilState;", "fossilState", "Lcom/cobblemon/mod/common/client/render/models/blockbench/fossil/FossilState;", "getFossilState", "()Lcom/cobblemon/mod/common/client/render/models/blockbench/fossil/FossilState;", "", "fossilInventory", "Ljava/util/List;", "getFossilInventory", "()Ljava/util/List;", "setFossilInventory", "(Ljava/util/List;)V", "tankConnectorDirection", "Lnet/minecraft/core/Direction;", "getTankConnectorDirection", "()Lnet/minecraft/core/Direction;", "setTankConnectorDirection", "(Lnet/minecraft/core/Direction;)V", "fillLevel", "getFillLevel", "setFillLevel", "(I)V", "Companion", "common"})
@SourceDebugExtension(value={"SMAP\nFossilMultiblockStructure.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FossilMultiblockStructure.kt\ncom/cobblemon/mod/common/block/multiblock/FossilMultiblockStructure\n+ 2 EventObservables.kt\ncom/cobblemon/mod/common/api/reactive/EventObservable\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 EventObservables.kt\ncom/cobblemon/mod/common/api/reactive/EventObservable$post$1\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,675:1\n14#2,5:676\n19#2:684\n14#2,5:685\n19#2:693\n13805#3:681\n13806#3:683\n13805#3:690\n13806#3:692\n14#4:682\n14#4:691\n1#5:694\n1869#6,2:695\n1869#6,2:697\n1869#6,2:699\n1869#6,2:701\n*S KotlinDebug\n*F\n+ 1 FossilMultiblockStructure.kt\ncom/cobblemon/mod/common/block/multiblock/FossilMultiblockStructure\n*L\n134#1:676,5\n134#1:684\n237#1:685,5\n237#1:693\n134#1:681\n134#1:683\n237#1:690\n237#1:692\n134#1:682\n237#1:691\n343#1:695,2\n349#1:697,2\n445#1:699,2\n610#1:701,2\n*E\n"})
public final class FossilMultiblockStructure
implements MultiblockStructure {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BlockPos monitorPos;
    @NotNull
    private final BlockPos analyzerPos;
    @NotNull
    private final BlockPos tankBasePos;
    @NotNull
    private final BlockPos controllerBlockPos;
    private int organicMaterialInside;
    private boolean hasCreatedPokemon;
    private int timeRemaining;
    @Nullable
    private Fossil resultingFossil;
    private long lastInteraction;
    private long machineStartTime;
    private int protectionTime;
    @Nullable
    private UUID fossilOwnerUUID;
    @NotNull
    private final SoundEvent runningSound;
    @NotNull
    private final FossilState fossilState;
    @NotNull
    private List<ItemStack> fossilInventory;
    @Nullable
    private Direction tankConnectorDirection;
    private int fillLevel;
    @NotNull
    private static final BlockEntityTicker<FossilMultiblockEntity> TICKER = FossilMultiblockStructure::TICKER$lambda$0;
    public static final int TICKS_PER_MINUTE = 1200;
    public static final int MATERIAL_TO_START = 128;
    public static final int TIME_TO_TAKE = 14400;
    public static final int TIME_PER_STAGE = 1800;
    public static final int PROTECTION_TIME = 6000;

    public FossilMultiblockStructure(@NotNull BlockPos monitorPos, @NotNull BlockPos analyzerPos, @NotNull BlockPos tankBasePos, int animAge, float animPartialTicks) {
        Intrinsics.checkNotNullParameter((Object)monitorPos, (String)"monitorPos");
        Intrinsics.checkNotNullParameter((Object)analyzerPos, (String)"analyzerPos");
        Intrinsics.checkNotNullParameter((Object)tankBasePos, (String)"tankBasePos");
        this.monitorPos = monitorPos;
        this.analyzerPos = analyzerPos;
        this.tankBasePos = tankBasePos;
        this.controllerBlockPos = this.analyzerPos;
        this.timeRemaining = -1;
        this.protectionTime = -1;
        this.runningSound = CobblemonSounds.FOSSIL_MACHINE_ACTIVE_LOOP;
        this.fossilState = new FossilState(animAge, animPartialTicks);
        this.fossilInventory = new ArrayList();
    }

    public /* synthetic */ FossilMultiblockStructure(BlockPos blockPos, BlockPos blockPos2, BlockPos blockPos3, int n, float f, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            n = -1;
        }
        if ((n2 & 0x10) != 0) {
            f = 0.0f;
        }
        this(blockPos, blockPos2, blockPos3, n, f);
    }

    @NotNull
    public final BlockPos getMonitorPos() {
        return this.monitorPos;
    }

    @NotNull
    public final BlockPos getAnalyzerPos() {
        return this.analyzerPos;
    }

    @NotNull
    public final BlockPos getTankBasePos() {
        return this.tankBasePos;
    }

    @Override
    @NotNull
    public BlockPos getControllerBlockPos() {
        return this.controllerBlockPos;
    }

    public final int getOrganicMaterialInside() {
        return this.organicMaterialInside;
    }

    public final boolean getHasCreatedPokemon() {
        return this.hasCreatedPokemon;
    }

    public final int getTimeRemaining() {
        return this.timeRemaining;
    }

    @Nullable
    public final Fossil getResultingFossil() {
        return this.resultingFossil;
    }

    @NotNull
    public final FossilState getFossilState() {
        return this.fossilState;
    }

    @NotNull
    public final List<ItemStack> getFossilInventory() {
        return this.fossilInventory;
    }

    public final void setFossilInventory(@NotNull List<ItemStack> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.fossilInventory = list;
    }

    @Nullable
    public final Direction getTankConnectorDirection() {
        return this.tankConnectorDirection;
    }

    public final void setTankConnectorDirection(@Nullable Direction direction) {
        this.tankConnectorDirection = direction;
    }

    public final int getFillLevel() {
        return this.fillLevel;
    }

    public final void setFillLevel(int n) {
        this.fillLevel = n;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public InteractionResult useWithoutItem(@NotNull BlockState blockState, @NotNull Level world, @NotNull BlockPos blockPos, @NotNull Player player, @NotNull BlockHitResult blockHitResult) {
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)blockHitResult, (String)"blockHitResult");
        ItemStack stack = player.getItemInHand(InteractionHand.MAIN_HAND);
        if (stack.is(CobblemonItemTags.POKE_BALLS) || stack.getItem() instanceof PokeBallItem) {
            if (!(player instanceof ServerPlayer)) {
                return InteractionResult.SUCCESS;
            }
            if (this.hasCreatedPokemon) {
                BlockState monitorState;
                Pokemon pokemon;
                Object object;
                if (this.fossilOwnerUUID != null && !Intrinsics.areEqual((Object)((ServerPlayer)player).getUUID(), (Object)this.fossilOwnerUUID)) {
                    Object ownerName = null;
                    ownerName = "UNKNOWN_USER";
                    Object object2 = DistributionUtilsKt.server();
                    if (object2 != null && (object2 = object2.getProfileCache()) != null && (object2 = object2.get(this.fossilOwnerUUID)) != null && (object2 = (GameProfile)((Optional)object2).orElse(null)) != null && (object2 = object2.getName()) != null) {
                        Object it = object2;
                        boolean bl = false;
                        ownerName = it;
                    }
                    Object[] objectArray = new Object[]{ownerName};
                    ((ServerPlayer)player).sendSystemMessage((Component)LocalizationUtilsKt.lang("fossilmachine.protected", objectArray), true);
                    return InteractionResult.FAIL;
                }
                Item item = stack.getItem();
                Intrinsics.checkNotNull((Object)item, (String)"null cannot be cast to non-null type com.cobblemon.mod.common.item.PokeBallItem");
                PokeBall ballType = ((PokeBallItem)item).getPokeBall();
                ItemStack itemStack = stack;
                if (itemStack != null) {
                    itemStack.consume(1, (LivingEntity)player);
                }
                Pokemon pokemon2 = (object = this.resultingFossil) != null && (object = ((Fossil)object).getResult()) != null ? ((PokemonProperties)object).create((ServerPlayer)player) : (pokemon = null);
                if (pokemon != null) {
                    void $this$iv;
                    pokemon.setCaughtBall(ballType);
                    PlayerExtensionsKt.party((ServerPlayer)player).add(pokemon);
                    this.fossilState.setGrowthState("Taken");
                    player.playSound(CobblemonSounds.FOSSIL_MACHINE_RETRIEVE_POKEMON, 1.0f, 1.0f);
                    EventObservable<FossilRevivedEvent> eventObservable = CobblemonEvents.FOSSIL_REVIVED;
                    FossilRevivedEvent[] fossilRevivedEventArray = new FossilRevivedEvent[]{new FossilRevivedEvent(pokemon, (ServerPlayer)player)};
                    FossilRevivedEvent[] events$iv = fossilRevivedEventArray;
                    boolean $i$f$post = false;
                    $this$iv.emit(Arrays.copyOf(events$iv, events$iv.length));
                    FossilRevivedEvent[] $this$forEach$iv$iv = events$iv;
                    boolean $i$f$forEach = false;
                    int n = $this$forEach$iv$iv.length;
                    for (int i = 0; i < n; ++i) {
                        FossilRevivedEvent element$iv$iv;
                        FossilRevivedEvent fossilRevivedEvent = element$iv$iv = $this$forEach$iv$iv[i];
                        boolean bl = false;
                        FossilRevivedEvent it = fossilRevivedEvent;
                    }
                    CobblemonCriteria.RESURRECT_POKEMON.trigger((ServerPlayer)player, pokemon);
                }
                if ((monitorState = world.getBlockState(this.monitorPos)).hasProperty((Property)MonitorBlock.Companion.getSCREEN()) && !monitorState.equals((Object)MonitorBlock.MonitorScreen.OFF)) {
                    world.setBlockAndUpdate(this.monitorPos, (BlockState)monitorState.setValue((Property)MonitorBlock.Companion.getSCREEN(), (Comparable)((Object)MonitorBlock.MonitorScreen.OFF)));
                }
                this.hasCreatedPokemon = false;
                this.fossilOwnerUUID = null;
                this.protectionTime = -1;
                this.updateFossilType(world);
                this.syncToClient(world);
                this.markDirty(world);
                return InteractionResult.SUCCESS;
            }
        }
        if (player.getItemInHand(InteractionHand.MAIN_HAND).isEmpty()) {
            if (!this.isRunning() && !this.hasCreatedPokemon) {
                if (this.fossilInventory.isEmpty()) {
                    return InteractionResult.CONSUME;
                }
                player.setItemInHand(InteractionHand.MAIN_HAND, (ItemStack)CollectionsKt.last(this.fossilInventory));
                this.fossilInventory.remove(this.fossilInventory.size() - 1);
                if (!world.isClientSide) {
                    world.playSound(null, this.analyzerPos, CobblemonSounds.FOSSIL_MACHINE_RETRIEVE_FOSSIL, SoundSource.BLOCKS);
                    this.updateFossilType(world);
                    this.syncToClient(world);
                    this.markDirty(world);
                }
            }
            return InteractionResult.CONSUME;
        }
        Intrinsics.checkNotNull((Object)stack);
        if (Fossils.isFossilIngredient(stack)) {
            if (!this.isRunning() && !this.hasCreatedPokemon) {
                if (this.fossilInventory.size() > Cobblemon.INSTANCE.getConfig().getMaxInsertedFossilItems()) {
                    return InteractionResult.FAIL;
                }
                if (player instanceof ServerPlayer) {
                    ItemStack copyFossilStack = stack.copyWithCount(1);
                    stack.consume(1, (LivingEntity)player);
                    this.fossilOwnerUUID = ((ServerPlayer)player).getUUID();
                    Intrinsics.checkNotNull((Object)copyFossilStack);
                    this.fossilInventory.add(copyFossilStack);
                    this.updateFossilType(world);
                    world.playSound(null, this.analyzerPos, CobblemonSounds.FOSSIL_MACHINE_INSERT_FOSSIL, SoundSource.BLOCKS);
                    this.syncToClient(world);
                    this.markDirty(world);
                }
            }
            return InteractionResult.SUCCESS;
        }
        if (NaturalMaterials.isNaturalMaterial(stack)) {
            if (player instanceof ServerPlayer && !this.isRunning() && !this.hasCreatedPokemon && this.organicMaterialInside < 128 && this.insertOrganicMaterial(new ItemStack((ItemLike)stack.getItem(), 1), world)) {
                this.lastInteraction = world.getGameTime();
                if (!player.hasInfiniteMaterials()) {
                    ResourceLocation returnItem = NaturalMaterials.getReturnItem(stack);
                    stack.shrink(1);
                    PlayerExtensionsKt.giveOrDropItemStack(player, new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(returnItem)), false);
                }
            }
            InteractionResult interactionResult = InteractionResult.sidedSuccess((boolean)world.isClientSide);
            Intrinsics.checkNotNullExpressionValue((Object)interactionResult, (String)"sidedSuccess(...)");
            return interactionResult;
        }
        if (stack.is(CobblemonItemTags.FOSSILS)) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean spawn(@NotNull Level world, @NotNull BlockPos pos, @NotNull Direction directionToBehind, @NotNull Pokemon pokemon) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)directionToBehind, (String)"directionToBehind");
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        PokemonEntity entity = new PokemonEntity(world, pokemon, null, 4, null);
        entity.refreshDimensions();
        double width = entity.getBoundingBox().getXsize();
        BlockPos idealPlace = pos.offset(directionToBehind.getNormal().multiply((int)Math.ceil(width / 2.0) + 1));
        AABB box = entity.getDimensions(Pose.STANDING).makeBoundingBox(idealPlace.getCenter().subtract(0.0, 0.5, 0.0));
        for (int i = 0; i < 6; ++i) {
            box = box.move((double)directionToBehind.getNormal().getX(), 0.0, (double)directionToBehind.getNormal().getZ());
            BlockPos blockPos = idealPlace.offset(directionToBehind.getNormal().multiply(i + 1));
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"offset(...)");
            Object object = box;
            Intrinsics.checkNotNull((Object)object);
            BlockPos fixedPosition = this.makeSuitableY(world, blockPos, entity, (AABB)object);
            if (fixedPosition == null) continue;
            entity.setPos(fixedPosition.getCenter().subtract(0.0, 0.5, 0.0));
            if (world.addFreshEntity((Entity)entity)) {
                void $this$iv;
                object = CobblemonEvents.FOSSIL_REVIVED;
                FossilRevivedEvent[] fossilRevivedEventArray = new FossilRevivedEvent[]{new FossilRevivedEvent(pokemon, null)};
                FossilRevivedEvent[] events$iv = fossilRevivedEventArray;
                boolean $i$f$post = false;
                $this$iv.emit(Arrays.copyOf(events$iv, events$iv.length));
                FossilRevivedEvent[] $this$forEach$iv$iv = events$iv;
                boolean $i$f$forEach = false;
                int n = $this$forEach$iv$iv.length;
                for (int j = 0; j < n; ++j) {
                    FossilRevivedEvent element$iv$iv;
                    FossilRevivedEvent fossilRevivedEvent = element$iv$iv = $this$forEach$iv$iv[j];
                    boolean bl = false;
                    FossilRevivedEvent it = fossilRevivedEvent;
                }
                return true;
            }
            Cobblemon.LOGGER.warn("Couldn't spawn resurrected Pok\u00e9mon for some reason");
            break;
        }
        return false;
    }

    public final boolean isSafeFloor(@NotNull Level world, @NotNull BlockPos pos, @NotNull PokemonEntity entity) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        BlockState state = world.getBlockState(pos);
        return state.isAir() ? false : (state.entityCanStandOn((BlockGetter)world, pos, (Entity)entity) || state.entityCanStandOnFace((BlockGetter)world, pos, (Entity)entity, Direction.DOWN) ? true : ((entity.getBehaviour().getMoving().getSwim().getCanWalkOnWater() || entity.getBehaviour().getMoving().getSwim().getCanSwimInWater()) && state.getFluidState().is(FluidTags.WATER) ? true : (entity.getBehaviour().getMoving().getSwim().getCanWalkOnLava() || entity.getBehaviour().getMoving().getSwim().getCanSwimInLava()) && state.getFluidState().is(FluidTags.LAVA)));
    }

    @Nullable
    public final BlockPos makeSuitableY(@NotNull Level world, @NotNull BlockPos pos, @NotNull PokemonEntity entity, @NotNull AABB box) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)box, (String)"box");
        if (world.collidesWithSuffocatingBlock((Entity)entity, box)) {
            for (int i = 1; i < 16; ++i) {
                AABB newBox = box.move(0.5, (double)i, 0.5);
                if (world.collidesWithSuffocatingBlock((Entity)entity, newBox)) continue;
                BlockPos blockPos = pos.offset(0, i - 1, 0);
                Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"offset(...)");
                if (!this.isSafeFloor(world, blockPos, entity)) continue;
                return pos.offset(0, i, 0);
            }
        } else {
            for (int i = 1; i < 16; ++i) {
                AABB newBox = box.move(0.5, -((double)i), 0.5);
                if (!world.collidesWithSuffocatingBlock((Entity)entity, newBox)) continue;
                BlockPos blockPos = pos.offset(0, -i, 0);
                Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"offset(...)");
                if (!this.isSafeFloor(world, blockPos, entity)) continue;
                return pos.offset(0, -i + 1, 0);
            }
        }
        return null;
    }

    @Override
    @Deprecated(message="Deprecated in Java")
    public int getAnalogOutputSignal(@NotNull BlockState state, @Nullable Level world, @Nullable BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (world == null || pos == null) {
            return 0;
        }
        if (Intrinsics.areEqual((Object)this.monitorPos, (Object)pos)) {
            if (this.hasCreatedPokemon) {
                return 15;
            }
            if (!this.isRunning()) {
                return 0;
            }
            return Math.max(15 - this.timeRemaining * 15 / 14400, 1);
        }
        if (Intrinsics.areEqual((Object)this.tankBasePos, (Object)pos) || Intrinsics.areEqual((Object)this.tankBasePos.above(), (Object)pos)) {
            return this.organicMaterialInside * 15 / 128;
        }
        return 0;
    }

    @Override
    public void onTriggerEvent(@Nullable BlockState state, @Nullable ServerLevel world, @Nullable BlockPos pos, @Nullable RandomSource random) {
        if (this.protectionTime <= 0) {
            boolean success;
            Direction direction;
            Object object;
            if (this.hasCreatedPokemon) {
                object = this.resultingFossil;
                if (object == null || (object = ((Fossil)object).getResult()) == null || (object = PokemonProperties.create$default((PokemonProperties)object, null, 1, null)) == null) {
                    return;
                }
            } else {
                return;
            }
            Object wildPokemon = object;
            BlockState blockState = state;
            Direction direction2 = blockState != null && (blockState = (Direction)blockState.getValue((Property)HorizontalDirectionalBlock.FACING)) != null ? blockState.getOpposite() : (direction = null);
            if (pos != null && direction != null && world != null && (success = this.spawn((Level)world, pos, direction, (Pokemon)wildPokemon))) {
                this.fossilState.setGrowthState("Taken");
                this.hasCreatedPokemon = false;
                this.fossilOwnerUUID = null;
                this.protectionTime = -1;
                world.playSound(null, this.tankBasePos, CobblemonSounds.FOSSIL_MACHINE_RETRIEVE_POKEMON, SoundSource.BLOCKS);
                this.updateFossilType((Level)world);
                this.syncToClient((Level)world);
                this.markDirty((Level)world);
            }
        }
    }

    @Override
    public void playerWillDestroy(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable Player player) {
        ItemStack it;
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        Object object;
        Direction direction;
        BlockState tankBaseBlockState;
        BlockState blockState;
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        BlockEntity blockEntity = world.getBlockEntity(this.monitorPos);
        MultiblockEntity monitorEntity = blockEntity instanceof MultiblockEntity ? (MultiblockEntity)blockEntity : null;
        BlockEntity blockEntity2 = world.getBlockEntity(this.analyzerPos);
        MultiblockEntity analyzerEntity = blockEntity2 instanceof MultiblockEntity ? (MultiblockEntity)blockEntity2 : null;
        BlockEntity blockEntity3 = world.getBlockEntity(this.tankBasePos);
        MultiblockEntity tankBaseEntity = blockEntity3 instanceof MultiblockEntity ? (MultiblockEntity)blockEntity3 : null;
        BlockEntity blockEntity4 = world.getBlockEntity(this.tankBasePos.above());
        MultiblockEntity tankTopEntity = blockEntity4 instanceof MultiblockEntity ? (MultiblockEntity)blockEntity4 : null;
        MultiblockEntity multiblockEntity = tankBaseEntity;
        if (multiblockEntity != null && (multiblockEntity = multiblockEntity.getBlockPos()) != null) {
            MultiblockEntity it2 = multiblockEntity;
            boolean bl = false;
            blockState = world.getBlockState((BlockPos)it2);
        } else {
            blockState = null;
        }
        BlockState blockState2 = tankBaseBlockState = blockState;
        Direction direction2 = direction = Intrinsics.areEqual((Object)(blockState2 != null ? blockState2.getBlock() : null), (Object)((Object)CobblemonBlocks.RESTORATION_TANK)) ? ((Direction)tankBaseBlockState.getValue((Property)HorizontalDirectionalBlock.FACING)).getOpposite() : Direction.UP;
        Pokemon wildPokemon = this.hasCreatedPokemon ? ((object = this.resultingFossil) != null && (object = ((Fossil)object).getResult()) != null ? PokemonProperties.create$default((PokemonProperties)object, null, 1, null) : null) : null;
        MultiblockEntity multiblockEntity2 = monitorEntity;
        if (multiblockEntity2 != null) {
            multiblockEntity2.setMultiblockStructure(null);
        }
        MultiblockEntity multiblockEntity3 = analyzerEntity;
        if (multiblockEntity3 != null) {
            multiblockEntity3.setMultiblockStructure(null);
        }
        MultiblockEntity multiblockEntity4 = tankBaseEntity;
        if (multiblockEntity4 != null) {
            multiblockEntity4.setMultiblockStructure(null);
        }
        MultiblockEntity multiblockEntity5 = tankTopEntity;
        if (multiblockEntity5 != null) {
            multiblockEntity5.setMultiblockStructure(null);
        }
        MultiblockEntity multiblockEntity6 = monitorEntity;
        if (multiblockEntity6 != null) {
            multiblockEntity6.setMasterBlockPos(null);
        }
        MultiblockEntity multiblockEntity7 = analyzerEntity;
        if (multiblockEntity7 != null) {
            multiblockEntity7.setMasterBlockPos(null);
        }
        MultiblockEntity multiblockEntity8 = tankBaseEntity;
        if (multiblockEntity8 != null) {
            multiblockEntity8.setMasterBlockPos(null);
        }
        MultiblockEntity multiblockEntity9 = tankTopEntity;
        if (multiblockEntity9 != null) {
            multiblockEntity9.setMasterBlockPos(null);
        }
        if (this.timeRemaining == -1 || this.timeRemaining >= 20) {
            $this$forEach$iv = this.fossilInventory;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (ItemStack)element$iv;
                boolean bl = false;
                ItemStack stack = new ItemStack((ItemLike)it.getItem(), 1);
                Containers.dropItemStack((Level)world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)stack);
            }
        }
        if (tankBaseEntity instanceof RestorationTankBlockEntity) {
            $this$forEach$iv = (Iterable)((RestorationTankBlockEntity)tankBaseEntity).getInv().getItems();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (ItemStack)element$iv;
                boolean bl = false;
                Containers.dropItemStack((Level)world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)it);
            }
        }
        if (wildPokemon != null) {
            Intrinsics.checkNotNull((Object)direction);
            this.spawn(world, pos, direction, wildPokemon);
        }
        this.protectionTime = -1;
        this.updateFossilType(world);
        this.stopMachine(world);
        this.syncToClient(world);
        this.markDirty(world);
    }

    @Override
    public void setRemoved(@NotNull Level world) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        if (world.isClientSide) {
            ResourceLocation resourceLocation = this.runningSound.getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"getLocation(...)");
            BlockEntitySoundTracker.INSTANCE.stop(this.tankBasePos, resourceLocation);
        }
    }

    @Override
    public void tick(@NotNull Level world) {
        int n;
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        if (this.protectionTime > 0) {
            n = this.protectionTime;
            this.protectionTime = n + -1;
        }
        if (this.protectionTime == 0) {
            this.protectionTime = -1;
            this.fossilOwnerUUID = null;
            this.updateProgress(world);
            this.syncToClient(world);
            this.markDirty(world);
            world.playSound(null, this.tankBasePos, CobblemonSounds.FOSSIL_MACHINE_UNPROTECTED, SoundSource.BLOCKS);
        }
        if (this.hasCreatedPokemon) {
            return;
        }
        if (world.isClientSide && this.isRunning() && (world.getGameTime() - this.machineStartTime) % 20L == 0L) {
            ResourceLocation resourceLocation = this.runningSound.getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"getLocation(...)");
            if (!BlockEntitySoundTracker.INSTANCE.isActive(this.tankBasePos, resourceLocation)) {
                BlockEntitySoundTracker.INSTANCE.play(this.tankBasePos, (SoundInstance)new CancellableSoundInstance(this.runningSound, this.tankBasePos, true, 1.0f, 1.0f));
            }
        }
        if (this.timeRemaining == -1 && this.organicMaterialInside >= 128 && this.resultingFossil != null) {
            this.startMachine(world);
            return;
        }
        if (this.timeRemaining >= 0) {
            n = this.timeRemaining;
            this.timeRemaining = n + -1;
        }
        if (this.timeRemaining % 1800 == 0) {
            this.updateProgress(world);
            this.syncToClient(world);
            this.markDirty(world);
        }
        if (this.timeRemaining == 0) {
            world.playSound(null, this.tankBasePos, CobblemonSounds.FOSSIL_MACHINE_FINISHED, SoundSource.BLOCKS);
            this.fossilInventory.clear();
            this.hasCreatedPokemon = true;
            if (this.fossilOwnerUUID != null) {
                this.protectionTime = 6000;
            }
            this.stopMachine(world);
        }
    }

    @Override
    public void syncToClient(@NotNull Level world) {
        MultiblockEntity monitorEntity;
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        BlockEntity blockEntity = world.getBlockEntity(this.tankBasePos);
        MultiblockEntity tankBaseEntity = blockEntity instanceof MultiblockEntity ? (MultiblockEntity)blockEntity : null;
        BlockEntity blockEntity2 = world.getBlockEntity(this.getControllerBlockPos());
        MultiblockEntity analyzerEntity = blockEntity2 instanceof MultiblockEntity ? (MultiblockEntity)blockEntity2 : null;
        BlockEntity blockEntity3 = world.getBlockEntity(this.monitorPos);
        MultiblockEntity multiblockEntity = monitorEntity = blockEntity3 instanceof MultiblockEntity ? (MultiblockEntity)blockEntity3 : null;
        if (tankBaseEntity != null) {
            world.sendBlockUpdated(this.tankBasePos, tankBaseEntity.getBlockState(), tankBaseEntity.getBlockState(), 2);
        }
        if (analyzerEntity != null) {
            world.sendBlockUpdated(this.analyzerPos, analyzerEntity.getBlockState(), analyzerEntity.getBlockState(), 2);
        }
        if (monitorEntity != null) {
            world.sendBlockUpdated(this.monitorPos, monitorEntity.getBlockState(), monitorEntity.getBlockState(), 2);
        }
    }

    @Override
    public void markDirty(@NotNull Level world) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Object[] objectArray = new BlockEntity[]{world.getBlockEntity(this.analyzerPos), world.getBlockEntity(this.tankBasePos), world.getBlockEntity(this.tankBasePos.above()), world.getBlockEntity(this.monitorPos)};
        List entities = CollectionsKt.listOf((Object[])objectArray);
        Iterable $this$forEach$iv = entities;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BlockEntity it = (BlockEntity)element$iv;
            boolean bl = false;
            BlockEntity blockEntity = it;
            if (blockEntity == null) continue;
            blockEntity.setChanged();
        }
    }

    public final void startMachine(@NotNull Level world) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        this.timeRemaining = 14400;
        this.machineStartTime = world.getGameTime();
        world.playSound(null, this.tankBasePos, CobblemonSounds.FOSSIL_MACHINE_ACTIVATE, SoundSource.BLOCKS);
        if (world.isClientSide) {
            BlockEntitySoundTracker.INSTANCE.play(this.tankBasePos, (SoundInstance)new CancellableSoundInstance(this.runningSound, this.tankBasePos, true, 1.0f, 1.0f));
        }
        this.updateOnStatus(world);
        this.updateProgress(world);
        this.syncToClient(world);
        this.markDirty(world);
    }

    public final void stopMachine(@NotNull Level world) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        this.fossilState.setGrowthState("Fully Grown");
        this.timeRemaining = -1;
        this.organicMaterialInside = 0;
        this.fossilInventory.clear();
        if (world.isClientSide) {
            ResourceLocation resourceLocation = CobblemonSounds.FOSSIL_MACHINE_ACTIVE_LOOP.getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"getLocation(...)");
            BlockEntitySoundTracker.INSTANCE.stop(this.tankBasePos, resourceLocation);
        }
        this.updateOnStatus(world);
        this.updateProgress(world);
        this.syncToClient(world);
        this.markDirty(world);
    }

    public final void updateOnStatus(@NotNull Level world) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        BlockPos upperTankPos = this.tankBasePos.above();
        BlockState analyzerState = world.getBlockState(this.analyzerPos);
        BlockState tankState = world.getBlockState(this.tankBasePos.above());
        if (analyzerState.hasProperty((Property)FossilAnalyzerBlock.Companion.getON())) {
            world.setBlockAndUpdate(this.analyzerPos, (BlockState)analyzerState.setValue((Property)FossilAnalyzerBlock.Companion.getON(), (Comparable)Boolean.valueOf(this.timeRemaining >= 0)));
        }
        if (tankState.hasProperty((Property)RestorationTankBlock.Companion.getON())) {
            world.setBlockAndUpdate(upperTankPos, (BlockState)tankState.setValue((Property)RestorationTankBlock.Companion.getON(), (Comparable)Boolean.valueOf(this.timeRemaining >= 0)));
        }
    }

    public final void updateProgress(@NotNull Level world) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        BlockState monitorState = world.getBlockState(this.monitorPos);
        if (monitorState.hasProperty((Property)MonitorBlock.Companion.getSCREEN())) {
            MonitorBlock.MonitorScreen screenID = (float)this.protectionTime > 0.0f ? MonitorBlock.MonitorScreen.GREEN_PROGRESS_9 : (this.timeRemaining <= 0 ? MonitorBlock.MonitorScreen.OFF : this.getProgressScreen((14400 - this.timeRemaining) / 1800));
            world.setBlockAndUpdate(this.monitorPos, (BlockState)monitorState.setValue((Property)MonitorBlock.Companion.getSCREEN(), (Comparable)((Object)screenID)));
        }
    }

    @NotNull
    public final MonitorBlock.MonitorScreen getProgressScreen(int progress) {
        return switch (progress) {
            case 0 -> MonitorBlock.MonitorScreen.BLUE_PROGRESS_1;
            case 1 -> MonitorBlock.MonitorScreen.BLUE_PROGRESS_2;
            case 2 -> MonitorBlock.MonitorScreen.BLUE_PROGRESS_3;
            case 3 -> MonitorBlock.MonitorScreen.BLUE_PROGRESS_4;
            case 4 -> MonitorBlock.MonitorScreen.BLUE_PROGRESS_5;
            case 5 -> MonitorBlock.MonitorScreen.BLUE_PROGRESS_6;
            case 6 -> MonitorBlock.MonitorScreen.BLUE_PROGRESS_7;
            case 7 -> MonitorBlock.MonitorScreen.BLUE_PROGRESS_8;
            case 8 -> MonitorBlock.MonitorScreen.BLUE_PROGRESS_9;
            default -> MonitorBlock.MonitorScreen.OFF;
        };
    }

    public final void updateFossilType(@NotNull Level world) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        if (this.fossilInventory.isEmpty()) {
            if (this.resultingFossil == null) {
                return;
            }
            this.resultingFossil = null;
        } else {
            this.resultingFossil = Fossils.getFossilByItemStacks(this.fossilInventory);
        }
    }

    public final boolean isRunning() {
        return this.timeRemaining > 0;
    }

    public final boolean insertOrganicMaterial(@NotNull ItemStack stack, @NotNull Level world) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Integer natureValue = NaturalMaterials.getContent(stack);
        if (this.timeRemaining > 0 || this.organicMaterialInside >= 128 || natureValue == null) {
            return false;
        }
        if ((natureValue = Integer.valueOf(natureValue * stack.getCount())) <= 0 && this.organicMaterialInside == 0) {
            return false;
        }
        int oldFillStage = this.organicMaterialInside * 8 / 128;
        this.organicMaterialInside = this.organicMaterialInside + natureValue > 128 ? 128 : (this.organicMaterialInside + natureValue < 0 ? 0 : (this.organicMaterialInside += natureValue.intValue()));
        if (this.organicMaterialInside >= 128) {
            world.playSound(null, this.tankBasePos, CobblemonSounds.FOSSIL_MACHINE_DNA_FULL, SoundSource.BLOCKS, 1.0f, 1.0f);
        } else if (world.getGameTime() - this.lastInteraction < 10L) {
            world.playSound(null, this.tankBasePos, CobblemonSounds.FOSSIL_MACHINE_INSERT_DNA_SMALL, SoundSource.BLOCKS, 1.0f, 1.0f);
        } else {
            world.playSound(null, this.tankBasePos, CobblemonSounds.FOSSIL_MACHINE_INSERT_DNA, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        this.markDirty(world);
        if (oldFillStage != this.organicMaterialInside * 8 / 128) {
            this.syncToClient(world);
        }
        return true;
    }

    public final boolean insertFossil(@NotNull ItemStack stack, @NotNull Level world) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        if (this.timeRemaining > 0 || this.fossilInventory.size() == 3) {
            return false;
        }
        int oldFillStage = this.fossilInventory.size();
        this.fossilInventory.add(stack);
        world.playSound(null, this.analyzerPos, CobblemonSounds.FOSSIL_MACHINE_INSERT_FOSSIL, SoundSource.BLOCKS);
        this.updateFossilType(world);
        this.markDirty(world);
        if (oldFillStage != this.fossilInventory.size()) {
            this.syncToClient(world);
        }
        return true;
    }

    @Override
    @NotNull
    public CompoundTag writeToNbt(@NotNull HolderLookup.Provider registryLookup) {
        Intrinsics.checkNotNullParameter((Object)registryLookup, (String)"registryLookup");
        CompoundTag result = new CompoundTag();
        result.put("MonitorPos", NbtUtils.writeBlockPos((BlockPos)this.monitorPos));
        result.put("AnalyzerPos", NbtUtils.writeBlockPos((BlockPos)this.analyzerPos));
        result.put("TankBasePos", NbtUtils.writeBlockPos((BlockPos)this.tankBasePos));
        result.putInt("TimeLeft", this.timeRemaining);
        result.putInt("ProtectedTimeLeft", this.protectionTime);
        UUID uUID = this.fossilOwnerUUID;
        if (uUID != null) {
            UUID it = uUID;
            boolean bl = false;
            result.putUUID("FossilOwner", it);
        }
        result.putInt("OrganicContent", this.organicMaterialInside);
        ListTag fossilInv = new ListTag();
        Iterable $this$forEach$iv = this.fossilInventory;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ItemStack it = (ItemStack)element$iv;
            boolean bl = false;
            fossilInv.add(ItemStack.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)it).getOrThrow());
        }
        result.put("InsertedFossilStacks", (Tag)fossilInv);
        Direction direction = this.tankConnectorDirection;
        result.putString("ConnectorDirection", direction != null ? direction.toString() : null);
        if (this.resultingFossil != null) {
            Fossil fossil = this.resultingFossil;
            Intrinsics.checkNotNull((Object)fossil);
            result.putString("InsertedFossil", fossil.getSerializedName());
        }
        result.putBoolean("HasCreatedPokemon", this.hasCreatedPokemon);
        return result;
    }

    private static final void TICKER$lambda$0(Level world, BlockPos blockPos, BlockState blockState, FossilMultiblockEntity blockEntity) {
        if (blockEntity.getMultiblockStructure() != null) {
            MultiblockStructure multiblockStructure = blockEntity.getMultiblockStructure();
            Intrinsics.checkNotNull((Object)multiblockStructure);
            Intrinsics.checkNotNull((Object)world);
            multiblockStructure.tick(world);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J1\u0010\r\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\r\u0010\u000eR\u001d\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8\u0006\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\b8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\b8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0016R\u0014\u0010\u0018\u001a\u00020\b8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0016R\u0014\u0010\u0019\u001a\u00020\b8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u0016R\u0014\u0010\u001a\u001a\u00020\b8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u0016\u00a8\u0006\u001b"}, d2={"Lcom/cobblemon/mod/common/block/multiblock/FossilMultiblockStructure$Companion;", "", "<init>", "()V", "Lnet/minecraft/nbt/CompoundTag;", "nbt", "Lnet/minecraft/core/HolderLookup$Provider;", "registryLookup", "", "animAge", "", "partialTicks", "Lcom/cobblemon/mod/common/block/multiblock/FossilMultiblockStructure;", "fromNbt", "(Lnet/minecraft/nbt/CompoundTag;Lnet/minecraft/core/HolderLookup$Provider;IF)Lcom/cobblemon/mod/common/block/multiblock/FossilMultiblockStructure;", "Lnet/minecraft/world/level/block/entity/BlockEntityTicker;", "Lcom/cobblemon/mod/common/block/entity/FossilMultiblockEntity;", "TICKER", "Lnet/minecraft/world/level/block/entity/BlockEntityTicker;", "getTICKER", "()Lnet/minecraft/world/level/block/entity/BlockEntityTicker;", "TICKS_PER_MINUTE", "I", "MATERIAL_TO_START", "TIME_TO_TAKE", "TIME_PER_STAGE", "PROTECTION_TIME", "common"})
    @SourceDebugExtension(value={"SMAP\nFossilMultiblockStructure.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FossilMultiblockStructure.kt\ncom/cobblemon/mod/common/block/multiblock/FossilMultiblockStructure$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,675:1\n1869#2,2:676\n*S KotlinDebug\n*F\n+ 1 FossilMultiblockStructure.kt\ncom/cobblemon/mod/common/block/multiblock/FossilMultiblockStructure$Companion\n*L\n649#1:676,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BlockEntityTicker<FossilMultiblockEntity> getTICKER() {
            return TICKER;
        }

        @NotNull
        public final FossilMultiblockStructure fromNbt(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider registryLookup, int animAge, float partialTicks) {
            ListTag listTag;
            Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
            Intrinsics.checkNotNullParameter((Object)registryLookup, (String)"registryLookup");
            Object t = NbtUtils.readBlockPos((CompoundTag)nbt, (String)"MonitorPos").get();
            Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
            BlockPos monitorPos = (BlockPos)t;
            Object t2 = NbtUtils.readBlockPos((CompoundTag)nbt, (String)"AnalyzerPos").get();
            Intrinsics.checkNotNullExpressionValue(t2, (String)"get(...)");
            BlockPos compartmentPos = (BlockPos)t2;
            Object t3 = NbtUtils.readBlockPos((CompoundTag)nbt, (String)"TankBasePos").get();
            Intrinsics.checkNotNullExpressionValue(t3, (String)"get(...)");
            BlockPos tankBasePos = (BlockPos)t3;
            FossilMultiblockStructure result = new FossilMultiblockStructure(monitorPos, compartmentPos, tankBasePos, animAge, partialTicks);
            result.organicMaterialInside = nbt.getInt("OrganicContent");
            result.timeRemaining = nbt.getInt("TimeLeft");
            result.protectionTime = nbt.contains("ProtectedTimeLeft") ? nbt.getInt("ProtectedTimeLeft") : -1;
            result.fossilOwnerUUID = nbt.contains("FossilOwner") ? nbt.getUUID("FossilOwner") : null;
            if (nbt.contains("InsertedFossilStacks")) {
                Tag tag = nbt.get("InsertedFossilStacks");
                Intrinsics.checkNotNull((Object)tag, (String)"null cannot be cast to non-null type net.minecraft.nbt.ListTag");
                listTag = (ListTag)tag;
            } else {
                listTag = new ListTag();
            }
            ListTag fossilInv = listTag;
            List actualFossilList = new ArrayList();
            Iterable $this$forEach$iv = (Iterable)fossilInv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Tag it = (Tag)element$iv;
                boolean bl = false;
                ItemStack.parse((HolderLookup.Provider)registryLookup, (Tag)it).ifPresent(arg_0 -> Companion.fromNbt$lambda$0$0((Function1)new Function1<ItemStack, Unit>((Object)actualFossilList){

                    public final void invoke(ItemStack p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        ((List)this.receiver).add(p0);
                    }
                }, arg_0));
            }
            result.setFossilInventory(actualFossilList);
            result.setTankConnectorDirection(Direction.byName((String)nbt.getString("ConnectorDirection")));
            if (nbt.contains("InsertedFossil")) {
                ResourceLocation id = ResourceLocation.parse((String)nbt.getString("InsertedFossil"));
                Intrinsics.checkNotNull((Object)id);
                Fossil fossil = Fossils.getByIdentifier(id);
                if (fossil != null) {
                    result.resultingFossil = fossil;
                } else {
                    Cobblemon.LOGGER.error("Loaded fossil structure with invalid fossil type: {}", (Object)id);
                }
            }
            if (nbt.contains("CreatedPokemon")) {
                result.hasCreatedPokemon = true;
            } else if (nbt.contains("HasCreatedPokemon")) {
                result.hasCreatedPokemon = nbt.getBoolean("HasCreatedPokemon");
            }
            result.setFillLevel(result.getOrganicMaterialInside() * 8 / 128);
            return result;
        }

        public static /* synthetic */ FossilMultiblockStructure fromNbt$default(Companion companion, CompoundTag compoundTag, HolderLookup.Provider provider, int n, float f, int n2, Object object) {
            if ((n2 & 4) != 0) {
                n = -1;
            }
            if ((n2 & 8) != 0) {
                f = 0.0f;
            }
            return companion.fromNbt(compoundTag, provider, n, f);
        }

        private static final void fromNbt$lambda$0$0(Function1 $tmp0, Object p0) {
            $tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

