/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.client.gui.dialogue.widgets;

import com.cobblemon.mod.common.api.gui.GuiUtilsKt;
import com.cobblemon.mod.common.api.text.TextKt;
import com.cobblemon.mod.common.client.gui.CobblemonRenderable;
import com.cobblemon.mod.common.client.gui.dialogue.DialogueScreen;
import com.cobblemon.mod.common.net.messages.client.dialogue.dto.DialogueInputDTO;
import com.cobblemon.mod.common.net.messages.server.dialogue.InputToDialoguePacket;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u00012\u00020\u0002B9\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\b\b\u0002\u0010\n\u001a\u00020\u0005\u00a2\u0006\u0004\b\u000b\u0010\fJ'\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J/\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0016H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ'\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001fR\u0017\u0010\u0004\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010 \u001a\u0004\b!\u0010\"\u00a8\u0006#"}, d2={"Lcom/cobblemon/mod/common/client/gui/dialogue/widgets/DialogueTextInputWidget;", "Lnet/minecraft/client/gui/components/EditBox;", "Lcom/cobblemon/mod/common/client/gui/CobblemonRenderable;", "Lcom/cobblemon/mod/common/client/gui/dialogue/DialogueScreen;", "dialogueScreen", "", "x", "y", "width", "height", "maxLength", "<init>", "(Lcom/cobblemon/mod/common/client/gui/dialogue/DialogueScreen;IIIII)V", "", "mouseX", "mouseY", "button", "", "mouseClicked", "(DDI)Z", "Lnet/minecraft/client/gui/GuiGraphics;", "context", "", "delta", "", "renderWidget", "(Lnet/minecraft/client/gui/GuiGraphics;IIF)V", "keyCode", "scanCode", "modifiers", "keyPressed", "(III)Z", "Lcom/cobblemon/mod/common/client/gui/dialogue/DialogueScreen;", "getDialogueScreen", "()Lcom/cobblemon/mod/common/client/gui/dialogue/DialogueScreen;", "common"})
public final class DialogueTextInputWidget
extends EditBox
implements CobblemonRenderable {
    @NotNull
    private final DialogueScreen dialogueScreen;

    public DialogueTextInputWidget(@NotNull DialogueScreen dialogueScreen, int x, int y, int width, int height, int maxLength) {
        Intrinsics.checkNotNullParameter((Object)dialogueScreen, (String)"dialogueScreen");
        super(Minecraft.getInstance().font, x, y, width, height, (Component)TextKt.text("gui_dialogue_text_input"));
        this.dialogueScreen = dialogueScreen;
        this.setMaxLength(maxLength);
        this.setFocused(true);
    }

    public /* synthetic */ DialogueTextInputWidget(DialogueScreen dialogueScreen, int n, int n2, int n3, int n4, int n5, int n6, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n6 & 0x20) != 0) {
            n5 = 30;
        }
        this(dialogueScreen, n, n2, n3, n4, n5);
    }

    @NotNull
    public final DialogueScreen getDialogueScreen() {
        return this.dialogueScreen;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.dialogueScreen.renderInput()) {
            return false;
        }
        if (this.dialogueScreen.getDialogueDTO().getDialogueInput().getInputType() != DialogueInputDTO.InputType.TEXT) return false;
        if (this.dialogueScreen.getWaitingForServerUpdate()) {
            return false;
        }
        int n = this.getX();
        int n2 = this.getX() + this.width;
        int n3 = (int)mouseX;
        if (n > n3) return false;
        if (n3 > n2) return false;
        boolean bl = true;
        if (!bl) return false;
        n = this.getY();
        n2 = this.getY() + this.height;
        n3 = (int)mouseY;
        if (n > n3) return false;
        if (n3 > n2) return false;
        boolean bl2 = true;
        if (!bl2) return false;
        this.setFocused(true);
        return true;
    }

    public void renderWidget(@NotNull GuiGraphics context, int mouseX, int mouseY, float delta) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!this.dialogueScreen.renderInput()) {
            return;
        }
        if (this.dialogueScreen.getDialogueDTO().getDialogueInput().getInputType() != DialogueInputDTO.InputType.TEXT || this.dialogueScreen.getWaitingForServerUpdate()) {
            return;
        }
        if (this.getCursorPosition() != this.getValue().length()) {
            this.moveCursorToEnd(Screen.hasShiftDown());
        }
        PoseStack poseStack = context.pose();
        Intrinsics.checkNotNullExpressionValue((Object)poseStack, (String)"pose(...)");
        PoseStack poseStack2 = poseStack;
        int n = this.getX();
        int n2 = this.getY();
        int n3 = this.width;
        int n4 = this.height;
        ResourceLocation resourceLocation = MiscUtilsKt.cobblemonResource("textures/gui/dialogue/dialogue_text_input.png");
        GuiUtilsKt.blitk$default(poseStack2, resourceLocation, n, n2, n4, n3, null, null, null, null, null, null, null, null, null, false, 0.0f, 131008, null);
        Object object = this.isFocused() ? this.getValue() + "|" : this.getValue();
        Intrinsics.checkNotNull((Object)object);
        poseStack2 = TextKt.text((String)object);
        float f = (float)this.getX() + (float)this.width / 2.0f;
        n2 = this.getY() + this.height / 2 - 3;
        GuiUtilsKt.drawCenteredText$default(context, null, (Component)poseStack2, Float.valueOf(f), n2, 0xFFFFFF, true, 2, null);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        switch (keyCode) {
            case 256: 
            case 257: 
            case 335: {
                UUID uUID = this.dialogueScreen.getDialogueDTO().getDialogueInput().getInputId();
                String string = this.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
                this.dialogueScreen.sendToServer(new InputToDialoguePacket(uUID, ((Object)StringsKt.trim((CharSequence)string)).toString()));
            }
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }
}

