/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.client.gui.interact.battleRequest;

import com.cobblemon.mod.common.api.gui.GuiUtilsKt;
import com.cobblemon.mod.common.api.text.TextKt;
import com.cobblemon.mod.common.battles.BattleFormat;
import com.cobblemon.mod.common.client.CobblemonResources;
import com.cobblemon.mod.common.client.battle.ClientBattleChallenge;
import com.cobblemon.mod.common.client.battle.ClientTeamRequest;
import com.cobblemon.mod.common.client.gui.CobblemonRenderable;
import com.cobblemon.mod.common.client.gui.interact.battleRequest.BattleRequestButton;
import com.cobblemon.mod.common.client.gui.interact.battleRequest.BattleRequestNavigationButton;
import com.cobblemon.mod.common.client.gui.interact.battleRequest.BattleResponseButton;
import com.cobblemon.mod.common.client.render.RenderHelperKt;
import com.cobblemon.mod.common.client.requests.ClientPlayerActionRequest;
import com.cobblemon.mod.common.net.messages.client.PlayerInteractOptionsPacket;
import com.cobblemon.mod.common.net.messages.server.BattleChallengePacket;
import com.cobblemon.mod.common.net.messages.server.BattleChallengeResponsePacket;
import com.cobblemon.mod.common.net.messages.server.battle.BattleTeamLeavePacket;
import com.cobblemon.mod.common.net.messages.server.battle.BattleTeamRequestPacket;
import com.cobblemon.mod.common.net.messages.server.battle.BattleTeamResponsePacket;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 42\u00020\u00012\u00020\u0002:\u000245B'\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u000bH\u0014\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0010H\u0014\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0014\u001a\u00020\rH\u0014\u00a2\u0006\u0004\b\u0014\u0010\u0015J\r\u0010\u0016\u001a\u00020\r\u00a2\u0006\u0004\b\u0016\u0010\u0015J/\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u001b\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00170\u001cH\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u000f\u0010 \u001a\u00020\u001fH\u0016\u00a2\u0006\u0004\b \u0010!J\u000f\u0010\"\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\"\u0010\u0015R\u0014\u0010\u0004\u001a\u00020\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010#R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010$R\u0016\u0010\b\u001a\u0004\u0018\u00010\u00078\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010%R$\u0010'\u001a\u00020\u00172\u0006\u0010&\u001a\u00020\u00178\u0002@BX\u0082\u000e\u00a2\u0006\f\n\u0004\b'\u0010(\"\u0004\b)\u0010*R$\u0010+\u001a\u00020\u00172\u0006\u0010&\u001a\u00020\u00178\u0002@BX\u0082\u000e\u00a2\u0006\f\n\u0004\b+\u0010(\"\u0004\b,\u0010*R\u0016\u0010.\u001a\u00020-8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b.\u0010/R\u0016\u00100\u001a\u00020\u001f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b0\u00101R\u0016\u00102\u001a\u00020\u000b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b2\u00103\u00a8\u00066"}, d2={"Lcom/cobblemon/mod/common/client/gui/interact/battleRequest/BattleConfigureGUI;", "Lnet/minecraft/client/gui/screens/Screen;", "Lcom/cobblemon/mod/common/client/gui/CobblemonRenderable;", "Lcom/cobblemon/mod/common/net/messages/client/PlayerInteractOptionsPacket;", "packet", "Lcom/cobblemon/mod/common/client/battle/ClientBattleChallenge;", "activeRequest", "Lcom/cobblemon/mod/common/client/battle/ClientTeamRequest;", "activeTeamRequest", "<init>", "(Lcom/cobblemon/mod/common/net/messages/client/PlayerInteractOptionsPacket;Lcom/cobblemon/mod/common/client/battle/ClientBattleChallenge;Lcom/cobblemon/mod/common/client/battle/ClientTeamRequest;)V", "", "delta", "", "renderBlurredBackground", "(F)V", "Lnet/minecraft/client/gui/GuiGraphics;", "context", "renderMenuBackground", "(Lnet/minecraft/client/gui/GuiGraphics;)V", "init", "()V", "updateRequestButtonText", "", "mouseX", "mouseY", "render", "(Lnet/minecraft/client/gui/GuiGraphics;IIF)V", "Lkotlin/Pair;", "getDimensions", "()Lkotlin/Pair;", "", "isPauseScreen", "()Z", "closeGUI", "Lcom/cobblemon/mod/common/net/messages/client/PlayerInteractOptionsPacket;", "Lcom/cobblemon/mod/common/client/battle/ClientBattleChallenge;", "Lcom/cobblemon/mod/common/client/battle/ClientTeamRequest;", "value", "currentPage", "I", "setCurrentPage", "(I)V", "levelRulesetOptionIndex", "setLevelRulesetOptionIndex", "Lnet/minecraft/network/chat/MutableComponent;", "targetName", "Lnet/minecraft/network/chat/MutableComponent;", "hasRequest", "Z", "ticksPassed", "F", "Companion", "BattleTypeTile", "common"})
@SourceDebugExtension(value={"SMAP\nBattleConfigureGUI.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BattleConfigureGUI.kt\ncom/cobblemon/mod/common/client/gui/interact/battleRequest/BattleConfigureGUI\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,457:1\n774#2:458\n865#2,2:459\n774#2:461\n865#2,2:462\n1#3:464\n*S KotlinDebug\n*F\n+ 1 BattleConfigureGUI.kt\ncom/cobblemon/mod/common/client/gui/interact/battleRequest/BattleConfigureGUI\n*L\n213#1:458\n213#1:459,2\n217#1:461\n217#1:462,2\n*E\n"})
public final class BattleConfigureGUI
extends Screen
implements CobblemonRenderable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PlayerInteractOptionsPacket packet;
    @Nullable
    private final ClientBattleChallenge activeRequest;
    @Nullable
    private final ClientTeamRequest activeTeamRequest;
    private int currentPage;
    private int levelRulesetOptionIndex;
    @NotNull
    private MutableComponent targetName;
    private boolean hasRequest;
    private float ticksPassed;
    public static final int SIZE = 113;
    @NotNull
    private static final ResourceLocation backgroundResource = MiscUtilsKt.cobblemonResource("textures/gui/interact/request/battle_request.png");
    @NotNull
    private static final ResourceLocation battleArrowsResource = MiscUtilsKt.cobblemonResource("textures/gui/interact/request/battle_request_arrows.png");
    @Nullable
    private static BattleRequestButton requestButton;
    @Nullable
    private static BattleRequestNavigationButton autoLevelNavButtonLeft;
    @Nullable
    private static BattleRequestNavigationButton autoLevelNavButtonRight;
    @NotNull
    private static final Map<PlayerInteractOptionsPacket.Options, BattleTypeTile> battleRequestMap;
    @NotNull
    private static final List<Integer> levelRulesetOption;
    @NotNull
    private static List<? extends PlayerInteractOptionsPacket.Options> options;
    private static final int blinkRate;

    public BattleConfigureGUI(@NotNull PlayerInteractOptionsPacket packet, @Nullable ClientBattleChallenge activeRequest, @Nullable ClientTeamRequest activeTeamRequest) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        super((Component)LocalizationUtilsKt.lang("ui.challenge.challenge_title", new Object[0]));
        this.packet = packet;
        this.activeRequest = activeRequest;
        this.activeTeamRequest = activeTeamRequest;
        MutableComponent mutableComponent = Component.literal((String)"Target Name");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"literal(...)");
        this.targetName = TextKt.bold(mutableComponent);
    }

    public /* synthetic */ BattleConfigureGUI(PlayerInteractOptionsPacket playerInteractOptionsPacket, ClientBattleChallenge clientBattleChallenge, ClientTeamRequest clientTeamRequest, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            clientBattleChallenge = null;
        }
        if ((n & 4) != 0) {
            clientTeamRequest = null;
        }
        this(playerInteractOptionsPacket, clientBattleChallenge, clientTeamRequest);
    }

    private final void setCurrentPage(int value) {
        this.currentPage = value > 0 && value < ((Collection)options).size() ? value : (value < 0 ? ((Collection)options).size() - 1 : 0);
    }

    private final void setLevelRulesetOptionIndex(int value) {
        this.levelRulesetOptionIndex = value > 0 && value < ((Collection)levelRulesetOption).size() ? value : (value < 0 ? ((Collection)levelRulesetOption).size() - 1 : 0);
    }

    protected void renderBlurredBackground(float delta) {
    }

    protected void renderMenuBackground(@NotNull GuiGraphics context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
    }

    protected void init() {
        ClientPlayerActionRequest pendingRequest;
        LocalPlayer localPlayer = Minecraft.getInstance().player;
        if (localPlayer == null || (localPlayer = localPlayer.level()) == null || (localPlayer = localPlayer.getPlayerByUUID(this.packet.getTargetId())) == null || (localPlayer = localPlayer.getName()) == null || (localPlayer = localPlayer.plainCopy()) == null || (localPlayer = TextKt.bold((MutableComponent)localPlayer)) == null) {
            localPlayer = this.targetName;
        }
        this.targetName = localPlayer;
        ClientTeamRequest clientTeamRequest = this.activeTeamRequest;
        ClientPlayerActionRequest clientPlayerActionRequest = pendingRequest = clientTeamRequest != null ? (ClientPlayerActionRequest)clientTeamRequest : (ClientPlayerActionRequest)this.activeRequest;
        if (this.activeTeamRequest != null) {
            options = CollectionsKt.listOf((Object)((Object)PlayerInteractOptionsPacket.Options.TEAM_REQUEST));
        } else if (this.activeRequest != null) {
            Set<PlayerInteractOptionsPacket.Options> set = this.packet.getOptions().keySet();
            Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
            Iterable $this$filter$iv = set;
            $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Object object;
                PlayerInteractOptionsPacket.Options it = (PlayerInteractOptionsPacket.Options)((Object)element$iv$iv);
                boolean bl = false;
                if (!(this.packet.getOptions().get((Object)it) == PlayerInteractOptionsPacket.OptionStatus.AVAILABLE && Intrinsics.areEqual((Object)((object = battleRequestMap.get((Object)it)) != null && (object = ((BattleTypeTile)object).getBattleFormat()) != null && (object = ((BattleFormat)object).getBattleType()) != null ? object.getName() : null), (Object)this.activeRequest.getBattleFormat().getBattleType().getName()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            options = (List)destination$iv$iv;
            int level = this.activeRequest.getBattleFormat().getAdjustLevel();
            this.setLevelRulesetOptionIndex(Math.max(0, levelRulesetOption.indexOf(level)));
        } else {
            Set<PlayerInteractOptionsPacket.Options> set = this.packet.getOptions().keySet();
            Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
            Iterable $this$filter$iv = set;
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                PlayerInteractOptionsPacket.Options it = (PlayerInteractOptionsPacket.Options)((Object)element$iv$iv);
                boolean bl = false;
                if (!(this.packet.getOptions().get((Object)it) == PlayerInteractOptionsPacket.OptionStatus.AVAILABLE && battleRequestMap.containsKey((Object)it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            options = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        }
        Pair<Integer, Integer> pair = this.getDimensions();
        int x = ((Number)pair.component1()).intValue();
        int y = ((Number)pair.component2()).intValue();
        if (pendingRequest != null) {
            this.addRenderableWidget((GuiEventListener)new BattleResponseButton(x + 22, y + 99, true, arg_0 -> BattleConfigureGUI.init$lambda$2(this, pendingRequest, arg_0)));
            this.addRenderableWidget((GuiEventListener)new BattleResponseButton(x + 56, y + 99, false, arg_0 -> BattleConfigureGUI.init$lambda$3(this, pendingRequest, arg_0)));
        } else {
            MutableComponent mutableComponent = LocalizationUtilsKt.lang("ui.challenge.challenge", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"lang(...)");
            BattleRequestButton battleRequestButton = requestButton = new BattleRequestButton(x + 22, y + 99, mutableComponent, arg_0 -> BattleConfigureGUI.init$lambda$4(this, arg_0));
            if (battleRequestButton != null) {
                BattleRequestButton it = battleRequestButton;
                boolean bl = false;
                BattleRequestButton cfr_ignored_0 = (BattleRequestButton)this.addRenderableWidget((GuiEventListener)it);
            }
            this.addRenderableWidget((GuiEventListener)new BattleRequestNavigationButton(x + 2, y + 30, 96, false, null, null, arg_0 -> BattleConfigureGUI.init$lambda$6(this, arg_0), 48, null));
            this.addRenderableWidget((GuiEventListener)new BattleRequestNavigationButton(x + 106, y + 30, 96, true, null, null, arg_0 -> BattleConfigureGUI.init$lambda$7(this, arg_0), 48, null));
            BattleTypeTile battleTypeTile = battleRequestMap.get((Object)options.get(this.currentPage));
            if ((battleTypeTile != null ? battleTypeTile.getOption() : null) != PlayerInteractOptionsPacket.Options.TEAM_REQUEST) {
                int n = x + 15;
                int n2 = y + 76;
                ResourceLocation resourceLocation = MiscUtilsKt.cobblemonResource("textures/gui/interact/request/label_arrow_left.png");
                Button.OnPress onPress = arg_0 -> BattleConfigureGUI.init$lambda$8(this, arg_0);
                autoLevelNavButtonLeft = new BattleRequestNavigationButton(n, n2, 0, false, null, resourceLocation, onPress, 20, null);
                this.addRenderableWidget((GuiEventListener)autoLevelNavButtonLeft);
                n = x + 94;
                n2 = y + 76;
                resourceLocation = MiscUtilsKt.cobblemonResource("textures/gui/interact/request/label_arrow_right.png");
                onPress = arg_0 -> BattleConfigureGUI.init$lambda$9(this, arg_0);
                autoLevelNavButtonRight = new BattleRequestNavigationButton(n, n2, 0, true, resourceLocation, null, onPress, 36, null);
                this.addRenderableWidget((GuiEventListener)autoLevelNavButtonRight);
            }
        }
    }

    public final void updateRequestButtonText() {
        BattleRequestButton it = requestButton;
        boolean bl = false;
        if (it != null) {
            BattleTypeTile battleTypeTile = battleRequestMap.get((Object)options.get(this.currentPage));
            if (battleTypeTile == null || (battleTypeTile = battleTypeTile.getButtonText()) == null) {
                MutableComponent mutableComponent = LocalizationUtilsKt.lang("ui.challenge.challenge", new Object[0]);
                battleTypeTile = mutableComponent;
                Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"lang(...)");
            }
            it.setText((MutableComponent)battleTypeTile);
        }
    }

    public void render(@NotNull GuiGraphics context, int mouseX, int mouseY, float delta) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.ticksPassed += delta;
        BattleTypeTile battleTypeTile = battleRequestMap.get((Object)options.get(this.currentPage));
        if (battleTypeTile == null) {
            return;
        }
        BattleTypeTile battleTypeData = battleTypeTile;
        Pair<Integer, Integer> pair = this.getDimensions();
        int x = ((Number)pair.component1()).intValue();
        int y = ((Number)pair.component2()).intValue();
        PoseStack poseStack = context.pose();
        Intrinsics.checkNotNullExpressionValue((Object)poseStack, (String)"pose(...)");
        PoseStack poseStack2 = poseStack;
        Object[] objectArray = backgroundResource;
        GuiUtilsKt.blitk$default(poseStack2, (ResourceLocation)objectArray, x, y, 126, 113, null, null, null, null, null, null, null, null, null, false, 0.0f, 131008, null);
        RenderHelperKt.drawScaledText$default(context, CobblemonResources.INSTANCE.getDEFAULT_LARGE(), battleTypeData.getTitle(), x + 42, y + 2, 0.0f, null, 0, 0, true, true, null, null, 6624, null);
        PoseStack poseStack3 = context.pose();
        Intrinsics.checkNotNullExpressionValue((Object)poseStack3, (String)"pose(...)");
        poseStack2 = poseStack3;
        objectArray = battleTypeData.getTileTexture();
        int n = 2 * (x + 56 - 47);
        int n2 = 2 * (y + 63 - 30 - 10);
        GuiUtilsKt.blitk$default(poseStack2, (ResourceLocation)objectArray, n, n2, 120, 190, null, null, null, null, null, null, null, null, null, false, 0.5f, 65472, null);
        if (this.ticksPassed % (float)blinkRate < (float)(blinkRate / 2)) {
            PoseStack poseStack4 = context.pose();
            Intrinsics.checkNotNullExpressionValue((Object)poseStack4, (String)"pose(...)");
            poseStack2 = poseStack4;
            objectArray = battleTypeData.getOverlayTexture();
            n = 2 * (x + 56 - 47);
            n2 = 2 * (y + 63 - 30 - 10);
            GuiUtilsKt.blitk$default(poseStack2, (ResourceLocation)objectArray, n, n2, 120, 190, null, null, null, null, null, null, null, null, null, false, 0.5f, 65472, null);
        }
        RenderHelperKt.drawScaledText$default(context, CobblemonResources.INSTANCE.getDEFAULT_LARGE(), battleTypeData.getSubTitle(), x + 55, y + 14, 0.0f, null, 0, 0, true, true, null, null, 6624, null);
        BattleTypeTile battleTypeTile2 = battleRequestMap.get((Object)options.get(this.currentPage));
        if ((battleTypeTile2 != null ? battleTypeTile2.getOption() : null) != PlayerInteractOptionsPacket.Options.TEAM_REQUEST) {
            MutableComponent mutableComponent;
            ResourceLocation resourceLocation = CobblemonResources.INSTANCE.getDEFAULT_LARGE();
            if (((Number)levelRulesetOption.get(this.levelRulesetOptionIndex)).intValue() < 0) {
                MutableComponent mutableComponent2 = LocalizationUtilsKt.lang("challenge.rule.anything_goes", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)mutableComponent2, (String)"lang(...)");
                mutableComponent = TextKt.bold(mutableComponent2);
            } else {
                objectArray = new Object[]{levelRulesetOption.get(this.levelRulesetOptionIndex)};
                MutableComponent mutableComponent3 = LocalizationUtilsKt.lang("challenge.rule.level", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)mutableComponent3, (String)"lang(...)");
                mutableComponent = TextKt.bold(mutableComponent3);
            }
            RenderHelperKt.drawScaledText$default(context, resourceLocation, mutableComponent, x + 55, y + 75, 0.0f, null, 0, 0, true, true, null, null, 6624, null);
            it = autoLevelNavButtonLeft;
            boolean bl = false;
            if (it != null) {
                it.active = true;
            }
            it = autoLevelNavButtonRight;
            boolean bl2 = false;
            if (it != null) {
                it.active = true;
            }
        } else {
            it = autoLevelNavButtonLeft;
            boolean bl = false;
            if (it != null) {
                it.active = false;
            }
            it = autoLevelNavButtonRight;
            boolean bl3 = false;
            if (it != null) {
                it.active = false;
            }
        }
        RenderHelperKt.drawScaledText$default(context, CobblemonResources.INSTANCE.getDEFAULT_LARGE(), this.targetName, x + 55, y + 87, 0.0f, null, 0, 0, true, true, null, null, 6624, null);
        PoseStack poseStack5 = context.pose();
        Intrinsics.checkNotNullExpressionValue((Object)poseStack5, (String)"pose(...)");
        poseStack2 = poseStack5;
        objectArray = battleArrowsResource;
        n = x + 1;
        n2 = y + 106;
        float f = (float)(battleTypeData.getColor() >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(battleTypeData.getColor() >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(battleTypeData.getColor() & 0xFF) / 255.0f;
        GuiUtilsKt.blitk$default(poseStack2, (ResourceLocation)objectArray, n, n2, 5, 111, null, null, null, null, null, Float.valueOf(f), Float.valueOf(f2), Float.valueOf(f3), null, false, 1.0f, 51136, null);
        super.render(context, mouseX, mouseY, delta);
    }

    private final Pair<Integer, Integer> getDimensions() {
        return new Pair((Object)((this.width - 113) / 2), (Object)((this.height - 113) / 2));
    }

    public boolean isPauseScreen() {
        return false;
    }

    private final void closeGUI() {
        Minecraft.getInstance().setScreen(null);
    }

    private static final void init$lambda$2(BattleConfigureGUI this$0, ClientPlayerActionRequest $pendingRequest, Button it) {
        Function3<PlayerInteractOptionsPacket, UUID, Boolean, Unit> function3 = battleRequestMap.get((Object)options.get(this$0.currentPage));
        if (function3 != null && (function3 = function3.getOnResponse()) != null) {
            Function3<PlayerInteractOptionsPacket, UUID, Boolean, Unit> it1 = function3;
            boolean bl = false;
            it1.invoke((Object)this$0.packet, (Object)$pendingRequest.getRequestID(), (Object)true);
        }
        this$0.closeGUI();
    }

    private static final void init$lambda$3(BattleConfigureGUI this$0, ClientPlayerActionRequest $pendingRequest, Button it) {
        Function3<PlayerInteractOptionsPacket, UUID, Boolean, Unit> function3 = battleRequestMap.get((Object)options.get(this$0.currentPage));
        if (function3 != null && (function3 = function3.getOnResponse()) != null) {
            Function3<PlayerInteractOptionsPacket, UUID, Boolean, Unit> it1 = function3;
            boolean bl = false;
            it1.invoke((Object)this$0.packet, (Object)$pendingRequest.getRequestID(), (Object)false);
        }
        this$0.closeGUI();
    }

    private static final void init$lambda$4(BattleConfigureGUI this$0, Button it) {
        Function2<PlayerInteractOptionsPacket, BattleFormat, Unit> function2 = battleRequestMap.get((Object)options.get(this$0.currentPage));
        if (function2 != null && (function2 = function2.getOnRequest()) != null) {
            Function2<PlayerInteractOptionsPacket, BattleFormat, Unit> it1 = function2;
            boolean bl = false;
            Object object = battleRequestMap.get((Object)options.get(this$0.currentPage));
            if (object == null || (object = ((BattleTypeTile)object).getBattleFormat()) == null) {
                object = BattleFormat.Companion.getGEN_9_SINGLES();
            }
            Object battleFormat = object;
            int level = ((Number)levelRulesetOption.get(this$0.levelRulesetOptionIndex)).intValue();
            ((BattleFormat)battleFormat).setAdjustLevel(level);
            it1.invoke((Object)this$0.packet, battleFormat);
        }
        this$0.closeGUI();
    }

    private static final void init$lambda$6(BattleConfigureGUI this$0, Button it) {
        this$0.setCurrentPage((this$0.currentPage - 1) % ((Collection)options).size());
        this$0.updateRequestButtonText();
    }

    private static final void init$lambda$7(BattleConfigureGUI this$0, Button it) {
        this$0.setCurrentPage((this$0.currentPage + 1) % ((Collection)options).size());
        this$0.updateRequestButtonText();
    }

    private static final void init$lambda$8(BattleConfigureGUI this$0, Button it) {
        this$0.setLevelRulesetOptionIndex(this$0.levelRulesetOptionIndex - 1);
    }

    private static final void init$lambda$9(BattleConfigureGUI this$0, Button it) {
        this$0.setLevelRulesetOptionIndex(this$0.levelRulesetOptionIndex + 1);
    }

    private static final Unit battleRequestMap$lambda$0(PlayerInteractOptionsPacket packet, BattleFormat battleFormat) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        Intrinsics.checkNotNullParameter((Object)battleFormat, (String)"battleFormat");
        Companion.sendBattleRequest(battleFormat, packet);
        return Unit.INSTANCE;
    }

    private static final Unit battleRequestMap$lambda$1(PlayerInteractOptionsPacket packet, UUID requestID, boolean accept) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        Intrinsics.checkNotNullParameter((Object)requestID, (String)"requestID");
        BattleConfigureGUI.Companion.sendBattleResponse(packet, requestID, accept);
        return Unit.INSTANCE;
    }

    private static final Unit battleRequestMap$lambda$2(PlayerInteractOptionsPacket packet, BattleFormat battleFormat) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        Intrinsics.checkNotNullParameter((Object)battleFormat, (String)"battleFormat");
        Companion.sendBattleRequest(battleFormat, packet);
        return Unit.INSTANCE;
    }

    private static final Unit battleRequestMap$lambda$3(PlayerInteractOptionsPacket packet, UUID requestID, boolean accept) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        Intrinsics.checkNotNullParameter((Object)requestID, (String)"requestID");
        BattleConfigureGUI.Companion.sendBattleResponse(packet, requestID, accept);
        return Unit.INSTANCE;
    }

    private static final Unit battleRequestMap$lambda$4(PlayerInteractOptionsPacket packet, BattleFormat battleFormat) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        Intrinsics.checkNotNullParameter((Object)battleFormat, (String)"battleFormat");
        Companion.sendBattleRequest(battleFormat, packet);
        return Unit.INSTANCE;
    }

    private static final Unit battleRequestMap$lambda$5(PlayerInteractOptionsPacket packet, UUID requestID, boolean accept) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        Intrinsics.checkNotNullParameter((Object)requestID, (String)"requestID");
        BattleConfigureGUI.Companion.sendBattleResponse(packet, requestID, accept);
        return Unit.INSTANCE;
    }

    private static final Unit battleRequestMap$lambda$6(PlayerInteractOptionsPacket packet, BattleFormat battleFormat) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        Intrinsics.checkNotNullParameter((Object)battleFormat, (String)"battleFormat");
        new BattleTeamRequestPacket(packet.getNumericTargetId()).sendToServer();
        return Unit.INSTANCE;
    }

    private static final Unit battleRequestMap$lambda$7(PlayerInteractOptionsPacket packet, UUID requestID, boolean accept) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        Intrinsics.checkNotNullParameter((Object)requestID, (String)"requestID");
        BattleConfigureGUI.Companion.sendTeamResponse(packet, requestID, accept);
        return Unit.INSTANCE;
    }

    private static final Unit battleRequestMap$lambda$8(PlayerInteractOptionsPacket playerInteractOptionsPacket, BattleFormat battleFormat) {
        Intrinsics.checkNotNullParameter((Object)playerInteractOptionsPacket, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)battleFormat, (String)"<unused var>");
        new BattleTeamLeavePacket().sendToServer();
        return Unit.INSTANCE;
    }

    private static final Unit battleRequestMap$lambda$9(PlayerInteractOptionsPacket playerInteractOptionsPacket, UUID uUID, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)playerInteractOptionsPacket, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)uUID, (String)"<unused var>");
        return Unit.INSTANCE;
    }

    private static final Unit battleRequestMap$lambda$10(PlayerInteractOptionsPacket packet, BattleFormat battleFormat) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        Intrinsics.checkNotNullParameter((Object)battleFormat, (String)"battleFormat");
        Companion.sendBattleRequest(battleFormat, packet);
        return Unit.INSTANCE;
    }

    private static final Unit battleRequestMap$lambda$11(PlayerInteractOptionsPacket packet, UUID requestID, boolean accept) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        Intrinsics.checkNotNullParameter((Object)requestID, (String)"requestID");
        BattleConfigureGUI.Companion.sendBattleResponse(packet, requestID, accept);
        return Unit.INSTANCE;
    }

    private static final Unit battleRequestMap$lambda$12(PlayerInteractOptionsPacket packet, BattleFormat battleFormat) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        Intrinsics.checkNotNullParameter((Object)battleFormat, (String)"battleFormat");
        Companion.sendBattleRequest(battleFormat, packet);
        return Unit.INSTANCE;
    }

    private static final Unit battleRequestMap$lambda$13(PlayerInteractOptionsPacket packet, UUID requestID, boolean accept) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        Intrinsics.checkNotNullParameter((Object)requestID, (String)"requestID");
        BattleConfigureGUI.Companion.sendBattleResponse(packet, requestID, accept);
        return Unit.INSTANCE;
    }

    static {
        Object[] objectArray = new Pair[7];
        BattleFormat battleFormat = BattleFormat.Companion.getGEN_9_SINGLES();
        ResourceLocation resourceLocation = MiscUtilsKt.cobblemonResource("textures/gui/interact/request/battle_request_single.png");
        ResourceLocation resourceLocation2 = MiscUtilsKt.cobblemonResource("textures/gui/interact/request/battle_request_overlay.png");
        MutableComponent mutableComponent = LocalizationUtilsKt.lang("ui.challenge.challenge_title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"lang(...)");
        MutableComponent mutableComponent2 = TextKt.bold(mutableComponent);
        MutableComponent mutableComponent3 = LocalizationUtilsKt.lang("battle.types.singles", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent3, (String)"lang(...)");
        MutableComponent mutableComponent4 = TextKt.bold(mutableComponent3);
        MutableComponent mutableComponent5 = LocalizationUtilsKt.lang("ui.challenge.challenge", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent5, (String)"lang(...)");
        objectArray[0] = new Pair((Object)PlayerInteractOptionsPacket.Options.SINGLE_BATTLE, (Object)new BattleTypeTile(PlayerInteractOptionsPacket.Options.SINGLE_BATTLE, battleFormat, resourceLocation, resourceLocation2, mutableComponent2, mutableComponent4, TextKt.bold(mutableComponent5), 0, BattleConfigureGUI::battleRequestMap$lambda$0, BattleConfigureGUI::battleRequestMap$lambda$1, 128, null));
        BattleFormat battleFormat2 = BattleFormat.Companion.getGEN_9_DOUBLES();
        ResourceLocation resourceLocation3 = MiscUtilsKt.cobblemonResource("textures/gui/interact/request/battle_request_double.png");
        ResourceLocation resourceLocation4 = MiscUtilsKt.cobblemonResource("textures/gui/interact/request/battle_request_overlay.png");
        MutableComponent mutableComponent6 = LocalizationUtilsKt.lang("ui.challenge.challenge_title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent6, (String)"lang(...)");
        MutableComponent mutableComponent7 = TextKt.bold(mutableComponent6);
        MutableComponent mutableComponent8 = LocalizationUtilsKt.lang("battle.types.doubles", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent8, (String)"lang(...)");
        MutableComponent mutableComponent9 = TextKt.bold(mutableComponent8);
        MutableComponent mutableComponent10 = LocalizationUtilsKt.lang("ui.challenge.challenge", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent10, (String)"lang(...)");
        objectArray[1] = new Pair((Object)PlayerInteractOptionsPacket.Options.DOUBLE_BATTLE, (Object)new BattleTypeTile(PlayerInteractOptionsPacket.Options.DOUBLE_BATTLE, battleFormat2, resourceLocation3, resourceLocation4, mutableComponent7, mutableComponent9, TextKt.bold(mutableComponent10), 0, BattleConfigureGUI::battleRequestMap$lambda$2, BattleConfigureGUI::battleRequestMap$lambda$3, 128, null));
        BattleFormat battleFormat3 = BattleFormat.Companion.getGEN_9_TRIPLES();
        ResourceLocation resourceLocation5 = MiscUtilsKt.cobblemonResource("textures/gui/interact/request/battle_request_triple.png");
        ResourceLocation resourceLocation6 = MiscUtilsKt.cobblemonResource("textures/gui/interact/request/battle_request_overlay.png");
        MutableComponent mutableComponent11 = LocalizationUtilsKt.lang("ui.challenge.challenge_title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent11, (String)"lang(...)");
        MutableComponent mutableComponent12 = TextKt.bold(mutableComponent11);
        MutableComponent mutableComponent13 = LocalizationUtilsKt.lang("battle.types.triples", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent13, (String)"lang(...)");
        MutableComponent mutableComponent14 = TextKt.bold(mutableComponent13);
        MutableComponent mutableComponent15 = LocalizationUtilsKt.lang("ui.challenge.challenge", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent15, (String)"lang(...)");
        objectArray[2] = new Pair((Object)PlayerInteractOptionsPacket.Options.TRIPLE_BATTLE, (Object)new BattleTypeTile(PlayerInteractOptionsPacket.Options.TRIPLE_BATTLE, battleFormat3, resourceLocation5, resourceLocation6, mutableComponent12, mutableComponent14, TextKt.bold(mutableComponent15), 0, BattleConfigureGUI::battleRequestMap$lambda$4, BattleConfigureGUI::battleRequestMap$lambda$5, 128, null));
        BattleFormat battleFormat4 = BattleFormat.Companion.getGEN_9_MULTI();
        ResourceLocation resourceLocation7 = MiscUtilsKt.cobblemonResource("textures/gui/interact/request/battle_request_multi.png");
        ResourceLocation resourceLocation8 = MiscUtilsKt.cobblemonResource("textures/gui/interact/request/battle_request_multi_overlay_partner.png");
        MutableComponent mutableComponent16 = LocalizationUtilsKt.lang("ui.team.invite_title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent16, (String)"lang(...)");
        MutableComponent mutableComponent17 = TextKt.bold(mutableComponent16);
        MutableComponent mutableComponent18 = LocalizationUtilsKt.lang("battle.types.multi", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent18, (String)"lang(...)");
        MutableComponent mutableComponent19 = TextKt.bold(mutableComponent18);
        MutableComponent mutableComponent20 = LocalizationUtilsKt.lang("ui.team.invite", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent20, (String)"lang(...)");
        objectArray[3] = new Pair((Object)PlayerInteractOptionsPacket.Options.TEAM_REQUEST, (Object)new BattleTypeTile(PlayerInteractOptionsPacket.Options.TEAM_REQUEST, battleFormat4, resourceLocation7, resourceLocation8, mutableComponent17, mutableComponent19, TextKt.bold(mutableComponent20), 3457708, (Function2<? super PlayerInteractOptionsPacket, ? super BattleFormat, Unit>)((Function2)BattleConfigureGUI::battleRequestMap$lambda$6), (Function3<? super PlayerInteractOptionsPacket, ? super UUID, ? super Boolean, Unit>)((Function3)BattleConfigureGUI::battleRequestMap$lambda$7)));
        BattleFormat battleFormat5 = BattleFormat.Companion.getGEN_9_MULTI();
        ResourceLocation resourceLocation9 = MiscUtilsKt.cobblemonResource("textures/gui/interact/request/battle_request_multi.png");
        ResourceLocation resourceLocation10 = MiscUtilsKt.cobblemonResource("textures/gui/interact/request/battle_request_multi_overlay_partner_leave.png");
        MutableComponent mutableComponent21 = LocalizationUtilsKt.lang("ui.team.leave_title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent21, (String)"lang(...)");
        MutableComponent mutableComponent22 = TextKt.bold(mutableComponent21);
        MutableComponent mutableComponent23 = LocalizationUtilsKt.lang("battle.types.multi", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent23, (String)"lang(...)");
        MutableComponent mutableComponent24 = TextKt.bold(mutableComponent23);
        MutableComponent mutableComponent25 = LocalizationUtilsKt.lang("ui.team.leave", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent25, (String)"lang(...)");
        objectArray[4] = new Pair((Object)PlayerInteractOptionsPacket.Options.TEAM_LEAVE, (Object)new BattleTypeTile(PlayerInteractOptionsPacket.Options.TEAM_LEAVE, battleFormat5, resourceLocation9, resourceLocation10, mutableComponent22, mutableComponent24, TextKt.bold(mutableComponent25), 3457708, (Function2<? super PlayerInteractOptionsPacket, ? super BattleFormat, Unit>)((Function2)BattleConfigureGUI::battleRequestMap$lambda$8), (Function3<? super PlayerInteractOptionsPacket, ? super UUID, ? super Boolean, Unit>)((Function3)BattleConfigureGUI::battleRequestMap$lambda$9)));
        BattleFormat battleFormat6 = BattleFormat.Companion.getGEN_9_MULTI();
        ResourceLocation resourceLocation11 = MiscUtilsKt.cobblemonResource("textures/gui/interact/request/battle_request_multi.png");
        ResourceLocation resourceLocation12 = MiscUtilsKt.cobblemonResource("textures/gui/interact/request/battle_request_multi_overlay_opponent.png");
        MutableComponent mutableComponent26 = LocalizationUtilsKt.lang("ui.challenge.challenge_title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent26, (String)"lang(...)");
        MutableComponent mutableComponent27 = TextKt.bold(mutableComponent26);
        MutableComponent mutableComponent28 = LocalizationUtilsKt.lang("battle.types.multi", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent28, (String)"lang(...)");
        MutableComponent mutableComponent29 = TextKt.bold(mutableComponent28);
        MutableComponent mutableComponent30 = LocalizationUtilsKt.lang("ui.challenge.challenge", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent30, (String)"lang(...)");
        objectArray[5] = new Pair((Object)PlayerInteractOptionsPacket.Options.MULTI_BATTLE, (Object)new BattleTypeTile(PlayerInteractOptionsPacket.Options.MULTI_BATTLE, battleFormat6, resourceLocation11, resourceLocation12, mutableComponent27, mutableComponent29, TextKt.bold(mutableComponent30), 0, BattleConfigureGUI::battleRequestMap$lambda$10, BattleConfigureGUI::battleRequestMap$lambda$11, 128, null));
        BattleFormat battleFormat7 = BattleFormat.Companion.getGEN_9_ROYAL();
        ResourceLocation resourceLocation13 = MiscUtilsKt.cobblemonResource("textures/gui/interact/request/battle_request_royal.png");
        ResourceLocation resourceLocation14 = MiscUtilsKt.cobblemonResource("textures/gui/interact/request/battle_request_royal_overlay.png");
        MutableComponent mutableComponent31 = LocalizationUtilsKt.lang("ui.challenge.challenge_title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent31, (String)"lang(...)");
        MutableComponent mutableComponent32 = TextKt.bold(mutableComponent31);
        MutableComponent mutableComponent33 = LocalizationUtilsKt.lang("battle.types.freeforall", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent33, (String)"lang(...)");
        MutableComponent mutableComponent34 = TextKt.bold(mutableComponent33);
        MutableComponent mutableComponent35 = LocalizationUtilsKt.lang("ui.challenge.challenge", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent35, (String)"lang(...)");
        objectArray[6] = new Pair((Object)PlayerInteractOptionsPacket.Options.ROYAL_BATTLE, (Object)new BattleTypeTile(PlayerInteractOptionsPacket.Options.ROYAL_BATTLE, battleFormat7, resourceLocation13, resourceLocation14, mutableComponent32, mutableComponent34, TextKt.bold(mutableComponent35), 0, BattleConfigureGUI::battleRequestMap$lambda$12, BattleConfigureGUI::battleRequestMap$lambda$13, 128, null));
        battleRequestMap = MapsKt.mutableMapOf((Pair[])objectArray);
        objectArray = new Integer[]{-1, 50, 100, 5};
        levelRulesetOption = CollectionsKt.mutableListOf((Object[])objectArray);
        options = CollectionsKt.emptyList();
        blinkRate = 35;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u001d\u0018\u00002\u00020\u0001B\u00d2\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\t\u0012\u0006\u0010\f\u001a\u00020\t\u0012\b\b\u0002\u0010\u000e\u001a\u00020\r\u00126\u0010\u0015\u001a2\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0013\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0005\u0012\u0004\u0012\u00020\u00140\u000f\u0012K\u0010\u001b\u001aG\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0013\u0012\u0013\u0012\u00110\u0017\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0018\u0012\u0013\u0012\u00110\u0019\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u001a\u0012\u0004\u0012\u00020\u00140\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001e\u001a\u0004\b\u001f\u0010 R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010!\u001a\u0004\b\"\u0010#R\u0019\u0010\u0007\u001a\u0004\u0018\u00010\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010$\u001a\u0004\b%\u0010&R\u0019\u0010\b\u001a\u0004\u0018\u00010\u00068\u0006\u00a2\u0006\f\n\u0004\b\b\u0010$\u001a\u0004\b'\u0010&R\u0017\u0010\n\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\n\u0010(\u001a\u0004\b)\u0010*R\u0017\u0010\u000b\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\u000b\u0010(\u001a\u0004\b+\u0010*R\u0017\u0010\f\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\f\u0010(\u001a\u0004\b,\u0010*R\u0017\u0010\u000e\u001a\u00020\r8\u0006\u00a2\u0006\f\n\u0004\b\u000e\u0010-\u001a\u0004\b.\u0010/RG\u0010\u0015\u001a2\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0013\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0005\u0012\u0004\u0012\u00020\u00140\u000f8\u0006\u00a2\u0006\f\n\u0004\b\u0015\u00100\u001a\u0004\b1\u00102R\\\u0010\u001b\u001aG\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0013\u0012\u0013\u0012\u00110\u0017\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0018\u0012\u0013\u0012\u00110\u0019\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u001a\u0012\u0004\u0012\u00020\u00140\u00168\u0006\u00a2\u0006\f\n\u0004\b\u001b\u00103\u001a\u0004\b4\u00105\u00a8\u00066"}, d2={"Lcom/cobblemon/mod/common/client/gui/interact/battleRequest/BattleConfigureGUI$BattleTypeTile;", "", "Lcom/cobblemon/mod/common/net/messages/client/PlayerInteractOptionsPacket$Options;", "option", "Lcom/cobblemon/mod/common/battles/BattleFormat;", "battleFormat", "Lnet/minecraft/resources/ResourceLocation;", "tileTexture", "overlayTexture", "Lnet/minecraft/network/chat/MutableComponent;", "title", "subTitle", "buttonText", "", "color", "Lkotlin/Function2;", "Lcom/cobblemon/mod/common/net/messages/client/PlayerInteractOptionsPacket;", "Lkotlin/ParameterName;", "name", "packet", "", "onRequest", "Lkotlin/Function3;", "Ljava/util/UUID;", "requestID", "", "accept", "onResponse", "<init>", "(Lcom/cobblemon/mod/common/net/messages/client/PlayerInteractOptionsPacket$Options;Lcom/cobblemon/mod/common/battles/BattleFormat;Lnet/minecraft/resources/ResourceLocation;Lnet/minecraft/resources/ResourceLocation;Lnet/minecraft/network/chat/MutableComponent;Lnet/minecraft/network/chat/MutableComponent;Lnet/minecraft/network/chat/MutableComponent;ILkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function3;)V", "Lcom/cobblemon/mod/common/net/messages/client/PlayerInteractOptionsPacket$Options;", "getOption", "()Lcom/cobblemon/mod/common/net/messages/client/PlayerInteractOptionsPacket$Options;", "Lcom/cobblemon/mod/common/battles/BattleFormat;", "getBattleFormat", "()Lcom/cobblemon/mod/common/battles/BattleFormat;", "Lnet/minecraft/resources/ResourceLocation;", "getTileTexture", "()Lnet/minecraft/resources/ResourceLocation;", "getOverlayTexture", "Lnet/minecraft/network/chat/MutableComponent;", "getTitle", "()Lnet/minecraft/network/chat/MutableComponent;", "getSubTitle", "getButtonText", "I", "getColor", "()I", "Lkotlin/jvm/functions/Function2;", "getOnRequest", "()Lkotlin/jvm/functions/Function2;", "Lkotlin/jvm/functions/Function3;", "getOnResponse", "()Lkotlin/jvm/functions/Function3;", "common"})
    public static final class BattleTypeTile {
        @NotNull
        private final PlayerInteractOptionsPacket.Options option;
        @NotNull
        private final BattleFormat battleFormat;
        @Nullable
        private final ResourceLocation tileTexture;
        @Nullable
        private final ResourceLocation overlayTexture;
        @NotNull
        private final MutableComponent title;
        @NotNull
        private final MutableComponent subTitle;
        @NotNull
        private final MutableComponent buttonText;
        private final int color;
        @NotNull
        private final Function2<PlayerInteractOptionsPacket, BattleFormat, Unit> onRequest;
        @NotNull
        private final Function3<PlayerInteractOptionsPacket, UUID, Boolean, Unit> onResponse;

        public BattleTypeTile(@NotNull PlayerInteractOptionsPacket.Options option, @NotNull BattleFormat battleFormat, @Nullable ResourceLocation tileTexture, @Nullable ResourceLocation overlayTexture, @NotNull MutableComponent title, @NotNull MutableComponent subTitle, @NotNull MutableComponent buttonText, int color, @NotNull Function2<? super PlayerInteractOptionsPacket, ? super BattleFormat, Unit> onRequest, @NotNull Function3<? super PlayerInteractOptionsPacket, ? super UUID, ? super Boolean, Unit> onResponse) {
            Intrinsics.checkNotNullParameter((Object)((Object)option), (String)"option");
            Intrinsics.checkNotNullParameter((Object)battleFormat, (String)"battleFormat");
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter((Object)subTitle, (String)"subTitle");
            Intrinsics.checkNotNullParameter((Object)buttonText, (String)"buttonText");
            Intrinsics.checkNotNullParameter(onRequest, (String)"onRequest");
            Intrinsics.checkNotNullParameter(onResponse, (String)"onResponse");
            this.option = option;
            this.battleFormat = battleFormat;
            this.tileTexture = tileTexture;
            this.overlayTexture = overlayTexture;
            this.title = title;
            this.subTitle = subTitle;
            this.buttonText = buttonText;
            this.color = color;
            this.onRequest = onRequest;
            this.onResponse = onResponse;
        }

        public /* synthetic */ BattleTypeTile(PlayerInteractOptionsPacket.Options options, BattleFormat battleFormat, ResourceLocation resourceLocation, ResourceLocation resourceLocation2, MutableComponent mutableComponent, MutableComponent mutableComponent2, MutableComponent mutableComponent3, int n, Function2 function2, Function3 function3, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 0x80) != 0) {
                n = 2724857;
            }
            this(options, battleFormat, resourceLocation, resourceLocation2, mutableComponent, mutableComponent2, mutableComponent3, n, (Function2<? super PlayerInteractOptionsPacket, ? super BattleFormat, Unit>)function2, (Function3<? super PlayerInteractOptionsPacket, ? super UUID, ? super Boolean, Unit>)function3);
        }

        @NotNull
        public final PlayerInteractOptionsPacket.Options getOption() {
            return this.option;
        }

        @NotNull
        public final BattleFormat getBattleFormat() {
            return this.battleFormat;
        }

        @Nullable
        public final ResourceLocation getTileTexture() {
            return this.tileTexture;
        }

        @Nullable
        public final ResourceLocation getOverlayTexture() {
            return this.overlayTexture;
        }

        @NotNull
        public final MutableComponent getTitle() {
            return this.title;
        }

        @NotNull
        public final MutableComponent getSubTitle() {
            return this.subTitle;
        }

        @NotNull
        public final MutableComponent getButtonText() {
            return this.buttonText;
        }

        public final int getColor() {
            return this.color;
        }

        @NotNull
        public final Function2<PlayerInteractOptionsPacket, BattleFormat, Unit> getOnRequest() {
            return this.onRequest;
        }

        @NotNull
        public final Function3<PlayerInteractOptionsPacket, UUID, Boolean, Unit> getOnResponse() {
            return this.onResponse;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001d\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000f\u0010\u0010J'\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u0011\u0010\fR\u0014\u0010\u0013\u001a\u00020\u00128\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0016\u001a\u00020\u00158\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00158\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0017R\u0018\u0010\u001a\u001a\u0004\u0018\u00010\u00198\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001bR$\u0010\u001d\u001a\u0004\u0018\u00010\u001c8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R$\u0010#\u001a\u0004\u0018\u00010\u001c8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b#\u0010\u001e\u001a\u0004\b$\u0010 \"\u0004\b%\u0010\"R#\u0010)\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020(0&8\u0006\u00a2\u0006\f\n\u0004\b)\u0010*\u001a\u0004\b+\u0010,R\u001d\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00120-8\u0006\u00a2\u0006\f\n\u0004\b.\u0010/\u001a\u0004\b0\u00101R\u001c\u00103\u001a\b\u0012\u0004\u0012\u00020'028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b3\u0010/R\u0014\u00104\u001a\u00020\u00128\u0002X\u0082D\u00a2\u0006\u0006\n\u0004\b4\u0010\u0014\u00a8\u00065"}, d2={"Lcom/cobblemon/mod/common/client/gui/interact/battleRequest/BattleConfigureGUI$Companion;", "", "<init>", "()V", "Lcom/cobblemon/mod/common/net/messages/client/PlayerInteractOptionsPacket;", "packet", "Ljava/util/UUID;", "requestID", "", "accept", "", "sendTeamResponse", "(Lcom/cobblemon/mod/common/net/messages/client/PlayerInteractOptionsPacket;Ljava/util/UUID;Z)V", "Lcom/cobblemon/mod/common/battles/BattleFormat;", "battleFormat", "sendBattleRequest", "(Lcom/cobblemon/mod/common/battles/BattleFormat;Lcom/cobblemon/mod/common/net/messages/client/PlayerInteractOptionsPacket;)V", "sendBattleResponse", "", "SIZE", "I", "Lnet/minecraft/resources/ResourceLocation;", "backgroundResource", "Lnet/minecraft/resources/ResourceLocation;", "battleArrowsResource", "Lcom/cobblemon/mod/common/client/gui/interact/battleRequest/BattleRequestButton;", "requestButton", "Lcom/cobblemon/mod/common/client/gui/interact/battleRequest/BattleRequestButton;", "Lcom/cobblemon/mod/common/client/gui/interact/battleRequest/BattleRequestNavigationButton;", "autoLevelNavButtonLeft", "Lcom/cobblemon/mod/common/client/gui/interact/battleRequest/BattleRequestNavigationButton;", "getAutoLevelNavButtonLeft", "()Lcom/cobblemon/mod/common/client/gui/interact/battleRequest/BattleRequestNavigationButton;", "setAutoLevelNavButtonLeft", "(Lcom/cobblemon/mod/common/client/gui/interact/battleRequest/BattleRequestNavigationButton;)V", "autoLevelNavButtonRight", "getAutoLevelNavButtonRight", "setAutoLevelNavButtonRight", "", "Lcom/cobblemon/mod/common/net/messages/client/PlayerInteractOptionsPacket$Options;", "Lcom/cobblemon/mod/common/client/gui/interact/battleRequest/BattleConfigureGUI$BattleTypeTile;", "battleRequestMap", "Ljava/util/Map;", "getBattleRequestMap", "()Ljava/util/Map;", "", "levelRulesetOption", "Ljava/util/List;", "getLevelRulesetOption", "()Ljava/util/List;", "", "options", "blinkRate", "common"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final BattleRequestNavigationButton getAutoLevelNavButtonLeft() {
            return autoLevelNavButtonLeft;
        }

        public final void setAutoLevelNavButtonLeft(@Nullable BattleRequestNavigationButton battleRequestNavigationButton) {
            autoLevelNavButtonLeft = battleRequestNavigationButton;
        }

        @Nullable
        public final BattleRequestNavigationButton getAutoLevelNavButtonRight() {
            return autoLevelNavButtonRight;
        }

        public final void setAutoLevelNavButtonRight(@Nullable BattleRequestNavigationButton battleRequestNavigationButton) {
            autoLevelNavButtonRight = battleRequestNavigationButton;
        }

        @NotNull
        public final Map<PlayerInteractOptionsPacket.Options, BattleTypeTile> getBattleRequestMap() {
            return battleRequestMap;
        }

        @NotNull
        public final List<Integer> getLevelRulesetOption() {
            return levelRulesetOption;
        }

        private final void sendTeamResponse(PlayerInteractOptionsPacket packet, UUID requestID, boolean accept) {
            new BattleTeamResponsePacket(packet.getNumericTargetId(), requestID, accept).sendToServer();
        }

        public final void sendBattleRequest(@NotNull BattleFormat battleFormat, @NotNull PlayerInteractOptionsPacket packet) {
            Intrinsics.checkNotNullParameter((Object)battleFormat, (String)"battleFormat");
            Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
            new BattleChallengePacket(packet.getNumericTargetId(), packet.getSelectedPokemonId(), battleFormat).sendToServer();
        }

        private final void sendBattleResponse(PlayerInteractOptionsPacket packet, UUID requestID, boolean accept) {
            new BattleChallengeResponsePacket(packet.getNumericTargetId(), requestID, packet.getSelectedPokemonId(), accept).sendToServer();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

