/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.client.gui.npc;

import com.cobblemon.mod.common.api.gui.GuiUtilsKt;
import com.cobblemon.mod.common.api.text.TextKt;
import com.cobblemon.mod.common.client.gui.CobblemonRenderable;
import com.cobblemon.mod.common.client.gui.behaviour.BehaviourEditorScreen;
import com.cobblemon.mod.common.client.gui.npc.NPCEditorButton;
import com.cobblemon.mod.common.client.gui.npc.widgets.ConfigVariableList;
import com.cobblemon.mod.common.client.gui.npc.widgets.NPCRenderWidget;
import com.cobblemon.mod.common.client.gui.npc.widgets.SimpleNPCTextInputWidget;
import com.cobblemon.mod.common.client.render.RenderHelperKt;
import com.cobblemon.mod.common.net.messages.client.npc.dto.NPCConfigurationDTO;
import com.cobblemon.mod.common.net.messages.server.npc.SaveNPCPacket;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0016\u0018\u0000 )2\u00020\u00012\u00020\u0002:\u0001)B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\n\u001a\u00020\tH\u0014\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\u000e\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\fH\u0014\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0010H\u0014\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0015\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J/\u0010\u0019\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aR\u0017\u0010\u0004\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u001b\u001a\u0004\b\u001c\u0010\u001dR\u0017\u0010\u0006\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u001e\u001a\u0004\b\u001f\u0010 R\u0011\u0010\"\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u001dR\u0011\u0010$\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u001dR\u0011\u0010&\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u001dR\u0011\u0010(\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u001d\u00a8\u0006*"}, d2={"Lcom/cobblemon/mod/common/client/gui/npc/NPCEditorScreen;", "Lnet/minecraft/client/gui/screens/Screen;", "Lcom/cobblemon/mod/common/client/gui/CobblemonRenderable;", "", "npcId", "Lcom/cobblemon/mod/common/net/messages/client/npc/dto/NPCConfigurationDTO;", "dto", "<init>", "(ILcom/cobblemon/mod/common/net/messages/client/npc/dto/NPCConfigurationDTO;)V", "", "init", "()V", "", "delta", "renderBlurredBackground", "(F)V", "Lnet/minecraft/client/gui/GuiGraphics;", "context", "renderMenuBackground", "(Lnet/minecraft/client/gui/GuiGraphics;)V", "", "isPauseScreen", "()Z", "mouseX", "mouseY", "render", "(Lnet/minecraft/client/gui/GuiGraphics;IIF)V", "I", "getNpcId", "()I", "Lcom/cobblemon/mod/common/net/messages/client/npc/dto/NPCConfigurationDTO;", "getDto", "()Lcom/cobblemon/mod/common/net/messages/client/npc/dto/NPCConfigurationDTO;", "getMiddleX", "middleX", "getMiddleY", "middleY", "getLeftX", "leftX", "getTopY", "topY", "Companion", "common"})
@SourceDebugExtension(value={"SMAP\nNPCEditorScreen.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NPCEditorScreen.kt\ncom/cobblemon/mod/common/client/gui/npc/NPCEditorScreen\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,131:1\n1563#2:132\n1634#2,3:133\n*S KotlinDebug\n*F\n+ 1 NPCEditorScreen.kt\ncom/cobblemon/mod/common/client/gui/npc/NPCEditorScreen\n*L\n66#1:132\n66#1:133,3\n*E\n"})
public final class NPCEditorScreen
extends Screen
implements CobblemonRenderable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int npcId;
    @NotNull
    private final NPCConfigurationDTO dto;
    public static final int BASE_WIDTH = 360;
    public static final int BASE_HEIGHT = 220;
    @NotNull
    private static final ResourceLocation baseResource = MiscUtilsKt.cobblemonResource("textures/gui/npc/base.png");

    public NPCEditorScreen(int npcId, @NotNull NPCConfigurationDTO dto) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        super((Component)MiscUtilsKt.asTranslated("gui.npc_editor.title"));
        this.npcId = npcId;
        this.dto = dto;
    }

    public final int getNpcId() {
        return this.npcId;
    }

    @NotNull
    public final NPCConfigurationDTO getDto() {
        return this.dto;
    }

    public final int getMiddleX() {
        Minecraft minecraft = this.minecraft;
        Intrinsics.checkNotNull((Object)minecraft);
        return minecraft.getWindow().getGuiScaledWidth() / 2;
    }

    public final int getMiddleY() {
        Minecraft minecraft = this.minecraft;
        Intrinsics.checkNotNull((Object)minecraft);
        return minecraft.getWindow().getGuiScaledHeight() / 2;
    }

    public final int getLeftX() {
        return this.getMiddleX() - 180;
    }

    public final int getTopY() {
        return this.getMiddleY() - 110;
    }

    protected void init() {
        super.init();
        this.addRenderableOnly(new NPCRenderWidget(this.getLeftX() + 12, this.getTopY() + 35, this.dto.getNpcUUID(), this.dto.getResourceIdentifier(), this.dto.getAspects()));
        this.addRenderableWidget((GuiEventListener)new SimpleNPCTextInputWidget(() -> NPCEditorScreen.init$lambda$0(this), null, arg_0 -> NPCEditorScreen.init$lambda$1(this, arg_0), this.getLeftX() + 12, this.getTopY() + 9, 192, 22, 32, false, false, 770, null));
        this.addRenderableWidget((GuiEventListener)new SimpleNPCTextInputWidget(() -> NPCEditorScreen.init$lambda$2(this), null, arg_0 -> NPCEditorScreen.init$lambda$3(this, arg_0), this.getLeftX() + 12, this.getTopY() + 155, 116, 40, 72, false, true, 258, null));
        this.addRenderableWidget((GuiEventListener)new NPCEditorButton((float)this.getLeftX() + 348.0f, (float)this.getTopY() + 201.0f, LocalizationUtilsKt.lang("ui.generic.save", new Object[0]), null, 0, null, null, false, true, arg_0 -> NPCEditorScreen.init$lambda$4(this, arg_0), 248, null));
        this.addRenderableWidget((GuiEventListener)new NPCEditorButton((float)this.getLeftX() + 12.0f, (float)this.getTopY() + 201.0f, LocalizationUtilsKt.lang("ui.entity.behaviour_editor", new Object[0]), null, 0, null, null, false, false, arg_0 -> NPCEditorScreen.init$lambda$5(this, arg_0), 504, null));
        this.addRenderableWidget((GuiEventListener)new ConfigVariableList(this.getLeftX() + 134, this.getTopY() + 35, this));
    }

    protected void renderBlurredBackground(float delta) {
    }

    protected void renderMenuBackground(@NotNull GuiGraphics context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void render(@NotNull GuiGraphics context, int mouseX, int mouseY, float delta) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        PoseStack poseStack = context.pose();
        Intrinsics.checkNotNullExpressionValue((Object)poseStack, (String)"pose(...)");
        GuiUtilsKt.blitk$default(poseStack, baseResource, this.getLeftX(), this.getTopY(), 220, 360, null, null, null, null, null, null, null, null, null, false, 0.0f, 131008, null);
        Object extendedId = String.valueOf(this.npcId);
        while (((String)extendedId).length() < 12) {
            extendedId = "0" + (String)extendedId;
        }
        RenderHelperKt.drawScaledTextJustifiedRight$default(context, TextKt.text((String)extendedId), this.getLeftX() + 348, this.getTopY() + 9, 0.0f, 0.0f, null, 0, true, 240, null);
        super.render(context, mouseX, mouseY, delta);
    }

    private static final String init$lambda$0(NPCEditorScreen this$0) {
        String string = this$0.dto.getNpcName().getString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        return string;
    }

    private static final Unit init$lambda$1(NPCEditorScreen this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.dto.setNpcName(TextKt.text(it));
        return Unit.INSTANCE;
    }

    private static final String init$lambda$2(NPCEditorScreen this$0) {
        return CollectionsKt.joinToString$default((Iterable)this$0.dto.getAspects(), null, null, null, (int)0, null, null, (int)63, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit init$lambda$3(NPCEditorScreen this$0, String it) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.dto.getAspects().clear();
        Object object = new String[]{","};
        object = StringsKt.split$default((CharSequence)it, (String[])object, (boolean)false, (int)0, (int)6, null);
        Set<String> set = this$0.dto.getAspects();
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Object)StringsKt.trim((CharSequence)((CharSequence)it2))).toString());
        }
        set.addAll((List)destination$iv$iv);
        return Unit.INSTANCE;
    }

    private static final void init$lambda$4(NPCEditorScreen this$0, Button it) {
        new SaveNPCPacket(this$0.npcId, this$0.dto).sendToServer();
        Minecraft minecraft = this$0.minecraft;
        Intrinsics.checkNotNull((Object)minecraft);
        minecraft.setScreen(null);
    }

    private static final void init$lambda$5(NPCEditorScreen this$0, Button it) {
        Minecraft minecraft = this$0.minecraft;
        Intrinsics.checkNotNull((Object)minecraft);
        ClientLevel clientLevel = minecraft.level;
        Intrinsics.checkNotNull((Object)clientLevel);
        Entity entity = clientLevel.getEntity(this$0.npcId);
        LivingEntity livingEntity = entity instanceof LivingEntity ? (LivingEntity)entity : null;
        if (livingEntity == null) {
            return;
        }
        LivingEntity entity2 = livingEntity;
        Minecraft minecraft2 = this$0.minecraft;
        Intrinsics.checkNotNull((Object)minecraft2);
        minecraft2.setScreen((Screen)new BehaviourEditorScreen(entity2, this$0.dto.getBehaviours()));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0006R\u0017\u0010\t\u001a\u00020\b8\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/cobblemon/mod/common/client/gui/npc/NPCEditorScreen$Companion;", "", "<init>", "()V", "", "BASE_WIDTH", "I", "BASE_HEIGHT", "Lnet/minecraft/resources/ResourceLocation;", "baseResource", "Lnet/minecraft/resources/ResourceLocation;", "getBaseResource", "()Lnet/minecraft/resources/ResourceLocation;", "common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ResourceLocation getBaseResource() {
            return baseResource;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

