/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.client.render.block;

import com.cobblemon.mod.common.api.berry.Berries;
import com.cobblemon.mod.common.api.berry.Berry;
import com.cobblemon.mod.common.block.PokeSnackBlock;
import com.cobblemon.mod.common.block.entity.PokeSnackBlockEntity;
import com.cobblemon.mod.common.client.render.atlas.CobblemonAtlases;
import com.cobblemon.mod.common.client.render.models.blockbench.ModelPartExtensionsKt;
import com.cobblemon.mod.common.client.render.models.blockbench.repository.BerryModelRepository;
import com.cobblemon.mod.common.item.components.IngredientComponent;
import com.cobblemon.mod.common.util.math.geometry.Axis;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J?\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J5\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0015\u0010\u0016J=\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lcom/cobblemon/mod/common/client/render/block/PokeSnackBlockEntityRenderer;", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRenderer;", "Lcom/cobblemon/mod/common/block/entity/PokeSnackBlockEntity;", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;", "ctx", "<init>", "(Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;)V", "blockEntity", "", "partialTick", "Lcom/mojang/blaze3d/vertex/PoseStack;", "poseStack", "Lnet/minecraft/client/renderer/MultiBufferSource;", "bufferSource", "", "packedLight", "packedOverlay", "", "render", "(Lcom/cobblemon/mod/common/block/entity/PokeSnackBlockEntity;FLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;II)V", "", "renderCandle", "(Lcom/cobblemon/mod/common/block/entity/PokeSnackBlockEntity;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;II)Z", "hasCandle", "renderBerries", "(Lcom/cobblemon/mod/common/block/entity/PokeSnackBlockEntity;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;IIZ)V", "common"})
@SourceDebugExtension(value={"SMAP\nPokeSnackBlockEntityRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PokeSnackBlockEntityRenderer.kt\ncom/cobblemon/mod/common/client/render/block/PokeSnackBlockEntityRenderer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,150:1\n1617#2,9:151\n1869#2:160\n1870#2:162\n1626#2:163\n1878#2,3:164\n1#3:161\n*S KotlinDebug\n*F\n+ 1 PokeSnackBlockEntityRenderer.kt\ncom/cobblemon/mod/common/client/render/block/PokeSnackBlockEntityRenderer\n*L\n81#1:151,9\n81#1:160\n81#1:162\n81#1:163\n83#1:164,3\n81#1:161\n*E\n"})
public class PokeSnackBlockEntityRenderer
implements BlockEntityRenderer<PokeSnackBlockEntity> {
    public PokeSnackBlockEntityRenderer(@NotNull BlockEntityRendererProvider.Context ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
    }

    public void render(@NotNull PokeSnackBlockEntity blockEntity, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        Direction facing;
        Intrinsics.checkNotNullParameter((Object)blockEntity, (String)"blockEntity");
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Intrinsics.checkNotNullParameter((Object)bufferSource, (String)"bufferSource");
        poseStack.pushPose();
        Direction direction = facing = (Direction)blockEntity.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING);
        float rotationAngle = switch (direction == null ? -1 : WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
            case 1 -> 180.0f;
            case 2 -> 0.0f;
            case 3 -> 90.0f;
            case 4 -> -90.0f;
            default -> 0.0f;
        };
        poseStack.translate(0.5, 0.5, 0.5);
        poseStack.mulPose(com.mojang.math.Axis.YP.rotationDegrees(rotationAngle));
        poseStack.translate(-0.5, -0.5, -0.5);
        boolean hasCandle = this.renderCandle(blockEntity, poseStack, bufferSource, packedLight, packedOverlay);
        this.renderBerries(blockEntity, poseStack, bufferSource, packedLight, packedOverlay, hasCandle);
        poseStack.popPose();
    }

    public final boolean renderCandle(@NotNull PokeSnackBlockEntity blockEntity, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        Intrinsics.checkNotNullParameter((Object)blockEntity, (String)"blockEntity");
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Intrinsics.checkNotNullParameter((Object)bufferSource, (String)"bufferSource");
        Integer candleId = (Integer)blockEntity.getBlockState().getValue((Property)PokeSnackBlock.Companion.getCANDLE());
        if (candleId > 0) {
            Comparable comparable = blockEntity.getBlockState().getValue((Property)PokeSnackBlock.Companion.getCANDLE());
            Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"getValue(...)");
            Block candleBlock = PokeSnackBlock.Companion.getCandleById(((Number)((Object)comparable)).intValue());
            poseStack.pushPose();
            poseStack.translate(0.0, 0.4375, 0.0);
            Minecraft.getInstance().getBlockRenderer().renderSingleBlock((BlockState)candleBlock.defaultBlockState().setValue((Property)BlockStateProperties.LIT, blockEntity.getBlockState().getValue((Property)BlockStateProperties.LIT)), poseStack, bufferSource, packedLight, packedOverlay);
            poseStack.popPose();
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final void renderBerries(@NotNull PokeSnackBlockEntity blockEntity, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight, int packedOverlay, boolean hasCandle) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter((Object)blockEntity, (String)"blockEntity");
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Intrinsics.checkNotNullParameter((Object)bufferSource, (String)"bufferSource");
        VertexConsumer buffer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)CobblemonAtlases.INSTANCE.getBERRY_SPRITE_ATLAS().textureAtlas.location()));
        Object object = blockEntity.getIngredientComponent();
        if (object == null || (object = ((IngredientComponent)object).getIngredientIds()) == null || (object = CollectionsKt.take((Iterable)((Iterable)object), (int)3)) == null) {
            object = CollectionsKt.emptyList();
        }
        Iterable iterable = (Iterable)object;
        boolean $i$f$mapNotNull = false;
        void var11_10 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach2 = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Berry it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            ResourceLocation it = (ResourceLocation)element$iv$iv;
            boolean bl2 = false;
            if (Berries.getByIdentifier(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List berryIngredients = (List)destination$iv$iv;
        Iterable $this$forEachIndexed$iv = berryIngredients;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            ModelPart model;
            void berry;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Berry $i$f$forEach2 = (Berry)item$iv;
            int index = n;
            boolean bl = false;
            if (BerryModelRepository.INSTANCE.modelOf(berry.getFruitModelIdentifier()) == null) {
                return;
            }
            switch (berryIngredients.size()) {
                case 1: {
                    Vec3 pos = berry.getPokeSnackPositionings()[0].getPosition();
                    Vec3 rot = berry.getPokeSnackPositionings()[0].getRotation();
                    if (hasCandle) {
                        ModelPartExtensionsKt.setPosition(model, Axis.X_AXIS.ordinal(), (float)pos.x);
                        ModelPartExtensionsKt.setPosition(model, Axis.Y_AXIS.ordinal(), (float)pos.y);
                        ModelPartExtensionsKt.setPosition(model, Axis.Z_AXIS.ordinal(), (float)pos.z);
                        model.setRotation((float)Math.toRadians(rot.x), (float)Math.toRadians(rot.y), (float)Math.toRadians(rot.z));
                        break;
                    }
                    ModelPartExtensionsKt.setPosition(model, Axis.X_AXIS.ordinal(), 8.0f);
                    ModelPartExtensionsKt.setPosition(model, Axis.Y_AXIS.ordinal(), (float)pos.y);
                    ModelPartExtensionsKt.setPosition(model, Axis.Z_AXIS.ordinal(), 8.0f);
                    model.setRotation((float)Math.toRadians(180.0), (float)Math.toRadians(0.0), (float)Math.toRadians(0.0));
                    break;
                }
                case 2: {
                    Vec3 pos = berry.getPokeSnackPositionings()[0].getPosition();
                    Vec3 rot = berry.getPokeSnackPositionings()[0].getRotation();
                    boolean isFirst = index == 0;
                    ModelPartExtensionsKt.setPosition(model, Axis.X_AXIS.ordinal(), (float)pos.x);
                    ModelPartExtensionsKt.setPosition(model, Axis.Y_AXIS.ordinal(), (float)pos.y);
                    ModelPartExtensionsKt.setPosition(model, Axis.Z_AXIS.ordinal(), isFirst ? (float)pos.z : 16.0f - (float)pos.z);
                    model.setRotation((float)Math.toRadians(isFirst ? rot.x : 180.0 + (180.0 - rot.x)), (float)Math.toRadians(rot.y), (float)Math.toRadians(rot.z));
                    break;
                }
                default: {
                    Vec3 pos = berry.getPokeSnackPositionings()[index].getPosition();
                    Vec3 rot = berry.getPokeSnackPositionings()[index].getRotation();
                    ModelPartExtensionsKt.setPosition(model, Axis.X_AXIS.ordinal(), (float)pos.x);
                    ModelPartExtensionsKt.setPosition(model, Axis.Y_AXIS.ordinal(), (float)pos.y);
                    ModelPartExtensionsKt.setPosition(model, Axis.Z_AXIS.ordinal(), (float)pos.z);
                    model.setRotation((float)Math.toRadians(rot.x), (float)Math.toRadians(rot.y), (float)Math.toRadians(rot.z));
                }
            }
            model.render(poseStack, buffer, packedLight, packedOverlay);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Direction.values().length];
            try {
                nArray[Direction.NORTH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.SOUTH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.WEST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.EAST.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

