/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.client.render.models.blockbench.bedrock.animation;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.client.render.models.blockbench.BedrockAnimationReferenceFactory;
import com.cobblemon.mod.common.client.render.models.blockbench.JsonPose;
import com.cobblemon.mod.common.client.render.models.blockbench.bedrock.animation.BedrockAnimation;
import com.cobblemon.mod.common.client.render.models.blockbench.bedrock.animation.BedrockAnimationAdapter;
import com.cobblemon.mod.common.client.render.models.blockbench.bedrock.animation.BedrockAnimationGroup;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J#\u0010\n\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001f\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0007\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001d\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0010J\u001f\u0010\u0012\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0012\u0010\u0010R\u001c\u0010\u0015\u001a\n \u0014*\u0004\u0018\u00010\u00130\u00138\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016R \u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00180\u00178\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lcom/cobblemon/mod/common/client/render/models/blockbench/bedrock/animation/BedrockAnimationRepository;", "", "<init>", "()V", "Lnet/minecraft/server/packs/resources/ResourceManager;", "resourceManager", "", "", "directories", "", "loadAnimations", "(Lnet/minecraft/server/packs/resources/ResourceManager;Ljava/util/List;)V", "fileName", "animationName", "Lcom/cobblemon/mod/common/client/render/models/blockbench/bedrock/animation/BedrockAnimation;", "tryGetAnimation", "(Ljava/lang/String;Ljava/lang/String;)Lcom/cobblemon/mod/common/client/render/models/blockbench/bedrock/animation/BedrockAnimation;", "getAnimation", "getAnimationOrNull", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "gson", "Lcom/google/gson/Gson;", "", "Lcom/cobblemon/mod/common/client/render/models/blockbench/bedrock/animation/BedrockAnimationGroup;", "animationGroups", "Ljava/util/Map;", "common"})
@SourceDebugExtension(value={"SMAP\nBedrockAnimationRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BedrockAnimationRepository.kt\ncom/cobblemon/mod/common/client/render/models/blockbench/bedrock/animation/BedrockAnimationRepository\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 GsonExtensions.kt\ncom/cobblemon/mod/common/util/GsonExtensionsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,87:1\n216#2:88\n217#2:92\n17#3:89\n1869#4,2:90\n*S KotlinDebug\n*F\n+ 1 BedrockAnimationRepository.kt\ncom/cobblemon/mod/common/client/render/models/blockbench/bedrock/animation/BedrockAnimationRepository\n*L\n45#1:88\n45#1:92\n47#1:89\n48#1:90,2\n*E\n"})
public final class BedrockAnimationRepository {
    @NotNull
    public static final BedrockAnimationRepository INSTANCE = new BedrockAnimationRepository();
    private static final Gson gson = new GsonBuilder().disableHtmlEscaping().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).registerTypeAdapter((Type)((Object)BedrockAnimation.class), (Object)BedrockAnimationAdapter.INSTANCE).create();
    @NotNull
    private static final Map<String, BedrockAnimationGroup> animationGroups = new LinkedHashMap();

    private BedrockAnimationRepository() {
    }

    /*
     * WARNING - void declaration
     */
    public final void loadAnimations(@NotNull ResourceManager resourceManager, @NotNull List<String> directories) {
        Intrinsics.checkNotNullParameter((Object)resourceManager, (String)"resourceManager");
        Intrinsics.checkNotNullParameter(directories, (String)"directories");
        JsonPose.Companion.registerAnimationFactory("bedrock", BedrockAnimationReferenceFactory.INSTANCE);
        Cobblemon.LOGGER.info("Loading animations...");
        int animationCount = 0;
        animationGroups.clear();
        boolean wereValidationErrors = false;
        for (String directory : directories) {
            void $this$forEach$iv;
            Intrinsics.checkNotNullExpressionValue((Object)resourceManager.listResources(directory, BedrockAnimationRepository::loadAnimations$lambda$0), (String)"listResources(...)");
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl = false;
                ResourceLocation identifier2 = (ResourceLocation)entry.getKey();
                Resource resource = (Resource)entry.getValue();
                try {
                    void reader$iv;
                    void $this$fromJson$iv;
                    Intrinsics.checkNotNullExpressionValue((Object)gson, (String)"gson");
                    InputStream inputStream = resource.open();
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"open(...)");
                    Closeable closeable = inputStream;
                    Charset charset = Charsets.UTF_8;
                    closeable = new InputStreamReader((InputStream)closeable, charset);
                    boolean $i$f$fromJson = false;
                    BedrockAnimationGroup animationGroup = (BedrockAnimationGroup)$this$fromJson$iv.fromJson((Reader)reader$iv, BedrockAnimationGroup.class);
                    Iterable $this$forEach$iv2 = animationGroup.getAnimations().entrySet();
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        Map.Entry entry2 = (Map.Entry)element$iv2;
                        boolean bl2 = false;
                        String name = (String)entry2.getKey();
                        BedrockAnimation animation = (BedrockAnimation)entry2.getValue();
                        animation.setName(name);
                        try {
                            animation.checkForErrors();
                        }
                        catch (Throwable e) {
                            Cobblemon.LOGGER.error("Failed to load animation " + name + " in group " + identifier2 + ": " + e.getMessage());
                            wereValidationErrors = true;
                        }
                    }
                    String string = identifier2.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                    String animationGroupName = StringsKt.replace$default((String)StringsKt.substringAfterLast$default((String)string, (String)"/", null, (int)2, null), (String)".animation.json", (String)"", (boolean)false, (int)4, null);
                    animationGroups.put(animationGroupName, animationGroup);
                    animationCount += animationGroup.getAnimations().size();
                }
                catch (Exception e) {
                    Cobblemon.LOGGER.error("Failed to load animation group " + identifier2, (Throwable)e);
                }
            }
        }
        if (wereValidationErrors) {
            Cobblemon.LOGGER.error("There were errors in the animations. See above for details. You should fix these or there might be crashes later.");
        }
        Cobblemon.LOGGER.info("Loaded " + animationCount + " animations from " + animationGroups.size() + " animation groups");
    }

    @Nullable
    public final BedrockAnimation tryGetAnimation(@NotNull String fileName, @NotNull String animationName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)animationName, (String)"animationName");
        BedrockAnimationGroup bedrockAnimationGroup = animationGroups.get(fileName);
        if (bedrockAnimationGroup == null) {
            return null;
        }
        BedrockAnimationGroup animationGroup = bedrockAnimationGroup;
        return animationGroup.getAnimations().get(animationName);
    }

    @NotNull
    public final BedrockAnimation getAnimation(@NotNull String fileName, @NotNull String animationName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)animationName, (String)"animationName");
        BedrockAnimationGroup bedrockAnimationGroup = animationGroups.get(fileName);
        if (bedrockAnimationGroup == null) {
            throw new IllegalArgumentException("Unknown animation group: " + fileName);
        }
        BedrockAnimationGroup animationGroup = bedrockAnimationGroup;
        BedrockAnimation bedrockAnimation = animationGroup.getAnimations().get(animationName);
        if (bedrockAnimation == null) {
            throw new IllegalArgumentException("Animation " + animationName + " not found in animation group " + fileName);
        }
        return bedrockAnimation;
    }

    @Nullable
    public final BedrockAnimation getAnimationOrNull(@NotNull String fileName, @NotNull String animationName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)animationName, (String)"animationName");
        Object object = animationGroups.get(fileName);
        return object != null && (object = ((BedrockAnimationGroup)object).getAnimations()) != null ? (BedrockAnimation)object.get(animationName) : null;
    }

    private static final boolean loadAnimations$lambda$0(ResourceLocation it) {
        String string = it.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return StringsKt.endsWith$default((String)string, (String)".animation.json", (boolean)false, (int)2, null);
    }
}

