/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.client.tooltips;

import com.cobblemon.mod.common.CobblemonItemComponents;
import com.cobblemon.mod.common.api.cooking.Flavour;
import com.cobblemon.mod.common.api.cooking.PokePuffUtils;
import com.cobblemon.mod.common.api.text.TextKt;
import com.cobblemon.mod.common.client.tooltips.TooltipGenerator;
import com.cobblemon.mod.common.item.PokePuffItem;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ-\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016\u00a2\u0006\u0004\b\u000b\u0010\n\u00a8\u0006\f"}, d2={"Lcom/cobblemon/mod/common/client/tooltips/PokePuffTooltipGenerator;", "Lcom/cobblemon/mod/common/client/tooltips/TooltipGenerator;", "<init>", "()V", "Lnet/minecraft/world/item/ItemStack;", "stack", "", "Lnet/minecraft/network/chat/Component;", "lines", "generateCategoryTooltip", "(Lnet/minecraft/world/item/ItemStack;Ljava/util/List;)Ljava/util/List;", "generateAdditionalTooltip", "common"})
public final class PokePuffTooltipGenerator
extends TooltipGenerator {
    @NotNull
    public static final PokePuffTooltipGenerator INSTANCE = new PokePuffTooltipGenerator();

    private PokePuffTooltipGenerator() {
    }

    @Override
    @Nullable
    public List<Component> generateCategoryTooltip(@NotNull ItemStack stack, @NotNull List<Component> lines) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter(lines, (String)"lines");
        if (!(stack.getItem() instanceof PokePuffItem)) {
            return null;
        }
        if (stack.get(CobblemonItemComponents.FLAVOUR) == null) {
            return null;
        }
        Object[] objectArray = new Component[1];
        MutableComponent mutableComponent = LocalizationUtilsKt.lang("tooltip.poke_puff.friendship_effects", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"lang(...)");
        objectArray[0] = TextKt.blue(mutableComponent);
        return CollectionsKt.mutableListOf((Object[])objectArray);
    }

    @Override
    @Nullable
    public List<Component> generateAdditionalTooltip(@NotNull ItemStack stack, @NotNull List<Component> lines) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter(lines, (String)"lines");
        if (!(stack.getItem() instanceof PokePuffItem)) {
            return null;
        }
        List resultLines = new ArrayList();
        Flavour dominantFlavour = PokePuffUtils.INSTANCE.getDominantFlavour(stack);
        if (dominantFlavour != null) {
            int friendshipLiked = PokePuffUtils.INSTANCE.getFriendshipChangeLiked(stack);
            int friendshipDisliked = PokePuffUtils.INSTANCE.getFriendshipChangeDisliked(stack);
            String natureLabelKey = WhenMappings.$EnumSwitchMapping$0[dominantFlavour.ordinal()] == 1 ? "tooltip.cobblemon.poke_puff.nature.neutral" : "cobblemon.stat." + PokePuffUtils.INSTANCE.getFlavorNatureLabel(dominantFlavour) + ".name";
            MutableComponent mutableComponent = Component.literal((String)"");
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"literal(...)");
            resultLines.add(mutableComponent);
            MutableComponent mutableComponent2 = LocalizationUtilsKt.lang("tooltip.poke_puff.friendship_effects", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent2, (String)"lang(...)");
            resultLines.add(TextKt.blue(mutableComponent2));
            Object[] objectArray = new Object[]{String.valueOf(friendshipLiked), Component.translatable((String)natureLabelKey)};
            MutableComponent mutableComponent3 = Component.translatable((String)"tooltip.cobblemon.poke_puff.friendship_increase", (Object[])objectArray).withStyle(ChatFormatting.GREEN);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent3, (String)"withStyle(...)");
            resultLines.add(mutableComponent3);
            objectArray = new Object[]{String.valueOf(friendshipDisliked)};
            MutableComponent mutableComponent4 = Component.translatable((String)"tooltip.cobblemon.poke_puff.friendship_decrease", (Object[])objectArray).withStyle(ChatFormatting.RED);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent4, (String)"withStyle(...)");
            resultLines.add(mutableComponent4);
        }
        return resultLines;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Flavour.values().length];
            try {
                nArray[Flavour.MILD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

