/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.command;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.permission.CobblemonPermissions;
import com.cobblemon.mod.common.api.spawning.SpawnBucket;
import com.cobblemon.mod.common.api.spawning.SpawnCause;
import com.cobblemon.mod.common.api.spawning.SpawningZone;
import com.cobblemon.mod.common.api.spawning.SpawningZoneGenerator;
import com.cobblemon.mod.common.api.spawning.detail.SpawnDetail;
import com.cobblemon.mod.common.api.spawning.position.AreaSpawnablePosition;
import com.cobblemon.mod.common.api.spawning.position.calculators.SpawnablePositionCalculator;
import com.cobblemon.mod.common.api.spawning.spawner.PlayerSpawner;
import com.cobblemon.mod.common.api.spawning.spawner.Spawner;
import com.cobblemon.mod.common.api.spawning.spawner.SpawningZoneInput;
import com.cobblemon.mod.common.api.text.TextKt;
import com.cobblemon.mod.common.command.argument.SpawnBucketArgumentType;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import com.cobblemon.mod.common.util.PermissionUtilsKt;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\b\u001a\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\b\u0010\tJ%\u0010\u000f\u001a\u00020\u000e2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001d\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00138\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u00138\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u0018R\u0014\u0010\u001a\u001a\u00020\u00138\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u0018R\u0017\u0010\u001c\u001a\u00020\u001b8\u0006\u00a2\u0006\f\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006 "}, d2={"Lcom/cobblemon/mod/common/command/CheckSpawnsCommand;", "", "<init>", "()V", "Lcom/mojang/brigadier/CommandDispatcher;", "Lnet/minecraft/commands/CommandSourceStack;", "dispatcher", "", "register", "(Lcom/mojang/brigadier/CommandDispatcher;)V", "Lcom/mojang/brigadier/context/CommandContext;", "context", "Lnet/minecraft/server/level/ServerPlayer;", "player", "", "execute", "(Lcom/mojang/brigadier/context/CommandContext;Lnet/minecraft/server/level/ServerPlayer;)I", "Lnet/minecraft/network/chat/MutableComponent;", "name", "", "percentage", "applyColour", "(Lnet/minecraft/network/chat/MutableComponent;F)Lnet/minecraft/network/chat/MutableComponent;", "PURPLE_THRESHOLD", "F", "RED_THRESHOLD", "YELLOW_THRESHOLD", "Ljava/text/DecimalFormat;", "df", "Ljava/text/DecimalFormat;", "getDf", "()Ljava/text/DecimalFormat;", "common"})
@SourceDebugExtension(value={"SMAP\nCheckSpawnsCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CheckSpawnsCommand.kt\ncom/cobblemon/mod/common/command/CheckSpawnsCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,130:1\n1869#2,2:131\n1068#2:133\n1869#2,2:134\n*S KotlinDebug\n*F\n+ 1 CheckSpawnsCommand.kt\ncom/cobblemon/mod/common/command/CheckSpawnsCommand\n*L\n86#1:131,2\n97#1:133\n99#1:134,2\n*E\n"})
public final class CheckSpawnsCommand {
    @NotNull
    public static final CheckSpawnsCommand INSTANCE = new CheckSpawnsCommand();
    public static final float PURPLE_THRESHOLD = 0.01f;
    public static final float RED_THRESHOLD = 0.1f;
    public static final float YELLOW_THRESHOLD = 5.0f;
    @NotNull
    private static final DecimalFormat df = new DecimalFormat("#.##");

    private CheckSpawnsCommand() {
    }

    @NotNull
    public final DecimalFormat getDf() {
        return df;
    }

    public final void register(@NotNull CommandDispatcher<CommandSourceStack> dispatcher) {
        Intrinsics.checkNotNullParameter(dispatcher, (String)"dispatcher");
        LiteralArgumentBuilder literalArgumentBuilder = Commands.literal((String)"checkspawn");
        Intrinsics.checkNotNullExpressionValue((Object)literalArgumentBuilder, (String)"literal(...)");
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)PermissionUtilsKt.permission$default((ArgumentBuilder)literalArgumentBuilder, CobblemonPermissions.getCHECKSPAWNS(), false, 2, null)).then(((RequiredArgumentBuilder)Commands.argument((String)"bucket", (ArgumentType)SpawnBucketArgumentType.Companion.spawnBucket()).requires(CheckSpawnsCommand::register$lambda$0)).executes(CheckSpawnsCommand::register$lambda$1)));
    }

    private final int execute(CommandContext<CommandSourceStack> context, ServerPlayer player) {
        if (!Cobblemon.INSTANCE.getConfig().getEnableSpawning()) {
            return 0;
        }
        PlayerSpawner spawner = PlayerExtensionsKt.getSpawner(player);
        SpawnBucket bucket = SpawnBucketArgumentType.Companion.getSpawnBucket(context, "bucket");
        SpawnCause cause = new SpawnCause(spawner, (Entity)player);
        SpawningZoneGenerator spawningZoneGenerator = Cobblemon.INSTANCE.getSpawningZoneGenerator();
        Spawner spawner2 = spawner;
        Level level = player.level();
        Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
        SpawningZone slice = spawningZoneGenerator.generate(spawner2, new SpawningZoneInput(cause, (ServerLevel)level, Mth.ceil((double)(player.getX() - (double)((float)Cobblemon.INSTANCE.getConfig().getSpawningZoneDiameter() / 2.0f))), Mth.ceil((double)(player.getY() - (double)((float)Cobblemon.INSTANCE.getConfig().getSpawningZoneHeight() / 2.0f))), Mth.ceil((double)(player.getZ() - (double)((float)Cobblemon.INSTANCE.getConfig().getSpawningZoneDiameter() / 2.0f))), Cobblemon.INSTANCE.getConfig().getSpawningZoneDiameter(), Cobblemon.INSTANCE.getConfig().getSpawningZoneHeight(), Cobblemon.INSTANCE.getConfig().getSpawningZoneDiameter()));
        List<AreaSpawnablePosition> contexts = Cobblemon.INSTANCE.getAreaSpawnablePositionResolver().resolve(spawner, SpawnablePositionCalculator.Companion.getPrioritizedAreaCalculators(), slice);
        Map<SpawnDetail, Float> spawnProbabilities = spawner.getSelector().getProbabilities(spawner, bucket, contexts);
        Map spawnNames = new LinkedHashMap();
        Map namedProbabilities = new LinkedHashMap();
        Iterable $this$forEach$iv = spawnProbabilities.entrySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry it = (Map.Entry)element$iv;
            boolean bl = false;
            MutableComponent nameText = ((SpawnDetail)it.getKey()).getName();
            String nameString = nameText.getString();
            if (!spawnNames.containsKey(nameString)) {
                spawnNames.put(nameString, ((SpawnDetail)it.getKey()).getName());
            }
            Object v = spawnNames.get(nameString);
            Intrinsics.checkNotNull(v);
            MutableComponent standardizedNameText = (MutableComponent)v;
            Map map = namedProbabilities;
            Float f = (Float)namedProbabilities.get(standardizedNameText);
            Float f2 = Float.valueOf((f != null ? f.floatValue() : 0.0f) + ((Number)it.getValue()).floatValue());
            map.put(standardizedNameText, f2);
        }
        Iterable $this$sortedByDescending$iv = namedProbabilities.entrySet();
        boolean $i$f$sortedByDescending = false;
        List sortedEntries = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)b;
                boolean bl = false;
                Comparable comparable = (Float)it.getValue();
                it = (Map.Entry)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Float)it.getValue()));
            }
        });
        List messages = new ArrayList();
        Iterable $this$forEach$iv2 = sortedEntries;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl = false;
            MutableComponent name = (MutableComponent)entry.getKey();
            float percentage = ((Number)entry.getValue()).floatValue();
            MutableComponent message = TextKt.plus(TextKt.plus(name, ": "), INSTANCE.applyColour(TextKt.text(df.format(Float.valueOf(percentage)) + "%"), percentage));
            messages.add(message);
        }
        if (messages.isEmpty()) {
            MutableComponent mutableComponent = LocalizationUtilsKt.lang("command.checkspawns.nothing", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"lang(...)");
            player.sendSystemMessage((Component)TextKt.red(mutableComponent));
        } else {
            MutableComponent mutableComponent = LocalizationUtilsKt.lang("command.checkspawns.spawns", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"lang(...)");
            player.sendSystemMessage((Component)TextKt.underline(mutableComponent));
            MutableComponent msg = (MutableComponent)messages.get(0);
            for (MutableComponent nextMessage : messages.subList(1, messages.size())) {
                TextKt.add(msg, (Component)TextKt.plus(TextKt.text(", "), nextMessage));
            }
            player.sendSystemMessage((Component)msg);
        }
        return 1;
    }

    @NotNull
    public final MutableComponent applyColour(@NotNull MutableComponent name, float percentage) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return percentage < 0.01f ? TextKt.lightPurple(name) : (percentage < 0.1f ? TextKt.red(name) : (percentage < 5.0f ? TextKt.yellow(name) : TextKt.green(name)));
    }

    private static final boolean register$lambda$0(CommandSourceStack it) {
        return it.getPlayer() != null;
    }

    private static final int register$lambda$1(CommandContext it) {
        Intrinsics.checkNotNull((Object)it);
        ServerPlayer serverPlayer = ((CommandSourceStack)it.getSource()).getPlayerOrException();
        Intrinsics.checkNotNullExpressionValue((Object)serverPlayer, (String)"getPlayerOrException(...)");
        return INSTANCE.execute((CommandContext<CommandSourceStack>)it, serverPlayer);
    }
}

