/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.command;

import com.cobblemon.mod.common.api.permission.CobblemonPermissions;
import com.cobblemon.mod.common.api.storage.StorePosition;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.api.storage.pc.PCPosition;
import com.cobblemon.mod.common.api.storage.pc.PCStore;
import com.cobblemon.mod.common.api.text.TextKt;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import com.cobblemon.mod.common.util.PermissionUtilsKt;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\b\u001a\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u001d\u0010\r\u001a\u00020\f2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\nH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ/\u0010\u0012\u001a\u00020\f2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\u0006\u0010\u0010\u001a\u00020\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u000fH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0015\u001a\u00020\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lcom/cobblemon/mod/common/command/PcTakeCommand;", "", "<init>", "()V", "Lcom/mojang/brigadier/CommandDispatcher;", "Lnet/minecraft/commands/CommandSourceStack;", "dispatcher", "", "register", "(Lcom/mojang/brigadier/CommandDispatcher;)V", "Lcom/mojang/brigadier/context/CommandContext;", "context", "", "execute", "(Lcom/mojang/brigadier/context/CommandContext;)I", "Lnet/minecraft/server/level/ServerPlayer;", "target", "executor", "executeWithTarget", "(Lcom/mojang/brigadier/context/CommandContext;Lnet/minecraft/server/level/ServerPlayer;Lnet/minecraft/server/level/ServerPlayer;)I", "Lcom/mojang/brigadier/exceptions/SimpleCommandExceptionType;", "IN_BATTLE_EXCEPTION", "Lcom/mojang/brigadier/exceptions/SimpleCommandExceptionType;", "common"})
public final class PcTakeCommand {
    @NotNull
    public static final PcTakeCommand INSTANCE = new PcTakeCommand();
    @NotNull
    private static final SimpleCommandExceptionType IN_BATTLE_EXCEPTION;

    private PcTakeCommand() {
    }

    public final void register(@NotNull CommandDispatcher<CommandSourceStack> dispatcher) {
        Intrinsics.checkNotNullParameter(dispatcher, (String)"dispatcher");
        LiteralArgumentBuilder literalArgumentBuilder = Commands.literal((String)"pctake");
        Intrinsics.checkNotNullExpressionValue((Object)literalArgumentBuilder, (String)"literal(...)");
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)PermissionUtilsKt.permission$default((ArgumentBuilder)literalArgumentBuilder, CobblemonPermissions.getTAKE_POKEMON(), false, 2, null)).then(Commands.argument((String)"player", (ArgumentType)((ArgumentType)EntityArgument.player())).then(Commands.argument((String)"box", (ArgumentType)((ArgumentType)IntegerArgumentType.integer((int)1))).then(Commands.argument((String)"slot", (ArgumentType)((ArgumentType)IntegerArgumentType.integer((int)1, (int)30))).executes(this::execute))));
        dispatcher.register(command);
    }

    private final int execute(CommandContext<CommandSourceStack> context) {
        Entity entity = ((CommandSourceStack)context.getSource()).getEntity();
        ServerPlayer executor = entity instanceof ServerPlayer ? (ServerPlayer)entity : null;
        ServerPlayer target = EntityArgument.getPlayer(context, (String)"player");
        Intrinsics.checkNotNull((Object)target);
        return this.executeWithTarget(context, target, executor);
    }

    private final int executeWithTarget(CommandContext<CommandSourceStack> context, ServerPlayer target, ServerPlayer executor) {
        try {
            if (PlayerExtensionsKt.isInBattle(target)) {
                CommandSyntaxException commandSyntaxException = IN_BATTLE_EXCEPTION.create();
                Intrinsics.checkNotNullExpressionValue((Object)((Object)commandSyntaxException), (String)"create(...)");
                throw (Throwable)commandSyntaxException;
            }
            int box = IntegerArgumentType.getInteger(context, (String)"box");
            int slot = IntegerArgumentType.getInteger(context, (String)"slot");
            PCStore pc = PlayerExtensionsKt.pc(target);
            if (box > 30) {
                Object[] objectArray = new Object[]{30};
                ((CommandSourceStack)context.getSource()).sendFailure((Component)LocalizationUtilsKt.commandLang("pctake.too_many_boxes", objectArray));
                return 0;
            }
            int boxIndex = box - 1;
            int slotIndex = slot - 1;
            if (slotIndex < 0 || slotIndex >= 30) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)LocalizationUtilsKt.commandLang("pctake.invalid_slot", new Object[0]));
                return 0;
            }
            Pokemon pokemon = pc.getBoxes().get(boxIndex).get(slotIndex);
            if (pokemon == null) {
                Object[] objectArray = new Object[]{box, slot};
                ((CommandSourceStack)context.getSource()).sendFailure((Component)LocalizationUtilsKt.commandLang("pctake.no_pokemon", objectArray));
                return 0;
            }
            pc.remove((StorePosition)new PCPosition(boxIndex, slotIndex));
            if (executor != null && !Intrinsics.areEqual((Object)executor, (Object)target)) {
                PlayerPartyStore toParty = PlayerExtensionsKt.party(executor);
                toParty.add(pokemon);
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> PcTakeCommand.executeWithTarget$lambda$0(pokemon, target), true);
                return 1;
            }
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> PcTakeCommand.executeWithTarget$lambda$1(pokemon, box, slot), true);
            return 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
    }

    private static final Component executeWithTarget$lambda$0(Pokemon $pokemon, ServerPlayer $target) {
        Object[] objectArray = new Object[2];
        objectArray[0] = $pokemon.getSpecies().getName();
        Intrinsics.checkNotNullExpressionValue((Object)$target.getName().getString(), (String)"getString(...)");
        return (Component)LocalizationUtilsKt.commandLang("pctake.taken_other", objectArray);
    }

    private static final Component executeWithTarget$lambda$1(Pokemon $pokemon, int $box, int $slot) {
        Object[] objectArray = new Object[]{$pokemon.getSpecies().getName(), $box, $slot};
        return (Component)LocalizationUtilsKt.commandLang("pctake.removed", objectArray);
    }

    static {
        MutableComponent mutableComponent = LocalizationUtilsKt.lang("pc.inbattle", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"lang(...)");
        IN_BATTLE_EXCEPTION = new SimpleCommandExceptionType((Message)TextKt.red(mutableComponent));
    }
}

