/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.compat.lambdynamiclights;

import com.cobblemon.mod.common.client.render.layer.PokemonOnShoulderRenderer;
import com.cobblemon.mod.common.compat.lambdynamiclights.CustomLuminance;
import com.cobblemon.mod.common.compat.lambdynamiclights.LambDynamicLightsInitializer;
import dev.lambdaurora.lambdynlights.api.entity.luminance.EntityLuminance;
import dev.lambdaurora.lambdynlights.api.item.ItemLightSourceManager;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public final class PlayerLuminance
extends CustomLuminance
implements EntityLuminance {
    public static final PlayerLuminance INSTANCE = new PlayerLuminance();
    private static final TagKey<Item> POKEDEX = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"cobblemon", (String)"pokedex"));

    @NotNull
    public EntityLuminance.Type type() {
        return LambDynamicLightsInitializer.PLAYER_LUMINANCE;
    }

    public @Range(from=0L, to=15L) int getLuminance(@NotNull ItemLightSourceManager itemLightSourceManager, @NotNull Entity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            int shoulderLightLevel = PlayerLuminance.shoulderLuminance(itemLightSourceManager, player);
            int itemLightLevel = player.isHolding(stack -> stack.is(POKEDEX)) ? 13 : 0;
            return Math.max(shoulderLightLevel, itemLightLevel);
        }
        return 0;
    }

    private static @Range(from=0L, to=15L) int shoulderLuminance(@NotNull ItemLightSourceManager itemLightSourceManager, @NotNull Player player) {
        PokemonOnShoulderRenderer.ShoulderData leftShoulder = PokemonOnShoulderRenderer.shoulderDataFrom(player.getShoulderEntityLeft());
        PokemonOnShoulderRenderer.ShoulderData rightShoulder = PokemonOnShoulderRenderer.shoulderDataFrom(player.getShoulderEntityRight());
        if (leftShoulder == null && rightShoulder == null) {
            return 0;
        }
        int leftShoulderLightLevel = PlayerLuminance.extractShoulderLightLevel(leftShoulder, itemLightSourceManager, player.isUnderWater());
        int rightShoulderLightLevel = PlayerLuminance.extractShoulderLightLevel(rightShoulder, itemLightSourceManager, player.isUnderWater());
        return Math.max(leftShoulderLightLevel, rightShoulderLightLevel);
    }

    private static int extractShoulderLightLevel(@Nullable PokemonOnShoulderRenderer.ShoulderData shoulderData, @NotNull ItemLightSourceManager itemLightSourceManager, boolean underwater) {
        if (shoulderData == null) {
            return 0;
        }
        ItemStack item = shoulderData.getShownItem();
        int itemLightLevel = item.isEmpty() ? 0 : itemLightSourceManager.getLuminance(item, underwater);
        int formLightLevel = PlayerLuminance.extractFormLightLevel(shoulderData.getForm(), underwater).orElse(0);
        return Math.max(itemLightLevel, formLightLevel);
    }
}

