/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.data;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.data.JsonDataRegistry;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.api.reactive.SimpleObservable;
import com.cobblemon.mod.common.config.starter.StarterCategory;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import com.cobblemon.mod.common.util.adapters.PokemonPropertiesAdapterKt;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.PackType;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0013\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J#\u0010\f\u001a\u00020\u000b2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00020\bH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\t8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0017\u001a\u00020\u00168\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0019\u0010\u001aR \u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00000\u001b8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001fR\"\u0010\"\u001a\n !*\u0004\u0018\u00010 0 8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\"\u0010#\u001a\u0004\b$\u0010%R \u0010'\u001a\b\u0012\u0004\u0012\u00020\u00020&8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b'\u0010(\u001a\u0004\b)\u0010*R\u001a\u0010,\u001a\u00020+8\u0016X\u0096D\u00a2\u0006\f\n\u0004\b,\u0010-\u001a\u0004\b.\u0010/R\u001a\u00101\u001a\b\u0012\u0004\u0012\u00020\u0002008\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b1\u00102\u00a8\u00063"}, d2={"Lcom/cobblemon/mod/common/data/StarterDataLoader;", "Lcom/cobblemon/mod/common/api/data/JsonDataRegistry;", "Lcom/cobblemon/mod/common/config/starter/StarterCategory;", "<init>", "()V", "", "getAllCategories", "()Ljava/util/List;", "", "Lnet/minecraft/resources/ResourceLocation;", "data", "", "reload", "(Ljava/util/Map;)V", "Lnet/minecraft/server/level/ServerPlayer;", "player", "sync", "(Lnet/minecraft/server/level/ServerPlayer;)V", "id", "Lnet/minecraft/resources/ResourceLocation;", "getId", "()Lnet/minecraft/resources/ResourceLocation;", "Lnet/minecraft/server/packs/PackType;", "type", "Lnet/minecraft/server/packs/PackType;", "getType", "()Lnet/minecraft/server/packs/PackType;", "Lcom/cobblemon/mod/common/api/reactive/SimpleObservable;", "observable", "Lcom/cobblemon/mod/common/api/reactive/SimpleObservable;", "getObservable", "()Lcom/cobblemon/mod/common/api/reactive/SimpleObservable;", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "gson", "Lcom/google/gson/Gson;", "getGson", "()Lcom/google/gson/Gson;", "Lcom/google/gson/reflect/TypeToken;", "typeToken", "Lcom/google/gson/reflect/TypeToken;", "getTypeToken", "()Lcom/google/gson/reflect/TypeToken;", "", "resourcePath", "Ljava/lang/String;", "getResourcePath", "()Ljava/lang/String;", "", "categories", "Ljava/util/List;", "common"})
@SourceDebugExtension(value={"SMAP\nStarterDataLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StarterDataLoader.kt\ncom/cobblemon/mod/common/data/StarterDataLoader\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,92:1\n136#2,9:93\n216#2:102\n217#2:105\n145#2:106\n1#3:103\n1#3:104\n360#4,7:107\n*S KotlinDebug\n*F\n+ 1 StarterDataLoader.kt\ncom/cobblemon/mod/common/data/StarterDataLoader\n*L\n52#1:93,9\n52#1:102\n52#1:105\n52#1:106\n52#1:104\n75#1:107,7\n*E\n"})
public final class StarterDataLoader
implements JsonDataRegistry<StarterCategory> {
    @NotNull
    public static final StarterDataLoader INSTANCE = new StarterDataLoader();
    @NotNull
    private static final ResourceLocation id = MiscUtilsKt.cobblemonResource("starters");
    @NotNull
    private static final PackType type = PackType.SERVER_DATA;
    @NotNull
    private static final SimpleObservable<StarterDataLoader> observable = new SimpleObservable();
    private static final Gson gson = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().registerTypeAdapter((Type)((Object)PokemonProperties.class), (Object)PokemonPropertiesAdapterKt.getPokemonPropertiesShortAdapter()).create();
    @NotNull
    private static final TypeToken<StarterCategory> typeToken;
    @NotNull
    private static final String resourcePath;
    @NotNull
    private static final List<StarterCategory> categories;

    private StarterDataLoader() {
    }

    @Override
    @NotNull
    public ResourceLocation getId() {
        return id;
    }

    @Override
    @NotNull
    public PackType getType() {
        return type;
    }

    @NotNull
    public SimpleObservable<StarterDataLoader> getObservable() {
        return observable;
    }

    @Override
    public Gson getGson() {
        return gson;
    }

    @Override
    @NotNull
    public TypeToken<StarterCategory> getTypeToken() {
        return typeToken;
    }

    @Override
    @NotNull
    public String getResourcePath() {
        return resourcePath;
    }

    @NotNull
    public final List<StarterCategory> getAllCategories() {
        return CollectionsKt.toList((Iterable)categories);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void reload(@NotNull Map<ResourceLocation, StarterCategory> data) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(data, (String)"data");
        categories.clear();
        if (Cobblemon.INSTANCE.getStarterConfig().getUseConfigStarters()) {
            CollectionsKt.addAll((Collection)categories, (Iterable)Cobblemon.INSTANCE.getStarterConfig().getStarters());
        }
        Map<ResourceLocation, StarterCategory> $this$mapNotNull$iv = data;
        boolean $i$f$mapNotNull = false;
        Map<ResourceLocation, StarterCategory> map = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            StarterCategory starterCategory;
            Map.Entry element$iv$iv$iv;
            Map.Entry element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Map.Entry entry = element$iv$iv;
            boolean bl2 = false;
            ResourceLocation id = (ResourceLocation)entry.getKey();
            StarterCategory category = (StarterCategory)entry.getValue();
            CharSequence charSequence = category.getName();
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                Cobblemon.LOGGER.warn("Skipping starter category '{}': missing name", (Object)id);
                starterCategory = null;
            } else {
                List<PokemonProperties> pokemonList;
                String displayName;
                String name = ((Object)StringsKt.trim((CharSequence)category.getName())).toString();
                Object object = category.getDisplayName();
                String it = object;
                boolean bl3 = false;
                CharSequence charSequence2 = it;
                Object object2 = !(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) ? object : null;
                if (object2 == null) {
                    object2 = displayName = name;
                }
                if ((object = (Collection)(pokemonList = category.getPokemon())) == null || object.isEmpty()) {
                    Cobblemon.LOGGER.warn("Skipping starter category '{}': pokemon list is empty", (Object)id);
                    starterCategory = null;
                } else {
                    starterCategory = new StarterCategory(name, displayName, pokemonList);
                }
            }
            if (starterCategory == null) continue;
            StarterCategory it$iv$iv = starterCategory;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List loadedCategories = (List)destination$iv$iv;
        if (!((Collection)loadedCategories).isEmpty() && !Cobblemon.INSTANCE.getStarterConfig().getUseConfigStarters()) {
            categories.clear();
            CollectionsKt.addAll((Collection)categories, (Iterable)loadedCategories);
        } else {
            for (StarterCategory newCategory : loadedCategories) {
                int existingIndex;
                block13: {
                    int n;
                    List<StarterCategory> $this$indexOfFirst$iv = categories;
                    boolean $i$f$indexOfFirst = false;
                    int index$iv = 0;
                    Iterator<StarterCategory> iterator2 = $this$indexOfFirst$iv.iterator();
                    while (iterator2.hasNext()) {
                        StarterCategory item$iv;
                        StarterCategory it = item$iv = iterator2.next();
                        boolean bl = false;
                        if (StringsKt.equals((String)it.getName(), (String)newCategory.getName(), (boolean)true)) {
                            n = index$iv;
                            break block13;
                        }
                        ++index$iv;
                    }
                    n = existingIndex = -1;
                }
                if (existingIndex >= 0) {
                    categories.set(existingIndex, newCategory);
                    Cobblemon.LOGGER.info("Replaced starter category '{}' at position {}", (Object)newCategory.getName(), (Object)existingIndex);
                    continue;
                }
                ((Collection)categories).add(newCategory);
                Cobblemon.LOGGER.info("Appended starter category '{}'", (Object)newCategory.getName());
            }
        }
        StarterDataLoader[] starterDataLoaderArray = new StarterDataLoader[]{this};
        this.getObservable().emit((StarterDataLoader[])starterDataLoaderArray);
    }

    @Override
    public void sync(@NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
    }

    static {
        TypeToken typeToken = TypeToken.get(StarterCategory.class);
        Intrinsics.checkNotNullExpressionValue((Object)typeToken, (String)"get(...)");
        StarterDataLoader.typeToken = typeToken;
        resourcePath = "starters";
        categories = new ArrayList();
    }
}

