/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.entity.ai;

import com.cobblemon.mod.common.entity.OmniPathingEntity;
import java.util.Objects;
import java.util.function.ToDoubleFunction;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.GoalUtils;
import net.minecraft.world.entity.ai.util.RandomPos;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lcom/cobblemon/mod/common/entity/ai/CobblemonRandomSurfacePos;", "", "<init>", "()V", "Companion", "common"})
public final class CobblemonRandomSurfacePos {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\n\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0004\b\n\u0010\u000bJ7\u0010\n\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00062\u000e\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\r\u00a2\u0006\u0004\b\n\u0010\u0010J/\u0010\u0012\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\t\u00a2\u0006\u0004\b\u0012\u0010\u0013J9\u0010\u0016\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J/\u0010\u0019\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u001f\u0010\u001b\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u000e\u00a2\u0006\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001d"}, d2={"Lcom/cobblemon/mod/common/entity/ai/CobblemonRandomSurfacePos$Companion;", "", "<init>", "()V", "Lnet/minecraft/world/entity/PathfinderMob;", "mob", "", "radius", "verticalRange", "Lnet/minecraft/world/phys/Vec3;", "getPos", "(Lnet/minecraft/world/entity/PathfinderMob;II)Lnet/minecraft/world/phys/Vec3;", "yRange", "Ljava/util/function/ToDoubleFunction;", "Lnet/minecraft/core/BlockPos;", "toDoubleFunction", "(Lnet/minecraft/world/entity/PathfinderMob;IILjava/util/function/ToDoubleFunction;)Lnet/minecraft/world/phys/Vec3;", "vectorPosition", "getPosTowards", "(Lnet/minecraft/world/entity/PathfinderMob;IILnet/minecraft/world/phys/Vec3;)Lnet/minecraft/world/phys/Vec3;", "", "shortCircuit", "getPosInDirection", "(Lnet/minecraft/world/entity/PathfinderMob;IILnet/minecraft/world/phys/Vec3;Z)Lnet/minecraft/world/phys/Vec3;", "pos", "generateRandomPosTowardDirection", "(Lnet/minecraft/world/entity/PathfinderMob;IZLnet/minecraft/core/BlockPos;)Lnet/minecraft/core/BlockPos;", "movePosUpOutOfSolid", "(Lnet/minecraft/world/entity/PathfinderMob;Lnet/minecraft/core/BlockPos;)Lnet/minecraft/core/BlockPos;", "common"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Vec3 getPos(@NotNull PathfinderMob mob, int radius, int verticalRange) {
            Intrinsics.checkNotNullParameter((Object)mob, (String)"mob");
            Objects.requireNonNull(mob);
            return this.getPos(mob, radius, verticalRange, arg_0 -> Companion.getPos$lambda$0(mob, arg_0));
        }

        @Nullable
        public final Vec3 getPos(@NotNull PathfinderMob mob, int radius, int yRange, @NotNull ToDoubleFunction<BlockPos> toDoubleFunction) {
            Intrinsics.checkNotNullParameter((Object)mob, (String)"mob");
            Intrinsics.checkNotNullParameter(toDoubleFunction, (String)"toDoubleFunction");
            boolean bl = GoalUtils.mobRestricted((PathfinderMob)mob, (int)radius);
            return RandomPos.generateRandomPos(() -> Companion.getPos$lambda$1(mob, radius, yRange, bl), toDoubleFunction);
        }

        @Nullable
        public final Vec3 getPosTowards(@NotNull PathfinderMob mob, int radius, int yRange, @NotNull Vec3 vectorPosition) {
            Intrinsics.checkNotNullParameter((Object)mob, (String)"mob");
            Intrinsics.checkNotNullParameter((Object)vectorPosition, (String)"vectorPosition");
            Vec3 vec3 = vectorPosition.subtract(mob.getX(), mob.getY(), mob.getZ());
            boolean bl = GoalUtils.mobRestricted((PathfinderMob)mob, (int)radius);
            Intrinsics.checkNotNull((Object)vec3);
            return this.getPosInDirection(mob, radius, yRange, vec3, bl);
        }

        private final Vec3 getPosInDirection(PathfinderMob mob, int radius, int yRange, Vec3 vectorPosition, boolean shortCircuit) {
            return RandomPos.generateRandomPos((PathfinderMob)mob, () -> Companion.getPosInDirection$lambda$0(mob, radius, yRange, vectorPosition, shortCircuit));
        }

        @Nullable
        public final BlockPos generateRandomPosTowardDirection(@NotNull PathfinderMob mob, int radius, boolean shortCircuit, @NotNull BlockPos pos) {
            Intrinsics.checkNotNullParameter((Object)mob, (String)"mob");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            BlockPos blockPos = RandomPos.generateRandomPosTowardDirection((PathfinderMob)mob, (int)radius, (RandomSource)mob.getRandom(), (BlockPos)pos);
            return !GoalUtils.isOutsideLimits((BlockPos)blockPos, (PathfinderMob)mob) && !GoalUtils.isRestricted((boolean)shortCircuit, (PathfinderMob)mob, (BlockPos)blockPos) && !GoalUtils.isNotStable((PathNavigation)mob.getNavigation(), (BlockPos)blockPos) ? blockPos : null;
        }

        @Nullable
        public final BlockPos movePosUpOutOfSolid(@NotNull PathfinderMob mob, @NotNull BlockPos pos) {
            Intrinsics.checkNotNullParameter((Object)mob, (String)"mob");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            BlockPos pos2 = pos;
            BlockPos blockPos = RandomPos.moveUpOutOfSolid((BlockPos)pos2, (int)mob.level().getMaxBuildHeight(), arg_0 -> Companion.movePosUpOutOfSolid$lambda$0(mob, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"moveUpOutOfSolid(...)");
            pos2 = blockPos;
            return !GoalUtils.hasMalus((PathfinderMob)mob, (BlockPos)pos2) ? pos2 : null;
        }

        private static final double getPos$lambda$0(PathfinderMob $mob, BlockPos pos) {
            if (pos != null) {
                double cfr_ignored_0 = $mob.getWalkTargetValue(pos);
            }
            return 0.0;
        }

        private static final BlockPos getPos$lambda$1(PathfinderMob $mob, int $radius, int $yRange, boolean $bl) {
            BlockPos blockPos = RandomPos.generateRandomDirection((RandomSource)$mob.getRandom(), (int)$radius, (int)$yRange);
            Intrinsics.checkNotNull((Object)blockPos);
            BlockPos blockPos2 = Companion.generateRandomPosTowardDirection($mob, $radius, $bl, blockPos);
            return blockPos2 == null ? null : Companion.movePosUpOutOfSolid($mob, blockPos2);
        }

        private static final BlockPos getPosInDirection$lambda$0(PathfinderMob $mob, int $radius, int $yRange, Vec3 $vectorPosition, boolean $shortCircuit) {
            BlockPos blockPos = RandomPos.generateRandomDirectionWithinRadians((RandomSource)$mob.getRandom(), (int)$radius, (int)$yRange, (int)0, (double)$vectorPosition.x, (double)$vectorPosition.z, (double)1.5707963705062866);
            if (blockPos == null) {
                return null;
            }
            BlockPos blockPos2 = Companion.generateRandomPosTowardDirection($mob, $radius, $shortCircuit, blockPos);
            return blockPos2 == null ? null : Companion.movePosUpOutOfSolid($mob, blockPos2);
        }

        private static final boolean movePosUpOutOfSolid$lambda$0(PathfinderMob $mob, BlockPos blockPos) {
            FluidState fluidState;
            Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
            if (GoalUtils.isSolid((PathfinderMob)$mob, (BlockPos)blockPos)) {
                // empty if block
            }
            return !(fluidState = $mob.level().getFluidState(blockPos)).isEmpty() && (!($mob instanceof OmniPathingEntity) || ((OmniPathingEntity)$mob).canWalkOnWater() && Intrinsics.areEqual((Object)fluidState.getType(), (Object)FluidTags.WATER) || ((OmniPathingEntity)$mob).canWalkOnLava() && Intrinsics.areEqual((Object)fluidState.getType(), (Object)FluidTags.LAVA));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

