/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.entity.ai;

import com.cobblemon.mod.common.CobblemonBlocks;
import com.cobblemon.mod.common.entity.OmniPathingEntity;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.ai.OmniPathNodeMaker;
import com.cobblemon.mod.common.util.BlockPosExtensionsKt;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import com.cobblemon.mod.common.util.WorldExtensionsKt;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.NodeEvaluator;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u000e\u0018\u0000 X2\u00020\u0001:\u0002YXB\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\bH\u0014\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\u000e\u001a\u00020\rH\u0014\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0010\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u000fJ\u0015\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\r\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0016\u001a\u00020\u0015H\u0014\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u000f\u0010\u0018\u001a\u00020\u0012H\u0014\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001d\u0010\u001c\u001a\u00020\r2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001a\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u001f\u0010!\u001a\u0004\u0018\u00010 2\u0006\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\b\u00a2\u0006\u0004\b!\u0010\"J!\u0010#\u001a\u0004\u0018\u00010 2\u0006\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b#\u0010\"J7\u0010+\u001a\u00020\u00122\u0006\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020$2\u0006\u0010'\u001a\u00020$2\b\b\u0002\u0010(\u001a\u00020$2\u0006\u0010*\u001a\u00020)\u00a2\u0006\u0004\b+\u0010,J\u0017\u0010-\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u001aH\u0016\u00a2\u0006\u0004\b-\u0010.J\u0017\u00100\u001a\u00020$2\u0006\u0010/\u001a\u00020\u0015H\u0014\u00a2\u0006\u0004\b0\u00101J!\u0010#\u001a\u0004\u0018\u00010 2\u0006\u0010\u0005\u001a\u0002022\u0006\u0010\u001f\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b#\u00103J!\u0010+\u001a\u00020\r2\b\u00104\u001a\u0004\u0018\u00010 2\u0006\u0010(\u001a\u00020$H\u0016\u00a2\u0006\u0004\b+\u00105J\u000f\u00106\u001a\u00020\u0012H\u0014\u00a2\u0006\u0004\b6\u0010\u0019J\r\u00107\u001a\u00020\b\u00a2\u0006\u0004\b7\u00108J\u000f\u00109\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b9\u0010\u0019R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010:\u001a\u0004\b;\u0010<R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010=\u001a\u0004\b>\u0010?R\u0017\u0010A\u001a\u00020@8\u0006\u00a2\u0006\f\n\u0004\bA\u0010B\u001a\u0004\bC\u0010DR$\u0010F\u001a\u0004\u0018\u00010E8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bF\u0010G\u001a\u0004\bH\u0010I\"\u0004\bJ\u0010KR\"\u0010M\u001a\u00020L8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bM\u0010N\u001a\u0004\bO\u0010P\"\u0004\bQ\u0010RR\"\u0010*\u001a\u00020)8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b*\u0010S\u001a\u0004\bT\u0010U\"\u0004\bV\u0010W\u00a8\u0006Z"}, d2={"Lcom/cobblemon/mod/common/entity/ai/OmniPathNavigation;", "Lnet/minecraft/world/entity/ai/navigation/GroundPathNavigation;", "Lnet/minecraft/world/level/Level;", "world", "Lnet/minecraft/world/entity/Mob;", "entity", "<init>", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/Mob;)V", "", "range", "Lnet/minecraft/world/level/pathfinder/PathFinder;", "createPathFinder", "(I)Lnet/minecraft/world/level/pathfinder/PathFinder;", "", "canUpdatePath", "()Z", "canFloat", "canPathThroughFire", "", "setCanPathThroughFire", "(Z)V", "Lnet/minecraft/world/phys/Vec3;", "getTempMobPos", "()Lnet/minecraft/world/phys/Vec3;", "followThePath", "()V", "Lnet/minecraft/core/BlockPos;", "pos", "isAirborne", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)Z", "target", "distance", "Lnet/minecraft/world/level/pathfinder/Path;", "findPath", "(Lnet/minecraft/core/BlockPos;I)Lnet/minecraft/world/level/pathfinder/Path;", "createPath", "", "x", "y", "z", "speed", "Lcom/cobblemon/mod/common/entity/ai/OmniPathNavigation$NavigationContext;", "navigationContext", "moveTo", "(DDDDLcom/cobblemon/mod/common/entity/ai/OmniPathNavigation$NavigationContext;)V", "isStableDestination", "(Lnet/minecraft/core/BlockPos;)Z", "vec", "getGroundY", "(Lnet/minecraft/world/phys/Vec3;)D", "Lnet/minecraft/world/entity/Entity;", "(Lnet/minecraft/world/entity/Entity;I)Lnet/minecraft/world/level/pathfinder/Path;", "path", "(Lnet/minecraft/world/level/pathfinder/Path;D)Z", "trimPath", "getPathfindingY", "()I", "stop", "Lnet/minecraft/world/level/Level;", "getWorld", "()Lnet/minecraft/world/level/Level;", "Lnet/minecraft/world/entity/Mob;", "getEntity", "()Lnet/minecraft/world/entity/Mob;", "Lcom/cobblemon/mod/common/entity/OmniPathingEntity;", "pather", "Lcom/cobblemon/mod/common/entity/OmniPathingEntity;", "getPather", "()Lcom/cobblemon/mod/common/entity/OmniPathingEntity;", "Lnet/minecraft/world/level/pathfinder/Node;", "cachedCurrentNode", "Lnet/minecraft/world/level/pathfinder/Node;", "getCachedCurrentNode", "()Lnet/minecraft/world/level/pathfinder/Node;", "setCachedCurrentNode", "(Lnet/minecraft/world/level/pathfinder/Node;)V", "", "currentNodeDistance", "F", "getCurrentNodeDistance", "()F", "setCurrentNodeDistance", "(F)V", "Lcom/cobblemon/mod/common/entity/ai/OmniPathNavigation$NavigationContext;", "getNavigationContext", "()Lcom/cobblemon/mod/common/entity/ai/OmniPathNavigation$NavigationContext;", "setNavigationContext", "(Lcom/cobblemon/mod/common/entity/ai/OmniPathNavigation$NavigationContext;)V", "Companion", "NavigationContext", "common"})
public final class OmniPathNavigation
extends GroundPathNavigation {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Level world;
    @NotNull
    private final Mob entity;
    @NotNull
    private final OmniPathingEntity pather;
    @Nullable
    private Node cachedCurrentNode;
    private float currentNodeDistance;
    @NotNull
    private NavigationContext navigationContext;
    @NotNull
    private static final Set<PathType> verticallyPreciseNodeTypes;

    public OmniPathNavigation(@NotNull Level world, @NotNull Mob entity) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        super(entity, world);
        this.world = world;
        Mob mob = this.entity = entity;
        Intrinsics.checkNotNull((Object)mob, (String)"null cannot be cast to non-null type com.cobblemon.mod.common.entity.OmniPathingEntity");
        this.pather = (OmniPathingEntity)mob;
        this.navigationContext = new NavigationContext(null, null, null, null, false, 0.0f, null, 127, null);
    }

    @NotNull
    public final Level getWorld() {
        return this.world;
    }

    @NotNull
    public final Mob getEntity() {
        return this.entity;
    }

    @NotNull
    public final OmniPathingEntity getPather() {
        return this.pather;
    }

    @Nullable
    public final Node getCachedCurrentNode() {
        return this.cachedCurrentNode;
    }

    public final void setCachedCurrentNode(@Nullable Node node) {
        this.cachedCurrentNode = node;
    }

    public final float getCurrentNodeDistance() {
        return this.currentNodeDistance;
    }

    public final void setCurrentNodeDistance(float f) {
        this.currentNodeDistance = f;
    }

    @NotNull
    public final NavigationContext getNavigationContext() {
        return this.navigationContext;
    }

    public final void setNavigationContext(@NotNull NavigationContext navigationContext) {
        Intrinsics.checkNotNullParameter((Object)navigationContext, (String)"<set-?>");
        this.navigationContext = navigationContext;
    }

    @NotNull
    protected PathFinder createPathFinder(int range) {
        this.nodeEvaluator = new OmniPathNodeMaker();
        this.nodeEvaluator.setCanOpenDoors(false);
        return new PathFinder(this.nodeEvaluator, range);
    }

    protected boolean canUpdatePath() {
        boolean isAtValidPosition;
        Level level = this.mob.level();
        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
        BlockGetter blockGetter = (BlockGetter)level;
        AABB aABB = this.mob.getBoundingBox();
        Intrinsics.checkNotNullExpressionValue((Object)aABB, (String)"getBoundingBox(...)");
        Pair<Boolean, Boolean> pair = WorldExtensionsKt.getWaterAndLavaIn(blockGetter, aABB);
        boolean isInLiquid = (Boolean)pair.component1();
        boolean isTouchingLava = (Boolean)pair.component2();
        boolean bl = isAtValidPosition = !this.mob.isInLava() && !this.mob.isEyeInFluid(FluidTags.LAVA) || isTouchingLava && this.pather.canSwimInLava() || this.mob.isPassenger();
        return this.pather.canSwimInWater() ? isInLiquid || this.mob.onGround() || this.pather.isFlying() || this.mob.isInLiquid() || this.mob.isPassenger() : isAtValidPosition;
    }

    public boolean canFloat() {
        return this.pather.canSwimInWater();
    }

    public final void setCanPathThroughFire(boolean canPathThroughFire) {
        NodeEvaluator nodeEvaluator = this.nodeEvaluator;
        Intrinsics.checkNotNull((Object)nodeEvaluator, (String)"null cannot be cast to non-null type com.cobblemon.mod.common.pokemon.ai.OmniPathNodeMaker");
        OmniPathNodeMaker omniPathNodeMaker = (OmniPathNodeMaker)nodeEvaluator;
        omniPathNodeMaker.setCanPathThroughFire(canPathThroughFire);
    }

    @NotNull
    protected Vec3 getTempMobPos() {
        return new Vec3(this.mob.getX(), (double)this.getPathfindingY(), this.mob.getZ());
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    protected void followThePath() {
        vec3d = this.getTempMobPos();
        v0 = this.getTargetPos();
        v1 = v0 != null && (v0 = BlockPosExtensionsKt.toVec3d(v0)) != null ? v0.add(0.5, 0.0, 0.5) : (targetVec = null);
        if (targetVec != null && targetVec.distanceTo(vec3d) <= (double)this.navigationContext.getDestinationProximity() && this.path != null) {
            this.path = null;
            this.cachedCurrentNode = null;
            this.navigationContext.getOnArrival().invoke();
            v2 = this.path;
            v3 = v2 != null && (v2 = v2.getNextNode()) != null ? v2.type : (node = null);
            if (node != null && node != PathType.OPEN && this.pather.couldStopFlying()) {
                this.pather.setFlying(false);
            }
            return;
        }
        this.maxDistanceToWaypoint = this.mob.getBbWidth() > 0.75f ? this.mob.getBbWidth() / 2.0f : 0.75f - this.mob.getBbWidth() / 2.0f;
        v4 = this.path;
        Intrinsics.checkNotNull((Object)v4);
        currentNode = v4.getNextNode();
        if (!Intrinsics.areEqual((Object)currentNode, (Object)this.cachedCurrentNode)) {
            this.cachedCurrentNode = currentNode;
            this.currentNodeDistance = (float)currentNode.asVec3().distanceTo(this.entity.position());
        } else if (this.cachedCurrentNode != null) {
            v5 = this.cachedCurrentNode;
            Intrinsics.checkNotNull((Object)v5);
            if (v5.asVec3().distanceTo(this.entity.position()) > (double)(this.currentNodeDistance + (float)true)) {
                this.recomputePath();
                this.navigationContext.getOnRecalculate().invoke((Object)true);
                return;
            }
        }
        v6 = this.path;
        Intrinsics.checkNotNull((Object)v6);
        targetVec3d = v6.getNextEntityPos((Entity)this.mob);
        d = Math.abs(this.mob.getX() - targetVec3d.x);
        e = Math.abs(this.mob.getY() - targetVec3d.y);
        f = Math.abs(this.mob.getZ() - targetVec3d.z);
        if (!(d < (double)this.maxDistanceToWaypoint) || !(f < (double)this.maxDistanceToWaypoint)) ** GOTO lbl-1000
        v7 /* !! */  = OmniPathNavigation.verticallyPreciseNodeTypes.contains(currentNode.type) != false && (this.mob.isUnderWater() != false || this.pather.isFlying() != false) ? Float.valueOf(this.maxDistanceToWaypoint) : Double.valueOf(1.0);
        if (e < ((Number)v7 /* !! */ ).doubleValue()) {
            v8 = true;
        } else lbl-1000:
        // 2 sources

        {
            v8 = closeEnough = false;
        }
        if (closeEnough) {
            v9 = this.path;
            Intrinsics.checkNotNull((Object)v9);
            v9.advance();
            v10 = this.path;
            Intrinsics.checkNotNull((Object)v10);
            if (v10.isDone()) {
                this.path = null;
                this.navigationContext.getOnArrival().invoke();
                if (currentNode.type != PathType.OPEN && this.pather.couldStopFlying()) {
                    this.pather.setFlying(false);
                }
            } else {
                v11 = this.path;
                Intrinsics.checkNotNull((Object)v11);
                newNode = v11.getNextNode();
                if (currentNode.type != newNode.type) {
                    if (newNode.type == PathType.OPEN) {
                        this.pather.setFlying(true);
                    } else if (currentNode.type != PathType.OPEN && this.pather.couldStopFlying()) {
                        this.pather.setFlying(false);
                    }
                }
            }
        }
        this.doStuckDetection(vec3d);
    }

    public final boolean isAirborne(@NotNull Level world, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return world.getBlockState(pos).isPathfindable(PathComputationType.AIR) && world.getBlockState(pos.below(1)).isPathfindable(PathComputationType.AIR) && world.getBlockState(pos.below(2)).isPathfindable(PathComputationType.AIR);
    }

    @Nullable
    public final Path findPath(@NotNull BlockPos target, int distance) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return this.createPath((Set)ImmutableSet.of((Object)target), 8, false, distance);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public Path createPath(@NotNull BlockPos target, int distance) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        target = target;
        blockPos = null;
        if (this.world.getBlockState(target).isAir() && !this.pather.canFly()) {
            v0 = target.below();
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"below(...)");
            blockPos = v0;
            while (blockPos.getY() > this.world.getMinBuildHeight() && this.world.getBlockState(blockPos).isAir()) {
                Intrinsics.checkNotNullExpressionValue((Object)blockPos.below(), (String)"below(...)");
            }
            while (blockPos.getY() < this.world.getMaxBuildHeight() && this.world.getBlockState(blockPos).isAir()) {
                Intrinsics.checkNotNullExpressionValue((Object)blockPos.above(), (String)"above(...)");
            }
            target = blockPos;
        }
        if (!(blockState = this.world.getBlockState(target)).isSolid()) ** GOTO lbl-1000
        if (blockState.is(BlockTags.LEAVES) && Intrinsics.areEqual((Object)blockState.getBlock(), (Object)CobblemonBlocks.SACCHARINE_LEAVES)) {
            v1 = this.entity;
            Intrinsics.checkNotNull((Object)v1, (String)"null cannot be cast to non-null type com.cobblemon.mod.common.entity.pokemon.PokemonEntity");
            ** if (!((PokemonEntity)v1).canPathThroughSaccLeaves()) goto lbl-1000
        }
        ** GOTO lbl-1000
lbl-1000:
        // 2 sources

        {
            v2 = this.findPath(target, distance);
            ** GOTO lbl30
        }
lbl-1000:
        // 2 sources

        {
            v3 = target.above();
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"above(...)");
            blockPos = v3;
            while (blockPos.getY() < this.world.getMaxBuildHeight() && this.world.getBlockState(blockPos).isSolid()) {
                Intrinsics.checkNotNullExpressionValue((Object)blockPos.above(), (String)"above(...)");
            }
            v2 = this.findPath(blockPos, distance);
        }
lbl30:
        // 2 sources

        path = v2;
        return path;
    }

    public final void moveTo(double x, double y, double z, double speed, @NotNull NavigationContext navigationContext) {
        Intrinsics.checkNotNullParameter((Object)navigationContext, (String)"navigationContext");
        this.navigationContext = navigationContext;
        this.moveTo(x, y, z, speed);
    }

    public static /* synthetic */ void moveTo$default(OmniPathNavigation omniPathNavigation, double d, double d2, double d3, double d4, NavigationContext navigationContext, int n, Object object) {
        if ((n & 8) != 0) {
            d4 = 1.0;
        }
        omniPathNavigation.moveTo(d, d2, d3, d4, navigationContext);
    }

    public boolean isStableDestination(@NotNull BlockPos pos) {
        BlockGetter blockGetter;
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        if (this.pather.canSwimInWater() && this.mob.isInWater()) {
            Level level = this.level;
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level");
            blockGetter = (BlockGetter)level;
            if (blockGetter.getFluidState(pos).is(FluidTags.WATER)) {
                return true;
            }
        }
        if (this.mob.canBreatheUnderwater()) {
            Level level = this.level;
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level");
            blockGetter = (BlockGetter)level;
            if (blockGetter.getFluidState(pos).is(FluidTags.WATER)) {
                BlockPos blockPos = pos.below();
                return this.level.getBlockState(blockPos).isSolidRender((BlockGetter)this.level, blockPos);
            }
        }
        if (this.pather.canWalkOnWater()) {
            Level level = this.level;
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level");
            blockGetter = (BlockGetter)level;
            if (blockGetter.getFluidState(pos.below()).is(FluidTags.WATER)) {
                return !this.level.getBlockState(pos).isSolidRender((BlockGetter)this.level, pos);
            }
        }
        if (this.pather.canWalkOnLava()) {
            Level level = this.level;
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level");
            blockGetter = (BlockGetter)level;
            if (blockGetter.getFluidState(pos.below()).is(FluidTags.LAVA)) {
                return !this.level.getBlockState(pos).isSolidRender((BlockGetter)this.level, pos);
            }
        }
        if (this.pather.canFly()) {
            return this.level.getBlockState(pos).isAir() || super.isStableDestination(pos);
        }
        return super.isStableDestination(pos);
    }

    protected double getGroundY(@NotNull Vec3 vec) {
        Intrinsics.checkNotNullParameter((Object)vec, (String)"vec");
        Level level = this.level;
        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level");
        BlockGetter blockGetter = (BlockGetter)level;
        BlockPos blockPos = BlockPos.containing((Position)((Position)vec));
        if (this.pather.isFlying() && this.world.getBlockState(blockPos).isPathfindable(PathComputationType.AIR)) {
            return vec.y;
        }
        if (Intrinsics.areEqual((Object)this.world.getBlockState(blockPos).getBlock(), (Object)((Object)CobblemonBlocks.SACCHARINE_LEAVES))) {
            Mob mob = this.entity;
            Intrinsics.checkNotNull((Object)mob, (String)"null cannot be cast to non-null type com.cobblemon.mod.common.entity.pokemon.PokemonEntity");
            if (((PokemonEntity)mob).canPathThroughSaccLeaves()) {
                return vec.y + 0.5;
            }
        }
        return this.canFloat() && blockGetter.getFluidState(blockPos).is(FluidTags.WATER) ? vec.y + 0.5 : super.getGroundY(vec);
    }

    @Nullable
    public Path createPath(@NotNull Entity entity, int distance) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        BlockPos blockPos = entity.blockPosition();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"blockPosition(...)");
        return this.createPath(blockPos, distance);
    }

    public boolean moveTo(@Nullable Path path, double speed) {
        if (path != null && path.getNodeCount() > 0) {
            Node node = path.getNode(0);
            Intrinsics.checkNotNull((Object)node);
            Node node2 = node;
            if (node2.type == PathType.OPEN && this.pather.canFly() && !this.pather.isFlying()) {
                this.pather.setFlying(true);
            }
        }
        return super.moveTo(path, speed);
    }

    protected void trimPath() {
        Vec3 toSubsequentNode;
        super.trimPath();
        Path path = this.getPath();
        if (path == null) {
            return;
        }
        Path path2 = path;
        if (path2.getNodeCount() < 2) {
            return;
        }
        Node introNode = path2.getNode(0);
        Node subsequentNode = path2.getNode(1);
        Vec3 mobMiddle = this.entity.position();
        Vec3 toIntroNode = introNode.asVec3().add(0.5, 0.0, 0.5).subtract(mobMiddle);
        if (toIntroNode.dot(toSubsequentNode = subsequentNode.asVec3().add(0.5, 0.0, 0.5).subtract(mobMiddle)) < 0.0 || toIntroNode.lengthSqr() > toSubsequentNode.lengthSqr()) {
            MiscUtilsKt.deleteNode(path2, 0);
        }
        int i = 2;
        while (i < path2.getNodeCount()) {
            Node firstNode = path2.getNode(i - 2);
            Node middleNode = path2.getNode(i - 1);
            Node nextNode = path2.getNode(i);
            PathType nodeType = firstNode.type;
            if (nodeType != middleNode.type || nodeType != nextNode.type || nodeType == PathType.WALKABLE) {
                ++i;
                continue;
            }
            BlockPos blockPos = middleNode.asBlockPos().subtract((Vec3i)firstNode.asBlockPos());
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"subtract(...)");
            Vec3 directionToMiddle = BlockPosExtensionsKt.toVec3d(blockPos).normalize();
            BlockPos blockPos2 = nextNode.asBlockPos().subtract((Vec3i)middleNode.asBlockPos());
            Intrinsics.checkNotNullExpressionValue((Object)blockPos2, (String)"subtract(...)");
            Vec3 directionToEnd = BlockPosExtensionsKt.toVec3d(blockPos2).normalize();
            if (Math.acos(directionToMiddle.dot(directionToEnd)) > 0.7853981633974483) {
                ++i;
                continue;
            }
            BlockPos blockPos3 = nextNode.asBlockPos().subtract((Vec3i)firstNode.asBlockPos());
            Intrinsics.checkNotNullExpressionValue((Object)blockPos3, (String)"subtract(...)");
            Vec3 directionFromFirstToEnd = BlockPosExtensionsKt.toVec3d(blockPos3);
            double length = directionFromFirstToEnd.length();
            Vec3 vec3 = directionFromFirstToEnd.normalize();
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"normalize(...)");
            directionFromFirstToEnd = vec3;
            List remainingNodes = new ArrayList();
            for (int j = i; j < path2.getNodeCount(); ++j) {
                Node node = path2.getNode(j);
                Intrinsics.checkNotNullExpressionValue((Object)node, (String)"getNode(...)");
                remainingNodes.add(node);
            }
            path2.truncateNodes(i + remainingNodes.size() - 1);
            int n = ((Collection)remainingNodes).size();
            for (int k = 0; k < n; ++k) {
                path2.replaceNode(i - 1 + k, (Node)remainingNodes.get(k));
            }
        }
    }

    public final int getPathfindingY() {
        boolean inSwimmableFluid;
        boolean bl = inSwimmableFluid = this.mob.isEyeInFluid(FluidTags.WATER) && this.pather.canSwimInWater() || this.mob.isEyeInFluid(FluidTags.LAVA) && this.pather.canSwimInLava();
        if (!inSwimmableFluid) {
            return Mth.floor((double)(this.mob.getY() + 0.5));
        }
        return this.mob.getBlockY();
    }

    public void stop() {
        super.stop();
        this.currentNodeDistance = -1.0f;
        this.cachedCurrentNode = null;
        this.path = null;
        this.nodeEvaluator.done();
        if (this.pather.couldStopFlying()) {
            Level level = this.entity.level();
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
            BlockPos blockPos = this.entity.blockPosition();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"blockPosition(...)");
            if (!this.isAirborne(level, blockPos)) {
                this.pather.setFlying(false);
            }
        }
    }

    static {
        Object[] objectArray = new PathType[]{PathType.WATER, PathType.OPEN, PathType.LAVA};
        verticallyPreciseNodeTypes = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001d\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0007\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/cobblemon/mod/common/entity/ai/OmniPathNavigation$Companion;", "", "<init>", "()V", "", "Lnet/minecraft/world/level/pathfinder/PathType;", "verticallyPreciseNodeTypes", "Ljava/util/Set;", "getVerticallyPreciseNodeTypes", "()Ljava/util/Set;", "common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<PathType> getVerticallyPreciseNodeTypes() {
            return verticallyPreciseNodeTypes;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000e\b\u0086\b\u0018\u00002\u00020\u0001B\u009b\u0001\u0012#\b\u0002\u0010\b\u001a\u001d\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0004\u0012\b\b\u0005\u0012\u0004\b\b(\u0006\u0012\u0004\u0012\u00020\u00070\u0002\u0012#\b\u0002\u0010\u000b\u001a\u001d\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\u0004\u0012\b\b\u0005\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u00070\u0002\u0012\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\f\u0012\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\f\u0012\b\b\u0002\u0010\u000f\u001a\u00020\t\u0012\b\b\u0002\u0010\u0011\u001a\u00020\u0010\u0012\u0014\b\u0002\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\t0\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J+\u0010\u0016\u001a\u001d\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0004\u0012\b\b\u0005\u0012\u0004\b\b(\u0006\u0012\u0004\u0012\u00020\u00070\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0016\u0010\u0017J+\u0010\u0018\u001a\u001d\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\u0004\u0012\b\b\u0005\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u00070\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0018\u0010\u0017J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00070\fH\u00c6\u0003\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00070\fH\u00c6\u0003\u00a2\u0006\u0004\b\u001b\u0010\u001aJ\u0010\u0010\u001c\u001a\u00020\tH\u00c6\u0003\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0010\u0010\u001e\u001a\u00020\u0010H\u00c6\u0003\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u001c\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\t0\u0002H\u00c6\u0003\u00a2\u0006\u0004\b \u0010\u0017J\u00a4\u0001\u0010!\u001a\u00020\u00002#\b\u0002\u0010\b\u001a\u001d\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0004\u0012\b\b\u0005\u0012\u0004\b\b(\u0006\u0012\u0004\u0012\u00020\u00070\u00022#\b\u0002\u0010\u000b\u001a\u001d\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\u0004\u0012\b\b\u0005\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u00070\u00022\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\f2\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\f2\b\b\u0002\u0010\u000f\u001a\u00020\t2\b\b\u0002\u0010\u0011\u001a\u00020\u00102\u0014\b\u0002\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\t0\u0002H\u00c6\u0001\u00a2\u0006\u0004\b!\u0010\"J\u001a\u0010$\u001a\u00020\t2\b\u0010#\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b$\u0010%J\u0010\u0010'\u001a\u00020&H\u00d6\u0001\u00a2\u0006\u0004\b'\u0010(J\u0010\u0010*\u001a\u00020)H\u00d6\u0001\u00a2\u0006\u0004\b*\u0010+R2\u0010\b\u001a\u001d\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0004\u0012\b\b\u0005\u0012\u0004\b\b(\u0006\u0012\u0004\u0012\u00020\u00070\u00028\u0006\u00a2\u0006\f\n\u0004\b\b\u0010,\u001a\u0004\b-\u0010\u0017R2\u0010\u000b\u001a\u001d\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\u0004\u0012\b\b\u0005\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u00070\u00028\u0006\u00a2\u0006\f\n\u0004\b\u000b\u0010,\u001a\u0004\b.\u0010\u0017R\u001d\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\f8\u0006\u00a2\u0006\f\n\u0004\b\r\u0010/\u001a\u0004\b0\u0010\u001aR\u001d\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\f8\u0006\u00a2\u0006\f\n\u0004\b\u000e\u0010/\u001a\u0004\b1\u0010\u001aR\u0017\u0010\u000f\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\u000f\u00102\u001a\u0004\b3\u0010\u001dR\u0017\u0010\u0011\u001a\u00020\u00108\u0006\u00a2\u0006\f\n\u0004\b\u0011\u00104\u001a\u0004\b5\u0010\u001fR#\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\t0\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0013\u0010,\u001a\u0004\b6\u0010\u0017\u00a8\u00067"}, d2={"Lcom/cobblemon/mod/common/entity/ai/OmniPathNavigation$NavigationContext;", "", "Lkotlin/Function1;", "Lnet/minecraft/world/damagesource/DamageSource;", "Lkotlin/ParameterName;", "name", "damage", "", "onHit", "", "dueToDistance", "onRecalculate", "Lkotlin/Function0;", "onArrival", "onCannotReach", "sprinting", "", "destinationProximity", "Lnet/minecraft/world/level/pathfinder/PathType;", "destinationPathTypeFilter", "<init>", "(Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;ZFLkotlin/jvm/functions/Function1;)V", "component1", "()Lkotlin/jvm/functions/Function1;", "component2", "component3", "()Lkotlin/jvm/functions/Function0;", "component4", "component5", "()Z", "component6", "()F", "component7", "copy", "(Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;ZFLkotlin/jvm/functions/Function1;)Lcom/cobblemon/mod/common/entity/ai/OmniPathNavigation$NavigationContext;", "other", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Lkotlin/jvm/functions/Function1;", "getOnHit", "getOnRecalculate", "Lkotlin/jvm/functions/Function0;", "getOnArrival", "getOnCannotReach", "Z", "getSprinting", "F", "getDestinationProximity", "getDestinationPathTypeFilter", "common"})
    public static final class NavigationContext {
        @NotNull
        private final Function1<DamageSource, Unit> onHit;
        @NotNull
        private final Function1<Boolean, Unit> onRecalculate;
        @NotNull
        private final Function0<Unit> onArrival;
        @NotNull
        private final Function0<Unit> onCannotReach;
        private final boolean sprinting;
        private final float destinationProximity;
        @NotNull
        private final Function1<PathType, Boolean> destinationPathTypeFilter;

        public NavigationContext(@NotNull Function1<? super DamageSource, Unit> onHit, @NotNull Function1<? super Boolean, Unit> onRecalculate, @NotNull Function0<Unit> onArrival, @NotNull Function0<Unit> onCannotReach, boolean sprinting, float destinationProximity, @NotNull Function1<? super PathType, Boolean> destinationPathTypeFilter) {
            Intrinsics.checkNotNullParameter(onHit, (String)"onHit");
            Intrinsics.checkNotNullParameter(onRecalculate, (String)"onRecalculate");
            Intrinsics.checkNotNullParameter(onArrival, (String)"onArrival");
            Intrinsics.checkNotNullParameter(onCannotReach, (String)"onCannotReach");
            Intrinsics.checkNotNullParameter(destinationPathTypeFilter, (String)"destinationPathTypeFilter");
            this.onHit = onHit;
            this.onRecalculate = onRecalculate;
            this.onArrival = onArrival;
            this.onCannotReach = onCannotReach;
            this.sprinting = sprinting;
            this.destinationProximity = destinationProximity;
            this.destinationPathTypeFilter = destinationPathTypeFilter;
        }

        public /* synthetic */ NavigationContext(Function1 function1, Function1 function12, Function0 function0, Function0 function02, boolean bl, float f, Function1 function13, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                function1 = NavigationContext::_init_$lambda$0;
            }
            if ((n & 2) != 0) {
                function12 = NavigationContext::_init_$lambda$1;
            }
            if ((n & 4) != 0) {
                function0 = NavigationContext::_init_$lambda$2;
            }
            if ((n & 8) != 0) {
                function02 = NavigationContext::_init_$lambda$3;
            }
            if ((n & 0x10) != 0) {
                bl = false;
            }
            if ((n & 0x20) != 0) {
                f = 0.01f;
            }
            if ((n & 0x40) != 0) {
                function13 = NavigationContext::_init_$lambda$4;
            }
            this((Function1<? super DamageSource, Unit>)function1, (Function1<? super Boolean, Unit>)function12, (Function0<Unit>)function0, (Function0<Unit>)function02, bl, f, (Function1<? super PathType, Boolean>)function13);
        }

        @NotNull
        public final Function1<DamageSource, Unit> getOnHit() {
            return this.onHit;
        }

        @NotNull
        public final Function1<Boolean, Unit> getOnRecalculate() {
            return this.onRecalculate;
        }

        @NotNull
        public final Function0<Unit> getOnArrival() {
            return this.onArrival;
        }

        @NotNull
        public final Function0<Unit> getOnCannotReach() {
            return this.onCannotReach;
        }

        public final boolean getSprinting() {
            return this.sprinting;
        }

        public final float getDestinationProximity() {
            return this.destinationProximity;
        }

        @NotNull
        public final Function1<PathType, Boolean> getDestinationPathTypeFilter() {
            return this.destinationPathTypeFilter;
        }

        @NotNull
        public final Function1<DamageSource, Unit> component1() {
            return this.onHit;
        }

        @NotNull
        public final Function1<Boolean, Unit> component2() {
            return this.onRecalculate;
        }

        @NotNull
        public final Function0<Unit> component3() {
            return this.onArrival;
        }

        @NotNull
        public final Function0<Unit> component4() {
            return this.onCannotReach;
        }

        public final boolean component5() {
            return this.sprinting;
        }

        public final float component6() {
            return this.destinationProximity;
        }

        @NotNull
        public final Function1<PathType, Boolean> component7() {
            return this.destinationPathTypeFilter;
        }

        @NotNull
        public final NavigationContext copy(@NotNull Function1<? super DamageSource, Unit> onHit, @NotNull Function1<? super Boolean, Unit> onRecalculate, @NotNull Function0<Unit> onArrival, @NotNull Function0<Unit> onCannotReach, boolean sprinting, float destinationProximity, @NotNull Function1<? super PathType, Boolean> destinationPathTypeFilter) {
            Intrinsics.checkNotNullParameter(onHit, (String)"onHit");
            Intrinsics.checkNotNullParameter(onRecalculate, (String)"onRecalculate");
            Intrinsics.checkNotNullParameter(onArrival, (String)"onArrival");
            Intrinsics.checkNotNullParameter(onCannotReach, (String)"onCannotReach");
            Intrinsics.checkNotNullParameter(destinationPathTypeFilter, (String)"destinationPathTypeFilter");
            return new NavigationContext(onHit, onRecalculate, onArrival, onCannotReach, sprinting, destinationProximity, destinationPathTypeFilter);
        }

        public static /* synthetic */ NavigationContext copy$default(NavigationContext navigationContext, Function1 function1, Function1 function12, Function0 function0, Function0 function02, boolean bl, float f, Function1 function13, int n, Object object) {
            if ((n & 1) != 0) {
                function1 = navigationContext.onHit;
            }
            if ((n & 2) != 0) {
                function12 = navigationContext.onRecalculate;
            }
            if ((n & 4) != 0) {
                function0 = navigationContext.onArrival;
            }
            if ((n & 8) != 0) {
                function02 = navigationContext.onCannotReach;
            }
            if ((n & 0x10) != 0) {
                bl = navigationContext.sprinting;
            }
            if ((n & 0x20) != 0) {
                f = navigationContext.destinationProximity;
            }
            if ((n & 0x40) != 0) {
                function13 = navigationContext.destinationPathTypeFilter;
            }
            return navigationContext.copy(function1, function12, function0, function02, bl, f, function13);
        }

        @NotNull
        public String toString() {
            return "NavigationContext(onHit=" + this.onHit + ", onRecalculate=" + this.onRecalculate + ", onArrival=" + this.onArrival + ", onCannotReach=" + this.onCannotReach + ", sprinting=" + this.sprinting + ", destinationProximity=" + this.destinationProximity + ", destinationPathTypeFilter=" + this.destinationPathTypeFilter + ")";
        }

        public int hashCode() {
            int result = this.onHit.hashCode();
            result = result * 31 + this.onRecalculate.hashCode();
            result = result * 31 + this.onArrival.hashCode();
            result = result * 31 + this.onCannotReach.hashCode();
            result = result * 31 + Boolean.hashCode(this.sprinting);
            result = result * 31 + Float.hashCode(this.destinationProximity);
            result = result * 31 + this.destinationPathTypeFilter.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof NavigationContext)) {
                return false;
            }
            NavigationContext navigationContext = (NavigationContext)other;
            if (!Intrinsics.areEqual(this.onHit, navigationContext.onHit)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.onRecalculate, navigationContext.onRecalculate)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.onArrival, navigationContext.onArrival)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.onCannotReach, navigationContext.onCannotReach)) {
                return false;
            }
            if (this.sprinting != navigationContext.sprinting) {
                return false;
            }
            if (Float.compare(this.destinationProximity, navigationContext.destinationProximity) != 0) {
                return false;
            }
            return Intrinsics.areEqual(this.destinationPathTypeFilter, navigationContext.destinationPathTypeFilter);
        }

        private static final Unit _init_$lambda$0(DamageSource it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Unit.INSTANCE;
        }

        private static final Unit _init_$lambda$1(boolean it) {
            return Unit.INSTANCE;
        }

        private static final Unit _init_$lambda$2() {
            return Unit.INSTANCE;
        }

        private static final Unit _init_$lambda$3() {
            return Unit.INSTANCE;
        }

        private static final boolean _init_$lambda$4(PathType it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return true;
        }

        public NavigationContext() {
            this(null, null, null, null, false, 0.0f, null, 127, null);
        }
    }
}

