/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.entity.pokemon.ai.tasks;

import com.cobblemon.mod.common.CobblemonMemories;
import com.cobblemon.mod.common.api.molang.ExpressionLike;
import com.cobblemon.mod.common.api.molang.MoLangFunctions;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.entity.pokemon.ai.tasks.PickUpItemTask;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.ai.ObtainableItem;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import com.cobblemon.mod.common.util.MoLangExtensionsKt;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 &2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001&B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\t\u0010\nJ'\u0010\r\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u000bH\u0014\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001f\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J'\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u000bH\u0014\u00a2\u0006\u0004\b\u0014\u0010\u0015J'\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u000bH\u0014\u00a2\u0006\u0004\b\u0018\u0010\u0015J'\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u000bH\u0014\u00a2\u0006\u0004\b\u0019\u0010\u0015J\u001f\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0003\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u0016\u0010\u001e\u001a\u00020\u000b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001fR\u001d\u0010\"\u001a\b\u0012\u0004\u0012\u00020!0 8\u0006\u00a2\u0006\f\n\u0004\b\"\u0010#\u001a\u0004\b$\u0010%\u00a8\u0006'"}, d2={"Lcom/cobblemon/mod/common/entity/pokemon/ai/tasks/EatHeldItemTask;", "Lnet/minecraft/world/entity/ai/behavior/Behavior;", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "entity", "<init>", "(Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)V", "Lnet/minecraft/server/level/ServerLevel;", "world", "", "checkExtraStartConditions", "(Lnet/minecraft/server/level/ServerLevel;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)Z", "", "time", "canStillUse", "(Lnet/minecraft/server/level/ServerLevel;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;J)Z", "Lnet/minecraft/world/item/ItemStack;", "item", "canEat", "(Lnet/minecraft/world/item/ItemStack;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)Z", "", "start", "(Lnet/minecraft/server/level/ServerLevel;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;J)V", "level", "gameTime", "stop", "tick", "Lnet/minecraft/world/entity/LivingEntity;", "itemStack", "spawnFoodParticles", "(Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/item/ItemStack;)V", "timelastEaten", "J", "", "Lcom/cobblemon/mod/common/pokemon/ai/ObtainableItem;", "pickupItems", "Ljava/util/List;", "getPickupItems", "()Ljava/util/List;", "Companion", "common"})
public final class EatHeldItemTask
extends Behavior<PokemonEntity> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private long timelastEaten;
    @NotNull
    private final List<ObtainableItem> pickupItems;
    private static final int MAX_DURATION = 60;
    private static final int COOLDOWN = 120;

    public EatHeldItemTask(@NotNull PokemonEntity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        super((Map)ImmutableMap.of((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT));
        this.pickupItems = MoLangExtensionsKt.getObjectList(entity.getConfig(), "pickup_items");
    }

    @NotNull
    public final List<ObtainableItem> getPickupItems() {
        return this.pickupItems;
    }

    protected boolean checkExtraStartConditions(@NotNull ServerLevel world, @NotNull PokemonEntity entity) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (this.timelastEaten + (long)120 > world.getGameTime()) {
            return false;
        }
        ItemStack itemStack = entity.getPokemon().heldItem();
        return !itemStack.isEmpty() && this.canEat(itemStack, entity) && !entity.isBusy();
    }

    protected boolean canStillUse(@NotNull ServerLevel world, @NotNull PokemonEntity entity, long time) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return !entity.getPokemon().getHeldItem$common().isEmpty() && !entity.getPokemon().isFull() && !entity.isBusy();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean canEat(ItemStack item, PokemonEntity entity) {
        if (item.has(DataComponents.FOOD)) return true;
        Collection collection = this.pickupItems;
        RegistryAccess registryAccess = entity.registryAccess();
        Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
        ObtainableItem obtainableItem = MiscUtilsKt.findMatchingEntry(collection, registryAccess, item);
        if (obtainableItem == null) return false;
        ExpressionLike expressionLike = obtainableItem.getOnUseEffect();
        if (expressionLike == null) return false;
        return true;
    }

    protected void start(@NotNull ServerLevel world, @NotNull PokemonEntity entity, long time) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        this.timelastEaten = time;
        entity.getBrain().setMemory(CobblemonMemories.IS_CONSUMING_ITEM, (Object)true);
    }

    protected void stop(@NotNull ServerLevel level, @NotNull PokemonEntity entity, long gameTime) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        entity.getBrain().eraseMemory(CobblemonMemories.IS_CONSUMING_ITEM);
    }

    protected void tick(@NotNull ServerLevel world, @NotNull PokemonEntity entity, long time) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (!world.isClientSide && entity.isAlive()) {
            ItemStack itemStack = entity.getPokemon().heldItem();
            Collection collection = this.pickupItems;
            RegistryAccess registryAccess = entity.registryAccess();
            Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
            ObtainableItem itemConfig = MiscUtilsKt.findMatchingEntry(collection, registryAccess, itemStack);
            if (this.canEat(itemStack, entity)) {
                if (this.timelastEaten + (long)60 <= time) {
                    ExpressionLike onUseEffect;
                    ResourceLocation configuredReturnItem;
                    ItemStack resultItemStack = itemStack.finishUsingItem((Level)world, (LivingEntity)entity);
                    ObtainableItem obtainableItem = itemConfig;
                    Object object = configuredReturnItem = obtainableItem != null ? obtainableItem.getReturnItem() : null;
                    resultItemStack = !Intrinsics.areEqual((Object)configuredReturnItem, (Object)ItemStack.EMPTY) ? new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(configuredReturnItem)) : (Intrinsics.areEqual((Object)resultItemStack.getItem(), (Object)itemStack.getItem()) ? ItemStack.EMPTY : resultItemStack);
                    Pokemon pokemon = entity.getPokemon();
                    ItemStack itemStack2 = resultItemStack;
                    Intrinsics.checkNotNull((Object)itemStack2);
                    Pokemon.swapHeldItem$default(pokemon, itemStack2, false, false, 6, null);
                    ObtainableItem obtainableItem2 = itemConfig;
                    ExpressionLike expressionLike = onUseEffect = obtainableItem2 != null ? obtainableItem2.getOnUseEffect() : null;
                    if (onUseEffect != null) {
                        MoLangExtensionsKt.withQueryValue(MoLangExtensionsKt.getMainThreadRuntime(), "entity", MoLangFunctions.INSTANCE.asMostSpecificMoLangValue((Entity)entity));
                        MoLangExtensionsKt.resolve$default(MoLangExtensionsKt.getMainThreadRuntime(), onUseEffect, null, 2, null);
                    }
                    this.timelastEaten = time;
                    if (itemConfig != null && itemConfig.getFullnessValue() > 0) {
                        entity.getPokemon().feedPokemon(itemConfig.getFullnessValue(), false);
                    }
                    resultItemStack = entity.getPokemon().heldItem();
                    Collection collection2 = this.pickupItems;
                    RegistryAccess registryAccess2 = entity.registryAccess();
                    Intrinsics.checkNotNullExpressionValue((Object)registryAccess2, (String)"registryAccess(...)");
                    ObtainableItem obtainableItem3 = MiscUtilsKt.findMatchingEntry(collection2, registryAccess2, resultItemStack);
                    if ((obtainableItem3 != null ? obtainableItem3.getPickupPriority() : 0) < 0 && !(resultItemStack = Pokemon.swapHeldItem$default(entity.getPokemon(), resultItemStack, false, false, 6, null)).isEmpty() && !entity.level().isClientSide) {
                        PickUpItemTask.INSTANCE.dropItem((Entity)entity, resultItemStack);
                    }
                } else {
                    ObtainableItem obtainableItem = itemConfig;
                    if ((obtainableItem != null ? obtainableItem.getFullnessValue() : 0) > 0 && this.timelastEaten > 0L && entity.getRandom().nextFloat() < 0.4f) {
                        entity.playSound(entity.getEatingSound(itemStack), 1.0f, 1.0f);
                        world.broadcastEntityEvent((Entity)entity, (byte)45);
                        this.spawnFoodParticles((LivingEntity)entity, itemStack);
                    }
                }
            }
        }
    }

    private final void spawnFoodParticles(LivingEntity entity, ItemStack itemStack) {
        Level level = entity.level();
        Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
        ServerLevel serverLevel = (ServerLevel)level;
        serverLevel.sendParticles((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, itemStack), entity.getX(), entity.getY() + 0.5, entity.getZ(), 5, 0.1, 0.1, 0.1, 0.05);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0006\u00a8\u0006\b"}, d2={"Lcom/cobblemon/mod/common/entity/pokemon/ai/tasks/EatHeldItemTask$Companion;", "", "<init>", "()V", "", "MAX_DURATION", "I", "COOLDOWN", "common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

