/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.entity.pokemon.ai.tasks;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u0000 '2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001'B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\t\u0010\nJ'\u0010\r\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u000bH\u0014\u00a2\u0006\u0004\b\r\u0010\u000eJ%\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J'\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u000bH\u0014\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J'\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u000bH\u0014\u00a2\u0006\u0004\b\u0017\u0010\u0014J'\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u000bH\u0014\u00a2\u0006\u0004\b\u0018\u0010\u0014J\u0017\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u0016J\u0017\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u0016J\u001d\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u001b\u00a2\u0006\u0004\b\u001d\u0010\u001eR\u001c\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00020\u000f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 R\u001c\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001b0\u000f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b!\u0010 R\u0016\u0010\"\u001a\u00020\b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\"\u0010#R\u0016\u0010%\u001a\u00020$8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b%\u0010&\u00a8\u0006("}, d2={"Lcom/cobblemon/mod/common/entity/pokemon/ai/tasks/HuntPlayerTask;", "Lnet/minecraft/world/entity/ai/behavior/Behavior;", "Lnet/minecraft/world/entity/LivingEntity;", "<init>", "()V", "Lnet/minecraft/server/level/ServerLevel;", "world", "entity", "", "checkExtraStartConditions", "(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/LivingEntity;)Z", "", "time", "canStillUse", "(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/LivingEntity;J)Z", "Ljava/util/Optional;", "findPlayer", "(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/LivingEntity;)Ljava/util/Optional;", "", "start", "(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/LivingEntity;J)V", "addLookWalkTargets", "(Lnet/minecraft/world/entity/LivingEntity;)V", "stop", "tick", "startSearching", "performSearch", "Lnet/minecraft/core/BlockPos;", "pos", "onEntityHeard", "(Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/core/BlockPos;)V", "targetEntity", "Ljava/util/Optional;", "lastKnownLocation", "searching", "Z", "", "searchTime", "I", "Companion", "common"})
@SourceDebugExtension(value={"SMAP\nHuntPlayerTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HuntPlayerTask.kt\ncom/cobblemon/mod/common/entity/pokemon/ai/tasks/HuntPlayerTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,182:1\n774#2:183\n865#2,2:184\n2423#2,14:186\n1#3:200\n*S KotlinDebug\n*F\n+ 1 HuntPlayerTask.kt\ncom/cobblemon/mod/common/entity/pokemon/ai/tasks/HuntPlayerTask\n*L\n66#1:183\n66#1:184,2\n68#1:186,14\n*E\n"})
public final class HuntPlayerTask
extends Behavior<LivingEntity> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Optional<LivingEntity> targetEntity;
    @NotNull
    private Optional<BlockPos> lastKnownLocation;
    private boolean searching;
    private int searchTime;
    private static final int MAX_SEARCH_DURATION = 1000;
    private static final int SEARCH_RADIUS = 20;
    private static final double ATTACK_RANGE = 2.0;
    private static final float WALK_SPEED = 0.5f;

    public HuntPlayerTask() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.DISTURBANCE_LOCATION, (Object)MemoryStatus.VALUE_PRESENT));
        Optional optional = Optional.empty();
        Intrinsics.checkNotNullExpressionValue(optional, (String)"empty(...)");
        this.targetEntity = optional;
        Optional optional2 = Optional.empty();
        Intrinsics.checkNotNullExpressionValue(optional2, (String)"empty(...)");
        this.lastKnownLocation = optional2;
    }

    protected boolean checkExtraStartConditions(@NotNull ServerLevel world, @NotNull LivingEntity entity) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        this.targetEntity = this.findPlayer(world, entity);
        return this.targetEntity.isPresent();
    }

    protected boolean canStillUse(@NotNull ServerLevel world, @NotNull LivingEntity entity, long time) {
        boolean isStillSearching;
        boolean canSeePlayer;
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        boolean bl = canSeePlayer = this.targetEntity.isPresent() && entity.hasLineOfSight((Entity)this.targetEntity.get());
        if (!canSeePlayer) {
            this.searching = true;
        }
        boolean bl2 = isStillSearching = this.searching && this.searchTime < 1000;
        return canSeePlayer || isStillSearching;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private final Optional<LivingEntity> findPlayer(ServerLevel world, LivingEntity entity) {
        Object object;
        Object v1;
        void $this$minByOrNull$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        List list = world.players();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"players(...)");
        Optional<ServerPlayer> optional = list;
        boolean $i$f$filter = false;
        void var6_5 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ServerPlayer it = (ServerPlayer)element$iv$iv;
            boolean bl = false;
            if (!(it.isAlive() && entity.hasLineOfSight((Entity)it) && entity.distanceToSqr((Entity)it) <= 400.0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v1 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v1 = minElem$iv;
            } else {
                ServerPlayer it = (ServerPlayer)minElem$iv;
                boolean bl = false;
                double minValue$iv = entity.distanceToSqr((Entity)it);
                do {
                    Object e$iv = iterator$iv.next();
                    ServerPlayer it2 = (ServerPlayer)e$iv;
                    $i$a$-minByOrNull-HuntPlayerTask$findPlayer$2 = false;
                    double v$iv = entity.distanceToSqr((Entity)it2);
                    if (Double.compare(minValue$iv, v$iv) <= 0) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v1 = minElem$iv;
            }
        }
        ServerPlayer serverPlayer = v1;
        if (serverPlayer != null) {
            ServerPlayer it = serverPlayer;
            boolean bl = false;
            optional = Optional.of(it);
            if (optional != null) {
                object = optional;
                return object;
            }
        }
        Optional<LivingEntity> optional2 = Optional.empty();
        object = optional2;
        Intrinsics.checkNotNullExpressionValue(optional2, (String)"empty(...)");
        return object;
    }

    protected void start(@NotNull ServerLevel world, @NotNull LivingEntity entity, long time) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        this.addLookWalkTargets(entity);
        this.searching = false;
        this.searchTime = 0;
        super.start(world, entity, time);
    }

    private final void addLookWalkTargets(LivingEntity entity) {
        this.targetEntity.ifPresent(arg_0 -> HuntPlayerTask.addLookWalkTargets$lambda$1(arg_0 -> HuntPlayerTask.addLookWalkTargets$lambda$0(entity, arg_0), arg_0));
    }

    protected void stop(@NotNull ServerLevel world, @NotNull LivingEntity entity, long time) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Optional optional = Optional.empty();
        Intrinsics.checkNotNullExpressionValue(optional, (String)"empty(...)");
        this.targetEntity = optional;
        this.searching = false;
    }

    protected void tick(@NotNull ServerLevel world, @NotNull LivingEntity entity, long time) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (this.searching) {
            int n = this.searchTime;
            this.searchTime = n + 1;
            if (this.searchTime >= 1000) {
                this.stop(world, entity, time);
                return;
            }
        }
        if (this.targetEntity.isPresent() && entity.hasLineOfSight((Entity)this.targetEntity.get())) {
            LivingEntity livingEntity = this.targetEntity.get();
            Intrinsics.checkNotNullExpressionValue((Object)livingEntity, (String)"get(...)");
            LivingEntity target = livingEntity;
            if (target.isAlive()) {
                if (entity.distanceToSqr((Entity)target) <= 4.0) {
                    entity.doHurtTarget((Entity)target);
                } else {
                    this.addLookWalkTargets(entity);
                }
                Optional<BlockPos> optional = Optional.of(target.blockPosition());
                Intrinsics.checkNotNullExpressionValue(optional, (String)"of(...)");
                this.lastKnownLocation = optional;
                this.searchTime = 0;
            } else {
                this.startSearching(entity);
            }
        } else if (this.searching) {
            this.performSearch(entity);
        } else {
            this.targetEntity = this.findPlayer(world, entity);
        }
    }

    private final void startSearching(LivingEntity entity) {
        if (this.lastKnownLocation.isPresent()) {
            this.searching = true;
            this.searchTime = 0;
            entity.getBrain().setMemory(MemoryModuleType.WALK_TARGET, (Object)new WalkTarget(this.lastKnownLocation.get(), 0.5f, 1));
        }
    }

    private final void performSearch(LivingEntity entity) {
        if (!this.lastKnownLocation.isPresent()) {
            this.searching = false;
            return;
        }
        int n = this.searchTime;
        this.searchTime = n + 1;
        if (this.searchTime % 20 == 0) {
            BlockPos randomPos = this.lastKnownLocation.get().offset(entity.getRandom().nextInt(40) - 20, 0, entity.getRandom().nextInt(40) - 20);
            entity.getBrain().setMemory(MemoryModuleType.WALK_TARGET, (Object)new WalkTarget(randomPos, 0.5f, 1));
        }
        if (this.searchTime >= 1000) {
            this.searching = false;
            Level level = entity.level();
            Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
            this.targetEntity = this.findPlayer((ServerLevel)level, entity);
        }
        Optional disturbanceLocation = entity.getBrain().getMemory(MemoryModuleType.DISTURBANCE_LOCATION);
        disturbanceLocation.ifPresent(arg_0 -> HuntPlayerTask.performSearch$lambda$1(arg_0 -> HuntPlayerTask.performSearch$lambda$0(this, entity, arg_0), arg_0));
    }

    public final void onEntityHeard(@NotNull LivingEntity entity, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        if (this.searching && !this.targetEntity.isPresent()) {
            this.searchTime = 0;
            Optional<BlockPos> optional = Optional.of(pos);
            Intrinsics.checkNotNullExpressionValue(optional, (String)"of(...)");
            this.lastKnownLocation = optional;
            entity.getBrain().setMemory(MemoryModuleType.WALK_TARGET, (Object)new WalkTarget(pos, 0.5f, 1));
        }
    }

    private static final Unit addLookWalkTargets$lambda$0(LivingEntity $entity, LivingEntity target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        EntityTracker lookTarget = new EntityTracker((Entity)target, true);
        $entity.getBrain().setMemory(MemoryModuleType.LOOK_TARGET, (Object)lookTarget);
        $entity.getBrain().setMemory(MemoryModuleType.WALK_TARGET, (Object)new WalkTarget((PositionTracker)lookTarget, 0.5f, 1));
        return Unit.INSTANCE;
    }

    private static final void addLookWalkTargets$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit performSearch$lambda$0(HuntPlayerTask this$0, LivingEntity $entity, BlockPos it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.onEntityHeard($entity, it);
        return Unit.INSTANCE;
    }

    private static final void performSearch$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0006R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\t\u0010\nR\u0014\u0010\f\u001a\u00020\u000b8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/cobblemon/mod/common/entity/pokemon/ai/tasks/HuntPlayerTask$Companion;", "", "<init>", "()V", "", "MAX_SEARCH_DURATION", "I", "SEARCH_RADIUS", "", "ATTACK_RANGE", "D", "", "WALK_SPEED", "F", "common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

