/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.entity.pokemon.ai.tasks;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000e\u0018\u0000 \"2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\"B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\t\u0010\nJ'\u0010\r\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u000bH\u0014\u00a2\u0006\u0004\b\r\u0010\u000eJ'\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u000bH\u0014\u00a2\u0006\u0004\b\u0010\u0010\u0011J'\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u000bH\u0014\u00a2\u0006\u0004\b\u0012\u0010\u0011J7\u0010\u0019\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ7\u0010\u001b\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001aR\"\u0010\u001c\u001a\u00020\b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!\u00a8\u0006#"}, d2={"Lcom/cobblemon/mod/common/entity/pokemon/ai/tasks/JumpOutOfWaterTask;", "Lnet/minecraft/world/entity/ai/behavior/Behavior;", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "<init>", "()V", "Lnet/minecraft/server/level/ServerLevel;", "world", "entity", "", "checkExtraStartConditions", "(Lnet/minecraft/server/level/ServerLevel;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)Z", "", "time", "canStillUse", "(Lnet/minecraft/server/level/ServerLevel;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;J)Z", "", "start", "(Lnet/minecraft/server/level/ServerLevel;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;J)V", "tick", "Lnet/minecraft/core/BlockPos;", "pos", "", "offsetX", "offsetZ", "multiplier", "isWater", "(Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;Lnet/minecraft/core/BlockPos;III)Z", "isAirAbove", "inWater", "Z", "getInWater", "()Z", "setInWater", "(Z)V", "Companion", "common"})
public final class JumpOutOfWaterTask
extends Behavior<PokemonEntity> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean inWater;
    private static final int MAX_DURATION = 80;
    private static final int CHANCE = 10;
    @NotNull
    private static final int[] OFFSET_MULTIPLIERS;

    public JumpOutOfWaterTask() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.IS_IN_WATER, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT));
    }

    public final boolean getInWater() {
        return this.inWater;
    }

    public final void setInWater(boolean bl) {
        this.inWater = bl;
    }

    protected boolean checkExtraStartConditions(@NotNull ServerLevel world, @NotNull PokemonEntity entity) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (entity.getRandom().nextInt(10) != 0) {
            return false;
        }
        Direction direction = entity.getMotionDirection();
        int x = direction.getStepX();
        int z = direction.getStepZ();
        BlockPos blockPos = entity.blockPosition();
        for (int offset : OFFSET_MULTIPLIERS) {
            Intrinsics.checkNotNull((Object)blockPos);
            if (this.isWater(entity, blockPos, x, z, offset) && this.isAirAbove(entity, blockPos, x, z, offset)) continue;
            return false;
        }
        return true;
    }

    protected boolean canStillUse(@NotNull ServerLevel world, @NotNull PokemonEntity entity, long time) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        double d = entity.getDeltaMovement().y;
        return !(d * d < (double)0.03f && !(entity.getXRot() == 0.0f) && Math.abs(entity.getXRot()) < 10.0f && entity.isInWater() || entity.onGround());
    }

    protected void start(@NotNull ServerLevel world, @NotNull PokemonEntity entity, long time) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Direction direction = entity.getMotionDirection();
        Vec3 newVelocity = entity.getDeltaMovement().add((double)direction.getStepX() * 0.6, 0.7, (double)direction.getStepZ() * 0.6);
        entity.setDeltaMovement(newVelocity);
        entity.getNavigation().stop();
    }

    protected void tick(@NotNull ServerLevel world, @NotNull PokemonEntity entity, long time) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        boolean bl = this.inWater;
        if (!bl) {
            FluidState fluidState = entity.level().getFluidState(entity.blockPosition());
            Intrinsics.checkNotNullExpressionValue((Object)fluidState, (String)"getFluidState(...)");
            FluidState fluidState2 = fluidState;
            this.inWater = fluidState2.is(FluidTags.WATER);
        }
        if (this.inWater && !bl) {
            entity.playSound(SoundEvents.DOLPHIN_JUMP, 1.0f, 1.0f);
        }
        Vec3 vec3d = entity.getDeltaMovement();
        if (vec3d.y * vec3d.y < (double)0.03f && !(entity.getXRot() == 0.0f)) {
            entity.setXRot(Mth.rotLerp((float)0.2f, (float)entity.getXRot(), (float)0.0f));
        } else if (vec3d.length() > (double)1.0E-5f) {
            double d = vec3d.horizontalDistance();
            double e = Math.atan2(-vec3d.y, d) * 57.2957763671875;
            entity.setXRot((float)e);
        }
    }

    private final boolean isWater(PokemonEntity entity, BlockPos pos, int offsetX, int offsetZ, int multiplier) {
        BlockPos blockPos = pos.offset(offsetX * multiplier, 0, offsetZ * multiplier);
        return entity.level().getFluidState(blockPos).is(FluidTags.WATER) && !entity.level().getBlockState(blockPos).blocksMotion();
    }

    private final boolean isAirAbove(PokemonEntity entity, BlockPos pos, int offsetX, int offsetZ, int multiplier) {
        return entity.level().getBlockState(pos.offset(offsetX * multiplier, 1, offsetZ * multiplier)).isAir() && entity.level().getBlockState(pos.offset(offsetX * multiplier, 2, offsetZ * multiplier)).isAir();
    }

    static {
        int[] nArray = new int[]{0, 1, 4, 5, 6, 7};
        OFFSET_MULTIPLIERS = nArray;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0006R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/cobblemon/mod/common/entity/pokemon/ai/tasks/JumpOutOfWaterTask$Companion;", "", "<init>", "()V", "", "MAX_DURATION", "I", "CHANCE", "", "OFFSET_MULTIPLIERS", "[I", "common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

