/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.item;

import com.cobblemon.mod.common.api.mulch.MulchVariant;
import com.cobblemon.mod.common.api.mulch.Mulchable;
import com.cobblemon.mod.common.item.CobblemonItem;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ1\u0010\u0014\u001a\u00020\u00132\b\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lcom/cobblemon/mod/common/item/MulchItem;", "Lcom/cobblemon/mod/common/item/CobblemonItem;", "Lcom/cobblemon/mod/common/api/mulch/MulchVariant;", "variant", "<init>", "(Lcom/cobblemon/mod/common/api/mulch/MulchVariant;)V", "Lnet/minecraft/world/item/context/UseOnContext;", "context", "Lnet/minecraft/world/InteractionResult;", "useOn", "(Lnet/minecraft/world/item/context/UseOnContext;)Lnet/minecraft/world/InteractionResult;", "Lnet/minecraft/world/entity/player/Player;", "player", "Lnet/minecraft/world/item/ItemStack;", "stack", "Lnet/minecraft/world/level/Level;", "world", "Lnet/minecraft/core/BlockPos;", "pos", "", "useOnMulchAble", "(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)Z", "Lcom/cobblemon/mod/common/api/mulch/MulchVariant;", "getVariant", "()Lcom/cobblemon/mod/common/api/mulch/MulchVariant;", "common"})
public final class MulchItem
extends CobblemonItem {
    @NotNull
    private final MulchVariant variant;

    public MulchItem(@NotNull MulchVariant variant) {
        Intrinsics.checkNotNullParameter((Object)((Object)variant), (String)"variant");
        super(new Item.Properties());
        this.variant = variant;
    }

    @NotNull
    public final MulchVariant getVariant() {
        return this.variant;
    }

    @NotNull
    public InteractionResult useOn(@NotNull UseOnContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Player player = context.getPlayer();
        ItemStack itemStack = context.getItemInHand();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItemInHand(...)");
        Intrinsics.checkNotNull((Object)world);
        Intrinsics.checkNotNull((Object)pos);
        if (this.useOnMulchAble(player, itemStack, world, pos)) {
            if (!world.isClientSide) {
                world.levelEvent(1505, pos, 0);
            }
            InteractionResult interactionResult = InteractionResult.sidedSuccess((boolean)true);
            Intrinsics.checkNotNullExpressionValue((Object)interactionResult, (String)"sidedSuccess(...)");
            return interactionResult;
        }
        return InteractionResult.PASS;
    }

    private final boolean useOnMulchAble(Player player, ItemStack stack, Level world, BlockPos pos) {
        BlockState state = world.getBlockState(pos);
        if (state.getBlock() instanceof Mulchable) {
            Block block = state.getBlock();
            Mulchable mulchable = block instanceof Mulchable ? (Mulchable)block : null;
            if (mulchable == null) {
                return false;
            }
            Mulchable mulchAble = mulchable;
            if (world instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)world;
                Intrinsics.checkNotNull((Object)state);
                if (mulchAble.canHaveMulchApplied(serverLevel, pos, state, this.variant)) {
                    ServerLevel serverLevel2 = (ServerLevel)world;
                    RandomSource randomSource = world.random;
                    Intrinsics.checkNotNullExpressionValue((Object)randomSource, (String)"random");
                    mulchAble.applyMulch(serverLevel2, randomSource, pos, state, this.variant);
                    stack.consume(1, (LivingEntity)player);
                    return true;
                }
            }
        }
        return false;
    }
}

