/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.item.interactive;

import com.cobblemon.mod.common.CobblemonSounds;
import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.api.events.Cancelable;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.events.pokemon.healing.PokemonHealedEvent;
import com.cobblemon.mod.common.api.item.HealingSource;
import com.cobblemon.mod.common.api.item.PokemonSelectingItem;
import com.cobblemon.mod.common.api.reactive.CancelableObservable;
import com.cobblemon.mod.common.api.reactive.EventObservable;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.item.CobblemonItem;
import com.cobblemon.mod.common.item.battle.BagItem;
import com.cobblemon.mod.common.pokemon.Pokemon;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001f\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ-\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u00132\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J/\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00132\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J'\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001aH\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eR\u001a\u0010 \u001a\u00020\u001f8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b \u0010!\u001a\u0004\b\"\u0010#\u00a8\u0006$"}, d2={"Lcom/cobblemon/mod/common/item/interactive/BerryJuiceItem;", "Lcom/cobblemon/mod/common/item/CobblemonItem;", "Lcom/cobblemon/mod/common/api/item/PokemonSelectingItem;", "Lcom/cobblemon/mod/common/api/item/HealingSource;", "<init>", "()V", "Lnet/minecraft/world/item/ItemStack;", "stack", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "pokemon", "", "canUseOnPokemon", "(Lnet/minecraft/world/item/ItemStack;Lcom/cobblemon/mod/common/pokemon/Pokemon;)Z", "Lnet/minecraft/world/level/Level;", "world", "Lnet/minecraft/world/entity/player/Player;", "user", "Lnet/minecraft/world/InteractionHand;", "hand", "Lnet/minecraft/world/InteractionResultHolder;", "use", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResultHolder;", "Lnet/minecraft/server/level/ServerPlayer;", "player", "applyToPokemon", "(Lnet/minecraft/server/level/ServerPlayer;Lnet/minecraft/world/item/ItemStack;Lcom/cobblemon/mod/common/pokemon/Pokemon;)Lnet/minecraft/world/InteractionResultHolder;", "Lcom/cobblemon/mod/common/battles/pokemon/BattlePokemon;", "battlePokemon", "", "applyToBattlePokemon", "(Lnet/minecraft/server/level/ServerPlayer;Lnet/minecraft/world/item/ItemStack;Lcom/cobblemon/mod/common/battles/pokemon/BattlePokemon;)V", "Lcom/cobblemon/mod/common/item/battle/BagItem;", "bagItem", "Lcom/cobblemon/mod/common/item/battle/BagItem;", "getBagItem", "()Lcom/cobblemon/mod/common/item/battle/BagItem;", "common"})
@SourceDebugExtension(value={"SMAP\nBerryJuiceItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BerryJuiceItem.kt\ncom/cobblemon/mod/common/item/interactive/BerryJuiceItem\n+ 2 EventObservables.kt\ncom/cobblemon/mod/common/api/reactive/CancelableObservable\n+ 3 EventObservables.kt\ncom/cobblemon/mod/common/api/reactive/EventObservable\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,87:1\n40#2:88\n41#2,6:92\n47#2:100\n17#3,2:89\n19#3:99\n13805#4:91\n13806#4:98\n*S KotlinDebug\n*F\n+ 1 BerryJuiceItem.kt\ncom/cobblemon/mod/common/item/interactive/BerryJuiceItem\n*L\n59#1:88\n59#1:92,6\n59#1:100\n59#1:89,2\n59#1:99\n59#1:91\n59#1:98\n*E\n"})
public final class BerryJuiceItem
extends CobblemonItem
implements PokemonSelectingItem,
HealingSource {
    @NotNull
    private final BagItem bagItem = new BagItem(){
        private final String itemName;
        private final Item returnItem;
        {
            this.itemName = "item.cobblemon.berry_juice";
            this.returnItem = Items.BOWL;
        }

        public String getItemName() {
            return this.itemName;
        }

        public Item getReturnItem() {
            return this.returnItem;
        }

        public String getShowdownInput(BattleActor actor, BattlePokemon battlePokemon, String data) {
            Intrinsics.checkNotNullParameter((Object)actor, (String)"actor");
            Intrinsics.checkNotNullParameter((Object)battlePokemon, (String)"battlePokemon");
            return "potion 20";
        }

        public boolean canUse(ItemStack stack, PokemonBattle battle, BattlePokemon target) {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            Intrinsics.checkNotNullParameter((Object)battle, (String)"battle");
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            return target.getHealth() < target.getMaxHealth() && target.getHealth() > 0;
        }
    };

    public BerryJuiceItem() {
        super(new Item.Properties());
    }

    @Override
    @NotNull
    public BagItem getBagItem() {
        return this.bagItem;
    }

    @Override
    public boolean canUseOnPokemon(@NotNull ItemStack stack, @NotNull Pokemon pokemon) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        return !pokemon.isFullHealth() && pokemon.getCurrentHealth() > 0 && PokemonSelectingItem.super.canUseOnPokemon(stack, pokemon);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level world, @NotNull Player user, @NotNull InteractionHand hand) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        if (user instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)user;
            ItemStack itemStack = user.getItemInHand(hand);
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItemInHand(...)");
            return this.use(serverPlayer, itemStack);
        }
        InteractionResultHolder interactionResultHolder = InteractionResultHolder.success((Object)user.getItemInHand(hand));
        Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"success(...)");
        return interactionResultHolder;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public InteractionResultHolder<ItemStack> applyToPokemon(@NotNull ServerPlayer player, @NotNull ItemStack stack, @NotNull Pokemon pokemon) {
        void this_$iv$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        if (!this.canUseOnPokemon(stack, pokemon)) {
            return InteractionResultHolder.fail((Object)stack);
        }
        Pokemon.feedPokemon$default(pokemon, 1, false, 2, null);
        int amount = 0;
        amount = Integer.min(pokemon.getCurrentHealth() + 20, pokemon.getMaxHealth());
        CancelableObservable<PokemonHealedEvent> cancelableObservable = CobblemonEvents.POKEMON_HEALED;
        Cancelable event$iv = new PokemonHealedEvent(pokemon, amount, this);
        boolean $i$f$postThen = false;
        EventObservable eventObservable = (EventObservable)this_$iv;
        Cancelable[] cancelableArray = new Cancelable[]{event$iv};
        Cancelable[] events$iv$iv = cancelableArray;
        boolean $i$f$post = false;
        this_$iv$iv.emit(Arrays.copyOf(events$iv$iv, events$iv$iv.length));
        Cancelable[] $this$forEach$iv$iv$iv = events$iv$iv;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv$iv$iv.length;
        for (int i = 0; i < n; ++i) {
            Cancelable element$iv$iv$iv;
            Cancelable it$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            if (it$iv.isCanceled()) {
                PokemonHealedEvent cancelledEvent = (PokemonHealedEvent)it$iv;
                boolean bl2 = false;
                return InteractionResultHolder.fail((Object)stack);
            }
            PokemonHealedEvent event = (PokemonHealedEvent)it$iv;
            boolean bl3 = false;
            amount = event.getAmount();
        }
        pokemon.setCurrentHealth(amount);
        player.playSound(CobblemonSounds.BERRY_EAT, 1.0f, 1.0f);
        if (!player.hasInfiniteMaterials()) {
            stack.shrink(1);
            ItemStack woodenBowlItemStack = new ItemStack((ItemLike)Items.BOWL);
            if (!player.getInventory().add(woodenBowlItemStack)) {
                player.drop(woodenBowlItemStack, false);
            }
        }
        return InteractionResultHolder.success((Object)stack);
    }

    @Override
    public void applyToBattlePokemon(@NotNull ServerPlayer player, @NotNull ItemStack stack, @NotNull BattlePokemon battlePokemon) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)battlePokemon, (String)"battlePokemon");
        PokemonSelectingItem.super.applyToBattlePokemon(player, stack, battlePokemon);
        Pokemon.feedPokemon$default(battlePokemon.getOriginalPokemon(), 1, false, 2, null);
        if (!player.hasInfiniteMaterials()) {
            ItemStack woodenBowlItemStack = new ItemStack((ItemLike)Items.BOWL);
            if (!player.getInventory().add(woodenBowlItemStack)) {
                player.drop(woodenBowlItemStack, false);
            }
        }
    }
}

