/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.item.interactive;

import com.cobblemon.mod.common.CobblemonItemComponents;
import com.cobblemon.mod.common.CobblemonSounds;
import com.cobblemon.mod.common.advancement.CobblemonCriteria;
import com.cobblemon.mod.common.advancement.criterion.CastPokeRodContext;
import com.cobblemon.mod.common.api.events.Cancelable;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.events.fishing.BaitConsumedEvent;
import com.cobblemon.mod.common.api.events.fishing.BaitSetEvent;
import com.cobblemon.mod.common.api.events.fishing.PokerodCastEvent;
import com.cobblemon.mod.common.api.events.fishing.PokerodReelEvent;
import com.cobblemon.mod.common.api.fishing.SpawnBaitEffects;
import com.cobblemon.mod.common.api.reactive.CancelableObservable;
import com.cobblemon.mod.common.api.reactive.EventObservable;
import com.cobblemon.mod.common.api.reactive.SimpleObservable;
import com.cobblemon.mod.common.entity.fishing.PokeRodFishingBobberEntity;
import com.cobblemon.mod.common.item.components.RodBaitComponent;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import com.cobblemon.mod.common.util.WorldExtensionsKt;
import java.util.Arrays;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u0000 -2\u00020\u0001:\u0001-B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J?\u0010\u0014\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J-\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\b0\u001b2\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u000f\u0010\u001f\u001a\u00020\u001eH\u0016\u00a2\u0006\u0004\b\u001f\u0010 J\u000f\u0010\"\u001a\u00020!H\u0016\u00a2\u0006\u0004\b\"\u0010#J\u0017\u0010'\u001a\u00020&2\u0006\u0010%\u001a\u00020$H\u0002\u00a2\u0006\u0004\b'\u0010(J\u0017\u0010)\u001a\u00020&2\u0006\u0010%\u001a\u00020$H\u0002\u00a2\u0006\u0004\b)\u0010(R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010*\u001a\u0004\b+\u0010,\u00a8\u0006."}, d2={"Lcom/cobblemon/mod/common/item/interactive/PokerodItem;", "Lnet/minecraft/world/item/FishingRodItem;", "Lnet/minecraft/resources/ResourceLocation;", "pokeRodId", "Lnet/minecraft/world/item/Item$Properties;", "settings", "<init>", "(Lnet/minecraft/resources/ResourceLocation;Lnet/minecraft/world/item/Item$Properties;)V", "Lnet/minecraft/world/item/ItemStack;", "itemStack", "itemStack2", "Lnet/minecraft/world/inventory/Slot;", "slot", "Lnet/minecraft/world/inventory/ClickAction;", "clickAction", "Lnet/minecraft/world/entity/player/Player;", "player", "Lnet/minecraft/world/entity/SlotAccess;", "slotAccess", "", "overrideOtherStackedOnMe", "(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/inventory/Slot;Lnet/minecraft/world/inventory/ClickAction;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/entity/SlotAccess;)Z", "Lnet/minecraft/world/level/Level;", "world", "user", "Lnet/minecraft/world/InteractionHand;", "hand", "Lnet/minecraft/world/InteractionResultHolder;", "use", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResultHolder;", "", "getEnchantmentValue", "()I", "", "getDescriptionId", "()Ljava/lang/String;", "Lnet/minecraft/world/entity/Entity;", "entity", "", "playAttachSound", "(Lnet/minecraft/world/entity/Entity;)V", "playDetachSound", "Lnet/minecraft/resources/ResourceLocation;", "getPokeRodId", "()Lnet/minecraft/resources/ResourceLocation;", "Companion", "common"})
@SourceDebugExtension(value={"SMAP\nPokerodItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PokerodItem.kt\ncom/cobblemon/mod/common/item/interactive/PokerodItem\n+ 2 EventObservables.kt\ncom/cobblemon/mod/common/api/reactive/CancelableObservable\n+ 3 EventObservables.kt\ncom/cobblemon/mod/common/api/reactive/EventObservable\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 EventObservables.kt\ncom/cobblemon/mod/common/api/reactive/EventObservable$post$1\n*L\n1#1,256:1\n40#2:257\n41#2,6:261\n47#2:269\n40#2:270\n41#2,6:274\n47#2:282\n40#2:283\n41#2,6:287\n47#2:295\n40#2:296\n41#2,4:300\n46#2:314\n47#2:317\n17#3,2:258\n19#3:268\n17#3,2:271\n19#3:281\n17#3,2:284\n19#3:294\n17#3,2:297\n14#3,5:305\n19#3:313\n19#3:316\n13805#4:260\n13806#4:267\n13805#4:273\n13806#4:280\n13805#4:286\n13806#4:293\n13805#4:299\n13805#4:310\n13806#4:312\n13806#4:315\n1#5:304\n14#6:311\n*S KotlinDebug\n*F\n+ 1 PokerodItem.kt\ncom/cobblemon/mod/common/item/interactive/PokerodItem\n*L\n100#1:257\n100#1:261,6\n100#1:269\n158#1:270\n158#1:274,6\n158#1:282\n181#1:283\n181#1:287,6\n181#1:295\n218#1:296\n218#1:300,4\n218#1:314\n218#1:317\n100#1:258,2\n100#1:268\n158#1:271,2\n158#1:281\n181#1:284,2\n181#1:294\n218#1:297,2\n226#1:305,5\n226#1:313\n218#1:316\n100#1:260\n100#1:267\n158#1:273\n158#1:280\n181#1:286\n181#1:293\n218#1:299\n226#1:310\n226#1:312\n218#1:315\n226#1:311\n*E\n"})
public final class PokerodItem
extends FishingRodItem {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ResourceLocation pokeRodId;

    public PokerodItem(@NotNull ResourceLocation pokeRodId, @NotNull Item.Properties settings) {
        Intrinsics.checkNotNullParameter((Object)pokeRodId, (String)"pokeRodId");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super(settings);
        this.pokeRodId = pokeRodId;
    }

    @NotNull
    public final ResourceLocation getPokeRodId() {
        return this.pokeRodId;
    }

    /*
     * WARNING - void declaration
     */
    public boolean overrideOtherStackedOnMe(@NotNull ItemStack itemStack, @NotNull ItemStack itemStack2, @NotNull Slot slot, @NotNull ClickAction clickAction, @NotNull Player player, @NotNull SlotAccess slotAccess) {
        void this_$iv$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        Intrinsics.checkNotNullParameter((Object)itemStack2, (String)"itemStack2");
        Intrinsics.checkNotNullParameter((Object)slot, (String)"slot");
        Intrinsics.checkNotNullParameter((Object)clickAction, (String)"clickAction");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)slotAccess, (String)"slotAccess");
        if (clickAction != ClickAction.SECONDARY || !slot.allowModification(player)) {
            return false;
        }
        ItemStack baitStack = Companion.getBaitStackOnRod(itemStack);
        CancelableObservable<BaitSetEvent> cancelableObservable = CobblemonEvents.BAIT_SET_PRE;
        Cancelable event$iv = new BaitSetEvent(itemStack, itemStack2);
        boolean $i$f$postThen = false;
        EventObservable eventObservable = (EventObservable)this_$iv;
        Cancelable[] cancelableArray = new Cancelable[]{event$iv};
        Cancelable[] events$iv$iv = cancelableArray;
        boolean $i$f$post = false;
        this_$iv$iv.emit(Arrays.copyOf(events$iv$iv, events$iv$iv.length));
        Cancelable[] $this$forEach$iv$iv$iv = events$iv$iv;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv$iv$iv.length;
        for (int i = 0; i < n; ++i) {
            Cancelable element$iv$iv$iv;
            Cancelable it$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            if (it$iv.isCanceled()) {
                BaitSetEvent event = (BaitSetEvent)it$iv;
                boolean bl2 = false;
                return event.isCanceled();
            }
            BaitSetEvent it = (BaitSetEvent)it$iv;
            boolean bl3 = false;
            if (itemStack2.isEmpty()) {
                if (Intrinsics.areEqual((Object)baitStack, (Object)ItemStack.EMPTY)) continue;
                this.playDetachSound((Entity)player);
                ItemStack itemStack3 = ItemStack.EMPTY;
                Intrinsics.checkNotNullExpressionValue((Object)itemStack3, (String)"EMPTY");
                Companion.setBait(itemStack, itemStack3);
                slotAccess.set(baitStack.copy());
                return true;
            }
            if (!SpawnBaitEffects.isFishingBait(itemStack2)) continue;
            if (!Intrinsics.areEqual((Object)baitStack, (Object)ItemStack.EMPTY)) {
                if (ItemStack.isSameItemSameComponents((ItemStack)baitStack, (ItemStack)itemStack2)) {
                    this.playAttachSound((Entity)player);
                    int diff = RangesKt.coerceIn((int)(baitStack.getMaxStackSize() - baitStack.getCount()), (int)0, (int)itemStack2.getCount());
                    itemStack2.shrink(diff);
                    baitStack.grow(diff);
                    Companion.setBait(itemStack, baitStack);
                    return true;
                }
                this.playAttachSound((Entity)player);
                ItemStack itemStack4 = itemStack2.copy();
                Intrinsics.checkNotNullExpressionValue((Object)itemStack4, (String)"copy(...)");
                Companion.setBait(itemStack, itemStack4);
                slotAccess.set(baitStack.copy());
                return true;
            }
            this.playAttachSound((Entity)player);
            ItemStack itemStack5 = itemStack2.copy();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack5, (String)"copy(...)");
            Companion.setBait(itemStack, itemStack5);
            itemStack2.shrink(itemStack2.getCount());
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level world, @NotNull Player user, @NotNull InteractionHand hand) {
        int n;
        Cancelable[] events$iv$iv;
        Object event$iv;
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        ItemStack itemStack = user.getItemInHand(hand);
        ItemStack offHandItem = user.getItemInHand(InteractionHand.OFF_HAND);
        if (!world.isClientSide && user.fishing == null) {
            Intrinsics.checkNotNull((Object)offHandItem);
            if (SpawnBaitEffects.isFishingBait(offHandItem)) {
                void this_$iv$iv;
                void this_$iv;
                CancelableObservable<BaitSetEvent> cancelableObservable = CobblemonEvents.BAIT_SET_PRE;
                Intrinsics.checkNotNull((Object)itemStack);
                event$iv = new BaitSetEvent(itemStack, offHandItem);
                boolean $i$f$postThen = false;
                EventObservable eventObservable = (EventObservable)this_$iv;
                Cancelable[] cancelableArray = new Cancelable[]{event$iv};
                events$iv$iv = cancelableArray;
                boolean $i$f$post = false;
                this_$iv$iv.emit(Arrays.copyOf(events$iv$iv, events$iv$iv.length));
                Cancelable[] $this$forEach$iv$iv$iv = events$iv$iv;
                boolean $i$f$forEach = false;
                n = $this$forEach$iv$iv$iv.length;
                for (int i = 0; i < n; ++i) {
                    Cancelable element$iv$iv$iv;
                    Cancelable it$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
                    boolean bl = false;
                    if (it$iv.isCanceled()) {
                        BaitSetEvent event = (BaitSetEvent)it$iv;
                        boolean bl2 = false;
                        InteractionResultHolder interactionResultHolder = InteractionResultHolder.fail((Object)itemStack);
                        Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"fail(...)");
                        return interactionResultHolder;
                    }
                    BaitSetEvent it = (BaitSetEvent)it$iv;
                    boolean bl3 = false;
                    this.playAttachSound((Entity)user);
                    ItemStack baitStack = Companion.getBaitStackOnRod(itemStack);
                    if (Intrinsics.areEqual((Object)baitStack, (Object)ItemStack.EMPTY) || Intrinsics.areEqual((Object)offHandItem.getItem(), (Object)baitStack.getItem())) continue;
                    user.drop(baitStack, true);
                    ItemStack singleBait = offHandItem.copy();
                    singleBait.setCount(1);
                    Intrinsics.checkNotNull((Object)singleBait);
                    Companion.setBait(itemStack, singleBait);
                    offHandItem.shrink(1);
                }
            }
        }
        int i = 0;
        if (user.fishing != null) {
            if (!world.isClientSide) {
                void event$iv2;
                void this_$iv;
                event$iv = CobblemonEvents.POKEROD_REEL;
                Intrinsics.checkNotNull((Object)itemStack);
                Cancelable $i$f$postThen = new PokerodReelEvent(user, itemStack);
                boolean $i$f$postThen2 = false;
                events$iv$iv = (Cancelable[])this_$iv;
                Cancelable[] $i$f$post = new Cancelable[]{event$iv2};
                Cancelable[] events$iv$iv2 = $i$f$post;
                boolean $i$f$post2 = false;
                ((SimpleObservable)this_$iv$iv).emit((T[])Arrays.copyOf(events$iv$iv2, events$iv$iv2.length));
                Cancelable[] $this$forEach$iv$iv$iv = events$iv$iv2;
                boolean $i$f$forEach = false;
                int element$iv$iv$iv = $this$forEach$iv$iv$iv.length;
                for (n = 0; n < element$iv$iv$iv; ++n) {
                    Cancelable element$iv$iv$iv2;
                    Cancelable it$iv = element$iv$iv$iv2 = $this$forEach$iv$iv$iv[n];
                    boolean bl = false;
                    if (it$iv.isCanceled()) {
                        PokerodReelEvent event = (PokerodReelEvent)it$iv;
                        boolean bl4 = false;
                        InteractionResultHolder interactionResultHolder = InteractionResultHolder.fail((Object)itemStack);
                        Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"fail(...)");
                        return interactionResultHolder;
                    }
                    PokerodReelEvent event = (PokerodReelEvent)it$iv;
                    boolean bl5 = false;
                    FishingHook fishingHook = user.fishing;
                    Intrinsics.checkNotNull((Object)fishingHook);
                    i = fishingHook.retrieve(itemStack);
                    itemStack.hurtAndBreak(i, (LivingEntity)user, MiscUtilsKt.toEquipmentSlot(hand));
                    WorldExtensionsKt.playSoundServer(world, new Vec3(user.getX(), user.getY(), user.getZ()), CobblemonSounds.FISHING_ROD_REEL_IN, SoundSource.PLAYERS, 1.0f, 1.0f / (world.getRandom().nextFloat() * 0.4f + 0.8f));
                }
            }
            world.playSound(null, user.getX(), user.getY(), user.getZ(), CobblemonSounds.FISHING_ROD_REEL_IN, SoundSource.PLAYERS, 1.0f, 1.0f);
            user.gameEvent((Holder)GameEvent.ITEM_INTERACT_FINISH);
        } else {
            if (!world.isClientSide) {
                void this_$iv$iv;
                void event$iv3;
                void this_$iv;
                Integer lureLevel = WorldExtensionsKt.getEnchantmentRegistry(world).getHolder(Enchantments.LURE).map(arg_0 -> PokerodItem.use$lambda$5(arg_0 -> PokerodItem.use$lambda$4(itemStack, arg_0), arg_0)).orElse(0);
                Integer luckLevel = WorldExtensionsKt.getEnchantmentRegistry(world).getHolder(Enchantments.LUCK_OF_THE_SEA).map(arg_0 -> PokerodItem.use$lambda$7(arg_0 -> PokerodItem.use$lambda$6(itemStack, arg_0), arg_0)).orElse(0);
                Intrinsics.checkNotNull((Object)itemStack);
                ItemStack itemStack2 = Companion.getBaitStackOnRod(itemStack);
                Intrinsics.checkNotNull((Object)luckLevel);
                int n2 = luckLevel;
                Intrinsics.checkNotNull((Object)lureLevel);
                PokeRodFishingBobberEntity bobberEntity = new PokeRodFishingBobberEntity(user, this.pokeRodId, itemStack2, world, n2, lureLevel, itemStack);
                this_$iv$iv = CobblemonEvents.POKEROD_CAST_PRE;
                Cancelable events$iv$iv2 = new PokerodCastEvent.Pre(itemStack, bobberEntity, Companion.getBaitStackOnRod(itemStack));
                boolean $i$f$postThen = false;
                EventObservable $this$forEach$iv$iv$iv = (EventObservable)this_$iv;
                Cancelable[] $i$f$forEach = new Cancelable[]{event$iv3};
                Cancelable[] events$iv$iv3 = $i$f$forEach;
                boolean $i$f$post = false;
                this_$iv$iv.emit(Arrays.copyOf(events$iv$iv3, events$iv$iv3.length));
                Cancelable[] $this$forEach$iv$iv$iv2 = events$iv$iv3;
                boolean $i$f$forEach2 = false;
                int n3 = $this$forEach$iv$iv$iv2.length;
                for (int j = 0; j < n3; ++j) {
                    void events$iv;
                    void $this$iv;
                    PokerodCastEvent.Post[] postArray;
                    PokerodCastEvent.Pre event;
                    Cancelable element$iv$iv$iv;
                    Cancelable it$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv2[j];
                    boolean bl = false;
                    if (it$iv.isCanceled()) {
                        event = (PokerodCastEvent.Pre)it$iv;
                        boolean bl6 = false;
                        InteractionResultHolder interactionResultHolder = InteractionResultHolder.fail((Object)itemStack);
                        Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"fail(...)");
                        return interactionResultHolder;
                    }
                    event = (PokerodCastEvent.Pre)it$iv;
                    boolean bl7 = false;
                    world.addFreshEntity((Entity)bobberEntity);
                    PokerodCastEvent.Post[] it = postArray = Companion.getBaitStackOnRod(itemStack);
                    boolean bl8 = false;
                    Object object = !it.isEmpty() ? postArray : null;
                    if (object == null || (object = object.getItemHolder()) == null || (object = object.unwrapKey()) == null || (object = (ResourceKey)((Optional)object).orElse(null)) == null || (object = object.location()) == null) {
                        object = MiscUtilsKt.cobblemonResource("empty_bait");
                    }
                    PokerodCastEvent.Post[] baitId = object;
                    CobblemonCriteria.CAST_POKE_ROD.trigger((ServerPlayer)user, new CastPokeRodContext((ResourceLocation)baitId));
                    EventObservable<PokerodCastEvent.Post> eventObservable = CobblemonEvents.POKEROD_CAST_POST;
                    postArray = new PokerodCastEvent.Post[]{new PokerodCastEvent.Post(itemStack, bobberEntity, Companion.getBaitStackOnRod(itemStack))};
                    boolean $i$f$post3 = false;
                    $this$iv.emit(Arrays.copyOf(events$iv, ((void)events$iv).length));
                    void $this$forEach$iv$iv = events$iv;
                    boolean $i$f$forEach3 = false;
                    int n4 = ((void)$this$forEach$iv$iv).length;
                    for (int k = 0; k < n4; ++k) {
                        void element$iv$iv;
                        void var35_59 = element$iv$iv = $this$forEach$iv$iv[k];
                        boolean bl9 = false;
                        void it2 = var35_59;
                    }
                }
            }
            user.awardStat(Stats.ITEM_USED.get((Object)this));
            user.gameEvent((Holder)GameEvent.ITEM_INTERACT_START);
        }
        InteractionResultHolder interactionResultHolder = InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)world.isClientSide);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"sidedSuccess(...)");
        return interactionResultHolder;
    }

    public int getEnchantmentValue() {
        return 1;
    }

    @NotNull
    public String getDescriptionId() {
        return "item.cobblemon.poke_rod";
    }

    private final void playAttachSound(Entity entity) {
        entity.playSound(CobblemonSounds.FISHING_BAIT_ATTACH, 1.0f, 1.0f);
    }

    private final void playDetachSound(Entity entity) {
        entity.playSound(CobblemonSounds.FISHING_BAIT_DETACH, 1.0f, 1.0f);
    }

    private static final Integer use$lambda$4(ItemStack $itemStack, Holder.Reference it) {
        return EnchantmentHelper.getItemEnchantmentLevel((Holder)((Holder)it), (ItemStack)$itemStack);
    }

    private static final Integer use$lambda$5(Function1 $tmp0, Object p0) {
        return (Integer)$tmp0.invoke(p0);
    }

    private static final Integer use$lambda$6(ItemStack $itemStack, Holder.Reference it) {
        return EnchantmentHelper.getItemEnchantmentLevel((Holder)((Holder)it), (ItemStack)$itemStack);
    }

    private static final Integer use$lambda$7(Function1 $tmp0, Object p0) {
        return (Integer)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001d\u0010\n\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0015\u0010\f\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/cobblemon/mod/common/item/interactive/PokerodItem$Companion;", "", "<init>", "()V", "Lnet/minecraft/world/item/ItemStack;", "stack", "getBaitStackOnRod", "(Lnet/minecraft/world/item/ItemStack;)Lnet/minecraft/world/item/ItemStack;", "bait", "", "setBait", "(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/ItemStack;)V", "consumeBait", "(Lnet/minecraft/world/item/ItemStack;)V", "common"})
    @SourceDebugExtension(value={"SMAP\nPokerodItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PokerodItem.kt\ncom/cobblemon/mod/common/item/interactive/PokerodItem$Companion\n+ 2 EventObservables.kt\ncom/cobblemon/mod/common/api/reactive/CancelableObservable\n+ 3 EventObservables.kt\ncom/cobblemon/mod/common/api/reactive/EventObservable\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 EventObservables.kt\ncom/cobblemon/mod/common/api/reactive/CancelableObservable$postThen$1\n*L\n1#1,256:1\n40#2:257\n41#2,6:261\n47#2:269\n39#2,2:270\n41#2,2:275\n44#2,3:278\n47#2:283\n17#3,2:258\n19#3:268\n17#3,2:272\n19#3:282\n13805#4:260\n13806#4:267\n13805#4:274\n13806#4:281\n39#5:277\n*S KotlinDebug\n*F\n+ 1 PokerodItem.kt\ncom/cobblemon/mod/common/item/interactive/PokerodItem$Companion\n*L\n54#1:257\n54#1:261,6\n54#1:269\n67#1:270,2\n67#1:275,2\n67#1:278,3\n67#1:283\n54#1:258,2\n54#1:268\n67#1:272,2\n67#1:282\n54#1:260\n54#1:267\n67#1:274\n67#1:281\n67#1:277\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ItemStack getBaitStackOnRod(@NotNull ItemStack stack) {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            RodBaitComponent rodBaitComponent = (RodBaitComponent)stack.getComponents().get(CobblemonItemComponents.BAIT);
            if (rodBaitComponent == null || (rodBaitComponent = rodBaitComponent.getStack()) == null) {
                ItemStack itemStack = ItemStack.EMPTY;
                rodBaitComponent = itemStack;
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
            }
            return rodBaitComponent;
        }

        /*
         * WARNING - void declaration
         */
        public final void setBait(@NotNull ItemStack stack, @NotNull ItemStack bait) {
            void this_$iv$iv;
            void this_$iv;
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            Intrinsics.checkNotNullParameter((Object)bait, (String)"bait");
            CancelableObservable<BaitSetEvent> cancelableObservable = CobblemonEvents.BAIT_SET;
            Cancelable event$iv = new BaitSetEvent(stack, bait);
            boolean $i$f$postThen = false;
            EventObservable eventObservable = (EventObservable)this_$iv;
            Cancelable[] cancelableArray = new Cancelable[]{event$iv};
            Cancelable[] events$iv$iv = cancelableArray;
            boolean $i$f$post = false;
            this_$iv$iv.emit(Arrays.copyOf(events$iv$iv, events$iv$iv.length));
            Cancelable[] $this$forEach$iv$iv$iv = events$iv$iv;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv$iv$iv.length;
            for (int i = 0; i < n; ++i) {
                Cancelable element$iv$iv$iv;
                Cancelable it$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
                boolean bl = false;
                if (it$iv.isCanceled()) {
                    BaitSetEvent event = (BaitSetEvent)it$iv;
                    boolean bl2 = false;
                    continue;
                }
                BaitSetEvent it = (BaitSetEvent)it$iv;
                boolean bl3 = false;
                if (bait.isEmpty()) {
                    stack.set(CobblemonItemComponents.BAIT, null);
                    return;
                }
                stack.set(CobblemonItemComponents.BAIT, (Object)new RodBaitComponent(bait));
            }
        }

        /*
         * WARNING - void declaration
         */
        public final void consumeBait(@NotNull ItemStack stack) {
            void this_$iv$iv;
            void $this$iv;
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            CancelableObservable<BaitConsumedEvent> cancelableObservable = CobblemonEvents.BAIT_CONSUMED;
            Cancelable event$iv = new BaitConsumedEvent(stack);
            boolean $i$f$postThen = false;
            EventObservable eventObservable = (EventObservable)$this$iv;
            Cancelable[] cancelableArray = new Cancelable[]{event$iv};
            Cancelable[] events$iv$iv = cancelableArray;
            boolean $i$f$post = false;
            this_$iv$iv.emit(Arrays.copyOf(events$iv$iv, events$iv$iv.length));
            Cancelable[] $this$forEach$iv$iv$iv = events$iv$iv;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv$iv$iv.length;
            for (int i = 0; i < n; ++i) {
                Cancelable it;
                Cancelable element$iv$iv$iv;
                Cancelable it$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
                boolean bl = false;
                if (it$iv.isCanceled()) {
                    Cancelable cancelable = it$iv;
                    boolean bl2 = false;
                    it = cancelable;
                    continue;
                }
                it = (BaitConsumedEvent)it$iv;
                boolean bl3 = false;
                ItemStack baitStack = Companion.getBaitStackOnRod(stack);
                int baitCount = baitStack.getCount();
                if (baitCount == 1) {
                    stack.set(CobblemonItemComponents.BAIT, null);
                    return;
                }
                if (baitCount <= 1) continue;
                baitStack.setCount(baitCount - 1);
                stack.set(CobblemonItemComponents.BAIT, (Object)new RodBaitComponent(baitStack));
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

