/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.mixin;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.ai.EntityBehaviour;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Phantom;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(targets={"net/minecraft/world/entity/monster/Phantom$PhantomSweepAttackGoal"})
public abstract class PhantomSweepAttackGoalMixin
extends Goal {
    @Unique
    private Phantom phantomSelf;

    @Inject(method={"<init>(Lnet/minecraft/world/entity/monster/Phantom;)V"}, at={@At(value="TAIL")})
    private void onInit(Phantom phantom, CallbackInfo ci) {
        this.phantomSelf = phantom;
    }

    @Inject(method={"canContinueToUse()Z"}, at={@At(value="RETURN")}, cancellable=true)
    private void modifyCanContinueToUse(CallbackInfoReturnable<Boolean> cir) {
        List nearbyFearedEntities;
        Phantom phantom = this.phantomSelf;
        if (phantom == null) {
            return;
        }
        if (((Boolean)cir.getReturnValue()).booleanValue() && !(nearbyFearedEntities = phantom.level().getEntities((Entity)phantom, phantom.getBoundingBox().inflate(16.0), entity -> entity instanceof PokemonEntity && ((PokemonEntity)entity).getBeamMode() == 0 && ((PokemonEntity)entity).getBehaviour().getEntityInteract().getAvoidedByPhantom() || entity instanceof ServerPlayer && EntityBehaviour.Companion.hasPhantomFearedShoulderMount((ServerPlayer)entity))).isEmpty()) {
            nearbyFearedEntities.forEach(entity -> {
                if (entity instanceof PokemonEntity) {
                    ((PokemonEntity)entity).cry();
                }
            });
            cir.setReturnValue((Object)false);
        }
    }
}

