/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.mixin;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.OrientationControllable;
import com.cobblemon.mod.common.PlayerSpawnerAccessor;
import com.cobblemon.mod.common.api.spawning.spawner.PlayerSpawner;
import com.cobblemon.mod.common.api.spawning.spawner.PlayerSpawnerFactory;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.world.gamerules.CobblemonGameRules;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerPlayer.class})
public abstract class ServerPlayerMixin
implements PlayerSpawnerAccessor {
    @Unique
    public PlayerSpawner cobblemon$spawner;

    @Shadow
    public abstract ServerLevel serverLevel();

    @Override
    public PlayerSpawner getPlayerSpawner() {
        ServerPlayer player = (ServerPlayer)this;
        if (this.cobblemon$spawner == null) {
            this.cobblemon$spawner = PlayerSpawnerFactory.INSTANCE.create(player);
        }
        return this.cobblemon$spawner;
    }

    @Override
    public void setPlayerSpawner(PlayerSpawner spawner) {
        this.cobblemon$spawner = spawner;
    }

    @Inject(method={"tick()V"}, at={@At(value="TAIL")})
    private void cobblemon$tickSpawner(CallbackInfo ci) {
        if (!Cobblemon.config.getEnableSpawning()) {
            return;
        }
        if (!this.serverLevel().getGameRules().getBoolean(CobblemonGameRules.DO_POKEMON_SPAWNING)) {
            return;
        }
        this.getPlayerSpawner().tick();
    }

    @Inject(method={"rideTick()V"}, at={@At(value="HEAD")})
    private void cobblemon$updateOrientationControllerRideTick(CallbackInfo ci) {
        ServerPlayer player = (ServerPlayer)this;
        Entity vehicle = player.getVehicle();
        if (!(vehicle instanceof OrientationControllable)) {
            return;
        }
        OrientationControllable controllableVehicle = (OrientationControllable)vehicle;
        boolean shouldUseCustomOrientation = this.cobblemon$shouldUseCustomOrientation(vehicle);
        controllableVehicle.getOrientationController().setActive(shouldUseCustomOrientation);
    }

    @Unique
    private boolean cobblemon$shouldUseCustomOrientation(Entity entity) {
        if (entity == null) {
            return false;
        }
        if (!(entity instanceof PokemonEntity)) {
            return false;
        }
        PokemonEntity pokemonEntity = (PokemonEntity)entity;
        return pokemonEntity.ifRidingAvailableSupply(false, (behaviour, settings, state) -> behaviour.shouldRoll(settings, state, pokemonEntity));
    }

    @Inject(method={"stopRiding()V"}, at={@At(value="HEAD")})
    public void cobblemon$resetOrientationOnDismount(CallbackInfo ci) {
        ServerPlayer player = (ServerPlayer)this;
        Entity entity = player.getVehicle();
        if (!(entity instanceof OrientationControllable)) {
            return;
        }
        OrientationControllable controllableVehicle = (OrientationControllable)entity;
        controllableVehicle.getOrientationController().setActive(false);
    }

    @ModifyExpressionValue(method={"addAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;hasExactlyOnePlayerPassenger()Z")})
    private boolean cobblemon$cancelSavingPokemonMounts(boolean original, @Local(ordinal=0) Entity entity) {
        return original && !(entity instanceof PokemonEntity);
    }
}

