/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.net.messages.server.pokemon.update.evolution;

import com.cobblemon.mod.common.api.net.NetworkPacket;
import com.cobblemon.mod.common.api.pokemon.evolution.EvolutionDisplay;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.BufferUtilsKt;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u001d2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u001dB\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0019\b\u0016\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u0006\u0010\fJ\u0017\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0019\u001a\u00020\u00188\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001e"}, d2={"Lcom/cobblemon/mod/common/net/messages/server/pokemon/update/evolution/AcceptEvolutionPacket;", "Lcom/cobblemon/mod/common/api/net/NetworkPacket;", "Ljava/util/UUID;", "pokemonUUID", "", "evolutionId", "<init>", "(Ljava/util/UUID;Ljava/lang/String;)V", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "pokemon", "Lcom/cobblemon/mod/common/api/pokemon/evolution/EvolutionDisplay;", "evolution", "(Lcom/cobblemon/mod/common/pokemon/Pokemon;Lcom/cobblemon/mod/common/api/pokemon/evolution/EvolutionDisplay;)V", "Lnet/minecraft/network/RegistryFriendlyByteBuf;", "buffer", "", "encode", "(Lnet/minecraft/network/RegistryFriendlyByteBuf;)V", "Ljava/util/UUID;", "getPokemonUUID", "()Ljava/util/UUID;", "Ljava/lang/String;", "getEvolutionId", "()Ljava/lang/String;", "Lnet/minecraft/resources/ResourceLocation;", "id", "Lnet/minecraft/resources/ResourceLocation;", "getId", "()Lnet/minecraft/resources/ResourceLocation;", "Companion", "common"})
public final class AcceptEvolutionPacket
implements NetworkPacket<AcceptEvolutionPacket> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UUID pokemonUUID;
    @NotNull
    private final String evolutionId;
    @NotNull
    private final ResourceLocation id;
    @NotNull
    private static final ResourceLocation ID = MiscUtilsKt.cobblemonResource("accept_evolution");

    public AcceptEvolutionPacket(@NotNull UUID pokemonUUID, @NotNull String evolutionId) {
        Intrinsics.checkNotNullParameter((Object)pokemonUUID, (String)"pokemonUUID");
        Intrinsics.checkNotNullParameter((Object)evolutionId, (String)"evolutionId");
        this.pokemonUUID = pokemonUUID;
        this.evolutionId = evolutionId;
        this.id = ID;
    }

    @NotNull
    public final UUID getPokemonUUID() {
        return this.pokemonUUID;
    }

    @NotNull
    public final String getEvolutionId() {
        return this.evolutionId;
    }

    public AcceptEvolutionPacket(@NotNull Pokemon pokemon, @NotNull EvolutionDisplay evolution) {
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        Intrinsics.checkNotNullParameter((Object)evolution, (String)"evolution");
        UUID uUID = pokemon.getUuid();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"<get-uuid>(...)");
        this(uUID, evolution.getId());
    }

    @Override
    @NotNull
    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    public void encode(@NotNull RegistryFriendlyByteBuf buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        buffer.writeUUID(this.pokemonUUID);
        BufferUtilsKt.writeString((ByteBuf)buffer, this.evolutionId);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bR\u0017\u0010\n\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/cobblemon/mod/common/net/messages/server/pokemon/update/evolution/AcceptEvolutionPacket$Companion;", "", "<init>", "()V", "Lnet/minecraft/network/RegistryFriendlyByteBuf;", "buffer", "Lcom/cobblemon/mod/common/net/messages/server/pokemon/update/evolution/AcceptEvolutionPacket;", "decode", "(Lnet/minecraft/network/RegistryFriendlyByteBuf;)Lcom/cobblemon/mod/common/net/messages/server/pokemon/update/evolution/AcceptEvolutionPacket;", "Lnet/minecraft/resources/ResourceLocation;", "ID", "Lnet/minecraft/resources/ResourceLocation;", "getID", "()Lnet/minecraft/resources/ResourceLocation;", "common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ResourceLocation getID() {
            return ID;
        }

        @NotNull
        public final AcceptEvolutionPacket decode(@NotNull RegistryFriendlyByteBuf buffer) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            UUID uUID = buffer.readUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"readUUID(...)");
            return new AcceptEvolutionPacket(uUID, BufferUtilsKt.readString((ByteBuf)buffer));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

