/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.util;

import com.bedrockk.molang.Expression;
import com.cobblemon.mod.common.api.molang.ExpressionLike;
import com.cobblemon.mod.common.api.riding.stats.RidingStat;
import com.cobblemon.mod.common.api.storage.party.PartyPosition;
import com.cobblemon.mod.common.api.storage.pc.PCPosition;
import com.cobblemon.mod.common.net.IntSize;
import com.cobblemon.mod.common.util.MoLangExtensionsKt;
import com.cobblemon.mod.common.util.NetExtensionsKt;
import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.handler.codec.EncoderException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.Utf8String;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.StreamEncoder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u00d4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0010\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0011\u0010\u0002\u001a\u00020\u0001*\u00020\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0003\u001a\u0019\u0010\u0006\u001a\u00020\u0005*\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0006\u0010\u0007\u001a\u0011\u0010\t\u001a\u00020\b*\u00020\u0000\u00a2\u0006\u0004\b\t\u0010\n\u001a\u0019\u0010\f\u001a\u00020\u0005*\u00020\u00002\u0006\u0010\u000b\u001a\u00020\b\u00a2\u0006\u0004\b\f\u0010\r\u001a\u0011\u0010\u0010\u001a\u00020\u000f*\u00020\u000e\u00a2\u0006\u0004\b\u0010\u0010\u0011\u001a?\u0010\u0017\u001a\u00020\u0005\"\u0004\b\u0000\u0010\u0012*\u00020\u000e2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u00132\u0018\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00050\u0015\u00a2\u0006\u0004\b\u0017\u0010\u0018\u001a;\u0010\u001a\u001a\u00020\u0005\"\u0004\b\u0000\u0010\u0012*\u00020\u000e2\b\u0010\u0019\u001a\u0004\u0018\u00018\u00002\u0018\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00050\u0015\u00a2\u0006\u0004\b\u001a\u0010\u001b\u001a5\u0010\u001a\u001a\u00020\u0005\"\u0004\b\u0000\u0010\u0012*\u00020\u000e2\b\u0010\u0019\u001a\u0004\u0018\u00018\u00002\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00028\u00000\u001c\u00a2\u0006\u0004\b\u001a\u0010\u001d\u001a\u0019\u0010 \u001a\u00020\u000e*\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u001e\u00a2\u0006\u0004\b \u0010!\u001a1\u0010&\u001a\b\u0012\u0004\u0012\u00028\u00000%\"\u0004\b\u0000\u0010\u0012*\u00020\u00002\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00028\u00000\"\u00a2\u0006\u0004\b&\u0010'\u001a\u0011\u0010(\u001a\u00020\u001e*\u00020\u000e\u00a2\u0006\u0004\b(\u0010)\u001a\u0019\u0010,\u001a\u00020\u000e*\u00020\u000e2\u0006\u0010+\u001a\u00020*\u00a2\u0006\u0004\b,\u0010-\u001a\u001b\u0010.\u001a\u00020\u000e*\u00020\u000e2\b\u0010+\u001a\u0004\u0018\u00010*\u00a2\u0006\u0004\b.\u0010-\u001a\u0019\u00101\u001a\u00020\u000e*\u00020\u000e2\u0006\u00100\u001a\u00020/\u00a2\u0006\u0004\b1\u00102\u001a%\u00107\u001a\u00020\u0005*\u00020\u000e2\u0012\u00106\u001a\u000e\u0012\u0004\u0012\u000204\u0012\u0004\u0012\u00020503\u00a2\u0006\u0004\b7\u00108\u001a\u001d\u00109\u001a\u000e\u0012\u0004\u0012\u000204\u0012\u0004\u0012\u00020503*\u00020\u000e\u00a2\u0006\u0004\b9\u0010:\u001a\u0011\u0010;\u001a\u00020**\u00020\u000e\u00a2\u0006\u0004\b;\u0010<\u001a\u0013\u0010=\u001a\u0004\u0018\u00010**\u00020\u000e\u00a2\u0006\u0004\b=\u0010<\u001a\u0011\u0010>\u001a\u00020/*\u00020\u000e\u00a2\u0006\u0004\b>\u0010?\u001a-\u0010@\u001a\u0004\u0018\u00018\u0000\"\u0004\b\u0000\u0010\u0012*\u00020\u000e2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00028\u00000\"\u00a2\u0006\u0004\b@\u0010A\u001ae\u0010G\u001a\u00020\u0005\"\u0004\b\u0000\u0010B\"\u0004\b\u0001\u0010C*\u00020\u000e2\u0012\u0010D\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001032\u0018\u0010E\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00050\u00152\u0018\u0010F\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\u00050\u0015\u00a2\u0006\u0004\bG\u0010H\u001aQ\u0010K\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u000103\"\u0004\b\u0000\u0010B\"\u0004\b\u0001\u0010C*\u00020\u000e2\u0012\u0010I\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00028\u00000\"2\u0012\u0010J\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00028\u00010\"\u00a2\u0006\u0004\bK\u0010L\u001a\u0011\u0010N\u001a\u00020M*\u00020\u000e\u00a2\u0006\u0004\bN\u0010O\u001a\u0019\u0010Q\u001a\u00020\u0005*\u00020\u000e2\u0006\u0010P\u001a\u00020M\u00a2\u0006\u0004\bQ\u0010R\u001a\u0019\u0010U\u001a\u00020\u0005*\u00020\u000e2\u0006\u0010T\u001a\u00020S\u00a2\u0006\u0004\bU\u0010V\u001a\u0011\u0010W\u001a\u00020S*\u00020\u000e\u00a2\u0006\u0004\bW\u0010X\u001a\u0019\u0010[\u001a\u00020\u0005*\u00020\u000e2\u0006\u0010Z\u001a\u00020Y\u00a2\u0006\u0004\b[\u0010\\\u001a\u0011\u0010]\u001a\u00020Y*\u00020\u000e\u00a2\u0006\u0004\b]\u0010^\u001a\u0019\u0010a\u001a\u00020\u0005*\u00020\u000e2\u0006\u0010`\u001a\u00020_\u00a2\u0006\u0004\ba\u0010b\u001a\u0011\u0010c\u001a\u00020_*\u00020\u000e\u00a2\u0006\u0004\bc\u0010d\u001a\u001d\u0010g\u001a\u00020\u0005*\u00020\u000e2\n\u0010f\u001a\u0006\u0012\u0002\b\u00030e\u00a2\u0006\u0004\bg\u0010h\u001a/\u0010k\u001a\u00028\u0000\"\u000e\b\u0000\u0010\u0012*\b\u0012\u0004\u0012\u00028\u00000e*\u00020\u000e2\f\u0010j\u001a\b\u0012\u0004\u0012\u00028\u00000i\u00a2\u0006\u0004\bk\u0010l\u001a\u0019\u0010o\u001a\u00020\u0005*\u00020\u000e2\u0006\u0010n\u001a\u00020m\u00a2\u0006\u0004\bo\u0010p\u001a\u0013\u0010q\u001a\u0004\u0018\u00010m*\u00020\u000e\u00a2\u0006\u0004\bq\u0010r\u001a=\u0010w\u001a\u00020\u0005\"\u000e\b\u0000\u0010s*\b\u0012\u0004\u0012\u00028\u00000e*\u00020\u000e2\f\u0010u\u001a\b\u0012\u0004\u0012\u00028\u00000t2\f\u0010v\u001a\b\u0012\u0004\u0012\u00028\u00000i\u00a2\u0006\u0004\bw\u0010x\u001a5\u0010y\u001a\b\u0012\u0004\u0012\u00028\u00000t\"\u000e\b\u0000\u0010s*\b\u0012\u0004\u0012\u00028\u00000e*\u00020\u000e2\f\u0010v\u001a\b\u0012\u0004\u0012\u00028\u00000i\u00a2\u0006\u0004\by\u0010z\u001a\"\u0010\u007f\u001a\u00020\u0005*\u00020\u000e2\u0006\u0010|\u001a\u00020{2\u0006\u0010~\u001a\u00020}\u00a2\u0006\u0005\b\u007f\u0010\u0080\u0001\u001a\u001c\u0010\u0081\u0001\u001a\u00020{*\u00020\u000e2\u0006\u0010~\u001a\u00020}\u00a2\u0006\u0006\b\u0081\u0001\u0010\u0082\u0001\u001a\u001e\u0010\u0085\u0001\u001a\u00020\u0005*\u00020\u000e2\b\u0010\u0084\u0001\u001a\u00030\u0083\u0001\u00a2\u0006\u0006\b\u0085\u0001\u0010\u0086\u0001\u001a\u0015\u0010\u0087\u0001\u001a\u00030\u0083\u0001*\u00020\u000e\u00a2\u0006\u0006\b\u0087\u0001\u0010\u0088\u0001\u001a\u001e\u0010\u008a\u0001\u001a\u00020\u0005*\u00020\u000e2\b\u0010\u0084\u0001\u001a\u00030\u0089\u0001\u00a2\u0006\u0006\b\u008a\u0001\u0010\u008b\u0001\u001a\u0015\u0010\u008c\u0001\u001a\u00030\u0089\u0001*\u00020\u000e\u00a2\u0006\u0006\b\u008c\u0001\u0010\u008d\u0001\u00a8\u0006\u008e\u0001"}, d2={"Lnet/minecraft/network/RegistryFriendlyByteBuf;", "Lnet/minecraft/world/item/ItemStack;", "readItemStack", "(Lnet/minecraft/network/RegistryFriendlyByteBuf;)Lnet/minecraft/world/item/ItemStack;", "itemStack", "", "writeItemStack", "(Lnet/minecraft/network/RegistryFriendlyByteBuf;Lnet/minecraft/world/item/ItemStack;)V", "Lnet/minecraft/network/chat/Component;", "readText", "(Lnet/minecraft/network/RegistryFriendlyByteBuf;)Lnet/minecraft/network/chat/Component;", "text", "writeText", "(Lnet/minecraft/network/RegistryFriendlyByteBuf;Lnet/minecraft/network/chat/Component;)V", "Lio/netty/buffer/ByteBuf;", "Lnet/minecraft/world/entity/EntityDimensions;", "readEntityDimensions", "(Lio/netty/buffer/ByteBuf;)Lnet/minecraft/world/entity/EntityDimensions;", "T", "", "collection", "Lkotlin/Function2;", "writer", "writeCollection", "(Lio/netty/buffer/ByteBuf;Ljava/util/Collection;Lkotlin/jvm/functions/Function2;)V", "obj", "writeNullable", "(Lio/netty/buffer/ByteBuf;Ljava/lang/Object;Lkotlin/jvm/functions/Function2;)V", "Lnet/minecraft/network/codec/StreamEncoder;", "(Lio/netty/buffer/ByteBuf;Ljava/lang/Object;Lnet/minecraft/network/codec/StreamEncoder;)V", "", "string", "writeString", "(Lio/netty/buffer/ByteBuf;Ljava/lang/String;)Lio/netty/buffer/ByteBuf;", "Lkotlin/Function1;", "Lnet/minecraft/network/FriendlyByteBuf;", "reader", "", "readList", "(Lnet/minecraft/network/RegistryFriendlyByteBuf;Lkotlin/jvm/functions/Function1;)Ljava/util/List;", "readString", "(Lio/netty/buffer/ByteBuf;)Ljava/lang/String;", "Lcom/bedrockk/molang/Expression;", "expression", "writeExpression", "(Lio/netty/buffer/ByteBuf;Lcom/bedrockk/molang/Expression;)Lio/netty/buffer/ByteBuf;", "writeNullableExpression", "Lcom/cobblemon/mod/common/api/molang/ExpressionLike;", "expressionLike", "writeExpressionLike", "(Lio/netty/buffer/ByteBuf;Lcom/cobblemon/mod/common/api/molang/ExpressionLike;)Lio/netty/buffer/ByteBuf;", "", "Lcom/cobblemon/mod/common/api/riding/stats/RidingStat;", "Lkotlin/ranges/IntRange;", "stats", "writeRidingStats", "(Lio/netty/buffer/ByteBuf;Ljava/util/Map;)V", "readRidingStats", "(Lio/netty/buffer/ByteBuf;)Ljava/util/Map;", "readExpression", "(Lio/netty/buffer/ByteBuf;)Lcom/bedrockk/molang/Expression;", "readNullableExpression", "readExpressionLike", "(Lio/netty/buffer/ByteBuf;)Lcom/cobblemon/mod/common/api/molang/ExpressionLike;", "readNullable", "(Lio/netty/buffer/ByteBuf;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "K", "V", "map", "keyWriter", "valueWriter", "writeMap", "(Lio/netty/buffer/ByteBuf;Ljava/util/Map;Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function2;)V", "keyReader", "valueReader", "readMap", "(Lio/netty/buffer/ByteBuf;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)Ljava/util/Map;", "Lnet/minecraft/resources/ResourceLocation;", "readIdentifier", "(Lio/netty/buffer/ByteBuf;)Lnet/minecraft/resources/ResourceLocation;", "id", "writeIdentifier", "(Lio/netty/buffer/ByteBuf;Lnet/minecraft/resources/ResourceLocation;)V", "Lcom/cobblemon/mod/common/api/storage/party/PartyPosition;", "partyPosition", "writePartyPosition", "(Lio/netty/buffer/ByteBuf;Lcom/cobblemon/mod/common/api/storage/party/PartyPosition;)V", "readPartyPosition", "(Lio/netty/buffer/ByteBuf;)Lcom/cobblemon/mod/common/api/storage/party/PartyPosition;", "Lcom/cobblemon/mod/common/api/storage/pc/PCPosition;", "pcPosition", "writePCPosition", "(Lio/netty/buffer/ByteBuf;Lcom/cobblemon/mod/common/api/storage/pc/PCPosition;)V", "readPCPosition", "(Lio/netty/buffer/ByteBuf;)Lcom/cobblemon/mod/common/api/storage/pc/PCPosition;", "Ljava/util/UUID;", "uuid", "writeUUID", "(Lio/netty/buffer/ByteBuf;Ljava/util/UUID;)V", "readUUID", "(Lio/netty/buffer/ByteBuf;)Ljava/util/UUID;", "", "value", "writeEnumConstant", "(Lio/netty/buffer/ByteBuf;Ljava/lang/Enum;)V", "Ljava/lang/Class;", "clazz", "readEnumConstant", "(Lio/netty/buffer/ByteBuf;Ljava/lang/Class;)Ljava/lang/Enum;", "Lnet/minecraft/nbt/Tag;", "nbt", "writeNbt", "(Lio/netty/buffer/ByteBuf;Lnet/minecraft/nbt/Tag;)V", "readNbt", "(Lio/netty/buffer/ByteBuf;)Lnet/minecraft/nbt/Tag;", "E", "Ljava/util/EnumSet;", "enumSet", "type", "writeEnumSet", "(Lio/netty/buffer/ByteBuf;Ljava/util/EnumSet;Ljava/lang/Class;)V", "readEnumSet", "(Lio/netty/buffer/ByteBuf;Ljava/lang/Class;)Ljava/util/EnumSet;", "Ljava/util/BitSet;", "bitSet", "", "size", "writeBitSet", "(Lio/netty/buffer/ByteBuf;Ljava/util/BitSet;I)V", "readBitSet", "(Lio/netty/buffer/ByteBuf;I)Ljava/util/BitSet;", "Lorg/joml/Matrix3f;", "matrix", "writeMatrix3f", "(Lio/netty/buffer/ByteBuf;Lorg/joml/Matrix3f;)V", "readMatrix3f", "(Lio/netty/buffer/ByteBuf;)Lorg/joml/Matrix3f;", "Lorg/joml/Matrix4f;", "writeMatrix4f", "(Lio/netty/buffer/ByteBuf;Lorg/joml/Matrix4f;)V", "readMatrix4f", "(Lio/netty/buffer/ByteBuf;)Lorg/joml/Matrix4f;", "common"})
@SourceDebugExtension(value={"SMAP\nBufferUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BufferUtils.kt\ncom/cobblemon/mod/common/util/BufferUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,333:1\n1869#2,2:334\n216#3,2:336\n*S KotlinDebug\n*F\n+ 1 BufferUtils.kt\ncom/cobblemon/mod/common/util/BufferUtilsKt\n*L\n72#1:334,2\n151#1:336,2\n*E\n"})
public final class BufferUtilsKt {
    @NotNull
    public static final ItemStack readItemStack(@NotNull RegistryFriendlyByteBuf $this$readItemStack) {
        Intrinsics.checkNotNullParameter((Object)$this$readItemStack, (String)"<this>");
        Object object = ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)$this$readItemStack);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"decode(...)");
        return (ItemStack)object;
    }

    public static final void writeItemStack(@NotNull RegistryFriendlyByteBuf $this$writeItemStack, @NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)$this$writeItemStack, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)$this$writeItemStack, (Object)itemStack);
    }

    @NotNull
    public static final Component readText(@NotNull RegistryFriendlyByteBuf $this$readText) {
        Intrinsics.checkNotNullParameter((Object)$this$readText, (String)"<this>");
        Object object = ComponentSerialization.STREAM_CODEC.decode((Object)$this$readText);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"decode(...)");
        return (Component)object;
    }

    public static final void writeText(@NotNull RegistryFriendlyByteBuf $this$writeText, @NotNull Component text) {
        Intrinsics.checkNotNullParameter((Object)$this$writeText, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        ComponentSerialization.STREAM_CODEC.encode((Object)$this$writeText, (Object)text);
    }

    @NotNull
    public static final EntityDimensions readEntityDimensions(@NotNull ByteBuf $this$readEntityDimensions) {
        EntityDimensions entityDimensions;
        Intrinsics.checkNotNullParameter((Object)$this$readEntityDimensions, (String)"<this>");
        float width = $this$readEntityDimensions.readFloat();
        float height = $this$readEntityDimensions.readFloat();
        boolean isFixed = $this$readEntityDimensions.readBoolean();
        if (isFixed) {
            EntityDimensions entityDimensions2 = EntityDimensions.fixed((float)width, (float)height);
            Intrinsics.checkNotNull((Object)entityDimensions2);
            entityDimensions = entityDimensions2;
        } else {
            EntityDimensions entityDimensions3 = EntityDimensions.scalable((float)width, (float)height);
            Intrinsics.checkNotNull((Object)entityDimensions3);
            entityDimensions = entityDimensions3;
        }
        return entityDimensions;
    }

    public static final <T> void writeCollection(@NotNull ByteBuf $this$writeCollection, @NotNull Collection<? extends T> collection, @NotNull Function2<? super ByteBuf, ? super T, Unit> writer) {
        Intrinsics.checkNotNullParameter((Object)$this$writeCollection, (String)"<this>");
        Intrinsics.checkNotNullParameter(collection, (String)"collection");
        Intrinsics.checkNotNullParameter(writer, (String)"writer");
        $this$writeCollection.writeInt(collection.size());
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv;
            Object it = element$iv = iterator.next();
            boolean bl = false;
            writer.invoke((Object)$this$writeCollection, it);
        }
    }

    public static final <T> void writeNullable(@NotNull ByteBuf $this$writeNullable, @Nullable T obj, @NotNull Function2<? super ByteBuf, ? super T, Unit> writer) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)$this$writeNullable, (String)"<this>");
            Intrinsics.checkNotNullParameter(writer, (String)"writer");
            $this$writeNullable.writeBoolean(obj != null);
            T t = obj;
            if (t == null) break block0;
            T it = t;
            boolean bl = false;
            writer.invoke((Object)$this$writeNullable, it);
        }
    }

    public static final <T> void writeNullable(@NotNull ByteBuf $this$writeNullable, @Nullable T obj, @NotNull StreamEncoder<ByteBuf, T> writer) {
        Intrinsics.checkNotNullParameter((Object)$this$writeNullable, (String)"<this>");
        Intrinsics.checkNotNullParameter(writer, (String)"writer");
        BufferUtilsKt.writeNullable($this$writeNullable, obj, (arg_0, arg_1) -> BufferUtilsKt.writeNullable$lambda$1(writer, arg_0, arg_1));
    }

    @NotNull
    public static final ByteBuf writeString(@NotNull ByteBuf $this$writeString, @NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)$this$writeString, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        Utf8String.write((ByteBuf)$this$writeString, (CharSequence)string, (int)Short.MAX_VALUE);
        return $this$writeString;
    }

    @NotNull
    public static final <T> List<T> readList(@NotNull RegistryFriendlyByteBuf $this$readList, @NotNull Function1<? super FriendlyByteBuf, ? extends T> reader) {
        Intrinsics.checkNotNullParameter((Object)$this$readList, (String)"<this>");
        Intrinsics.checkNotNullParameter(reader, (String)"reader");
        Collection collection = $this$readList.readCollection(Lists::newArrayListWithCapacity, arg_0 -> BufferUtilsKt.readList$lambda$0(reader, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"readCollection(...)");
        return (List)collection;
    }

    @NotNull
    public static final String readString(@NotNull ByteBuf $this$readString) {
        Intrinsics.checkNotNullParameter((Object)$this$readString, (String)"<this>");
        String string = Utf8String.read((ByteBuf)$this$readString, (int)Short.MAX_VALUE);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"read(...)");
        return string;
    }

    @NotNull
    public static final ByteBuf writeExpression(@NotNull ByteBuf $this$writeExpression, @NotNull Expression expression) {
        Intrinsics.checkNotNullParameter((Object)$this$writeExpression, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        return BufferUtilsKt.writeString($this$writeExpression, MoLangExtensionsKt.getString(expression));
    }

    @NotNull
    public static final ByteBuf writeNullableExpression(@NotNull ByteBuf $this$writeNullableExpression, @Nullable Expression expression) {
        Intrinsics.checkNotNullParameter((Object)$this$writeNullableExpression, (String)"<this>");
        BufferUtilsKt.writeNullable($this$writeNullableExpression, expression, BufferUtilsKt::writeNullableExpression$lambda$0);
        return $this$writeNullableExpression;
    }

    @NotNull
    public static final ByteBuf writeExpressionLike(@NotNull ByteBuf $this$writeExpressionLike, @NotNull ExpressionLike expressionLike) {
        Intrinsics.checkNotNullParameter((Object)$this$writeExpressionLike, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)expressionLike, (String)"expressionLike");
        return BufferUtilsKt.writeString($this$writeExpressionLike, expressionLike.getString());
    }

    public static final void writeRidingStats(@NotNull ByteBuf $this$writeRidingStats, @NotNull Map<RidingStat, IntRange> stats) {
        Intrinsics.checkNotNullParameter((Object)$this$writeRidingStats, (String)"<this>");
        Intrinsics.checkNotNullParameter(stats, (String)"stats");
        BufferUtilsKt.writeMap($this$writeRidingStats, stats, BufferUtilsKt::writeRidingStats$lambda$0, BufferUtilsKt::writeRidingStats$lambda$1);
    }

    @NotNull
    public static final Map<RidingStat, IntRange> readRidingStats(@NotNull ByteBuf $this$readRidingStats) {
        Intrinsics.checkNotNullParameter((Object)$this$readRidingStats, (String)"<this>");
        return BufferUtilsKt.readMap($this$readRidingStats, BufferUtilsKt::readRidingStats$lambda$0, BufferUtilsKt::readRidingStats$lambda$1);
    }

    @NotNull
    public static final Expression readExpression(@NotNull ByteBuf $this$readExpression) {
        Intrinsics.checkNotNullParameter((Object)$this$readExpression, (String)"<this>");
        Expression expression = MoLangExtensionsKt.asExpression(BufferUtilsKt.readString($this$readExpression));
        Intrinsics.checkNotNullExpressionValue((Object)expression, (String)"asExpression(...)");
        return expression;
    }

    @Nullable
    public static final Expression readNullableExpression(@NotNull ByteBuf $this$readNullableExpression) {
        Intrinsics.checkNotNullParameter((Object)$this$readNullableExpression, (String)"<this>");
        return (Expression)BufferUtilsKt.readNullable($this$readNullableExpression, BufferUtilsKt::readNullableExpression$lambda$0);
    }

    @NotNull
    public static final ExpressionLike readExpressionLike(@NotNull ByteBuf $this$readExpressionLike) {
        Intrinsics.checkNotNullParameter((Object)$this$readExpressionLike, (String)"<this>");
        return MoLangExtensionsKt.asExpressionLike(BufferUtilsKt.readString($this$readExpressionLike));
    }

    @Nullable
    public static final <T> T readNullable(@NotNull ByteBuf $this$readNullable, @NotNull Function1<? super ByteBuf, ? extends T> reader) {
        Intrinsics.checkNotNullParameter((Object)$this$readNullable, (String)"<this>");
        Intrinsics.checkNotNullParameter(reader, (String)"reader");
        boolean isPresent = $this$readNullable.readBoolean();
        if (isPresent) {
            return (T)reader.invoke((Object)$this$readNullable);
        }
        return null;
    }

    public static final <K, V> void writeMap(@NotNull ByteBuf $this$writeMap, @NotNull Map<K, ? extends V> map, @NotNull Function2<? super ByteBuf, ? super K, Unit> keyWriter, @NotNull Function2<? super ByteBuf, ? super V, Unit> valueWriter) {
        Intrinsics.checkNotNullParameter((Object)$this$writeMap, (String)"<this>");
        Intrinsics.checkNotNullParameter(map, (String)"map");
        Intrinsics.checkNotNullParameter(keyWriter, (String)"keyWriter");
        Intrinsics.checkNotNullParameter(valueWriter, (String)"valueWriter");
        $this$writeMap.writeInt(map.size());
        Map<K, V> $this$forEach$iv = map;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<K, V>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<K, V> element$iv;
            Map.Entry<K, V> entry = element$iv = iterator.next();
            boolean bl = false;
            K key = entry.getKey();
            V value = entry.getValue();
            keyWriter.invoke((Object)$this$writeMap, key);
            valueWriter.invoke((Object)$this$writeMap, value);
        }
    }

    @NotNull
    public static final <K, V> Map<K, V> readMap(@NotNull ByteBuf $this$readMap, @NotNull Function1<? super ByteBuf, ? extends K> keyReader, @NotNull Function1<? super ByteBuf, ? extends V> valueReader) {
        Intrinsics.checkNotNullParameter((Object)$this$readMap, (String)"<this>");
        Intrinsics.checkNotNullParameter(keyReader, (String)"keyReader");
        Intrinsics.checkNotNullParameter(valueReader, (String)"valueReader");
        Map map = new LinkedHashMap();
        int numElements = $this$readMap.readInt();
        int n = 0;
        while (n < numElements) {
            int it = n++;
            boolean bl = false;
            Object key = keyReader.invoke((Object)$this$readMap);
            Object value = valueReader.invoke((Object)$this$readMap);
            map.put(key, value);
        }
        return map;
    }

    @NotNull
    public static final ResourceLocation readIdentifier(@NotNull ByteBuf $this$readIdentifier) {
        Intrinsics.checkNotNullParameter((Object)$this$readIdentifier, (String)"<this>");
        String str = BufferUtilsKt.readString($this$readIdentifier);
        ResourceLocation resourceLocation = ResourceLocation.tryParse((String)str);
        Intrinsics.checkNotNull((Object)resourceLocation);
        return resourceLocation;
    }

    public static final void writeIdentifier(@NotNull ByteBuf $this$writeIdentifier, @NotNull ResourceLocation id) {
        Intrinsics.checkNotNullParameter((Object)$this$writeIdentifier, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        String string = id.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        BufferUtilsKt.writeString($this$writeIdentifier, string);
    }

    public static final void writePartyPosition(@NotNull ByteBuf $this$writePartyPosition, @NotNull PartyPosition partyPosition) {
        Intrinsics.checkNotNullParameter((Object)$this$writePartyPosition, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)partyPosition, (String)"partyPosition");
        NetExtensionsKt.writeSizedInt($this$writePartyPosition, IntSize.U_SHORT, partyPosition.getSlot());
    }

    @NotNull
    public static final PartyPosition readPartyPosition(@NotNull ByteBuf $this$readPartyPosition) {
        Intrinsics.checkNotNullParameter((Object)$this$readPartyPosition, (String)"<this>");
        return new PartyPosition(NetExtensionsKt.readSizedInt($this$readPartyPosition, IntSize.U_SHORT));
    }

    public static final void writePCPosition(@NotNull ByteBuf $this$writePCPosition, @NotNull PCPosition pcPosition) {
        Intrinsics.checkNotNullParameter((Object)$this$writePCPosition, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)pcPosition, (String)"pcPosition");
        NetExtensionsKt.writeSizedInt($this$writePCPosition, IntSize.U_SHORT, pcPosition.getBox());
        NetExtensionsKt.writeSizedInt($this$writePCPosition, IntSize.U_BYTE, pcPosition.getSlot());
    }

    @NotNull
    public static final PCPosition readPCPosition(@NotNull ByteBuf $this$readPCPosition) {
        Intrinsics.checkNotNullParameter((Object)$this$readPCPosition, (String)"<this>");
        return new PCPosition(NetExtensionsKt.readSizedInt($this$readPCPosition, IntSize.U_SHORT), NetExtensionsKt.readSizedInt($this$readPCPosition, IntSize.U_BYTE));
    }

    public static final void writeUUID(@NotNull ByteBuf $this$writeUUID, @NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)$this$writeUUID, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        $this$writeUUID.writeLong(uuid.getMostSignificantBits());
        $this$writeUUID.writeLong(uuid.getLeastSignificantBits());
    }

    @NotNull
    public static final UUID readUUID(@NotNull ByteBuf $this$readUUID) {
        Intrinsics.checkNotNullParameter((Object)$this$readUUID, (String)"<this>");
        return new UUID($this$readUUID.readLong(), $this$readUUID.readLong());
    }

    public static final void writeEnumConstant(@NotNull ByteBuf $this$writeEnumConstant, @NotNull Enum<?> value) {
        Intrinsics.checkNotNullParameter((Object)$this$writeEnumConstant, (String)"<this>");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        $this$writeEnumConstant.writeInt(value.ordinal());
    }

    @NotNull
    public static final <T extends Enum<T>> T readEnumConstant(@NotNull ByteBuf $this$readEnumConstant, @NotNull Class<T> clazz) {
        Intrinsics.checkNotNullParameter((Object)$this$readEnumConstant, (String)"<this>");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Enum enum_ = ((Enum[])clazz.getEnumConstants())[$this$readEnumConstant.readInt()];
        Intrinsics.checkNotNullExpressionValue((Object)enum_, (String)"get(...)");
        return (T)enum_;
    }

    public static final void writeNbt(@NotNull ByteBuf $this$writeNbt, @NotNull Tag nbt) {
        Intrinsics.checkNotNullParameter((Object)$this$writeNbt, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        try {
            NbtIo.writeAnyTag((Tag)nbt, (DataOutput)((DataOutput)new ByteBufOutputStream($this$writeNbt)));
        }
        catch (IOException var3) {
            IOException iOException = var3;
            throw new EncoderException((Throwable)iOException);
        }
    }

    @Nullable
    public static final Tag readNbt(@NotNull ByteBuf $this$readNbt) {
        Intrinsics.checkNotNullParameter((Object)$this$readNbt, (String)"<this>");
        IOException iOException = null;
        Tag nbtElement = null;
        try {
            CompoundTag compoundTag = NbtIo.read((DataInput)((DataInput)new ByteBufInputStream($this$readNbt)), (NbtAccounter)NbtAccounter.create((long)0x200000L));
            Intrinsics.checkNotNullExpressionValue((Object)compoundTag, (String)"read(...)");
            nbtElement = (Tag)compoundTag;
            if (Intrinsics.areEqual((Object)((CompoundTag)nbtElement).getType(), (Object)EndTag.TYPE)) {
                return null;
            }
        }
        catch (IOException var4) {
            iOException = var4;
            throw new EncoderException((Throwable)iOException);
        }
        try {
            return nbtElement;
        }
        catch (IOException var3) {
            iOException = var3;
            throw new EncoderException((Throwable)iOException);
        }
    }

    public static final <E extends Enum<E>> void writeEnumSet(@NotNull ByteBuf $this$writeEnumSet, @NotNull EnumSet<E> enumSet, @NotNull Class<E> type) {
        Intrinsics.checkNotNullParameter((Object)$this$writeEnumSet, (String)"<this>");
        Intrinsics.checkNotNullParameter(enumSet, (String)"enumSet");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Enum[] enums = (Enum[])type.getEnumConstants();
        BitSet bitSet = new BitSet(enums.length);
        int n = enums.length;
        for (int i = 0; i < n; ++i) {
            bitSet.set(i, enumSet.contains(enums[i]));
        }
        BufferUtilsKt.writeBitSet($this$writeEnumSet, bitSet, enums.length);
    }

    @NotNull
    public static final <E extends Enum<E>> EnumSet<E> readEnumSet(@NotNull ByteBuf $this$readEnumSet, @NotNull Class<E> type) {
        Intrinsics.checkNotNullParameter((Object)$this$readEnumSet, (String)"<this>");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        E[] EArray = type.getEnumConstants();
        Intrinsics.checkNotNullExpressionValue(EArray, (String)"getEnumConstants(...)");
        Enum[] enums = (Enum[])EArray;
        BitSet bitSet = BufferUtilsKt.readBitSet($this$readEnumSet, enums.length);
        EnumSet<Enum> enumSet = EnumSet.noneOf(type);
        int n = enums.length;
        for (int i = 0; i < n; ++i) {
            if (!bitSet.get(i)) continue;
            enumSet.add(enums[i]);
        }
        Intrinsics.checkNotNull(enumSet);
        return enumSet;
    }

    public static final void writeBitSet(@NotNull ByteBuf $this$writeBitSet, @NotNull BitSet bitSet, int size) {
        Intrinsics.checkNotNullParameter((Object)$this$writeBitSet, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)bitSet, (String)"bitSet");
        if (bitSet.length() > size) {
            int var10002 = bitSet.length();
            throw new EncoderException("BitSet is larger than expected size (" + var10002 + ">" + size + ")");
        }
        byte[] bs = bitSet.toByteArray();
        Intrinsics.checkNotNull((Object)bs);
        byte[] byArray = Arrays.copyOf(bs, Mth.positiveCeilDiv((int)size, (int)8));
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(...)");
        $this$writeBitSet.writeBytes(byArray);
    }

    @NotNull
    public static final BitSet readBitSet(@NotNull ByteBuf $this$readBitSet, int size) {
        Intrinsics.checkNotNullParameter((Object)$this$readBitSet, (String)"<this>");
        byte[] bs = new byte[Mth.positiveCeilDiv((int)size, (int)8)];
        $this$readBitSet.readBytes(bs);
        BitSet bitSet = BitSet.valueOf(bs);
        Intrinsics.checkNotNullExpressionValue((Object)bitSet, (String)"valueOf(...)");
        return bitSet;
    }

    public static final void writeMatrix3f(@NotNull ByteBuf $this$writeMatrix3f, @NotNull Matrix3f matrix) {
        Intrinsics.checkNotNullParameter((Object)$this$writeMatrix3f, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)matrix, (String)"matrix");
        $this$writeMatrix3f.writeFloat(matrix.m00);
        $this$writeMatrix3f.writeFloat(matrix.m01);
        $this$writeMatrix3f.writeFloat(matrix.m02);
        $this$writeMatrix3f.writeFloat(matrix.m10);
        $this$writeMatrix3f.writeFloat(matrix.m11);
        $this$writeMatrix3f.writeFloat(matrix.m12);
        $this$writeMatrix3f.writeFloat(matrix.m20);
        $this$writeMatrix3f.writeFloat(matrix.m21);
        $this$writeMatrix3f.writeFloat(matrix.m22);
    }

    @NotNull
    public static final Matrix3f readMatrix3f(@NotNull ByteBuf $this$readMatrix3f) {
        Intrinsics.checkNotNullParameter((Object)$this$readMatrix3f, (String)"<this>");
        return new Matrix3f($this$readMatrix3f.readFloat(), $this$readMatrix3f.readFloat(), $this$readMatrix3f.readFloat(), $this$readMatrix3f.readFloat(), $this$readMatrix3f.readFloat(), $this$readMatrix3f.readFloat(), $this$readMatrix3f.readFloat(), $this$readMatrix3f.readFloat(), $this$readMatrix3f.readFloat());
    }

    public static final void writeMatrix4f(@NotNull ByteBuf $this$writeMatrix4f, @NotNull Matrix4f matrix) {
        Intrinsics.checkNotNullParameter((Object)$this$writeMatrix4f, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)matrix, (String)"matrix");
        $this$writeMatrix4f.writeFloat(matrix.m00());
        $this$writeMatrix4f.writeFloat(matrix.m01());
        $this$writeMatrix4f.writeFloat(matrix.m02());
        $this$writeMatrix4f.writeFloat(matrix.m03());
        $this$writeMatrix4f.writeFloat(matrix.m10());
        $this$writeMatrix4f.writeFloat(matrix.m11());
        $this$writeMatrix4f.writeFloat(matrix.m12());
        $this$writeMatrix4f.writeFloat(matrix.m13());
        $this$writeMatrix4f.writeFloat(matrix.m20());
        $this$writeMatrix4f.writeFloat(matrix.m21());
        $this$writeMatrix4f.writeFloat(matrix.m22());
        $this$writeMatrix4f.writeFloat(matrix.m23());
        $this$writeMatrix4f.writeFloat(matrix.m30());
        $this$writeMatrix4f.writeFloat(matrix.m31());
        $this$writeMatrix4f.writeFloat(matrix.m32());
        $this$writeMatrix4f.writeFloat(matrix.m33());
    }

    @NotNull
    public static final Matrix4f readMatrix4f(@NotNull ByteBuf $this$readMatrix4f) {
        Intrinsics.checkNotNullParameter((Object)$this$readMatrix4f, (String)"<this>");
        return new Matrix4f($this$readMatrix4f.readFloat(), $this$readMatrix4f.readFloat(), $this$readMatrix4f.readFloat(), $this$readMatrix4f.readFloat(), $this$readMatrix4f.readFloat(), $this$readMatrix4f.readFloat(), $this$readMatrix4f.readFloat(), $this$readMatrix4f.readFloat(), $this$readMatrix4f.readFloat(), $this$readMatrix4f.readFloat(), $this$readMatrix4f.readFloat(), $this$readMatrix4f.readFloat(), $this$readMatrix4f.readFloat(), $this$readMatrix4f.readFloat(), $this$readMatrix4f.readFloat(), $this$readMatrix4f.readFloat());
    }

    private static final Unit writeNullable$lambda$1(StreamEncoder $writer, ByteBuf buf, Object otherObj) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        Intrinsics.checkNotNullParameter((Object)otherObj, (String)"otherObj");
        $writer.encode((Object)buf, otherObj);
        return Unit.INSTANCE;
    }

    private static final Object readList$lambda$0(Function1 $tmp0, Object object) {
        return $tmp0.invoke(object);
    }

    private static final Unit writeNullableExpression$lambda$0(ByteBuf buf, Expression expr) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        BufferUtilsKt.writeExpression(buf, expr);
        return Unit.INSTANCE;
    }

    private static final Unit writeRidingStats$lambda$0(ByteBuf buf, RidingStat stat) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        Intrinsics.checkNotNullParameter((Object)((Object)stat), (String)"stat");
        BufferUtilsKt.writeEnumConstant(buf, stat);
        return Unit.INSTANCE;
    }

    private static final Unit writeRidingStats$lambda$1(ByteBuf buf, IntRange range) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        buf.writeInt(range.getFirst()).writeInt(range.getLast());
        return Unit.INSTANCE;
    }

    private static final RidingStat readRidingStats$lambda$0(ByteBuf buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        return BufferUtilsKt.readEnumConstant(buf, RidingStat.class);
    }

    private static final IntRange readRidingStats$lambda$1(ByteBuf buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        return new IntRange(buf.readInt(), buf.readInt());
    }

    private static final Expression readNullableExpression$lambda$0(ByteBuf buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        return BufferUtilsKt.readExpression(buf);
    }
}

