/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.world.feature;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.CobblemonBlocks;
import com.cobblemon.mod.common.api.tags.CobblemonBiomeTags;
import com.cobblemon.mod.common.block.ApricornBlock;
import com.cobblemon.mod.common.util.ListExtensionsKt;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.RangesKt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.BlockStateConfiguration;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001d\u0010\b\u001a\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ'\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J+\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u00162\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J+\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u00190\u00192\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ!\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u001c2\b\u0010\r\u001a\u0004\u0018\u00010\fH\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001f\u00a8\u0006 "}, d2={"Lcom/cobblemon/mod/common/world/feature/ApricornTreeFeature;", "Lnet/minecraft/world/level/levelgen/feature/Feature;", "Lnet/minecraft/world/level/levelgen/feature/configurations/BlockStateConfiguration;", "<init>", "()V", "Lnet/minecraft/world/level/levelgen/feature/FeaturePlaceContext;", "context", "", "place", "(Lnet/minecraft/world/level/levelgen/feature/FeaturePlaceContext;)Z", "Lnet/minecraft/world/level/WorldGenLevel;", "worldGenLevel", "Lnet/minecraft/core/BlockPos;", "blockPos", "Lnet/minecraft/world/level/block/state/BlockState;", "blockState", "", "setBlockIfClear", "(Lnet/minecraft/world/level/WorldGenLevel;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "origin", "Lnet/minecraft/util/RandomSource;", "random", "Lkotlin/Pair;", "getLayerOneVariation", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/util/RandomSource;)Lkotlin/Pair;", "", "getLayerFourVariation", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/util/RandomSource;)Ljava/util/List;", "Lnet/minecraft/world/level/LevelSimulatedReader;", "testableWorld", "isAir", "(Lnet/minecraft/world/level/LevelSimulatedReader;Lnet/minecraft/core/BlockPos;)Z", "common"})
@SourceDebugExtension(value={"SMAP\nApricornTreeFeature.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApricornTreeFeature.kt\ncom/cobblemon/mod/common/world/feature/ApricornTreeFeature\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,234:1\n774#2:235\n865#2,2:236\n1563#2:238\n1634#2,3:239\n1869#2,2:242\n*S KotlinDebug\n*F\n+ 1 ApricornTreeFeature.kt\ncom/cobblemon/mod/common/world/feature/ApricornTreeFeature\n*L\n159#1:235\n159#1:236,2\n161#1:238\n161#1:239,3\n162#1:242,2\n*E\n"})
public final class ApricornTreeFeature
extends Feature<BlockStateConfiguration> {
    public ApricornTreeFeature() {
        super(BlockStateConfiguration.CODEC);
    }

    /*
     * WARNING - void declaration
     */
    public boolean place(@NotNull FeaturePlaceContext<BlockStateConfiguration> context) {
        Object object;
        Object leafPos;
        Object coords22;
        Object[] leafPos2;
        boolean isGenerating;
        Intrinsics.checkNotNullParameter(context, (String)"context");
        WorldGenLevel worldGenLevel = context.level();
        Intrinsics.checkNotNullExpressionValue((Object)worldGenLevel, (String)"level(...)");
        WorldGenLevel worldGenLevel2 = worldGenLevel;
        RandomSource random = context.random();
        BlockPos origin = context.origin();
        boolean bl = isGenerating = !Intrinsics.areEqual((Object)worldGenLevel2.getChunk(origin).getPersistedStatus(), (Object)ChunkStatus.FULL);
        if (isGenerating) {
            float f;
            Holder biome = worldGenLevel2.getBiome(origin);
            if (biome.is(CobblemonBiomeTags.HAS_APRICORNS_SPARSE)) {
                f = 0.1f;
            } else if (biome.is(CobblemonBiomeTags.HAS_APRICORNS_DENSE)) {
                f = 10.0f;
            } else if (biome.is(CobblemonBiomeTags.HAS_APRICORNS_NORMAL)) {
                f = 1.0f;
            } else {
                return false;
            }
            float multiplier = f;
            if (random.nextFloat() > multiplier * Cobblemon.INSTANCE.getConfig().getBaseApricornTreeGenerationChance()) {
                return false;
            }
        }
        if (!worldGenLevel2.getBlockState(origin.below()).is(BlockTags.DIRT)) {
            return false;
        }
        BlockState logState = CobblemonBlocks.APRICORN_LOG.defaultBlockState();
        for (int y = 0; y < 5; ++y) {
            try {
                BlockPos logPos = origin.relative(Direction.UP, y);
                worldGenLevel2.setBlock(logPos, logState, 2);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        List allApricornSpots = new ArrayList();
        BlockState leafBlock = CobblemonBlocks.APRICORN_LEAVES.defaultBlockState();
        BlockPos layerOnePos = origin.relative(Direction.UP);
        Object[] objectArray = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
        for (Object direction : CollectionsKt.listOf((Object[])objectArray)) {
            Object[] objectArray2 = leafPos2 = layerOnePos.relative((Direction)direction);
            Intrinsics.checkNotNull((Object)objectArray2);
            BlockState blockState = LeavesBlock.updateDistance((BlockState)leafBlock, (LevelAccessor)((LevelAccessor)worldGenLevel2), (BlockPos)leafPos2);
            Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"updateDistance(...)");
            this.setBlockIfClear(worldGenLevel2, (BlockPos)objectArray2, blockState);
            for (int offset = 1; offset < 4; ++offset) {
                Object[] objectArray3 = leafPos2 = leafPos2.above();
                Intrinsics.checkNotNull((Object)objectArray3);
                BlockState blockState2 = LeavesBlock.updateDistance((BlockState)leafBlock, (LevelAccessor)((LevelAccessor)worldGenLevel2), (BlockPos)leafPos2);
                Intrinsics.checkNotNullExpressionValue((Object)blockState2, (String)"updateDistance(...)");
                this.setBlockIfClear(worldGenLevel2, (BlockPos)objectArray3, blockState2);
            }
        }
        Intrinsics.checkNotNull((Object)layerOnePos);
        Intrinsics.checkNotNull((Object)random);
        Pair<BlockPos, BlockPos> layerOneExtenders = this.getLayerOneVariation(layerOnePos, random);
        BlockPos blockPos = (BlockPos)layerOneExtenders.getFirst();
        BlockState blockState = LeavesBlock.updateDistance((BlockState)leafBlock, (LevelAccessor)((LevelAccessor)worldGenLevel2), (BlockPos)((BlockPos)layerOneExtenders.getFirst()));
        Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"updateDistance(...)");
        this.setBlockIfClear(worldGenLevel2, blockPos, blockState);
        BlockPos blockPos2 = (BlockPos)layerOneExtenders.getSecond();
        BlockState blockState3 = LeavesBlock.updateDistance((BlockState)leafBlock, (LevelAccessor)((LevelAccessor)worldGenLevel2), (BlockPos)((BlockPos)layerOneExtenders.getSecond()));
        Intrinsics.checkNotNullExpressionValue((Object)blockState3, (String)"updateDistance(...)");
        this.setBlockIfClear(worldGenLevel2, blockPos2, blockState3);
        leafPos2 = new Pair[]{new Pair((Object)1, (Object)1), new Pair((Object)-1, (Object)-1), new Pair((Object)1, (Object)-1), new Pair((Object)-1, (Object)1)};
        for (Object coords22 : CollectionsKt.listOf((Object[])leafPos2)) {
            void var14_25;
            BlockPos leafPos3;
            BlockPos blockPos3 = leafPos3 = layerOnePos.offset(((Number)coords22.getFirst()).intValue(), 0, ((Number)coords22.getSecond()).intValue());
            Intrinsics.checkNotNull((Object)blockPos3);
            BlockState blockState4 = LeavesBlock.updateDistance((BlockState)leafBlock, (LevelAccessor)((LevelAccessor)worldGenLevel2), (BlockPos)leafPos3);
            Intrinsics.checkNotNullExpressionValue((Object)blockState4, (String)"updateDistance(...)");
            this.setBlockIfClear(worldGenLevel2, blockPos3, blockState4);
            boolean bl2 = true;
            while (var14_25 < 4) {
                leafPos3 = leafPos3.above();
                BlockPos blockPos4 = leafPos3;
                Intrinsics.checkNotNull((Object)blockPos4);
                BlockState blockState5 = LeavesBlock.updateDistance((BlockState)leafBlock, (LevelAccessor)((LevelAccessor)worldGenLevel2), (BlockPos)leafPos3);
                Intrinsics.checkNotNullExpressionValue((Object)blockState5, (String)"updateDistance(...)");
                this.setBlockIfClear(worldGenLevel2, blockPos4, blockState5);
                ++var14_25;
            }
        }
        BlockPos layerTwoPos = origin.offset(0, 2, 0);
        Object[] objectArray2 = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
        Iterator iterator = Lists.newArrayList((Object[])objectArray2).iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        coords22 = iterator;
        while (coords22.hasNext()) {
            Direction direction = (Direction)coords22.next();
            List list = new ArrayList();
            object = leafPos = layerTwoPos.offset(direction.getStepX() * 2, direction.getStepY() * 2, direction.getStepZ() * 2);
            Intrinsics.checkNotNull((Object)object);
            BlockState blockState6 = LeavesBlock.updateDistance((BlockState)leafBlock, (LevelAccessor)((LevelAccessor)worldGenLevel2), (BlockPos)leafPos);
            Intrinsics.checkNotNullExpressionValue((Object)blockState6, (String)"updateDistance(...)");
            this.setBlockIfClear(worldGenLevel2, (BlockPos)object, blockState6);
            list.add(TuplesKt.to((Object)direction.getOpposite(), (Object)leafPos.relative(direction)));
            object = leafPos = leafPos.above();
            Intrinsics.checkNotNull((Object)object);
            BlockState blockState7 = LeavesBlock.updateDistance((BlockState)leafBlock, (LevelAccessor)((LevelAccessor)worldGenLevel2), (BlockPos)leafPos);
            Intrinsics.checkNotNullExpressionValue((Object)blockState7, (String)"updateDistance(...)");
            this.setBlockIfClear(worldGenLevel2, (BlockPos)object, blockState7);
            list.add(TuplesKt.to((Object)direction.getOpposite(), (Object)leafPos.relative(direction)));
            allApricornSpots.add(list);
        }
        Object[] objectArray3 = new Pair[]{new Pair((Object)1, (Object)2), new Pair((Object)-1, (Object)2), new Pair((Object)1, (Object)-2), new Pair((Object)-2, (Object)1), new Pair((Object)2, (Object)1), new Pair((Object)-2, (Object)-1), new Pair((Object)-1, (Object)-2), new Pair((Object)2, (Object)-1)};
        Iterator iterator2 = Lists.newArrayList((Object[])objectArray3).iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
        coords22 = iterator2;
        while (coords22.hasNext()) {
            Object apricornPos;
            Object[] direction22;
            Pair coords3 = (Pair)coords22.next();
            List list = new ArrayList();
            object = leafPos = layerTwoPos.offset(((Number)coords3.getFirst()).intValue(), 0, ((Number)coords3.getSecond()).intValue());
            Intrinsics.checkNotNull((Object)object);
            BlockState blockState8 = LeavesBlock.updateDistance((BlockState)leafBlock, (LevelAccessor)((LevelAccessor)worldGenLevel2), (BlockPos)leafPos);
            Intrinsics.checkNotNullExpressionValue((Object)blockState8, (String)"updateDistance(...)");
            this.setBlockIfClear(worldGenLevel2, (BlockPos)object, blockState8);
            Object[] objectArray4 = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
            for (Object[] direction22 : CollectionsKt.listOf((Object[])objectArray4)) {
                apricornPos = leafPos.relative((Direction)direction22);
                if (!this.isAir((LevelSimulatedReader)worldGenLevel2, (BlockPos)apricornPos)) continue;
                list.add(TuplesKt.to((Object)direction22.getOpposite(), (Object)apricornPos));
            }
            object = leafPos = leafPos.above();
            Intrinsics.checkNotNull((Object)object);
            BlockState blockState9 = LeavesBlock.updateDistance((BlockState)leafBlock, (LevelAccessor)((LevelAccessor)worldGenLevel2), (BlockPos)leafPos);
            Intrinsics.checkNotNullExpressionValue((Object)blockState9, (String)"updateDistance(...)");
            this.setBlockIfClear(worldGenLevel2, (BlockPos)object, blockState9);
            direction22 = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
            for (Direction direction : CollectionsKt.listOf((Object[])direction22)) {
                apricornPos = leafPos.relative(direction);
                if (!this.isAir((LevelSimulatedReader)worldGenLevel2, (BlockPos)apricornPos)) continue;
                list.add(TuplesKt.to((Object)direction.getOpposite(), (Object)apricornPos));
            }
            allApricornSpots.add(list);
        }
        BlockPos topperPos = origin.offset(0, 5, 0);
        Intrinsics.checkNotNull((Object)topperPos);
        BlockState blockState10 = LeavesBlock.updateDistance((BlockState)leafBlock, (LevelAccessor)((LevelAccessor)worldGenLevel2), (BlockPos)topperPos);
        Intrinsics.checkNotNullExpressionValue((Object)blockState10, (String)"updateDistance(...)");
        this.setBlockIfClear(worldGenLevel2, topperPos, blockState10);
        leafPos = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
        Iterator iterator3 = Lists.newArrayList((Object[])leafPos).iterator();
        Intrinsics.checkNotNullExpressionValue(iterator3, (String)"iterator(...)");
        Iterator<Object> coords3 = iterator3;
        while (coords3.hasNext()) {
            Direction direction = (Direction)coords3.next();
            leafPos = topperPos.relative(direction);
            Intrinsics.checkNotNull((Object)leafPos);
            BlockState blockState11 = LeavesBlock.updateDistance((BlockState)leafBlock, (LevelAccessor)((LevelAccessor)worldGenLevel2), (BlockPos)leafPos);
            Intrinsics.checkNotNullExpressionValue((Object)blockState11, (String)"updateDistance(...)");
            this.setBlockIfClear(worldGenLevel2, (BlockPos)leafPos, blockState11);
        }
        BlockPos blockPos5 = origin.relative(Direction.UP, 4);
        Intrinsics.checkNotNullExpressionValue((Object)blockPos5, (String)"relative(...)");
        for (List list : this.getLayerFourVariation(blockPos5, random)) {
            for (BlockPos block : list) {
                BlockState blockState12 = LeavesBlock.updateDistance((BlockState)leafBlock, (LevelAccessor)((LevelAccessor)worldGenLevel2), (BlockPos)block);
                Intrinsics.checkNotNullExpressionValue((Object)blockState12, (String)"updateDistance(...)");
                this.setBlockIfClear(worldGenLevel2, block, blockState12);
            }
        }
        if (!((Collection)allApricornSpots).isEmpty()) {
            void $this$forEach$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            List p0;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = allApricornSpots;
            boolean bl3 = false;
            leafPos = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                p0 = (List)element$iv$iv;
                boolean bl2 = false;
                boolean bl4 = !((Collection)p0).isEmpty();
                if (!bl4) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = ListExtensionsKt.randomNoCopy((List)destination$iv$iv, RangesKt.coerceAtMost((int)allApricornSpots.size(), (int)8));
            boolean bl5 = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                p0 = (List)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl4 = false;
                collection.add((Pair)CollectionsKt.random((Collection)((Collection)it), (Random)((Random)Random.Default)));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean bl6 = false;
            for (Object element$iv : $this$forEach$iv) {
                Pair it = (Pair)element$iv;
                boolean bl52 = false;
                if (!worldGenLevel2.getBlockState(((BlockPos)it.getSecond()).relative((Direction)it.getFirst())).getBlock().equals((Object)leafBlock.getBlock())) continue;
                BlockPos blockPos6 = (BlockPos)it.getSecond();
                Object object2 = ((BlockState)((BlockStateConfiguration)context.config()).state.setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)it.getFirst())).setValue((Property)ApricornBlock.Companion.getAGE(), (Comparable)Integer.valueOf(isGenerating ? random.nextInt(4) : 0));
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"setValue(...)");
                this.setBlockIfClear(worldGenLevel2, blockPos6, (BlockState)object2);
            }
        }
        return true;
    }

    private final void setBlockIfClear(WorldGenLevel worldGenLevel, BlockPos blockPos, BlockState blockState) {
        if (!TreeFeature.isAirOrLeaves((LevelSimulatedReader)((LevelSimulatedReader)worldGenLevel), (BlockPos)blockPos)) {
            return;
        }
        worldGenLevel.setBlock(blockPos, blockState, 3);
    }

    private final Pair<BlockPos, BlockPos> getLayerOneVariation(BlockPos origin, RandomSource random) {
        Direction direction = Direction.NORTH;
        switch (random.nextInt(4)) {
            case 1: {
                direction = Direction.EAST;
                break;
            }
            case 2: {
                direction = Direction.SOUTH;
                break;
            }
            case 3: {
                direction = Direction.WEST;
            }
        }
        BlockPos posOne = origin.offset(direction.getStepX() * 2, direction.getStepY() * 2, direction.getStepZ() * 2);
        int offset = random.nextBoolean() ? -1 : 1;
        BlockPos posTwo = direction.getStepX() == 0 ? posOne.offset(offset, 0, 0) : posOne.offset(0, 0, offset);
        return TuplesKt.to((Object)posOne, (Object)posTwo);
    }

    private final List<List<BlockPos>> getLayerFourVariation(BlockPos origin, RandomSource random) {
        List variationList = new ArrayList();
        List usedDirections = new ArrayList();
        int i = 1;
        int n = Random.Default.nextInt(2, 4);
        if (i <= n) {
            while (true) {
                BlockPos posTwo;
                Direction direction = null;
                while (direction == null || usedDirections.contains(direction)) {
                    switch (random.nextInt(4)) {
                        case 0: {
                            direction = Direction.NORTH;
                            break;
                        }
                        case 1: {
                            direction = Direction.EAST;
                            break;
                        }
                        case 2: {
                            direction = Direction.SOUTH;
                            break;
                        }
                        case 3: {
                            direction = Direction.WEST;
                        }
                    }
                }
                BlockPos posOne = origin.offset(direction.getStepX() * 2, direction.getStepY() * 2, direction.getStepZ() * 2);
                int offset = random.nextBoolean() ? -1 : 1;
                BlockPos blockPos = posTwo = direction.getStepX() == 0 ? posOne.offset(offset, 0, 0) : posOne.offset(0, 0, offset);
                if (random.nextInt(3) == 0) {
                    Object[] objectArray = new BlockPos[]{posOne, posTwo};
                    v1 = variationList.add(CollectionsKt.listOf((Object[])objectArray));
                } else {
                    v1 = variationList.add(CollectionsKt.listOf((Object)(random.nextBoolean() ? posOne : posTwo)));
                }
                if (i == n) break;
                ++i;
            }
        }
        return variationList;
    }

    private final boolean isAir(LevelSimulatedReader testableWorld, BlockPos blockPos) {
        return testableWorld.isStateAtPosition(blockPos, ApricornTreeFeature::isAir$lambda$0);
    }

    private static final boolean isAir$lambda$0(BlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        return blockState.is(Blocks.AIR);
    }
}

