/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.relocations.oracle.truffle.js.nodes.access;

import com.cobblemon.mod.relocations.oracle.truffle.api.CompilerDirectives;
import com.cobblemon.mod.relocations.oracle.truffle.api.frame.VirtualFrame;
import com.cobblemon.mod.relocations.oracle.truffle.api.instrumentation.Tag;
import com.cobblemon.mod.relocations.oracle.truffle.api.nodes.Node;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.JavaScriptNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.cast.JSToBooleanNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.JSContext;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.Strings;
import java.util.Set;

public class IteratorCompleteUnaryNode
extends JavaScriptNode {
    @Node.Child
    private PropertyGetNode getDoneNode;
    @Node.Child
    private JavaScriptNode iterResultNode;
    @Node.Child
    private JSToBooleanNode toBooleanNode;

    protected IteratorCompleteUnaryNode(JSContext context, JavaScriptNode iterResultNode) {
        this.iterResultNode = iterResultNode;
        this.getDoneNode = PropertyGetNode.create(Strings.DONE, false, context);
    }

    public static JavaScriptNode create(JSContext context, JavaScriptNode iterResultNode) {
        return new IteratorCompleteUnaryNode(context, iterResultNode);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        return this.executeBoolean(frame);
    }

    @Override
    public boolean executeBoolean(VirtualFrame frame) {
        Object iterResult = this.iterResultNode.execute(frame);
        Object done = this.getDoneNode.getValue(iterResult);
        if (done instanceof Boolean) {
            return (Boolean)done;
        }
        if (this.toBooleanNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.toBooleanNode = this.insert(JSToBooleanNode.create());
        }
        return this.toBooleanNode.executeBoolean(done);
    }

    @Override
    public final boolean isResultAlwaysOfType(Class<?> clazz) {
        return clazz == Boolean.TYPE;
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return IteratorCompleteUnaryNode.create(this.getDoneNode.getContext(), IteratorCompleteUnaryNode.cloneUninitialized(this.iterResultNode, materializedTags));
    }
}

